/*
 * Decompiled with CFR 0.152.
 */
package com.sun.portal.wireless.providers.mail;

import com.iplanet.am.sdk.AMStoreConnection;
import com.iplanet.am.sdk.AMUser;
import com.iplanet.sso.SSOToken;
import com.iplanet.sso.SSOTokenManager;
import com.sun.mobile.util.ContentUtils;
import com.sun.portal.providers.InvalidEditFormDataException;
import com.sun.portal.providers.ProviderEditUtility;
import com.sun.portal.providers.ProviderException;
import com.sun.portal.providers.context.ProviderContext;
import com.sun.portal.providers.context.ProviderContextException;
import com.sun.portal.providers.mail.MailApplicationHelper;
import com.sun.portal.providers.mail.MailProvider;
import com.sun.portal.wireless.providers.mail.MailViews;
import com.sun.portal.wireless.providers.util.ProviderUtility;
import com.sun.portal.wireless.taglibs.dispatcher.Compressor;
import com.sun.ssoadapter.SSOAdapter;
import com.sun.ssoadapter.config.ClientAwareUserContext;
import com.sun.ssoadapter.config.Configuration;
import com.sun.ssoadapter.config.ConfigurationFactory;
import com.sun.ssoadapter.config.PSClientAwareContextFactory;
import java.net.MalformedURLException;
import java.net.URL;
import java.net.URLDecoder;
import java.net.URLEncoder;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.Map;
import java.util.Properties;
import java.util.ResourceBundle;
import java.util.Set;
import java.util.Vector;
import javax.mail.Message;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;

public class MAJspMailAppHelper
implements MailApplicationHelper {
    public MailProvider provider = null;
    public SSOAdapter ssoAdapter = null;
    public SSOToken ssoToken = null;
    public Properties adapterProperties = null;
    private ConfigurationFactory appConfigFactory = null;
    private ConfigurationFactory ssoConfigFactory = null;
    private PSClientAwareContextFactory saalContextFactory = null;
    private Map serviceMap = new HashMap();
    private ClientAwareUserContext saalContext = null;
    private Configuration appConfig = null;
    private MailViews mailViewsHandler = null;
    private String editContainer = null;
    private String container = null;
    private String editPopSelected = null;
    private ResourceBundle bundle = null;
    protected String appName = "";
    private static final int PREDEFINED_REPLIES_LENGTH = 9;

    public void init(MailProvider provider, SSOAdapter ssoAdapter) {
        this.provider = provider;
        this.ssoAdapter = ssoAdapter;
        try {
            this.ssoToken = ssoAdapter.getSSOToken();
        }
        catch (Exception exception) {
            // empty catch block
        }
        this.adapterProperties = ssoAdapter.getProperties();
        this.appConfigFactory = ConfigurationFactory.getInstance((String)"SunMobileAppMailService", (String)"sunMobileAppMailConfig", (String)"sunConfigurationTemplates");
        this.ssoConfigFactory = ConfigurationFactory.getInstance((String)"SunSSOAdapterService", (String)"sunSSOAdapterConfigurations", (String)"sunConfigurationTemplates");
        this.serviceMap.put("serviceName", "SunMobileAppMailService");
        this.bundle = ResourceBundle.getBundle("MAJspMailAppHelper", provider.getProviderContext().getLocale());
    }

    private void prefsReqInit(HttpServletRequest req) throws Exception {
        if (this.editContainer == null) {
            this.editContainer = req.getParameter("provider");
        }
        if (this.container == null) {
            this.container = req.getParameter("containerName");
        }
        if (this.appConfig == null) {
            String nameSuffix;
            AMStoreConnection amConn = new AMStoreConnection(this.ssoToken);
            AMUser amUser = amConn.getUser(((Object)this.ssoToken.getPrincipal()).toString());
            Set assignedServices = amUser.getAssignedServices();
            Iterator svcIter = assignedServices.iterator();
            boolean found = false;
            while (svcIter.hasNext()) {
                String svcName = (String)svcIter.next();
                if (!svcName.equalsIgnoreCase("SunMobileAppMailService")) continue;
                found = true;
                break;
            }
            if (!found) {
                throw new Exception("SunMobileAppMailService service not assigned to user");
            }
            String configName = this.ssoAdapter.getName();
            int i = configName.indexOf(nameSuffix = "_" + this.provider.getName());
            if (i < 0) {
                i = configName.length();
                configName = configName + nameSuffix;
            }
            this.appConfig = this.appConfigFactory.readConfiguration(configName, true, req);
            if (this.appConfig == null) {
                this.appConfig = this.appConfigFactory.readConfiguration(configName.substring(0, i), true, req);
                if (this.appConfig != null) {
                    this.appConfig.setConfigurationName(configName);
                }
                if (this.appConfig == null) {
                    this.appConfig = new Configuration();
                    this.appConfig.setConfigurationName(configName);
                    this.appConfig.setConfigurationDescription("MA-MAIL-APP");
                }
            }
        }
        this.saalContextFactory = PSClientAwareContextFactory.getInstance();
        this.saalContext = this.saalContextFactory.getClientAwareUserContext(req);
        try {
            if (this.mailViewsHandler == null) {
                this.mailViewsHandler = new MailViews();
                this.mailViewsHandler.init(this.provider, this.container, this.editContainer, this, req);
            }
        }
        catch (Exception e) {
            this.mailViewsHandler = null;
            this.provider.getProviderContext().debugError((Object)("MAJspMailAppHelper.prefsReqInit:  MailViews init failed.  e=" + e));
        }
    }

    public String getStartURL(MailProvider mprov, HttpServletRequest request) {
        return this.getApplicationURL(mprov, request);
    }

    private String getApplicationURL(MailProvider mprov, HttpServletRequest request) {
        String appURL = null;
        try {
            SSOTokenManager tokenManager = SSOTokenManager.getInstance();
            SSOToken token = tokenManager.createSSOToken(request);
            appURL = "/jsp/default/launchMail.jsp?mi=" + ContentUtils.rfc2396Escape((String)"", (String)this.ssoAdapter.getName());
            Compressor compressor = Compressor.getCompressor((SSOToken)token);
            appURL = request.getContextPath() + compressor.compressURL(appURL);
            appURL = token.encodeURL(appURL);
        }
        catch (Exception e) {
            return null;
        }
        return appURL;
    }

    public String getMessageURL(MailProvider mprov, HttpServletRequest request, Message message) {
        return null;
    }

    public StringBuffer getAppPrefsEdit(MailProvider mprov, HttpServletRequest req, HttpServletResponse res) {
        StringBuffer edit = null;
        try {
            this.prefsReqInit(req);
        }
        catch (Exception e) {
            return null;
        }
        String viewMode = req.getParameter("viewmode");
        if (viewMode != null) {
            try {
                edit = this.mailViewsHandler.getEdit(req, res);
            }
            catch (Exception e) {
                mprov.getProviderContext().debugError((Object)("MAJspMailAppHelper.getAppPrefsEdit:  MailViews.getEdit() failed.  e=" + e));
            }
        } else {
            String page = req.getParameter("page");
            if (page == null) {
                edit = this.getAppPrefsMainEdit(mprov, req);
            } else if (page.endsWith("PopConfig")) {
                edit = this.getAppPrefsPopEdit(mprov, req, page);
            }
        }
        return edit;
    }

    private StringBuffer getAppPrefsMainEdit(MailProvider mprov, HttpServletRequest req) {
        StringBuffer popOptions = new StringBuffer();
        StringBuffer viewOptions = new StringBuffer();
        ProviderContext pc = mprov.getProviderContext();
        Hashtable<String, CharSequence> tagTable = new Hashtable<String, CharSequence>();
        Hashtable<String, String> mailValuePairs = new Hashtable<String, String>();
        try {
            String signature;
            Enumeration configEnum = this.ssoConfigFactory.getConfigurationNames(req);
            if (configEnum != null) {
                while (configEnum.hasMoreElements()) {
                    String configName = (String)configEnum.nextElement();
                    mailValuePairs.clear();
                    try {
                        ProviderUtility.setDefaultPresentation(this.provider.getName(), this.provider.getProviderContext(), mailValuePairs);
                    }
                    catch (ProviderContextException pce) {
                        pc.debugMessage((Object)"MAJspMailAppHelper: setDefaultPresentation", (Throwable)pce);
                    }
                    mailValuePairs.put("configName", configName);
                    try {
                        Configuration configProps = this.ssoConfigFactory.readConfiguration(configName, true, req);
                        if (!configProps.getProperty("protocol").equals("pop3") || !configProps.getConfigurationDescription().equals("POP-COLLECTIONS")) continue;
                        popOptions.append(mprov.getTemplate("ma-edit-config-options.template", mailValuePairs));
                    }
                    catch (Exception ee) {}
                }
                tagTable.put("popConfigs", popOptions);
            }
            if ((signature = this.getSAALStringAttribute(req, "sunMobileAppMailSignature")) != null) {
                tagTable.put("signature", signature);
            }
            Set predefinedMsgs = this.getSAALAttribute(req, "sunMobileAppMailPredefinedReplies");
            int size = predefinedMsgs.size();
            int i = 0;
            Iterator j = predefinedMsgs.iterator();
            while (j.hasNext()) {
                String key;
                String predefinedMsgValuePair = (String)j.next();
                if (predefinedMsgValuePair.indexOf(61) != -1) {
                    key = predefinedMsgValuePair.substring(0, predefinedMsgValuePair.indexOf(61));
                    String value = predefinedMsgValuePair.substring(predefinedMsgValuePair.indexOf(61) + 1);
                    tagTable.put(key, value);
                } else {
                    key = "preset" + (i + 1);
                    tagTable.put(key, "");
                }
                ++i;
            }
            if (size < 9) {
                for (i = size; i <= 9; ++i) {
                    String key = "preset" + i;
                    tagTable.put(key, "");
                }
            }
            boolean sentFolderCopy = false;
            String sentFolderCopyString = this.getAppConfigString(req, "sentFolderCopy");
            if (sentFolderCopyString != null) {
                sentFolderCopy = Boolean.valueOf(sentFolderCopyString);
            }
            if (sentFolderCopy) {
                tagTable.put("sentFolderCopyChecked", "CHECKED");
                tagTable.put("sentFolderCopy", "true");
            } else {
                tagTable.put("sentFolderCopyChecked", "");
                tagTable.put("sentFolderCopy", "false");
            }
            String fromAddress = this.getAppConfigString(req, "fromAddress");
            if (fromAddress != null) {
                tagTable.put("fromAddress", fromAddress);
            }
            tagTable.put("isAppHandler", this.getName());
            try {
                ProviderUtility.setDefaultPresentation(this.provider.getName(), this.provider.getProviderContext(), tagTable);
            }
            catch (ProviderContextException pce) {
                pc.debugMessage((Object)"MAJspMailAppHelper: setDefaultPresentation", (Throwable)pce);
            }
            return mprov.getTemplate("ma-edit.template", tagTable);
        }
        catch (Exception e) {
            mprov.getProviderContext().debugError((Object)("MAJspMailAppHelper.getAppPrefsMainEdit():  e=" + e));
            return null;
        }
    }

    private StringBuffer getAppPrefsPopEdit(MailProvider mprov, HttpServletRequest request, String page) {
        StringBuffer edit;
        block13: {
            edit = null;
            Hashtable<String, String> mailValuePairs = new Hashtable<String, String>();
            ProviderContext pc = mprov.getProviderContext();
            Configuration ssoConfigProps = null;
            try {
                mailValuePairs.clear();
                mailValuePairs.put("isAppHandler", this.getName());
                try {
                    ProviderUtility.setDefaultPresentation(this.provider.getName(), this.provider.getProviderContext(), mailValuePairs);
                }
                catch (ProviderContextException pce) {
                    pc.debugMessage((Object)"MAJspMailAppHelper: setDefaultPresentation", (Throwable)pce);
                }
                if (page.equals("AddPopConfig")) {
                    mailValuePairs.put("process", "AddPop");
                    mailValuePairs.put("port", "110");
                    edit = mprov.getTemplate("ma-edit-pop-config.template", mailValuePairs);
                    break block13;
                }
                mailValuePairs.put("process", "EditPop");
                String configName = request.getParameter("selection");
                try {
                    ssoConfigProps = this.ssoConfigFactory.readConfiguration(configName, true, request);
                }
                catch (Exception e) {
                    mprov.getProviderContext().debugError((Object)("MAJspMailAppHelper.getAppPrefsPopEdit():  e=" + e));
                    return null;
                }
                this.editPopSelected = configName;
                if (this.editPopSelected.indexOf(43) != -1) {
                    this.editPopSelected = URLDecoder.decode(this.editPopSelected);
                }
                mailValuePairs.put("configName", configName);
                this.setTagtable(mailValuePairs, "host", ssoConfigProps, "host");
                this.setTagtable(mailValuePairs, "port", ssoConfigProps, "port");
                this.setTagtable(mailValuePairs, "uid", ssoConfigProps, "uid");
                this.setTagtable(mailValuePairs, "password", ssoConfigProps, "password");
                boolean popDelete = false;
                String popDeleteString = ssoConfigProps.getProperty("popDelete");
                if (popDeleteString != null) {
                    popDelete = Boolean.valueOf(popDeleteString);
                }
                if (popDelete) {
                    mailValuePairs.put("popDeleteChecked", "CHECKED");
                    mailValuePairs.put("popDelete", "true");
                } else {
                    mailValuePairs.put("popDeleteChecked", "");
                    mailValuePairs.put("popDelete", "false");
                }
                try {
                    ProviderUtility.setDefaultPresentation(this.provider.getName(), this.provider.getProviderContext(), mailValuePairs);
                }
                catch (ProviderContextException pce) {
                    pc.debugMessage((Object)"MAJspMailAppHelper: setDefaultPresentation", (Throwable)pce);
                }
                edit = mprov.getTemplate("ma-edit-pop-config.template", mailValuePairs);
            }
            catch (Exception e) {
                mprov.getProviderContext().debugError((Object)("MAJspMailAppHelper.getAppPrefsPopEdit():  e=" + e));
                return null;
            }
        }
        return edit;
    }

    public URL processAppPrefsEdit(MailProvider mprov, HttpServletRequest req, HttpServletResponse res) {
        URL finishURL = null;
        try {
            URL url = null;
            String desktopURL = mprov.getProviderContext().getDesktopURL(req);
            desktopURL = desktopURL + "?action=edit";
            desktopURL = desktopURL + "&provider=" + URLEncoder.encode(this.editContainer);
            desktopURL = desktopURL + "&targetprovider=" + mprov.getName();
            desktopURL = desktopURL + "&containerName=" + URLEncoder.encode(this.container);
            finishURL = new URL(desktopURL);
            desktopURL = desktopURL + "&appPref=" + URLEncoder.encode(this.getName());
            String process = req.getParameter("process");
            try {
                String viewMode = req.getParameter("viewmode");
                if (viewMode != null) {
                    try {
                        url = this.mailViewsHandler.processEdit(req, res);
                    }
                    catch (Exception e) {
                        mprov.getProviderContext().debugError((Object)("MAJspMailAppHelper.processAppPrefsEdit:  MailViews.processEdit() failed.  e=" + e));
                    }
                    return url;
                }
                if (process != null) {
                    if (process.equals("AddPop") || process.equals("EditPop")) {
                        url = this.processAppPrefsPopEdit(mprov, req, res);
                    }
                    if (url != null) {
                        return url;
                    }
                }
                if (req.getParameter("OpenRules") != null) {
                    desktopURL = desktopURL + "&viewmode=Rules";
                    url = new URL(desktopURL);
                } else if (req.getParameter("OpenViews") != null) {
                    desktopURL = desktopURL + "&viewmode=Views";
                    url = new URL(desktopURL);
                } else if (req.getParameter("OpenDevice") != null) {
                    desktopURL = desktopURL + "&viewmode=Device";
                    url = new URL(desktopURL);
                } else if (req.getParameter("OpenAddPop") != null) {
                    desktopURL = desktopURL + "&page=AddPopConfig";
                    url = new URL(desktopURL);
                } else if (req.getParameter("OpenEditPop") != null) {
                    desktopURL = req.getParameter("popConfigs") != null ? desktopURL + "&page=EditPopConfig&selection=" + req.getParameter("popConfigs") : desktopURL + "&page=AddPopConfig";
                    url = new URL(desktopURL);
                } else {
                    url = req.getParameter("DeletePop") != null ? this.processAppPrefsPopEdit(mprov, req, res) : this.processAppPrefsMainEdit(mprov, req, res);
                }
            }
            catch (InvalidEditFormDataException ie) {
            }
            catch (Exception e) {
                mprov.getProviderContext().debugError((Object)("MAJspMailAppHelper.processAppPrefsEdit():  e=" + e));
                return finishURL;
            }
            if (url == null) {
                url = finishURL;
            }
            return url;
        }
        catch (Exception e) {
            mprov.getProviderContext().debugError((Object)("MAJspMailAppHelper.processAppPrefsEdit():  e=" + e));
            return finishURL;
        }
    }

    private URL processAppPrefsMainEdit(MailProvider mprov, HttpServletRequest req, HttpServletResponse res) {
        try {
            this.setSAALStringAttribute(req, "sunMobileAppMailSignature", req.getParameter("signature"));
            Vector<String> predefinedReplies = new Vector<String>();
            for (int i = 1; i <= 9; ++i) {
                String reply = req.getParameter("preset" + i);
                predefinedReplies.add("preset" + i + "=" + reply);
            }
            HashSet predefinedRepliesSet = new HashSet(predefinedReplies);
            this.setSAALAttribute(req, "sunMobileAppMailPredefinedReplies", predefinedRepliesSet);
            String sentFolderCopy = req.getParameter("sentFolderCopy");
            if (sentFolderCopy != null) {
                this.appConfig.setProperty("sentFolderCopy", "true");
            } else {
                this.appConfig.setProperty("sentFolderCopy", "false");
            }
            String fromAddress = req.getParameter("fromAddress");
            if (fromAddress != null) {
                this.appConfig.setProperty("fromAddress", fromAddress);
            }
            this.appConfigFactory.writeConfiguration(this.appConfig, req);
        }
        catch (Exception e) {
            mprov.getProviderContext().debugError((Object)("MAJspMailAppHelper.processAppPrefsMainEdit():  e=" + e));
            return null;
        }
        return null;
    }

    private URL processAppPrefsPopEdit(MailProvider mprov, HttpServletRequest req, HttpServletResponse res) throws ProviderException {
        String process = req.getParameter("process");
        if (process != null) {
            Configuration props;
            String configName = req.getParameter("configName");
            if (configName == null || configName.length() == 0) {
                return this.getAppPrefsEditReturnURL(mprov, req, this.bundle.getString("MAJspMailAppHelper-noconfigname"));
            }
            String host = req.getParameter("host");
            if (host == null || host.length() == 0) {
                return this.getAppPrefsEditReturnURL(mprov, req, this.bundle.getString("MAJspMailAppHelper-nohost"));
            }
            String portString = req.getParameter("port");
            if (portString != null && portString.length() != 0) {
                try {
                    int i = Integer.parseInt(portString);
                }
                catch (Exception e) {
                    String errMsg = this.bundle.getString("MAJspMailAppHelper-invalidPortNum");
                    return this.getAppPrefsEditReturnURL(mprov, req, errMsg);
                }
            }
            try {
                props = this.ssoConfigFactory.readConfiguration(configName, true, req);
            }
            catch (Exception e) {
                props = null;
            }
            if (props == null) {
                props = new Configuration();
                props.setConfigurationName(configName);
                props.setConfigurationDescription("POP-COLLECTIONS");
            }
            props.setProperty("protocol", "pop3");
            this.setSSOProperty(props, "host", "host", req);
            this.setSSOProperty(props, "port", "port", req);
            this.setSSOProperty(props, "uid", "uid", req);
            this.setSSOProperty(props, "password", "password", req);
            if (req.getParameter("popDelete") != null) {
                props.setProperty("popDelete", "true");
            } else {
                props.setProperty("popDelete", "false");
            }
            if (process.equals("AddPop")) {
                try {
                    this.ssoConfigFactory.writeConfiguration(props, req);
                }
                catch (Exception e) {
                    mprov.getProviderContext().debugError((Object)("MAJspMailAppHelper.processPopConfigEdit(): Can not add POP configuration " + configName), (Throwable)e);
                    String errMsg = this.bundle.getString("MAJspMailAppHelper-addpopfail");
                    return this.getAppPrefsEditReturnURL(mprov, req, errMsg);
                }
            } else {
                try {
                    if (configName.equals(this.editPopSelected)) {
                        this.ssoConfigFactory.writeConfiguration(props, req);
                    }
                    this.ssoConfigFactory.writeConfiguration(props, req);
                    this.ssoConfigFactory.removeConfiguration(this.editPopSelected, req);
                }
                catch (Exception e) {
                    mprov.getProviderContext().debugError((Object)("MAJspMailAppHelper.processPopConfigEdit(): Can not replace POP configuration " + configName), (Throwable)e);
                    String errMsg = this.bundle.getString("MAJspMailAppHelper-editpopfail");
                    return this.getAppPrefsEditReturnURL(mprov, req, errMsg);
                }
            }
        } else {
            String selection = req.getParameter("popConfigs");
            try {
                if (selection != null) {
                    this.ssoConfigFactory.removeConfiguration(selection, req);
                }
            }
            catch (Exception e) {
                mprov.getProviderContext().debugError((Object)("MAJspMailAppHelper.processPopConfigEdit(): Can not remove POP configuration " + selection), (Throwable)e);
                String errMsg = this.bundle.getString("MAJspMailAppHelper-deletepopfail");
                return this.getAppPrefsEditReturnURL(mprov, req, errMsg);
            }
        }
        return this.getAppPrefsEditReturnURL(mprov, req);
    }

    private String getSAALStringAttribute(HttpServletRequest req, String name) {
        try {
            return this.saalContext.getStringAttribute(this.serviceMap, name);
        }
        catch (Exception e) {
            return null;
        }
    }

    private void setSAALStringAttribute(HttpServletRequest req, String name, String value) throws Exception {
        this.saalContext.setStringAttribute(this.serviceMap, name, value);
    }

    private Set getSAALAttribute(HttpServletRequest req, String name) {
        try {
            return this.saalContext.getAttribute(this.serviceMap, name);
        }
        catch (Exception e) {
            return null;
        }
    }

    private void setSAALAttribute(HttpServletRequest req, String name, Set value) throws Exception {
        this.saalContext.setAttribute(this.serviceMap, name, value);
    }

    private String getAppConfigString(HttpServletRequest req, String name) {
        if (this.appConfig == null) {
            try {
                this.appConfig = this.appConfigFactory.readConfiguration(this.ssoAdapter.getName(), true, req);
                if (this.appConfig == null) {
                    this.appConfig = new Configuration();
                    this.appConfig.setConfigurationName(this.ssoAdapter.getName());
                    this.appConfig.setConfigurationDescription("MA-MAIL-APP");
                }
            }
            catch (Exception e) {
                return null;
            }
        }
        return this.appConfig.getProperty(name);
    }

    private void setTagtable(Hashtable table, String tag, Configuration configProps, String prop) {
        String value = configProps.getProperty(prop);
        if (value != null) {
            table.put(tag, value);
        }
    }

    private void setSSOProperty(Configuration configProps, String prop, String param, HttpServletRequest request) {
        String value = request.getParameter(param);
        if (value != null) {
            configProps.setProperty(prop, value);
        } else {
            configProps.getHashMap().remove(prop);
        }
    }

    private URL getEditReturnURL(MailProvider mprov, HttpServletRequest request) {
        String desktopURL = mprov.getProviderContext().getDesktopURL(request);
        desktopURL = desktopURL + "?action=edit";
        desktopURL = desktopURL + "&provider=" + URLEncoder.encode(this.editContainer);
        desktopURL = desktopURL + "&targetprovider=" + mprov.getName();
        desktopURL = desktopURL + "&containerName=" + URLEncoder.encode(this.container);
        URL url = null;
        try {
            url = new URL(desktopURL);
        }
        catch (MalformedURLException e) {
            mprov.getProviderContext().debugError((Object)"MAJspMailAppHelper.getEditReturnURL(): ", (Throwable)e);
        }
        return url;
    }

    private URL getAppPrefsEditReturnURL(MailProvider mprov, HttpServletRequest request) {
        String desktopURL = mprov.getProviderContext().getDesktopURL(request);
        desktopURL = desktopURL + "?action=edit";
        desktopURL = desktopURL + "&provider=" + URLEncoder.encode(this.editContainer);
        desktopURL = desktopURL + "&targetprovider=" + mprov.getName();
        desktopURL = desktopURL + "&containerName=" + URLEncoder.encode(this.container);
        desktopURL = desktopURL + "&appPref=" + URLEncoder.encode(this.getName());
        URL url = null;
        try {
            url = new URL(desktopURL);
        }
        catch (MalformedURLException e) {
            mprov.getProviderContext().debugError((Object)"MAJspMailAppHelper.getEditReturnURL(): ", (Throwable)e);
        }
        return url;
    }

    private URL getEditReturnURL(MailProvider mprov, HttpServletRequest request, String errMsg) {
        String desktopURL = mprov.getProviderContext().getDesktopURL(request);
        desktopURL = desktopURL + "?action=edit";
        desktopURL = desktopURL + "&provider=" + URLEncoder.encode(this.editContainer);
        desktopURL = desktopURL + "&targetprovider=" + mprov.getName();
        desktopURL = desktopURL + "&containerName=" + URLEncoder.encode(this.container);
        desktopURL = desktopURL + "&error=" + errMsg;
        URL url = null;
        try {
            url = new URL(desktopURL);
        }
        catch (MalformedURLException e) {
            // empty catch block
        }
        return url;
    }

    private URL getAppPrefsEditReturnURL(MailProvider mprov, HttpServletRequest request, String errMsg) {
        String desktopURL = mprov.getProviderContext().getDesktopURL(request);
        desktopURL = desktopURL + "?action=edit";
        desktopURL = desktopURL + "&provider=" + URLEncoder.encode(this.editContainer);
        desktopURL = desktopURL + "&targetprovider=" + mprov.getName();
        desktopURL = desktopURL + "&containerName=" + URLEncoder.encode(this.container);
        desktopURL = desktopURL + "&appPref=" + URLEncoder.encode(this.getName());
        desktopURL = desktopURL + "&error=" + errMsg;
        URL url = null;
        try {
            url = new URL(desktopURL);
        }
        catch (MalformedURLException e) {
            // empty catch block
        }
        return url;
    }

    public String getAppHelperEditLink(HttpServletRequest req, ProviderContext pc) {
        try {
            this.prefsReqInit(req);
        }
        catch (Exception e) {
            return "";
        }
        Hashtable<String, String> tagTable = new Hashtable<String, String>();
        StringBuffer link = new StringBuffer();
        try {
            link.append(pc.getDesktopURL(req));
        }
        catch (Exception e) {
            return "";
        }
        link.append("?action=edit&provider=");
        link.append(ProviderEditUtility.getRequestParameter((String)"provider", (HttpServletRequest)req));
        link.append("&targetprovider=" + this.provider.getName());
        link.append("&containerName=");
        link.append(ProviderEditUtility.getRequestParameter((String)"containerName", (HttpServletRequest)req));
        link.append("&appPref=" + this.getName());
        tagTable.put("editLink", link.toString());
        String content = null;
        try {
            ProviderUtility.setDefaultPresentation(this.provider.getName(), this.provider.getProviderContext(), tagTable);
        }
        catch (ProviderContextException pce) {
            pc.debugMessage((Object)"MAJspMailAppHelper: setDefaultPresentation", (Throwable)pce);
        }
        try {
            String fontTag = pc.getStringProperty(this.provider.getName(), "fontFace1", "Sans-serif");
            tagTable.put("iwtDesktop-fontFace1", fontTag);
            content = pc.getTemplate(this.provider.getName(), "ma-edit-link.template", tagTable).toString();
            pc.debugMessage((Object)("content = \n" + content.toString()));
        }
        catch (Exception e) {
            pc.debugError((Object)"unable to create hyperlink\n", (Throwable)e);
            content = "";
        }
        pc.debugMessage((Object)("MAJspMailAppHelper: returned value is" + content.toString()));
        return content;
    }

    public void setName(String name) {
        this.appName = name;
    }

    public String getName() {
        return this.appName;
    }
}

