/*
 * Decompiled with CFR 0.152.
 */
package com.sun.portal.wireless.providers.ab;

import com.iplanet.am.sdk.AMStoreConnection;
import com.iplanet.am.sdk.AMUser;
import com.iplanet.sso.SSOToken;
import com.iplanet.sso.SSOTokenManager;
import com.sun.mobile.util.ContentUtils;
import com.sun.portal.providers.ProviderEditUtility;
import com.sun.portal.providers.ab.AddressBookApplicationHelper;
import com.sun.portal.providers.ab.AddressBookProvider;
import com.sun.portal.providers.context.ProviderContext;
import com.sun.portal.providers.context.ProviderContextException;
import com.sun.portal.wireless.providers.util.ProviderUtility;
import com.sun.portal.wireless.taglibs.dispatcher.Compressor;
import com.sun.ssoadapter.SSOAdapter;
import com.sun.ssoadapter.config.Configuration;
import com.sun.ssoadapter.config.ConfigurationFactory;
import java.net.URL;
import java.net.URLEncoder;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.Properties;
import java.util.Set;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;

public class MAJspABAppHelper
implements AddressBookApplicationHelper {
    public SSOAdapter ssoAdapter = null;
    public SSOToken ssoToken = null;
    public Properties adapterProperties = null;
    private AddressBookProvider provider = null;
    protected String appName = "";
    private String editContainer = null;
    private String container = null;
    private ConfigurationFactory appConfigFactory = null;
    private Configuration appConfig = null;
    private static final String sortOrderAscending = "asc";
    private static final String sortOrderDescending = "dsc";
    private static final String sortOrderNone = "none";

    public void init(AddressBookProvider provider, SSOAdapter ssoAdapter) {
        this.provider = provider;
        this.ssoAdapter = ssoAdapter;
        try {
            this.ssoToken = ssoAdapter.getSSOToken();
        }
        catch (Exception exception) {
            // empty catch block
        }
        this.adapterProperties = ssoAdapter.getProperties();
        this.appConfigFactory = ConfigurationFactory.getInstance((String)"SunMobileAppABService", (String)"sunMobileAppABConfig", (String)"sunConfigurationTemplates");
    }

    private void prefsReqInit(HttpServletRequest req) throws Exception {
        if (this.editContainer == null) {
            this.editContainer = req.getParameter("provider");
        }
        if (this.container == null) {
            this.container = req.getParameter("containerName");
        }
        if (this.appConfig == null) {
            String nameSuffix;
            AMStoreConnection amConn = new AMStoreConnection(this.ssoToken);
            AMUser amUser = amConn.getUser(((Object)this.ssoToken.getPrincipal()).toString());
            Set assignedServices = amUser.getAssignedServices();
            Iterator svcIter = assignedServices.iterator();
            boolean found = false;
            while (svcIter.hasNext()) {
                String svcName = (String)svcIter.next();
                if (!svcName.equalsIgnoreCase("SunMobileAppABService")) continue;
                found = true;
                break;
            }
            if (!found) {
                throw new Exception("SunMobileAppABService service not assigned to user");
            }
            String configName = this.ssoAdapter.getName();
            int i = configName.indexOf(nameSuffix = "_" + this.provider.getName());
            if (i < 0) {
                i = configName.length();
                configName = configName + nameSuffix;
            }
            this.appConfig = this.appConfigFactory.readConfiguration(configName, true, req);
            if (this.appConfig == null) {
                this.appConfig = this.appConfigFactory.readConfiguration(configName.substring(0, i), true, req);
                if (this.appConfig != null) {
                    this.appConfig.setConfigurationName(configName);
                }
                if (this.appConfig == null) {
                    this.appConfig = new Configuration();
                    this.appConfig.setConfigurationName(configName);
                    this.appConfig.setConfigurationDescription("MA-AB-APP");
                }
            }
        }
    }

    public String getStartURL(AddressBookProvider provider, HttpServletRequest request) {
        return this.getApplicationURL(provider, request);
    }

    private String getApplicationURL(AddressBookProvider provider, HttpServletRequest request) {
        String appURL = null;
        try {
            SSOTokenManager tokenManager = SSOTokenManager.getInstance();
            SSOToken token = tokenManager.createSSOToken(request);
            appURL = "/jsp/default/launchAB.jsp?ai=" + ContentUtils.rfc2396Escape((String)"", (String)this.ssoAdapter.getName());
            Compressor compressor = Compressor.getCompressor((SSOToken)token);
            appURL = request.getContextPath() + compressor.compressURL(appURL);
            appURL = token.encodeURL(appURL);
        }
        catch (Exception e) {
            return null;
        }
        return appURL;
    }

    public StringBuffer getAppPrefsEdit(AddressBookProvider aprov, HttpServletRequest req, HttpServletResponse res) {
        Hashtable<String, String> tagTable = new Hashtable<String, String>();
        ProviderContext pc = aprov.getProviderContext();
        try {
            this.prefsReqInit(req);
            try {
                ProviderUtility.setDefaultPresentation(this.provider.getName(), this.provider.getProviderContext(), tagTable);
            }
            catch (ProviderContextException pce) {
                pc.debugMessage((Object)"MAJspABAppHelper: setDefaultPresentation", (Throwable)pce);
            }
            String sortBy = this.appConfig.getProperty("sortBy");
            if (sortBy == null || sortBy.equals("")) {
                tagTable.put("isNoSorting", "selected");
                tagTable.put("isCnSelected", "");
            } else {
                tagTable.put("isNoSorting", "");
                if (sortBy.equals("cn")) {
                    tagTable.put("isCnSelected", "selected");
                } else {
                    tagTable.put("isCnSelected", "");
                    tagTable.put("isNoSorting", "selected");
                }
            }
            String sortOrder = this.appConfig.getProperty("sortOrder");
            if (sortOrderNone.equals(sortOrder)) {
                tagTable.put("isUpSelected", "");
                tagTable.put("isDownSelected", "");
                tagTable.put("isNoSorting", "selected");
            } else {
                tagTable.put("isNoSorting", "");
                if (sortOrderDescending.equals(sortOrder)) {
                    tagTable.put("isDownSelected", "selected");
                    tagTable.put("isUpSelected", "");
                } else {
                    tagTable.put("isUpSelected", "selected");
                    tagTable.put("isDownSelected", "");
                }
            }
            tagTable.put("isAppHandler", this.getName());
            return aprov.getTemplate("ma-edit.template", tagTable);
        }
        catch (Exception e) {
            pc.debugMessage((Object)"MAJspABAppHelper: ", (Throwable)e);
            return null;
        }
    }

    public URL processAppPrefsEdit(AddressBookProvider aprov, HttpServletRequest req, HttpServletResponse res) {
        URL url = null;
        try {
            String sortOrder;
            String val;
            String desktopURL = aprov.getProviderContext().getDesktopURL(req);
            desktopURL = desktopURL + "?action=edit";
            desktopURL = desktopURL + "&provider=" + URLEncoder.encode(this.editContainer);
            desktopURL = desktopURL + "&targetprovider=" + aprov.getName();
            desktopURL = desktopURL + "&containerName=" + URLEncoder.encode(this.container);
            url = new URL(desktopURL);
            String sortBy = req.getParameter("sortBy");
            if (sortBy != null) {
                val = sortBy.equals("Commonname") ? "cn" : "";
                this.appConfig.setProperty("sortBy", val);
            }
            if ((sortOrder = req.getParameter("sortOrder")) != null) {
                val = sortOrder.equals("Down") ? sortOrderDescending : (sortOrder.equals("Up") ? sortOrderAscending : sortOrderNone);
                this.appConfig.setProperty("sortOrder", val);
            }
            if (sortOrder != null || sortBy != null) {
                this.appConfigFactory.writeConfiguration(this.appConfig, req);
            }
        }
        catch (Exception e) {
            return null;
        }
        return url;
    }

    public String getAppHelperEditLink(HttpServletRequest req, ProviderContext pc) {
        try {
            this.prefsReqInit(req);
        }
        catch (Exception e) {
            return "";
        }
        Hashtable<String, String> tagTable = new Hashtable<String, String>();
        StringBuffer link = new StringBuffer();
        try {
            link.append(pc.getDesktopURL(req));
        }
        catch (Exception e) {
            return "";
        }
        link.append("?action=edit&provider=");
        link.append(ProviderEditUtility.getRequestParameter((String)"provider", (HttpServletRequest)req));
        link.append("&targetprovider=" + this.provider.getName());
        link.append("&containerName=");
        link.append(ProviderEditUtility.getRequestParameter((String)"containerName", (HttpServletRequest)req));
        link.append("&appPref=" + this.getName());
        try {
            ProviderUtility.setDefaultPresentation(this.provider.getName(), this.provider.getProviderContext(), tagTable);
        }
        catch (ProviderContextException pce) {
            pc.debugMessage((Object)"MAJspABAppHelper: setDefaultPresentation", (Throwable)pce);
        }
        tagTable.put("editLink", link.toString());
        String content = null;
        try {
            String fontTag = pc.getStringProperty(this.provider.getName(), "fontFace1", "Sans-serif");
            tagTable.put("iwtDesktop-fontFace1", fontTag);
            content = pc.getTemplate(this.provider.getName(), "ma-edit-link.template", tagTable).toString();
            pc.debugMessage((Object)("content = \n" + content.toString()));
        }
        catch (Exception e) {
            pc.debugError((Object)"unable to create hyperlink\n", (Throwable)e);
            content = "";
        }
        pc.debugMessage((Object)("MAJspABAppHelper: returned value is" + content.toString()));
        return content;
    }

    public void setName(String name) {
        this.appName = name;
    }

    public String getName() {
        return this.appName;
    }
}

