/*
 * Decompiled with CFR 0.152.
 */
package com.sun.mobile.util;

import com.iplanet.am.util.Debug;
import com.iplanet.am.util.Locale;
import java.text.DateFormat;
import java.text.MessageFormat;
import java.text.ParsePosition;
import java.text.SimpleDateFormat;
import java.util.Calendar;
import java.util.Date;
import java.util.MissingResourceException;
import java.util.ResourceBundle;

public class SpeakableDate {
    private String dateString = null;
    private String localeString = null;
    private java.util.Locale locale = null;
    private Date date = null;
    private Calendar today = null;
    private long start_of_todays_time_in_milliseconds = 0L;
    private static Debug debug = Debug.getInstance((String)"mapJsp");
    ResourceBundle resource_bundle = null;
    String resource_bundle_name = "SpeakableDate";
    boolean already_got_resource_bundle = false;
    private static String[] resource_names_for_days_of_month = new String[]{"first", "second", "third", "fourth", "fifth", "sixth", "seventh", "eighth", "ninth", "tenth", "eleventh", "twelfth", "thirteenth", "fourteenth", "fifteenth", "sixteenth", "seventeenth", "eighteenth", "nineteenth", "twentieth", "twenty_first", "twenty_second", "twenty_third", "twenty_fourth", "twenty_fifth", "twenty_sixth", "twenty_seventh", "twenty_eighth", "twenty_ninth", "thirtieth", "thirty_first"};

    public SpeakableDate() {
        this.setToday();
    }

    private void log(String day, Calendar calendar) {
        if (debug.messageEnabled()) {
            Date date = calendar.getTime();
            debug.message("Start of " + day + ": " + date.getTime() + " (" + date + ")");
        }
    }

    private void setToday() {
        this.today = Calendar.getInstance();
        this.log("Rightnow", this.today);
        this.today.set(9, 0);
        this.today.set(11, 0);
        this.today.set(10, 0);
        this.today.set(12, 0);
        this.today.set(13, 0);
        this.today.set(14, 0);
        this.log("Today", this.today);
        this.start_of_todays_time_in_milliseconds = this.today.getTime().getTime();
    }

    private boolean isToday(Date date) {
        long time_in_milliseconds = date.getTime();
        if (time_in_milliseconds >= this.start_of_todays_time_in_milliseconds) {
            Calendar tomorrow = (Calendar)this.today.clone();
            tomorrow.add(5, 1);
            this.log("Tomorrow", tomorrow);
            if (time_in_milliseconds < tomorrow.getTime().getTime()) {
                return true;
            }
        }
        return false;
    }

    private boolean isYesterday(Date date) {
        long time_in_milliseconds = date.getTime();
        if (time_in_milliseconds < this.start_of_todays_time_in_milliseconds) {
            Calendar yesterday = (Calendar)this.today.clone();
            yesterday.add(5, -1);
            this.log("Yesterday", yesterday);
            if (time_in_milliseconds >= yesterday.getTime().getTime()) {
                return true;
            }
        }
        return false;
    }

    private String getDay(Calendar calendar) {
        switch (calendar.get(7)) {
            case 1: {
                return this.getResourceString("sunday", "sunday");
            }
            case 2: {
                return this.getResourceString("monday", "monday");
            }
            case 3: {
                return this.getResourceString("tuesday", "tuesday");
            }
            case 4: {
                return this.getResourceString("wednesday", "wednesday");
            }
            case 5: {
                return this.getResourceString("thursday", "thursday");
            }
            case 6: {
                return this.getResourceString("friday", "friday");
            }
            case 7: {
                return this.getResourceString("saturday", "saturday");
            }
        }
        return "";
    }

    private String getMonth(Calendar calendar) {
        switch (calendar.get(2)) {
            case 0: {
                return this.getResourceString("january", "january");
            }
            case 1: {
                return this.getResourceString("february", "february");
            }
            case 2: {
                return this.getResourceString("march", "march");
            }
            case 3: {
                return this.getResourceString("april", "april");
            }
            case 4: {
                return this.getResourceString("may", "may");
            }
            case 5: {
                return this.getResourceString("june", "june");
            }
            case 6: {
                return this.getResourceString("july", "july");
            }
            case 7: {
                return this.getResourceString("august", "august");
            }
            case 8: {
                return this.getResourceString("september", "september");
            }
            case 9: {
                return this.getResourceString("october", "october");
            }
            case 10: {
                return this.getResourceString("november", "november");
            }
            case 11: {
                return this.getResourceString("december", "december");
            }
        }
        return "";
    }

    private String getDayOfMonth(Calendar calendar) {
        String key = null;
        int day_of_month = calendar.get(5);
        key = day_of_month >= calendar.getMinimum(5) && day_of_month <= calendar.getMaximum(5) ? resource_names_for_days_of_month[day_of_month - 1] : resource_names_for_days_of_month[0];
        return this.getResourceString(key, key);
    }

    private String getAmPm(Calendar cal) {
        switch (cal.get(9)) {
            case 0: {
                return this.getResourceString("am", "am");
            }
            case 1: {
                return this.getResourceString("pm", "pm");
            }
        }
        return "";
    }

    public void setDateString(String string) {
        this.dateString = string;
        if (debug.messageEnabled()) {
            debug.message("Setting the date string to : " + this.dateString);
        }
    }

    public void setLocaleString(String string) {
        this.localeString = string;
        if (debug.messageEnabled()) {
            debug.message("Setting the locale string to : " + this.localeString);
        }
        this.locale = Locale.getLocale((String)string);
    }

    private ResourceBundle getResourceBundle() {
        if (!this.already_got_resource_bundle) {
            block3: {
                try {
                    this.resource_bundle = this.locale != null ? ResourceBundle.getBundle(this.resource_bundle_name, this.locale) : ResourceBundle.getBundle(this.resource_bundle_name);
                }
                catch (MissingResourceException e) {
                    if (!debug.messageEnabled()) break block3;
                    debug.message("Could not get ResourceBundle for: " + this.resource_bundle_name + "; locale = " + this.locale);
                }
            }
            this.already_got_resource_bundle = true;
        }
        return this.resource_bundle;
    }

    public String getSpeakableDate() {
        if (this.date == null) {
            this.date = this.constructDateFromString(this.dateString);
            if (this.date == null) {
                return "";
            }
        }
        if (this.isToday(this.date)) {
            return this.getResourceString("today", "today");
        }
        if (this.isYesterday(this.date)) {
            return this.getResourceString("yesterday", "yesterday");
        }
        String format_string = this.getResourceString("date", "");
        if (format_string.equals("")) {
            return this.date.toString();
        }
        Calendar calendar_date = Calendar.getInstance();
        calendar_date.setTime(this.date);
        Object[] args = new String[]{this.getDay(calendar_date), this.getMonth(calendar_date), this.getDayOfMonth(calendar_date)};
        return MessageFormat.format(format_string, args);
    }

    public String getSpeakableTime() {
        if (this.date == null) {
            this.date = this.constructDateFromString(this.dateString);
            if (this.date == null) {
                return "";
            }
        }
        Calendar calendar_date = Calendar.getInstance();
        calendar_date.setTime(this.date);
        String format_string = null;
        int minutes = calendar_date.get(12);
        format_string = minutes == 0 ? this.getResourceString("time_hr", "") : this.getResourceString("time_hr_min", "");
        if (format_string.equals("")) {
            return this.date.toString();
        }
        String hour_string = null;
        int hour = calendar_date.get(10);
        hour_string = hour != 0 ? Integer.toString(hour) : this.getResourceString("hour_zero", "0");
        Object[] args = new String[]{hour_string, Integer.toString(minutes), this.getAmPm(calendar_date)};
        return MessageFormat.format(format_string, args);
    }

    private String getResourceString(String key, String default_value) {
        String value;
        block3: {
            ResourceBundle bundle = this.getResourceBundle();
            if (bundle == null) {
                return default_value;
            }
            value = null;
            try {
                value = bundle.getString(key);
            }
            catch (MissingResourceException e) {
                value = default_value;
                if (!debug.messageEnabled()) break block3;
                debug.message("Could not get resource bundle key: " + key);
            }
        }
        return value;
    }

    public Date constructDateFromString(String dateString) {
        if (debug.messageEnabled()) {
            debug.message("parsing now: " + dateString);
        }
        ParsePosition pos = new ParsePosition(0);
        DateFormat df = this.locale == null ? DateFormat.getDateTimeInstance(2, 2) : DateFormat.getDateTimeInstance(2, 2, this.locale);
        SimpleDateFormat sdf = (SimpleDateFormat)df;
        sdf.applyPattern("M/d/yy h:mm a");
        Date parsed_date = sdf.parse(dateString, pos);
        if (parsed_date == null) {
            sdf.applyPattern("EE MMM d H:mm:ss z yyyy");
            pos.setIndex(0);
            parsed_date = sdf.parse(dateString, pos);
        }
        return parsed_date;
    }

    public static void main(String[] args) {
        String str = "Mon Oct 13 11:28:39 PDT 2003";
        if (args.length > 0) {
            str = args[0];
        }
        SpeakableDate sd = new SpeakableDate();
        sd.setDateString(str);
        String speakable_date = sd.getSpeakableDate();
        System.out.println("Speakable date: " + speakable_date);
        String speakable_time = sd.getSpeakableTime();
        System.out.println("Speakable time: " + speakable_time);
    }
}

