/*
 * Decompiled with CFR 0.152.
 */
package com.sun.mobile.util;

import netscape.ldap.util.DN;

public class ContentUtils {
    private static char[] escapeArray = null;
    private static char[] localEscapeArray = new char[]{' ', '\n', '\r', '\t', '/', '=', ':'};

    public static String rfc2396Escape(String encode, String uriFragment) {
        int length = uriFragment.length();
        if (length == 0) {
            return uriFragment;
        }
        StringBuffer results = new StringBuffer();
        block5: for (int i = 0; i < length; ++i) {
            char c = uriFragment.charAt(i);
            switch (c) {
                case ' ': 
                case '\"': 
                case '$': 
                case '%': 
                case '&': 
                case '+': 
                case ',': 
                case '/': 
                case ':': 
                case ';': 
                case '=': 
                case '?': 
                case '@': {
                    try {
                        byte[] octets = uriFragment.substring(i, i + 1).getBytes();
                        for (int j = 0; j < octets.length; ++j) {
                            String hexVal = Integer.toHexString(octets[j]);
                            if (hexVal.length() == 2) {
                                results.append("%" + hexVal);
                                continue;
                            }
                            results.append("%0" + hexVal);
                        }
                        continue block5;
                    }
                    catch (Exception e) {
                        continue block5;
                    }
                }
                default: {
                    results.append(c);
                }
            }
        }
        return results.toString();
    }

    public static String escapeClientType(String userAgent) {
        int len = userAgent.length();
        StringBuffer stringBuffer = new StringBuffer(len);
        for (int i = 0; i < len; ++i) {
            char ch = userAgent.charAt(i);
            if (ContentUtils.isEscape(ch)) {
                stringBuffer.append('_');
                continue;
            }
            stringBuffer.append(ch);
        }
        return stringBuffer.toString();
    }

    private static boolean isEscape(char ch) {
        for (int i = 0; i < escapeArray.length; ++i) {
            if (ch != escapeArray[i]) continue;
            return true;
        }
        return false;
    }

    static {
        int len = DN.ESCAPED_CHAR.length + localEscapeArray.length;
        escapeArray = new char[len];
        int i = 0;
        for (i = 0; i < DN.ESCAPED_CHAR.length; ++i) {
            ContentUtils.escapeArray[i] = DN.ESCAPED_CHAR[i];
        }
        for (int j = 0; j < localEscapeArray.length; ++j) {
            ContentUtils.escapeArray[i] = localEscapeArray[j];
            ++i;
        }
    }
}

