/*
 * Decompiled with CFR 0.152.
 */
package com.sun.mobile.responsebuffer;

import com.aligo.util.Cache;
import com.iplanet.am.util.AdminUtils;
import com.iplanet.am.util.Debug;
import com.iplanet.services.cdm.Client;
import com.iplanet.sso.SSOException;
import com.iplanet.sso.SSOToken;
import com.iplanet.sso.SSOTokenEvent;
import com.iplanet.sso.SSOTokenListener;
import com.iplanet.sso.SSOTokenManager;
import com.sun.identity.session.util.SessionUtils;
import com.sun.identity.sm.ServiceSchema;
import com.sun.identity.sm.ServiceSchemaManager;
import com.sun.mobile.responsebuffer.ResponseBufferEntry;
import com.sun.mobile.responsebuffer.ResponseBufferGroup;
import java.net.MalformedURLException;
import java.net.URL;
import java.security.Principal;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Set;
import javax.servlet.http.HttpServletRequest;

public class ResponseBufferService
implements SSOTokenListener {
    private int _response_buffer_history_depth = 20;
    private String _base_url = null;
    private static String _login_url = ResponseBufferService.computeLoginURL();
    private String _desktop_url = ResponseBufferService.computeDesktopURL();
    protected static final String ENTRY_NUMBER = "e";
    protected static final int ENTRY_NUMBER_RADIX = 36;
    private HashMap _response_buffer_group_table_for_tokens = new HashMap();
    private HashMap _response_buffer_group_table_for_sessions = new HashMap();
    private static final String _servlet_relative_uri = "rb";
    private static Debug debug = Debug.getInstance((String)"MAPResponseBufferService");
    private static ResponseBufferService _instance = new ResponseBufferService();

    private ResponseBufferService() {
    }

    public static ResponseBufferService getInstance() {
        return _instance;
    }

    int getHistoryDepth() {
        return this._response_buffer_history_depth;
    }

    public String getBaseURL() {
        return this._base_url;
    }

    void setBaseURL(String base_url) {
        this._base_url = base_url;
    }

    private String getBaseURLFromRequest(HttpServletRequest request) {
        String url = null;
        if (request != null) {
            StringBuffer url_buffer = new StringBuffer();
            url_buffer.append(request.getContextPath());
            url_buffer.append('/');
            url_buffer.append(_servlet_relative_uri);
            url = url_buffer.toString();
        }
        return url;
    }

    private String getEntryURL(ResponseBufferEntry entry, SSOToken token, HttpServletRequest request) {
        if (entry == null) {
            return null;
        }
        String base_url = this.getBaseURL();
        if (base_url == null) {
            base_url = this.getBaseURLFromRequest(request);
        }
        String entry_number_string = Integer.toString(entry.getEntryNumber(), 36);
        String base_url_with_entry_num = ResponseBufferService.addNameValuePairAsQueryToURL(base_url, ENTRY_NUMBER, entry_number_string);
        if (token != null) {
            try {
                return SessionUtils.encodeURL((SSOToken)token, (String)base_url_with_entry_num, (boolean)false);
            }
            catch (SSOException e) {
                // empty catch block
            }
        }
        return base_url_with_entry_num;
    }

    public String getDesktopURL() {
        return this._desktop_url;
    }

    public String getLoginURL() {
        return _login_url;
    }

    public void ssoTokenChanged(SSOTokenEvent event) {
        block5: {
            try {
                SSOToken token = event.getToken();
                switch (event.getType()) {
                    case 1: 
                    case 2: 
                    case 3: {
                        this.invalidate(token);
                        break;
                    }
                }
            }
            catch (Exception e) {
                if (!debug.warningEnabled()) break block5;
                debug.warning("ssoTokenChanged: Got exception " + e.getMessage());
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    ResponseBufferGroup getGroup(SSOToken token) {
        ResponseBufferGroup group = null;
        HashMap hashMap = this._response_buffer_group_table_for_tokens;
        synchronized (hashMap) {
            group = (ResponseBufferGroup)this._response_buffer_group_table_for_tokens.get(ResponseBufferService.getHashKeyFromSSOToken(token));
        }
        if (group == null && debug.messageEnabled()) {
            String sso_token_string = ResponseBufferService.getStringRepresentationForSSOToken(token);
            debug.message(sso_token_string + ": getGroup: Can't find group for the given token");
        }
        return group;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    ResponseBufferGroup createGroupIfNecessary(SSOToken token) throws SSOException {
        String sso_token_string;
        boolean group_created = false;
        ResponseBufferGroup group = null;
        HashMap hashMap = this._response_buffer_group_table_for_tokens;
        synchronized (hashMap) {
            Object key = ResponseBufferService.getHashKeyFromSSOToken(token);
            group = (ResponseBufferGroup)this._response_buffer_group_table_for_tokens.get(key);
            if (group == null && (group = new ResponseBufferGroup(this.getHistoryDepth())) != null) {
                group_created = true;
                this._response_buffer_group_table_for_tokens.put(key, group);
            }
        }
        if (group_created) {
            token.addSSOTokenListener((SSOTokenListener)this);
        }
        this.invalidate(ResponseBufferService.getSessionIdFromSSOToken(token));
        if (group == null) {
            sso_token_string = ResponseBufferService.getStringRepresentationForSSOToken(token);
            debug.error(sso_token_string + ": createGroupIfNecessary: Can't create group for token");
        } else if (group_created && debug.messageEnabled()) {
            sso_token_string = ResponseBufferService.getStringRepresentationForSSOToken(token);
            debug.message(sso_token_string + ": createGroupIfNecessary: Created a group for token");
        }
        return group;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void invalidate(SSOToken token) {
        if (token == null) {
            return;
        }
        ResponseBufferGroup group = null;
        HashMap hashMap = this._response_buffer_group_table_for_tokens;
        synchronized (hashMap) {
            group = (ResponseBufferGroup)this._response_buffer_group_table_for_tokens.remove(ResponseBufferService.getHashKeyFromSSOToken(token));
        }
        if (group != null) {
            group.invalidate();
            if (debug.messageEnabled()) {
                String sso_token_string = ResponseBufferService.getStringRepresentationForSSOToken(token);
                debug.message(sso_token_string + ": invalidate: Just invalidated this token");
            }
        }
    }

    public ResponseBufferEntry createEntry(SSOToken token, String request_url, HttpServletRequest request) throws SSOException {
        if (token == null) {
            return null;
        }
        ResponseBufferGroup group = this.createGroupIfNecessary(token);
        String sso_token_string = ResponseBufferService.getStringRepresentationForSSOToken(token);
        return this.createEntryInGroup(group, token, sso_token_string, request_url, request);
    }

    public ResponseBufferEntry getEntry(SSOToken token, Integer entry_number) {
        ResponseBufferGroup group = this.getGroup(token);
        if (group == null) {
            if (debug.warningEnabled()) {
                String sso_token_string = ResponseBufferService.getStringRepresentationForSSOToken(token);
                debug.warning(sso_token_string + ": getEntry: Group containing the Entry " + entry_number + " cannot be found for the given token!");
            }
            return null;
        }
        return group.getEntry(entry_number);
    }

    public String getRequestURL(SSOToken token, Integer entry_number) {
        ResponseBufferGroup group = this.getGroup(token);
        if (group == null) {
            return null;
        }
        return group.getRequestURL(entry_number);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    ResponseBufferGroup getGroup(String session_id) {
        ResponseBufferGroup group = null;
        HashMap hashMap = this._response_buffer_group_table_for_sessions;
        synchronized (hashMap) {
            group = (ResponseBufferGroup)this._response_buffer_group_table_for_sessions.get(session_id);
        }
        if (group == null && debug.messageEnabled()) {
            debug.message(session_id + ": getGroup: Can't find group for session id");
        }
        return group;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    ResponseBufferGroup createGroupIfNecessary(String session_id) {
        boolean group_created = false;
        ResponseBufferGroup group = null;
        HashMap hashMap = this._response_buffer_group_table_for_sessions;
        synchronized (hashMap) {
            group = (ResponseBufferGroup)this._response_buffer_group_table_for_sessions.get(session_id);
            if (group == null && (group = new ResponseBufferGroup(this.getHistoryDepth())) != null) {
                group_created = true;
                this._response_buffer_group_table_for_sessions.put(session_id, group);
            }
        }
        if (group == null) {
            debug.error(session_id + ": createGroupIfNecessary: Can't create group for session");
        } else if (group_created && debug.messageEnabled()) {
            debug.message(session_id + ": createGroupIfNecessary: Created a group for session");
        }
        return group;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void invalidate(String session_id) {
        if (session_id == null) {
            return;
        }
        ResponseBufferGroup group = null;
        HashMap hashMap = this._response_buffer_group_table_for_sessions;
        synchronized (hashMap) {
            group = (ResponseBufferGroup)this._response_buffer_group_table_for_sessions.remove(session_id);
        }
        if (group != null) {
            group.invalidate();
            if (debug.messageEnabled()) {
                debug.message(session_id + ": invalidate: Just invalidated this session");
            }
        }
    }

    private ResponseBufferEntry createEntry(String session_id, String request_url, HttpServletRequest request) {
        if (session_id == null) {
            return null;
        }
        ResponseBufferGroup group = this.createGroupIfNecessary(session_id);
        return this.createEntryInGroup(group, null, session_id, request_url, request);
    }

    public ResponseBufferEntry getEntry(String session_id, Integer entry_number) {
        ResponseBufferGroup group = this.getGroup(session_id);
        if (group == null) {
            if (debug.warningEnabled()) {
                debug.warning(session_id + ": getEntry: Group containing the Entry " + entry_number + " cannot be found for the given session!");
            }
            return null;
        }
        return group.getEntry(entry_number);
    }

    public String getRequestURL(String session_id, Integer entry_number) {
        ResponseBufferGroup group = this.getGroup(session_id);
        if (group == null) {
            return null;
        }
        return group.getRequestURL(entry_number);
    }

    private static String addNameValuePairAsQueryToURL(String url, String name, String value) {
        if (url == null || name == null || value == null) {
            return null;
        }
        StringBuffer url_with_name_value_pair = new StringBuffer(url);
        if (url.indexOf(63) == -1) {
            url_with_name_value_pair.append('?');
        } else {
            url_with_name_value_pair.append('&');
        }
        url_with_name_value_pair.append(name);
        url_with_name_value_pair.append('=');
        url_with_name_value_pair.append(value);
        return url_with_name_value_pair.toString();
    }

    private static String computeLoginURL() {
        String login_url = null;
        try {
            String service = "iPlanetAMPlatformService";
            String attribute = "iplanet-am-platform-login-url";
            String version = "1.0";
            SSOToken admin_token = SSOTokenManager.getInstance().createSSOToken(new Principal(){

                public String getName() {
                    return AdminUtils.getAdminDN();
                }
            }, new String(AdminUtils.getAdminPassword()));
            ServiceSchema service_schema = new ServiceSchemaManager(admin_token, service, version).getGlobalSchema();
            Set attribute_values = (Set)service_schema.getAttributeDefaults().get(attribute);
            Iterator iterator = attribute_values.iterator();
            while (iterator.hasNext() && (login_url = (String)iterator.next()) == null) {
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        return login_url;
    }

    private static String computeDesktopURL() {
        if (_login_url != null) {
            return _login_url;
        }
        return ResponseBufferService.computeLoginURL();
    }

    private static Object getHashKeyFromSSOToken(SSOToken token) {
        return ResponseBufferService.getStringRepresentationForSSOToken(token);
    }

    private static String getSessionIdFromSSOToken(SSOToken token) {
        return ResponseBufferService.getStringRepresentationForSSOToken(token);
    }

    private static String getStringRepresentationForSSOToken(SSOToken token) {
        try {
            return token.getTokenID().toString();
        }
        catch (Exception exception) {
            return null;
        }
    }

    private ResponseBufferEntry createEntryInGroup(ResponseBufferGroup group, SSOToken token, String token_or_session_id, String request_url, HttpServletRequest request) {
        Cache buffer;
        ResponseBufferEntry entry = null;
        if (group != null && (buffer = new Cache(request_url)) != null && (entry = group.createEntry(buffer)) != null) {
            buffer.addParamIdentifier(ENTRY_NUMBER);
            buffer.setBaseUrl(this.getEntryURL(entry, token, request));
        }
        if (entry == null) {
            debug.error(token_or_session_id + ": createEntry: Failed to create entry for " + request_url);
        } else if (debug.messageEnabled()) {
            debug.message(token_or_session_id + ": createEntry: Entry for " + request_url + " has been created with number " + entry.getEntryNumber());
        }
        return entry;
    }

    protected static String getAbsoluteURL(String url, HttpServletRequest request, Client client) throws MalformedURLException {
        if (url.regionMatches(true, 0, "http://", 0, 7) || url.regionMatches(true, 0, "https://", 0, 7)) {
            return url;
        }
        StringBuffer ru = ResponseBufferService.getRequestURLUsingHostHeader(request, client);
        URL requestURL = new URL(ru.toString());
        String scheme = requestURL.getProtocol();
        int port = requestURL.getPort();
        if (scheme.equals("http") && port <= 0) {
            port = 80;
        } else if (scheme.equals("https") && port <= 0) {
            port = 443;
        }
        StringBuffer absURL = new StringBuffer().append(scheme).append("://").append(requestURL.getHost()).append(":").append(port).append(url);
        return absURL.toString();
    }

    private static StringBuffer getRequestURLUsingHostHeader(HttpServletRequest request, Client client) {
        String i;
        StringBuffer url = new StringBuffer();
        boolean ignoreHostHeader = false;
        if (client != null && (i = client.getProperty("ignoreHostHeader")) != null) {
            ignoreHostHeader = Boolean.getBoolean(i.toLowerCase());
        }
        String host = null;
        if (!ignoreHostHeader) {
            host = request.getHeader("host");
        }
        String scheme = request.getScheme();
        url.append(scheme).append("://");
        if (host == null) {
            url.append(request.getServerName());
            int port = request.getServerPort();
            if (scheme.equals("http") && port != 80 || scheme.equals("https") && port != 443) {
                url.append(':').append(port);
            }
        } else {
            url.append(host);
        }
        return url;
    }
}

