/*
 * Decompiled with CFR 0.152.
 */
package com.sun.mobile.responsebuffer;

import com.aligo.util.Cache;
import com.sun.mobile.responsebuffer.ResponseBufferEntry;
import java.util.SortedMap;
import java.util.TreeMap;

class ResponseBufferGroup {
    private ResponseBufferEntry _entry = null;
    private SortedMap _invalidated_entry_url_list = null;
    private int _max_invalidated_entry_url_list_size = 0;
    private int _counter = 0;
    private boolean _is_valid = true;

    ResponseBufferGroup(int max_num_invalidated_entry_urls) {
        if (max_num_invalidated_entry_urls > 0) {
            this._max_invalidated_entry_url_list_size = max_num_invalidated_entry_urls;
            this._invalidated_entry_url_list = new TreeMap();
        }
    }

    public synchronized boolean isValid() {
        return this._is_valid;
    }

    synchronized void invalidate(Integer entry_number) {
        this.invalidate(this.getEntry(entry_number));
    }

    synchronized void invalidate(ResponseBufferEntry entry) {
        if (entry == null) {
            return;
        }
        entry.setInvalid();
        if (this._invalidated_entry_url_list != null) {
            Object _lowest_entry_number;
            if (this._invalidated_entry_url_list.size() >= this._max_invalidated_entry_url_list_size && (_lowest_entry_number = this._invalidated_entry_url_list.firstKey()) != null) {
                this._invalidated_entry_url_list.remove(_lowest_entry_number);
            }
            this._invalidated_entry_url_list.put(entry.getEntryNumber(), entry.getRequestURL());
        }
    }

    synchronized void invalidate() {
        if (!this._is_valid) {
            return;
        }
        this._is_valid = false;
        if (this._entry != null) {
            this._entry.setInvalid();
        }
        if (this._invalidated_entry_url_list != null) {
            this._invalidated_entry_url_list.clear();
        }
    }

    private synchronized Integer getNextEntryNumber() {
        return new Integer(++this._counter);
    }

    synchronized ResponseBufferEntry createEntry(Cache cache) {
        this.invalidate(this._entry);
        this._entry = new ResponseBufferEntry(this, this.getNextEntryNumber(), cache);
        return this._entry;
    }

    synchronized ResponseBufferEntry getEntry(Integer entry_number) {
        if (entry_number == null || this._entry == null || entry_number.compareTo(this._entry.getEntryNumber()) != 0) {
            return null;
        }
        return this._entry;
    }

    synchronized String getRequestURL(Integer entry_number) {
        ResponseBufferEntry entry = this.getEntry(entry_number);
        if (entry != null) {
            return entry.getRequestURL();
        }
        if (this._invalidated_entry_url_list != null) {
            return (String)this._invalidated_entry_url_list.get(entry_number);
        }
        return null;
    }
}

