/*
 * Decompiled with CFR 0.152.
 */
package com.sun.mobile.responsebuffer;

import com.aligo.util.Cache;
import com.sun.mobile.responsebuffer.ResponseBufferGroup;
import com.sun.mobile.responsebuffer.StaleResponseBufferDataException;

public class ResponseBufferEntry {
    private ResponseBufferGroup _group = null;
    private Integer _entry_number = null;
    private String _request_url = null;
    private boolean _is_valid = true;
    private Cache _buffer = null;

    ResponseBufferEntry(ResponseBufferGroup response_buffer_group, Integer response_buffer_entry_number, Cache buffer) {
        this._group = response_buffer_group;
        this._entry_number = response_buffer_entry_number;
        this._buffer = buffer;
        if (buffer != null) {
            this._request_url = buffer.getRequestUrl();
        }
    }

    private ResponseBufferEntry() {
    }

    public Cache getCache() throws StaleResponseBufferDataException {
        if (!this.isValid()) {
            throw new StaleResponseBufferDataException();
        }
        return this._buffer;
    }

    public synchronized boolean isValid() {
        return this._is_valid;
    }

    synchronized void setInvalid() {
        if (this._is_valid) {
            this._is_valid = false;
        }
    }

    public synchronized void invalidate() {
        if (this.isValid()) {
            this.setInvalid();
            if (this._group != null) {
                this._group.invalidate(this._entry_number);
            }
        }
    }

    public String getRequestURL() {
        return this._request_url;
    }

    public ResponseBufferGroup getGroup() {
        return this._group;
    }

    public Integer getEntryNumber() {
        return this._entry_number;
    }
}

