/*
 * Decompiled with CFR 0.152.
 */
package com.sun.mobile.filter;

import com.aligo.engine.Content;
import com.aligo.portal.wireless.services.rendering.RenderingEngine;
import com.aligo.portal.wireless.services.rendering.RenderingEngineFactory;
import com.aligo.portal.wireless.services.rendering.RenderingException;
import com.aligo.util.Cache;
import com.iplanet.am.util.AMClientDetector;
import com.iplanet.am.util.Debug;
import com.iplanet.am.util.Locale;
import com.iplanet.services.cdm.Client;
import com.iplanet.services.cdm.ClientException;
import com.iplanet.services.cdm.ClientsManager;
import com.iplanet.sso.SSOException;
import com.iplanet.sso.SSOToken;
import com.iplanet.sso.SSOTokenManager;
import com.sun.identity.common.ISLocaleContext;
import com.sun.mobile.filter.AMLHttpResponse;
import com.sun.mobile.responsebuffer.ResponseBufferEntry;
import com.sun.mobile.responsebuffer.ResponseBufferService;
import com.sun.mobile.responsebuffer.StaleResponseBufferDataException;
import java.io.IOException;
import java.io.PrintWriter;
import java.util.MissingResourceException;
import java.util.ResourceBundle;
import javax.servlet.Filter;
import javax.servlet.FilterChain;
import javax.servlet.FilterConfig;
import javax.servlet.ServletContext;
import javax.servlet.ServletException;
import javax.servlet.ServletOutputStream;
import javax.servlet.ServletRequest;
import javax.servlet.ServletResponse;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;

public class AMLController
implements Filter {
    public static Debug debug = Debug.getInstance((String)"AMLFilterConfig");
    private RenderingEngineFactory engineFactory = null;
    private RenderingEngine engine = null;
    private ServletContext context = null;
    private AMClientDetector cd = null;
    private static final String RESPONSE = "AMLResponseObject";
    private static final String AML_PATH = "/aml/";
    public static final String AML_CONTENT_TYPE = "text/aml";

    public void init(FilterConfig config) throws ServletException {
        this.context = config.getServletContext();
        this.cd = new AMClientDetector();
        this.engineFactory = RenderingEngineFactory.getInstance();
    }

    public void destroy() {
    }

    public void doFilter(ServletRequest request, ServletResponse response, FilterChain chain) throws IOException, ServletException {
        AMLHttpResponse resp;
        HttpServletRequest hReq = (HttpServletRequest)request;
        String uri = hReq.getRequestURI();
        if (debug.messageEnabled()) {
            debug.message("AMLController: Filter URI: " + uri);
        }
        if ((resp = (AMLHttpResponse)((Object)hReq.getAttribute(RESPONSE))) != null) {
            this.checkForAML(uri, resp);
            try {
                chain.doFilter((ServletRequest)hReq, (ServletResponse)resp);
            }
            catch (ServletException se) {
                String msg = " Error: (uri=" + uri + "): ";
                this.context.log(msg, (Throwable)se);
                throw se;
            }
            return;
        }
        if (debug.messageEnabled()) {
            debug.message("--------\nAMLController: New request: " + request);
        }
        AMLHttpResponse mapResponse = new AMLHttpResponse((HttpServletResponse)response);
        hReq.setAttribute(RESPONSE, (Object)mapResponse);
        this.checkForAML(uri, mapResponse);
        try {
            chain.doFilter((ServletRequest)hReq, (ServletResponse)mapResponse);
        }
        catch (ServletException se) {
            String msg = " Error: (uri=" + uri + "): ";
            this.context.log(msg, (Throwable)se);
            throw se;
        }
        catch (RuntimeException re) {
            this.doTransform(hReq, response, mapResponse);
            String msg = " Error: (uri=" + uri + "): ";
            this.context.log(msg, (Throwable)re);
            if (debug.messageEnabled()) {
                debug.message("AMLController: (handled_rtexcptn) transform(): " + uri + " : ", (Throwable)re);
                debug.message("-------------------------");
            }
            throw re;
        }
        this.doTransform(hReq, response, mapResponse);
        if (debug.messageEnabled()) {
            debug.message("AMLController: (normal) transform(): " + uri + "\n-------------------------");
        }
    }

    private void doTransform(HttpServletRequest request, ServletResponse response, AMLHttpResponse mapResponse) throws IOException, ServletException {
        String clientType = this.cd.getClientType(request);
        Client client = null;
        try {
            client = ClientsManager.getInstance((String)clientType);
        }
        catch (ClientException ce) {
            debug.error("Could not getClientInstance(): ", (Throwable)ce);
            client = ClientsManager.getDefaultInstance();
        }
        if (mapResponse.usingStream() || mapResponse.usingWriter()) {
            String buffer = null;
            buffer = this.getAMLContent(mapResponse);
            if (buffer != null) {
                String trxfd = this.transform(request, mapResponse, buffer, client);
                PrintWriter out = response.getWriter();
                out.print(trxfd);
                out.flush();
            } else {
                byte[] arr = mapResponse.getByteArray();
                debug.message("AMLController: Stream Size = " + arr.length);
                ServletOutputStream out = response.getOutputStream();
                out.write(arr, 0, arr.length);
                out.flush();
            }
            response.flushBuffer();
        } else if (debug.messageEnabled()) {
            debug.message("AMLController: nothing to transform(): ");
        }
    }

    private void checkForAML(String uri, AMLHttpResponse mResp) {
        if (mResp != null) {
            return;
        }
        if (mResp.isContentAML()) {
            return;
        }
        if (uri != null && uri.indexOf(AML_PATH) != -1) {
            mResp.setContentAML(true);
        }
    }

    private String getAMLContent(AMLHttpResponse mapResp) {
        String buffer = mapResp.getBufferAsString();
        return buffer;
    }

    private String transform(HttpServletRequest request, AMLHttpResponse mapResp, String input, Client client) {
        String output = null;
        if (debug.messageEnabled()) {
            debug.message("AMLInput: " + input);
        }
        SSOToken sso_token = null;
        try {
            sso_token = SSOTokenManager.getInstance().createSSOToken(request);
        }
        catch (SSOException ssoe) {
            // empty catch block
        }
        ResponseBufferService service = ResponseBufferService.getInstance();
        ResponseBufferEntry entry = null;
        Object session_id = null;
        if (sso_token != null) {
            try {
                entry = service.createEntry(sso_token, request.getRequestURL().toString(), request);
            }
            catch (SSOException ssoe) {
                // empty catch block
            }
        }
        StringBuffer logName = new StringBuffer("AMLController: ");
        logName.append(request.getRequestURI());
        if (request.getQueryString() != null) {
            logName.append("?");
            logName.append(request.getQueryString());
        }
        Cache entry_cache = null;
        try {
            if (entry != null) {
                entry_cache = entry.getCache();
            }
        }
        catch (StaleResponseBufferDataException srbde) {
            entry_cache = null;
        }
        RenderingEngine engine = this.engineFactory.getEngine(entry_cache, new String(logName));
        Content content = null;
        try {
            content = engine.renderContent(input, client, entry != null, false);
            if (content != null) {
                output = content.getContents();
            } else {
                debug.error("AMLController: Rendering engine returned null Content");
                output = this.fetchErrorPage(input, client, sso_token, request, mapResp, engine, service);
            }
        }
        catch (RenderingException rex) {
            debug.error("AMLController.transform(): ", (Throwable)rex);
            output = this.fetchErrorPage(input, client, sso_token, request, mapResp, engine, service);
        }
        String cType = mapResp.getContentType();
        if (cType == null || cType.indexOf(AML_CONTENT_TYPE) != -1) {
            String content_type = null;
            content_type = content != null ? content.getHeader("Content-type") : client.getProperty("contentType") + " ; charset=" + mapResp.getCharEnc();
            mapResp.setContentType(content_type);
        }
        if (debug.messageEnabled()) {
            debug.message("Markup : " + output);
        }
        return output;
    }

    private String fetchErrorPage(String input, Client client, SSOToken ssoToken, HttpServletRequest request, AMLHttpResponse mapResp, RenderingEngine engine, ResponseBufferService service) {
        String errPg = null;
        String errStr = null;
        String desktopURL = null;
        ResourceBundle bundle = null;
        java.util.Locale locale = null;
        try {
            if (ssoToken != null) {
                locale = Locale.getLocale((String)ssoToken.getProperty("Locale"));
            }
        }
        catch (SSOException se) {
            // empty catch block
        }
        if (locale == null) {
            ISLocaleContext lcontext = new ISLocaleContext();
            lcontext.setLocale(request);
            locale = lcontext.getLocale();
        }
        try {
            bundle = ResourceBundle.getBundle("RenderingError", locale);
            errStr = bundle.getString("defaultError");
        }
        catch (MissingResourceException mre) {
            if (debug.messageEnabled()) {
                debug.message("AMLController.fetchErrorPage(): ", (Throwable)mre);
            }
            return "";
        }
        if (debug.messageEnabled()) {
            debug.message("AMLController.fetchErrorPage(): Error page from properties file = " + errStr);
        }
        desktopURL = service.getDesktopURL();
        String encodedDesktopURL = null;
        if (ssoToken != null) {
            try {
                encodedDesktopURL = ssoToken.encodeURL(desktopURL);
            }
            catch (SSOException ss) {
                // empty catch block
            }
        }
        if (encodedDesktopURL == null) {
            encodedDesktopURL = desktopURL;
        }
        if (debug.messageEnabled()) {
            debug.message("AMLController.fetchErrorPage(): desktop url = " + encodedDesktopURL);
        }
        if (errStr != null) {
            int start = errStr.indexOf("[PORTALHM]");
            if (start != -1) {
                int end = start + 10;
                StringBuffer errBuf = new StringBuffer(errStr);
                errPg = errBuf.replace(start, end, encodedDesktopURL).toString();
            } else {
                errPg = errStr;
            }
            if (debug.messageEnabled()) {
                debug.message("AMLController.fetchErrorPage(): Error Page to render = " + errPg);
            }
        }
        try {
            Content content = engine.renderContent(errPg, client, false, false);
            if (content != null) {
                if (debug.messageEnabled()) {
                    debug.message("AMLController.fetchErrorPage(): xformed content: " + content.getContents());
                }
                return content.getContents();
            }
            if (debug.messageEnabled()) {
                debug.message("AMLController.fetchErrorPage(): xformed content is null");
            }
            return "";
        }
        catch (RenderingException re) {
            if (debug.messageEnabled()) {
                debug.message("AMLController.fetchErrorPage(): Unrecoverable Rendering Exception", (Throwable)re);
            }
            return "";
        }
    }
}

