/*
 * Decompiled with CFR 0.152.
 */
package com.sun.mobile.cdm;

import com.iplanet.services.cdm.Client;
import com.iplanet.services.cdm.ClientDetectionException;
import com.sun.ccpp.DescriptionManager;
import com.sun.ccpp.ProfileFactoryImpl;
import com.sun.ccpp.ProfileFragmentFactoryImpl;
import com.sun.mobile.cdm.CCPPClientDetector;
import com.sun.mobile.cdm.DebugHandler;
import com.sun.mobile.cdm.OrderedSet;
import com.sun.mobile.util.MAPConfigProperties;
import java.io.File;
import java.util.AbstractSet;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import java.util.StringTokenizer;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.ccpp.Attribute;
import javax.ccpp.Profile;
import javax.ccpp.ProfileFactory;
import javax.ccpp.ProfileFragmentFactory;
import javax.ccpp.SequenceAttribute;
import javax.ccpp.SetAttribute;
import javax.servlet.http.HttpServletRequest;

public class FEDIClientDetector
extends CCPPClientDetector {
    private String thisClassName = this.getClass().getName();
    public static final String DEF_CONFIG_ROOT = "/etc/opt/SUNWps/MAP/fedi";
    public static final String DEF_SCHEMA_FILE = "/vocabularies/vocabulary.xsd";
    public static final String DEF_VOCAB_DEFNS = "/vocabularies/uaprof20000405a.xml /vocabularies/uaprof20000405b.xml /vocabularies/uaprof20010330a.xml /vocabularies/uaprof20010330b.xml /vocabularies/uaprof20010430.xml /vocabularies/uaprof20020710.xml";
    private static final String CONFIG_ROOT = MAPConfigProperties.get("fediConfigRoot", "/etc/opt/SUNWps/MAP/fedi");
    private static final String SCHEMA_FILE = MAPConfigProperties.get("schemaFile", "/vocabularies/vocabulary.xsd");
    private static final String VOCAB_DEFNS = MAPConfigProperties.get("vocabularyDefinitions", "/vocabularies/uaprof20000405a.xml /vocabularies/uaprof20000405b.xml /vocabularies/uaprof20010330a.xml /vocabularies/uaprof20010330b.xml /vocabularies/uaprof20010430.xml /vocabularies/uaprof20020710.xml");
    private static final String STORE_PROFILE_IN = MAPConfigProperties.get("storeProfileInClient", null);
    private static ProfileFactory profileFactory = null;

    private static String[] parseString(String data) {
        StringTokenizer st = new StringTokenizer(data);
        String[] arr = new String[st.countTokens()];
        int i = 0;
        while (st.hasMoreTokens()) {
            arr[i] = CONFIG_ROOT + st.nextToken();
            ++i;
        }
        return arr;
    }

    protected Map getMergedUAProfile(Client client, HttpServletRequest request) throws ClientDetectionException {
        if (profileFactory == null) {
            throw new ClientDetectionException(this.thisClassName + " :: ProfileFactory Object not Initialized.");
        }
        Profile profile = null;
        try {
            profile = profileFactory.newProfile(request);
        }
        catch (Exception e) {
            debug.warning(this.thisClassName + ": Merge Profile failed: ", (Throwable)e);
        }
        Set attrs = null;
        if (profile == null || (attrs = profile.getAttributes()) == null) {
            debug.warning(this.thisClassName + ": Merge failed: Profile object is empty");
            return null;
        }
        if (debug.messageEnabled()) {
            debug.message("PROFILE STR:" + profile.toString());
        }
        HashMap<String, Set> profMap = new HashMap<String, Set>();
        Iterator itr = attrs.iterator();
        while (itr.hasNext()) {
            String propertyName;
            Attribute attr = (Attribute)itr.next();
            Set values = this.getPropertiesFromUAProf(attr, propertyName = attr.getName());
            if (values == null) continue;
            if (profMap.containsKey(propertyName)) {
                propertyName = attr.getDescription().getURI();
            }
            profMap.put(propertyName, values);
        }
        if (STORE_PROFILE_IN != null) {
            OrderedSet prop = new OrderedSet(2);
            prop.add(STORE_PROFILE_IN);
            prop.add(profile);
            profMap.put(STORE_PROFILE_IN, prop);
        }
        return profMap;
    }

    private Set getPropertiesFromUAProf(Attribute p, String name) {
        if (p == null || name == null) {
            return null;
        }
        AbstractSet properties = null;
        try {
            if (p instanceof SetAttribute) {
                Collection c = (Collection)p.getValue();
                if (c != null) {
                    Iterator itr = c.iterator();
                    properties = new HashSet(c.size());
                    while (itr.hasNext()) {
                        String s = itr.next().toString();
                        properties.add(s);
                    }
                }
            } else if (p instanceof SequenceAttribute) {
                Collection c = (Collection)p.getValue();
                if (c != null) {
                    properties = new OrderedSet(c);
                }
            } else {
                String s = p.toString();
                if (s != null) {
                    properties = new HashSet(1);
                    properties.add(s);
                }
            }
        }
        catch (Exception e) {
            // empty catch block
        }
        return properties;
    }

    static {
        Logger logger = Logger.getLogger("com.sun.ccpp.logger");
        logger.setLevel(Level.ALL);
        DebugHandler dh = new DebugHandler(debug);
        logger.addHandler(dh);
        ProfileFactory pf = ProfileFactoryImpl.getInstance();
        ProfileFactory.setInstance((ProfileFactory)pf);
        ProfileFragmentFactory pff = ProfileFragmentFactoryImpl.getInstance();
        ProfileFragmentFactory.setInstance((ProfileFragmentFactory)pff);
        try {
            String schemaFile = CONFIG_ROOT + SCHEMA_FILE;
            File schema = new File(schemaFile);
            DescriptionManager.setSchema((File)schema);
            DescriptionManager dm = DescriptionManager.getInstance();
            String[] vocabFiles = FEDIClientDetector.parseString(VOCAB_DEFNS);
            for (int i = 0; i < vocabFiles.length; ++i) {
                File vocab = new File(vocabFiles[i]);
                dm.addVocabulary(vocab);
            }
            profileFactory = ProfileFactory.getInstance();
        }
        catch (Throwable e) {
            debug.warning("Could not create Profile Object", e);
            e.printStackTrace();
        }
    }
}

