/*
 * Decompiled with CFR 0.152.
 */
package com.sun.mobile.cdm;

import com.iplanet.am.util.Debug;
import com.iplanet.services.cdm.Client;
import com.iplanet.services.cdm.ClientDetectionException;
import com.iplanet.services.cdm.ClientsManager;
import com.sun.mobile.cdm.MAPClientDetector;
import com.sun.mobile.util.MAPConfigProperties;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.Hashtable;
import java.util.Map;
import java.util.Set;
import java.util.StringTokenizer;
import javax.servlet.http.HttpServletRequest;

public class CCPPClientDetector
extends MAPClientDetector {
    private String thisClassName = this.getClass().getName();
    public static final String[] CPI_PROFILE_HEADERS = new String[]{"x-wap-profile", "Profile"};
    public static final String PROPS_HEADERS = "ps.uaprof.http.headers";
    public static final String REQ_PROF_ATTR = "com.sun.profile.uri";
    protected static Debug debug = Debug.getInstance((String)"CCPPClientDetector");
    private static Hashtable profileURITable = new Hashtable();
    private static Map statusMap = new HashMap();
    private static String[] headerNames = null;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Client getCCPPClient(String profURI, Client client, HttpServletRequest request) {
        if (debug.messageEnabled()) {
            debug.message(this.thisClassName + " :getCCPPClient(uri) = " + profURI);
        }
        Client ccppClient = null;
        Object mergeIndicator = null;
        Object object = statusMap;
        synchronized (object) {
            ccppClient = (Client)profileURITable.get(profURI);
            if (ccppClient != null) {
                return ccppClient;
            }
            mergeIndicator = statusMap.get(profURI);
            if (mergeIndicator == null) {
                mergeIndicator = new Object();
                statusMap.put(profURI, mergeIndicator);
                if (debug.messageEnabled()) {
                    debug.message("*** Adding to MonitorList: " + profURI);
                }
            }
        }
        object = mergeIndicator;
        synchronized (object) {
            ccppClient = (Client)profileURITable.get(profURI);
            if (ccppClient != null) {
                return ccppClient;
            }
            if (debug.messageEnabled()) {
                debug.message("*** Merging profiles for: " + profURI);
            }
            try {
                Map map = this.getMergedUAProfile(client, request);
                if (map != null) {
                    ccppClient = this.makeAndAddClient(profURI, client, map);
                }
            }
            catch (Throwable e) {
                debug.warning(this.thisClassName + " :: Merge profile failed.", e);
            }
            Map map = statusMap;
            synchronized (map) {
                statusMap.remove(profURI);
            }
        }
        return ccppClient;
    }

    private Client makeAndAddClient(String profURI, Client localClient, Map cMap) {
        if (profURI == null || cMap == null) {
            return null;
        }
        Set ctSet = this.makeClientType(profURI);
        cMap.put("clientType", ctSet);
        String parentCT = localClient.getClientType();
        Set parentSet = this.createSet(parentCT);
        cMap.put("parentId", parentSet);
        String clientType = this.getFirstAndOnlyString(ctSet);
        if (debug.messageEnabled()) {
            debug.message(this.thisClassName + " : makeClient() = " + profURI + " :: ClientType = " + clientType + " : Parent : " + parentSet);
        }
        Client c = null;
        try {
            c = this.addClient(clientType, cMap, false);
            profileURITable.put(profURI, c);
        }
        catch (Exception e) {
            debug.warning(this.thisClassName + " :: Failed to add clientType to Manager : " + clientType, (Throwable)e);
        }
        return c;
    }

    protected String getProfileURI(HttpServletRequest request) {
        String profileURI = null;
        profileURI = (String)request.getAttribute(REQ_PROF_ATTR);
        if (profileURI != null) {
            return profileURI;
        }
        StringBuffer sb = null;
        for (int i = 0; i < headerNames.length; ++i) {
            Enumeration e = request.getHeaders(headerNames[i]);
            while (e.hasMoreElements()) {
                String header = (String)e.nextElement();
                header = header.trim();
                if (sb == null) {
                    sb = new StringBuffer();
                } else {
                    sb.append('_');
                }
                sb.append(header);
            }
        }
        if (sb != null) {
            profileURI = sb.toString();
            request.setAttribute(REQ_PROF_ATTR, (Object)profileURI);
        }
        return profileURI;
    }

    public String getClientType(HttpServletRequest request) throws ClientDetectionException {
        String profileURI = this.getProfileURI(request);
        Client client = null;
        if (profileURI != null && (client = (Client)profileURITable.get(profileURI)) != null) {
            String ct = client.getClientType();
            if (debug.messageEnabled()) {
                debug.message(this.thisClassName + ": ====== getClientType(perf) Returning: " + ct);
            }
            return ct;
        }
        String uaMatchedClientType = super.getClientType(request);
        if (debug.messageEnabled()) {
            debug.message(this.thisClassName + ":: UA Match = " + uaMatchedClientType + " :: Profile URI = " + profileURI);
        }
        if (profileURI == null) {
            if (debug.messageEnabled()) {
                debug.message(this.thisClassName + " :: Legacy device = " + uaMatchedClientType);
            }
            return uaMatchedClientType;
        }
        try {
            client = ClientsManager.getInstance((String)uaMatchedClientType);
        }
        catch (Exception e) {
            debug.warning("GOT Excptn: ", (Throwable)e);
        }
        Client ccppClient = this.getCCPPClient(profileURI, client, request);
        String clientType = null;
        if (ccppClient != null) {
            clientType = ccppClient.getClientType();
        }
        if (clientType == null) {
            clientType = uaMatchedClientType;
        }
        if (debug.messageEnabled()) {
            debug.message(this.thisClassName + ": ====== getClientType() Returning: " + clientType);
        }
        return clientType;
    }

    protected Map getMergedUAProfile(Client client, HttpServletRequest request) throws ClientDetectionException {
        debug.error(this.thisClassName + " : Cannot support cc/pp without an RI");
        return null;
    }

    static {
        String value = MAPConfigProperties.get(PROPS_HEADERS, null);
        if (value == null) {
            headerNames = CPI_PROFILE_HEADERS;
        } else {
            StringTokenizer st = new StringTokenizer(value);
            headerNames = new String[st.countTokens()];
            int i = 0;
            while (st.hasMoreTokens()) {
                CCPPClientDetector.headerNames[i] = st.nextToken();
                ++i;
            }
        }
    }
}

