/*
 * Decompiled with CFR 0.152.
 */
package com.aligo.portal.wireless.services.rendering;

import com.aligo.engine.logging.interfaces.LoggerInterface;
import com.aligo.portal.wireless.services.rendering.CommonLogger;
import com.aligo.portal.wireless.services.rendering.Logger;
import com.aligo.portal.wireless.services.rendering.RenderingEngine;
import com.aligo.util.Cache;

public class RenderingEngineFactory {
    private static RenderingEngineFactory actualFactory;
    private LoggerInterface logger;

    private RenderingEngineFactory() {
        this.setLogger(new CommonLogger());
    }

    public static synchronized RenderingEngineFactory getInstance() {
        if (actualFactory == null) {
            actualFactory = new RenderingEngineFactory();
        }
        return actualFactory;
    }

    public void setLogger(LoggerInterface logger) {
        this.logger = logger;
        RenderingEngine.setLogger(logger);
    }

    public LoggerInterface getLogger() {
        return this.logger;
    }

    public RenderingEngine getEngine(Cache cache, Logger logger) {
        RenderingEngine renderer = new RenderingEngine(cache, logger);
        return renderer;
    }

    public RenderingEngine getEngine(Cache cache, String logName) {
        return this.getEngine(cache, new Logger(logName));
    }
}

