/*
 * Decompiled with CFR 0.152.
 */
package com.aligo.portal.wireless.services.rendering;

import com.aligo.aml.AmlCollection;
import com.aligo.aml.AmlDocument;
import com.aligo.aml.AmlPage;
import com.aligo.aml.base.interfaces.AmlElement;
import com.aligo.engine.Content;
import com.aligo.engine.interfaces.AligoEngineFactory;
import com.aligo.engine.interfaces.AligoEngineInterface;
import com.aligo.engine.logging.interfaces.LoggerInterface;
import com.aligo.morpher.AligoMorpher;
import com.aligo.portal.wireless.services.rendering.RenderingException;
import com.aligo.profile.UAProfileClient;
import com.aligo.profile.interfaces.UAProfile;
import com.aligo.util.Cache;
import com.iplanet.services.cdm.Client;

public class RenderingEngine {
    private static final String RENDERING_ENGINE = "Rendering engine ";
    private static final String NULL_CLIENT = "Null client...";
    private static int MAXSIZE = Integer.MAX_VALUE;
    private Cache oCache;
    private LoggerInterface oLogger;

    public void setCache(Cache oCache) {
        this.oCache = oCache;
    }

    public RenderingEngine(Cache cache, LoggerInterface renderLogger) {
        this.setCache(cache);
        this.setRenderLogger(renderLogger);
    }

    private static AligoEngineInterface getNativeAligoEngine() {
        return AligoEngineFactory.getAligoEngine();
    }

    public static void setLogger(LoggerInterface logger) {
        AligoEngineInterface aligoEngine = RenderingEngine.getNativeAligoEngine();
        aligoEngine.setLogger(logger);
    }

    private void setRenderLogger(LoggerInterface logger) {
        this.oLogger = logger;
    }

    public Content renderContent(String aml, Client client) throws RenderingException {
        return this.renderContent(aml, client, true, true);
    }

    public Content renderContent(String aml, Client client, boolean cache, boolean forgive) throws RenderingException {
        return this.renderContent(aml, client, true, true, false);
    }

    public Content renderContent(String aml, Client client, boolean cache, boolean forgive, boolean fragment) throws RenderingException {
        Content content = null;
        try {
            Cache ocache = this.setupCache(fragment, cache);
            UAProfile uaprofile = this.getUAProfile(client, ocache);
            AmlElement amlElement = this.getAmlElement(aml, forgive, fragment);
            AligoEngineInterface aligoEngine = this.getAligoEngine(ocache);
            content = this.renderContent(aligoEngine, amlElement, uaprofile);
        }
        catch (Exception e) {
            this.oLogger.logError((Throwable)e);
            throw new RenderingException(e.getMessage());
        }
        return content;
    }

    private Cache setupCache(boolean fragment, boolean cache) {
        boolean mCache = cache ? !fragment : cache;
        return mCache ? this.oCache : null;
    }

    private UAProfile getUAProfile(Client client, Cache cache) throws RenderingException {
        UAProfileClient uaprof = null;
        if (client != null) {
            uaprof = new UAProfileClient(client);
            if (cache == null) {
                uaprof.setPDUSize(MAXSIZE);
            }
        } else {
            this.oLogger.logError("Rendering engine Null client...");
            throw new RenderingException(NULL_CLIENT);
        }
        return uaprof;
    }

    private AmlElement getAmlElement(String aml, boolean forgive, boolean fragment) throws RenderingException {
        AmlElement element;
        block11: {
            AligoMorpher morpher = new AligoMorpher(this.oLogger);
            try {
                boolean multiple = false;
                if (fragment) {
                    multiple = true;
                }
                element = morpher.getAmlObject(aml, forgive, multiple);
                if (fragment) {
                    if (!(element instanceof AmlDocument)) break block11;
                    int numberChildren = element.getNumberElements();
                    if (numberChildren == 1) {
                        try {
                            element = element.amlElementAt(0);
                        }
                        catch (Exception ex) {
                            this.oLogger.logError((Throwable)ex);
                        }
                        break block11;
                    }
                    AmlCollection elements = new AmlCollection();
                    int i = 0;
                    while (i < numberChildren) {
                        try {
                            elements.addAmlElement(element.amlElementAt(i));
                        }
                        catch (Exception ex) {
                            this.oLogger.logError((Throwable)ex);
                        }
                        ++i;
                    }
                    element = elements;
                    break block11;
                }
                if (element instanceof AmlPage) {
                    AmlDocument document = new AmlDocument();
                    document.addAmlPage((AmlPage)element);
                    element = document;
                }
            }
            catch (Exception e) {
                throw new RenderingException(e.getMessage());
            }
        }
        return element;
    }

    private AligoEngineInterface getAligoEngine(Cache cache) {
        AligoEngineInterface aligoEngine = RenderingEngine.getNativeAligoEngine();
        if (cache != null) {
            aligoEngine.setCache(cache);
        }
        aligoEngine.setLocalLogger(this.oLogger);
        return aligoEngine;
    }

    private Content renderContent(AligoEngineInterface aligoEngine, AmlElement amlElement, UAProfile uaprof) throws RenderingException {
        try {
            return aligoEngine.processContent(amlElement, uaprof);
        }
        catch (Exception e) {
            throw new RenderingException(e.getMessage());
        }
    }
}

