/*
 * Decompiled with CFR 0.152.
 */
package com.aligo.portal.wireless.services.rendering;

import com.aligo.engine.Content;
import com.aligo.engine.logging.interfaces.LoggerInterface;
import com.aligo.portal.wireless.services.rendering.CacheManagerFactory;
import com.aligo.portal.wireless.services.rendering.CachingException;
import com.aligo.util.Cache;
import com.aligo.util.CacheReader;
import com.aligo.util.URLGet;
import com.aligo.util.URLMethod;
import com.aligo.util.URLPost;
import java.net.URL;
import java.util.Hashtable;
import javax.servlet.http.HttpServletRequest;

public class CacheManager {
    private static final String CACHE_MANAGER = "CACHE MANAGER ";
    private Cache oCache;
    private Hashtable oFormParms;
    private HttpServletRequest oRequest;
    private LoggerInterface oLogger;
    private static final String UNKNOWN_FORMNUM = "UNKNOWN";
    private static final String PARAM_VALUE_SEPARATOR = "=";
    private static final String GET = "get";
    private static final String POST = "post";

    public CacheManager(Cache cache, LoggerInterface logger) {
        this.setCache(cache);
        this.setLogger(logger);
    }

    private void setCache(Cache cache) {
        this.oCache = cache;
    }

    private void setLogger(LoggerInterface logger) {
        this.oLogger = logger;
    }

    public Content getContent(HttpServletRequest request) throws CachingException {
        Content content = null;
        try {
            this.oRequest = request;
            CacheReader.storeCachedParameters((Cache)this.oCache, (HttpServletRequest)this.oRequest);
            if (this.oLogger.debugEnabled()) {
                this.oLogger.logDebug("CACHE MANAGER stored params = " + CacheReader.getParams((Cache)this.oCache, (HttpServletRequest)this.oRequest));
            }
            String url = this.oRequest.getQueryString();
            content = this.getContent(this.oCache, this.oRequest, url);
        }
        catch (Exception ex) {
            this.oLogger.logError((Throwable)ex);
            throw new CachingException(ex.getMessage());
        }
        return content;
    }

    private Content getContent(Cache cache, HttpServletRequest request, String url) throws CachingException {
        Content content = null;
        try {
            String cacheQuery = cache.getCacheQuery();
            String dynamicQuery = cache.getDynamicQuery();
            String cacheIdentifier = cache.getCacheIdentifier();
            boolean cacheRegular = false;
            boolean cacheDynamic = false;
            String index = null;
            if (request != null) {
                String cacheVal = request.getParameter(cacheIdentifier);
                if (cacheVal != null) {
                    if (cacheVal.equals(cache.getCacheIdentifierValue())) {
                        cacheRegular = true;
                    } else if (cacheVal.equals(cache.getDynamicIdentifierValue())) {
                        cacheDynamic = true;
                    }
                }
                index = CacheReader.getIndex((Cache)cache, (HttpServletRequest)request);
            } else if (url != null) {
                if (url.indexOf(cacheQuery) != -1) {
                    cacheRegular = true;
                } else if (url.indexOf(dynamicQuery) != -1) {
                    cacheDynamic = true;
                }
                index = CacheReader.getIndex((Cache)cache, (String)url);
            }
            if (cacheRegular) {
                if (this.oLogger.debugEnabled()) {
                    this.oLogger.logDebug("CACHE MANAGER cache index is " + index);
                }
                if (index != null) {
                    String contents = CacheReader.getCacheContent((Cache)cache, (String)index);
                    content = this.createContent(cache);
                    content.setContents(contents);
                }
            } else if (cacheDynamic) {
                if (this.oLogger.debugEnabled()) {
                    this.oLogger.logDebug("CACHE MANAGER dynamic index is " + index);
                }
                if (index != null) {
                    String redUrl = CacheReader.getRedirectURL((Cache)cache, (String)index, (HttpServletRequest)this.oRequest);
                    content = this.getContent(cache, null, redUrl);
                }
            } else if (url != null) {
                Hashtable params = CacheReader.getParams((Cache)cache, (HttpServletRequest)this.oRequest);
                String paramUrl = URLMethod.composeURL((Hashtable)params);
                content = this.createContent(cache);
                int maxLength = CacheManagerFactory.getInstance().getMaxParamLength();
                if (maxLength < 0 || paramUrl.length() <= maxLength) {
                    String redURL = URLGet.getConnURL((String)url, (String)paramUrl);
                    this.setRedirectURL(redURL, content);
                } else {
                    if (url.indexOf("://") == -1) {
                        String contextPath = cache.getRequestUrl();
                        url = new URL(new URL(contextPath), url).toString();
                        if (this.oLogger.debugEnabled()) {
                            this.oLogger.logDebug("Ticket Number: HD100291 :Check value of " + url + "=(" + contextPath + ")+(" + url + ")");
                        }
                    }
                    URLPost upost = new URLPost(url);
                    upost.setRequest(this.oRequest);
                    upost.setParams(params);
                    String encoding = content.getHeader("Encoding");
                    if (encoding != null) {
                        upost.setEncoding(encoding);
                    }
                    if (this.oLogger.debugEnabled()) {
                        this.oLogger.logDebug("CACHE MANAGER posting url is " + url);
                    }
                    String contents = upost.post();
                    String redirectURL = upost.getRedirectURL();
                    if (redirectURL == null) {
                        this.setContents(contents, content);
                    } else {
                        this.setRedirectURL(redirectURL, content);
                    }
                }
                CacheReader.removeCachedParameters((Cache)cache, (HttpServletRequest)this.oRequest);
            }
        }
        catch (Exception ex) {
            this.oLogger.logError((Throwable)ex);
            throw new CachingException(ex.getMessage());
        }
        return content;
    }

    private Content createContent(Cache cache) {
        Content content = new Content();
        content.setHeaders(cache.getHeaders());
        return content;
    }

    private void setContents(String contents, Content content) {
        if (this.oLogger.debugEnabled()) {
            this.oLogger.logDebug("CACHE MANAGER contents are " + contents);
        }
        content.setContents(contents);
    }

    private void setRedirectURL(String url, Content content) {
        if (this.oLogger.debugEnabled()) {
            this.oLogger.logDebug("CACHE MANAGER redirect url is " + url);
        }
        content.setRedirectURL(url);
    }
}

