/*
 * Decompiled with CFR 0.152.
 */
package com.aligo.modules.manager.log;

import com.aligo.logging.GlobalLogger;
import com.aligo.modules.manager.log.StyleLogger;

public class StyleDebugLog
extends StyleLogger {
    private static StringBuffer debug = new StringBuffer(GlobalLogger.bufferSize);
    private static StyleDebugLog iDebugLog = null;

    public StyleDebugLog(String ln) {
        super(ln);
    }

    public static void enable(boolean flg) {
        iDebugLog._enable(flg);
    }

    public static boolean enabled() {
        return iDebugLog._enabled();
    }

    public static void init(boolean enabled) {
        if (iDebugLog == null) {
            iDebugLog = new StyleDebugLog("debug");
            iDebugLog._enable(enabled);
        }
    }

    public static void log(String msg) {
        if (iDebugLog._enabled()) {
            String lmsg = GlobalLogger.getLogDate() + " - " + Thread.currentThread().getName() + " " + msg;
            debug.append(lmsg);
            debug.append("\n");
            if (debug.length() > GlobalLogger.bufferSize) {
                StyleDebugLog.writeDebugLog(debug);
            }
        }
    }

    private static void writeDebugLog(StringBuffer msg) {
        StyleLogger.logger.logDebug(msg.toString());
        debug.setLength(0);
    }

    public static void flush() {
        if (debug.length() > 0) {
            StyleDebugLog.writeDebugLog(debug);
        }
    }
}

