/*
 * Decompiled with CFR 0.152.
 */
package com.aligo.logging;

import java.io.File;
import java.io.PrintWriter;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.Random;
import java.util.TimeZone;

public class GlobalLogger {
    public static Random randy;
    public static int bufferSize;
    public static String basePath;
    private static PrintWriter pw;
    private static SimpleDateFormat formatter;
    private static int tzOffset;
    public static File fLogs;
    private String logName;
    private String fileTimeStamp = null;
    private boolean bLog = true;

    public GlobalLogger() {
        this.logName = "UNKNOWN";
        this.bLog = false;
    }

    public GlobalLogger(String ln) {
        this.logName = ln;
        this.bLog = true;
    }

    public String getFileTimeStamp() {
        if (this.fileTimeStamp == null) {
            this.fileTimeStamp = GlobalLogger.getLogFileDate();
        }
        return this.fileTimeStamp;
    }

    public static void init(String bp) {
        basePath = bp;
        File basePathDir = new File(basePath);
        if (basePathDir == null || !basePathDir.isDirectory()) {
            basePath = ".";
        }
        GlobalLogger.init();
    }

    public static void init() {
        fLogs = new File(basePath + File.separator + "logs");
        fLogs.mkdir();
        GlobalLogger.rollLogs();
        randy = new Random();
        tzOffset = TimeZone.getDefault().getRawOffset() / 3600000;
    }

    public boolean _enabled() {
        return this.bLog;
    }

    public void _enable(boolean flg) {
        this.bLog = flg;
    }

    public static String getLogDate() {
        if (formatter == null) {
            formatter = new SimpleDateFormat("dd/MMM/yyyy:HH:mm:ss");
        }
        String dateString = formatter.format(new Date());
        String ns = tzOffset < 0 ? "-" : "";
        int tzv = Math.abs(tzOffset);
        String leadC = tzv > 9 ? "" : "0";
        StringBuffer str = new StringBuffer();
        str.append("[");
        str.append(dateString);
        str.append(" ");
        str.append(ns);
        str.append(leadC);
        str.append(tzv);
        str.append("00] ");
        return str.toString();
    }

    public static String getLogFileDate() {
        SimpleDateFormat fformatter = new SimpleDateFormat("ddMMMyyyyHHmmss");
        return fformatter.format(new Date());
    }

    public static String getW3CStdFormat(String ipAddress, String msg) {
        StringBuffer str = new StringBuffer();
        str.append(ipAddress);
        str.append(" - - ");
        str.append(GlobalLogger.getLogDate());
        str.append("\"");
        str.append(msg);
        str.append("\" 200 ");
        str.append(msg.length());
        return str.toString();
    }

    public String getLogFileName() {
        StringBuffer fileName = new StringBuffer(basePath);
        fileName.append(File.separator);
        fileName.append("aligo.");
        fileName.append(this.logName);
        fileName.append(".log");
        fileName.append(this.getFileTimeStamp());
        return fileName.toString();
    }

    public static void rollLogs() {
        String[] aFiles = new File(basePath).list();
        int i = 0;
        while (i < aFiles.length) {
            if (aFiles[i].indexOf(".log") != -1) {
                File fTmp = new File(fLogs.getAbsolutePath() + File.separator + aFiles[i]);
                File fFile = new File(basePath + File.separator + aFiles[i]);
                fFile.renameTo(fTmp);
            }
            ++i;
        }
    }

    public void rollLog() {
        String currentFileName = this.getLogFileName();
        StringBuffer fileName = new StringBuffer(fLogs.getAbsolutePath());
        fileName.append(File.separator);
        fileName.append(currentFileName);
        File fTmp = new File(fileName.toString());
        File fFile = new File(currentFileName);
        fFile.renameTo(fTmp);
        this.fileTimeStamp = null;
    }

    static {
        bufferSize = 32768;
        basePath = ".";
        pw = null;
        formatter = null;
    }
}

