/*
 * Decompiled with CFR 0.152.
 */
package com.aligo.xhtml;

import com.aligo.xhtml.XHtmlAttributes;
import com.aligo.xhtml.XHtmlContainer;
import com.aligo.xhtml.XHtmlElementCollection;
import com.aligo.xhtml.exceptions.XHtmlAttributeCannotBeAddedException;
import com.aligo.xhtml.exceptions.XHtmlElementCannotBeAddedException;
import com.aligo.xhtml.exceptions.XHtmlElementCloneFailedException;
import com.aligo.xhtml.exceptions.XHtmlElementIndexOutOfBoundsException;
import com.aligo.xhtml.exceptions.XHtmlElementNotFoundException;
import com.aligo.xhtml.exceptions.XHtmlTextCannotBeResetException;
import com.aligo.xhtml.exceptions.XHtmlTextCannotBeSetException;
import com.aligo.xhtml.exceptions.XHtmlTextNotSetException;
import com.aligo.xhtml.interfaces.XHtmlAttributeInterface;
import com.aligo.xhtml.interfaces.XHtmlContainerInterface;
import com.aligo.xhtml.interfaces.XHtmlElement;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Vector;

public class XHtmlBaseElement
implements XHtmlElement {
    public static final String AMPERSAND = "&";
    public static final String CLOSEBRACE = ")";
    public static final String COLON = ":";
    public static final String COMMA = ",";
    public static final String DASH = "-";
    public static final String DOLLAR = "$";
    public static final String EQUALS = "=";
    public static final String FORWARDSLASH = "/";
    public static final String GREATERTHAN = ">";
    public static final String HASH = "#";
    public static final String LESSERTHAN = "<";
    public static final String NEWLINE = "\n";
    public static final String OPENBRACE = "(";
    public static final String QUESTION = "?";
    public static final String QUOTE = "\"";
    public static final String SEMICOLON = ";";
    public static final String SPACE = " ";
    public static final String UNDERSCORE = "_";
    public static final String ONCE = "";
    public static final String ZERO_OR_ONE = "?";
    public static final String ZERO_OR_MORE = "*";
    public static final String ONE_OR_MORE = "+";
    public static final String XHTML_BOOLEAN = "boolean";
    public static final String XHTML_CDATA = "cdata";
    public static final String XHTML_EMPH = "emph";
    public static final String XHTML_FLOW = "flow";
    public static final String XHTML_HREF = "href";
    public static final String XHTML_ID = "id";
    public static final String XHTML_INLINE = "inline";
    public static final String XHTML_LAYOUT = "layout";
    public static final String XHTML_LENGTH = "length";
    public static final String XHTML_NUMBER = "number";
    public static final String XHTML_PASSWORD = "password";
    public static final String XHTML_PCDATA = "pcdata";
    public static final String XHTML_TEXT = "text";
    public static final String XHTML_TOKEN = "nmtoken";
    public static final String XHTML_VDATA = "vdata";
    public static final String[] SXHtmlDataTypes = new String[]{"boolean", "cdata", "emph", "flow", "href", "id", "inline", "layout", "length", "number", "password", "pcdata", "text", "nmtoken", "vdata"};
    public static final String XHTML_XHTML = "XHtml";
    public static final int LAST_ELEMENT_ID = -1;
    protected static boolean bContainerClass = false;
    protected boolean bContentsWithTag = false;
    private String SName = this.getName();
    private String sContents = null;
    protected XHtmlElementCollection elements = new XHtmlElementCollection();
    private Hashtable oChildrenRules = this.getChildrenRules();
    protected XHtmlAttributeInterface oAttributes = new XHtmlAttributes();
    private Hashtable oAttributeRules;
    private String[] requiredAttributes = this.getRequiredAttributes();
    protected String sText;
    private XHtmlElement oXHtmlParentElement;

    public XHtmlBaseElement() {
        this.oAttributeRules = this.getAttributeRules();
    }

    public String getName() {
        return "XHtmlBaseElement";
    }

    public String getXmlID() {
        return XHTML_XHTML;
    }

    protected void addNCXHtmlElement(XHtmlElement xhtmlElement, int index) throws XHtmlElementCannotBeAddedException {
        if (index == -1) {
            this.elements.addXHtmlElement(xhtmlElement);
        } else {
            this.elements.addXHtmlElementAt(xhtmlElement, index);
        }
        xhtmlElement.setXHtmlParentElement(this);
    }

    public void addXHtmlElementAt(XHtmlElement xhtmlElement, int index) throws XHtmlElementCannotBeAddedException {
        int numberElements = this.elements.getNumberElements();
        boolean done = false;
        boolean exception = false;
        String className = xhtmlElement.getName();
        if (this instanceof XHtmlContainerInterface || xhtmlElement instanceof XHtmlContainerInterface) {
            this.addNCXHtmlElement(xhtmlElement, index);
            XHtmlContainerInterface checkValidElement = null;
            if (this instanceof XHtmlContainerInterface) {
                checkValidElement = (XHtmlContainerInterface)((Object)this);
            } else if (xhtmlElement instanceof XHtmlContainerInterface) {
                checkValidElement = (XHtmlContainerInterface)((Object)xhtmlElement);
            }
            done = checkValidElement.isAddValid();
            if (!done) {
                try {
                    this.removeXHtmlElement(xhtmlElement);
                }
                catch (XHtmlElementNotFoundException je) {
                    // empty catch block
                }
                throw new XHtmlElementCannotBeAddedException();
            }
        } else {
            try {
                Enumeration keys = this.oChildrenRules.keys();
                while (!done && keys.hasMoreElements()) {
                    String sChild;
                    XHtmlElement containedElement;
                    int i;
                    Object child = keys.nextElement();
                    String childValue = (String)this.oChildrenRules.get(child);
                    if (child instanceof Vector) {
                        Vector vChild = (Vector)child;
                        if (!vChild.contains(className)) continue;
                        done = true;
                        if (!childValue.equals(ONCE)) continue;
                        int numberChild = vChild.size();
                        i = 0;
                        while (i < numberElements && !exception) {
                            containedElement = this.elements.xhtmlElementAt(i);
                            int j = 0;
                            while (j < numberChild && !exception) {
                                String childName = (String)vChild.elementAt(j);
                                if (containedElement.getName().equals(childName)) {
                                    exception = true;
                                }
                                ++j;
                            }
                            ++i;
                        }
                        continue;
                    }
                    if (!(child instanceof String) || !(sChild = (String)child).equals(className)) continue;
                    done = true;
                    if (!childValue.equals(ONCE)) continue;
                    i = 0;
                    while (i < numberElements && !exception) {
                        containedElement = this.elements.xhtmlElementAt(i);
                        if (containedElement.getName().equals(sChild)) {
                            exception = true;
                        }
                        ++i;
                    }
                }
            }
            catch (XHtmlElementIndexOutOfBoundsException we) {
                // empty catch block
            }
            if (!done || exception) {
                throw new XHtmlElementCannotBeAddedException();
            }
            this.addNCXHtmlElement(xhtmlElement, index);
        }
    }

    public void addXHtmlElement(XHtmlElement xhtmlElement) throws XHtmlElementCannotBeAddedException {
        this.addXHtmlElementAt(xhtmlElement, -1);
    }

    public boolean hasElements() {
        boolean flag = false;
        if (this.elements.getNumberElements() > 0) {
            flag = true;
        }
        return flag;
    }

    public int getNumberElements() {
        return this.elements.getNumberElements();
    }

    public XHtmlElement xhtmlElementAt(int index) throws XHtmlElementIndexOutOfBoundsException {
        return this.elements.xhtmlElementAt(index);
    }

    public int xhtmlElementIndex(XHtmlElement xhtmlElement) throws XHtmlElementNotFoundException {
        return this.elements.xhtmlElementIndex(xhtmlElement);
    }

    public void removeXHtmlElement(int index) throws XHtmlElementIndexOutOfBoundsException {
        XHtmlElement xhtmlElement = this.xhtmlElementAt(index);
        try {
            this.removeXHtmlElement(xhtmlElement);
        }
        catch (XHtmlElementNotFoundException we) {
            throw new XHtmlElementIndexOutOfBoundsException(index);
        }
    }

    public void removeXHtmlElement(XHtmlElement xhtmlElement) throws XHtmlElementNotFoundException {
        this.elements.removeXHtmlElement(xhtmlElement);
        xhtmlElement.setXHtmlParentElement(null);
    }

    public void removeAll() {
        int numberElements = this.getNumberElements();
        int i = 0;
        while (i < numberElements) {
            try {
                this.removeXHtmlElement(i);
            }
            catch (XHtmlElementIndexOutOfBoundsException xHtmlElementIndexOutOfBoundsException) {
                // empty catch block
            }
            ++i;
        }
    }

    public Hashtable getChildrenRules() {
        return null;
    }

    public boolean areXHtmlChildrenSane() {
        int numberElements = this.elements.getNumberElements();
        boolean done = false;
        boolean sane = true;
        try {
            Enumeration keys = this.oChildrenRules.keys();
            while (sane && keys.hasMoreElements()) {
                int j;
                XHtmlElement containedElement;
                XHtmlElement childElement;
                int i;
                Object child = keys.nextElement();
                String childValue = (String)this.oChildrenRules.get(child);
                if (child instanceof Vector) {
                    Vector vChild = (Vector)child;
                    if (!childValue.equals(ONCE) && !childValue.equals(ONE_OR_MORE)) continue;
                    int numberChild = vChild.size();
                    done = false;
                    i = 0;
                    while (i < numberElements && !done) {
                        childElement = this.elements.xhtmlElementAt(i);
                        Vector vContainer = this.getNonContainerElements(childElement);
                        int numberContainer = vContainer.size();
                        int k = 0;
                        while (k < numberContainer) {
                            containedElement = (XHtmlElement)vContainer.elementAt(k);
                            j = 0;
                            while (j < numberChild && !done) {
                                String childName = (String)vChild.elementAt(j);
                                if (containedElement.getName().equals(childName)) {
                                    done = true;
                                }
                                ++j;
                            }
                            ++k;
                        }
                        ++i;
                    }
                    if (done) continue;
                    sane = false;
                    continue;
                }
                if (!(child instanceof String)) continue;
                String sChild = (String)child;
                if (!childValue.equals(ONCE) && !childValue.equals(ONE_OR_MORE)) continue;
                done = false;
                i = 0;
                while (i < numberElements && !done) {
                    childElement = this.elements.xhtmlElementAt(i);
                    Vector vContainer = this.getNonContainerElements(childElement);
                    int numberContainer = vContainer.size();
                    j = 0;
                    while (j < numberContainer) {
                        containedElement = (XHtmlElement)vContainer.elementAt(j);
                        if (containedElement.getName().equals(sChild)) {
                            done = true;
                        }
                        ++j;
                    }
                    ++i;
                }
                if (done) continue;
                sane = false;
            }
        }
        catch (XHtmlElementIndexOutOfBoundsException we) {
            // empty catch block
        }
        return sane;
    }

    public void addXHtmlAttribute(String name, String value) throws XHtmlAttributeCannotBeAddedException {
        boolean exception = false;
        boolean flag = false;
        Object attributeValues = null;
        attributeValues = this.oAttributeRules.get(name);
        if (attributeValues != null) {
            if (attributeValues instanceof Vector) {
                Vector vAttributeValues = attributeValues;
                int numberValues = vAttributeValues.size();
                int i = 0;
                while (i < numberValues && !flag) {
                    String strAttributeValue = (String)vAttributeValues.elementAt(i);
                    if (strAttributeValue.equals(value)) {
                        flag = true;
                    }
                    ++i;
                }
                if (!flag) {
                    exception = true;
                }
            } else if (attributeValues instanceof String) {
                // empty if block
            }
        } else {
            exception = true;
        }
        if (exception) {
            throw new XHtmlAttributeCannotBeAddedException();
        }
        this.oAttributes.addAttribute(name, value);
    }

    public String getXHtmlAttributeValue(String name) {
        return this.oAttributes.getValue(name);
    }

    public String changeXHtmlAttribute(String name, String value) {
        String oldAttributeValue = this.oAttributes.change(name, value);
        return oldAttributeValue;
    }

    public void removeXHtmlAttribute(String name) {
        String value = this.getXHtmlAttributeValue(name);
        this.oAttributes.remove(name);
    }

    public Hashtable getAttributeRules() {
        return null;
    }

    public String[] getRequiredAttributes() {
        return null;
    }

    public boolean areXHtmlAttributesSane() {
        boolean sane = true;
        String value = null;
        if (this.requiredAttributes != null) {
            int i = 0;
            while (i < this.requiredAttributes.length && sane) {
                value = this.oAttributes.getValue(this.requiredAttributes[i]);
                if (value == null) {
                    sane = false;
                }
                ++i;
            }
        }
        return sane;
    }

    public int getNumberOfLines() {
        return this.elements.getNumberOfLines();
    }

    public String getStartTag() {
        return ONCE;
    }

    public String getEndTag() {
        return this.getStartTag();
    }

    public String getHead() {
        String startTag = this.getStartTag();
        String head = ONCE;
        if (!startTag.equals(ONCE)) {
            head = LESSERTHAN + startTag + this.oAttributes.getContents();
            if (this.elements.getNumberElements() == 0 && this.sContents == null) {
                head = head + FORWARDSLASH;
            }
            head = head + GREATERTHAN;
        }
        return head;
    }

    public String getTail() {
        String endTag = this.getEndTag();
        String tail = ONCE;
        if (!(endTag.equals(ONCE) || this.elements.getNumberElements() == 0 && this.sContents == null)) {
            tail = "</" + endTag + GREATERTHAN;
        }
        return tail;
    }

    public String getBody() {
        String body = ONCE;
        String text = null;
        try {
            text = this.getText();
            if (text != null) {
                body = text;
            }
        }
        catch (XHtmlTextNotSetException we) {
            body = this.elements.getContents();
        }
        return body;
    }

    public String getContents() {
        String contents = ONCE;
        if (this.sContents == null) {
            String body = this.getBody();
            contents = this.getHead() + body + this.getTail();
        } else {
            contents = this.bContentsWithTag ? this.getHead() + this.sContents + this.getTail() : this.sContents;
        }
        return contents;
    }

    public void setContents(String contents) {
        this.sContents = contents;
        this.bContentsWithTag = false;
    }

    public void setContentsWithTag(String contents) {
        this.setContents(contents);
        this.bContentsWithTag = true;
    }

    public void setText(String text) throws XHtmlTextCannotBeSetException {
        throw new XHtmlTextCannotBeSetException();
    }

    public String getText() throws XHtmlTextNotSetException {
        throw new XHtmlTextNotSetException();
    }

    public void resetText() throws XHtmlTextCannotBeResetException {
        throw new XHtmlTextCannotBeResetException();
    }

    public void setXHtmlParentElement(XHtmlElement xhtmlParentElement) {
        this.oXHtmlParentElement = xhtmlParentElement;
    }

    public XHtmlElement getXHtmlParentElement() {
        return this.oXHtmlParentElement;
    }

    public XHtmlElement cloneXHtmlElement() throws XHtmlElementCloneFailedException {
        XHtmlElement cXHtmlElement = null;
        try {
            cXHtmlElement = (XHtmlElement)this.getClass().newInstance();
            Enumeration keys = this.oAttributes.keys();
            while (keys.hasMoreElements()) {
                String name = (String)keys.nextElement();
                String value = this.oAttributes.getValue(name);
                cXHtmlElement.addXHtmlAttribute(name, value);
            }
            try {
                String text = this.getText();
                cXHtmlElement.setText(text);
            }
            catch (XHtmlTextNotSetException je) {
                // empty catch block
            }
            int numberElements = this.getNumberElements();
            int i = 0;
            while (i < numberElements) {
                XHtmlElement childXHtmlElement = this.xhtmlElementAt(i);
                XHtmlElement cChildXHtmlElement = childXHtmlElement.cloneXHtmlElement();
                cXHtmlElement.addXHtmlElement(cChildXHtmlElement);
                ++i;
            }
        }
        catch (XHtmlElementCloneFailedException je) {
            throw je;
        }
        catch (Exception ex) {
            throw new XHtmlElementCloneFailedException(ex.getMessage());
        }
        return cXHtmlElement;
    }

    public static String[] getXHtmlDataTypes() {
        return SXHtmlDataTypes;
    }

    public static boolean isCoreDataType(String dataType) {
        boolean found = false;
        int i = 0;
        while (i < SXHtmlDataTypes.length && !found) {
            if (dataType.equals(SXHtmlDataTypes[i])) {
                found = true;
            }
            ++i;
        }
        return found;
    }

    public String getPCDataTag() {
        return XHTML_PCDATA;
    }

    private Vector getNonContainerElements(XHtmlElement xhtmlElement) {
        Vector nonContainerElements = new Vector();
        this.getNonContainerElements(xhtmlElement, nonContainerElements);
        return nonContainerElements;
    }

    private void getNonContainerElements(XHtmlElement xhtmlElement, Vector nonContainerElements) {
        if (xhtmlElement != null) {
            if (xhtmlElement instanceof XHtmlContainer) {
                int numberChildren = xhtmlElement.getNumberElements();
                int i = 0;
                while (i < numberChildren) {
                    try {
                        XHtmlElement childXHtmlElement = xhtmlElement.xhtmlElementAt(i);
                        this.getNonContainerElements(childXHtmlElement, nonContainerElements);
                    }
                    catch (XHtmlElementIndexOutOfBoundsException he) {
                        // empty catch block
                    }
                    ++i;
                }
            } else {
                nonContainerElements.addElement(xhtmlElement);
            }
        }
    }
}

