/*
 * Decompiled with CFR 0.152.
 */
package com.aligo.wml;

import com.aligo.wml.WmlAttributes;
import com.aligo.wml.WmlContainer;
import com.aligo.wml.WmlElementCollection;
import com.aligo.wml.exceptions.WmlAttributeCannotBeAddedException;
import com.aligo.wml.exceptions.WmlElementCannotBeAddedException;
import com.aligo.wml.exceptions.WmlElementIndexOutOfBoundsException;
import com.aligo.wml.exceptions.WmlElementNotFoundException;
import com.aligo.wml.exceptions.WmlTextCannotBeResetException;
import com.aligo.wml.exceptions.WmlTextCannotBeSetException;
import com.aligo.wml.exceptions.WmlTextNotSetException;
import com.aligo.wml.interfaces.WmlAttributeInterface;
import com.aligo.wml.interfaces.WmlContainerInterface;
import com.aligo.wml.interfaces.WmlElement;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Vector;

public class WmlBaseElement
implements WmlElement {
    public static final String AMPERSAND = "&";
    public static final String CLOSEBRACE = ")";
    public static final String COLON = ":";
    public static final String COMMA = ",";
    public static final String DASH = "-";
    public static final String DOLLAR = "$";
    public static final String EQUALS = "=";
    public static final String FORWARDSLASH = "/";
    public static final String GREATERTHAN = ">";
    public static final String HASH = "#";
    public static final String LESSERTHAN = "<";
    public static final String NEWLINE = "\n";
    public static final String OPENBRACE = "(";
    public static final String QUESTION = "?";
    public static final String QUOTE = "\"";
    public static final String SEMICOLON = ";";
    public static final String SPACE = " ";
    public static final String UNDERSCORE = "_";
    public static final String ONCE = "";
    public static final String ZERO_OR_ONE = "?";
    public static final String ZERO_OR_MORE = "*";
    public static final String ONE_OR_MORE = "+";
    public static final String WML_BOOLEAN = "boolean";
    public static final String WML_CDATA = "cdata";
    public static final String WML_EMPH = "emph";
    public static final String WML_FLOW = "flow";
    public static final String WML_HREF = "href";
    public static final String WML_ID = "id";
    public static final String WML_INLINE = "inline";
    public static final String WML_LAYOUT = "layout";
    public static final String WML_LENGTH = "length";
    public static final String WML_NUMBER = "number";
    public static final String WML_PASSWORD = "password";
    public static final String WML_PCDATA = "pcdata";
    public static final String WML_TEXT = "text";
    public static final String WML_TOKEN = "nmtoken";
    public static final String WML_VDATA = "vdata";
    public static final String[] SWmlDataTypes = new String[]{"boolean", "cdata", "emph", "flow", "href", "id", "inline", "layout", "length", "number", "password", "pcdata", "text", "nmtoken", "vdata"};
    public static final String WML_WML = "Wml";
    public static final int LAST_ELEMENT_ID = -1;
    protected static boolean bContainerClass = false;
    private String SName = this.getName();
    protected WmlElementCollection elements = new WmlElementCollection();
    private Hashtable oChildrenRules = this.getChildrenRules();
    protected WmlAttributeInterface oAttributes = new WmlAttributes();
    private Hashtable oAttributeRules;
    private String[] requiredAttributes = this.getRequiredAttributes();
    protected String sText;
    protected int iTextLen;
    private WmlElement oWmlParentElement;

    public WmlBaseElement() {
        this.oAttributeRules = this.getAttributeRules();
    }

    public String getName() {
        return "WmlBaseElement";
    }

    public String getXmlID() {
        return WML_WML;
    }

    protected void addNCWmlElement(WmlElement wmlElement, int index) throws WmlElementCannotBeAddedException {
        if (index == -1) {
            this.elements.addWmlElement(wmlElement);
        } else {
            this.elements.addWmlElementAt(wmlElement, index);
        }
        wmlElement.setWmlParentElement(this);
    }

    public void addWmlElementAt(WmlElement wmlElement, int index) throws WmlElementCannotBeAddedException {
        int numberElements = this.elements.getNumberElements();
        boolean done = false;
        boolean exception = false;
        String className = wmlElement.getName();
        if (this instanceof WmlContainerInterface || wmlElement instanceof WmlContainerInterface) {
            this.addNCWmlElement(wmlElement, index);
            WmlContainerInterface checkValidElement = null;
            if (this instanceof WmlContainerInterface) {
                checkValidElement = (WmlContainerInterface)((Object)this);
            } else if (wmlElement instanceof WmlContainerInterface) {
                checkValidElement = (WmlContainerInterface)((Object)wmlElement);
            }
            done = checkValidElement.isAddValid();
            if (!done) {
                try {
                    this.removeWmlElement(wmlElement);
                }
                catch (WmlElementNotFoundException je) {
                    // empty catch block
                }
                throw new WmlElementCannotBeAddedException();
            }
        } else {
            try {
                Enumeration keys = this.oChildrenRules.keys();
                while (!done && keys.hasMoreElements()) {
                    String sChild;
                    WmlElement containedElement;
                    int i;
                    Object child = keys.nextElement();
                    String childValue = (String)this.oChildrenRules.get(child);
                    if (child instanceof Vector) {
                        Vector vChild = (Vector)child;
                        if (!vChild.contains(className)) continue;
                        done = true;
                        if (!childValue.equals(ONCE)) continue;
                        int numberChild = vChild.size();
                        i = 0;
                        while (i < numberElements && !exception) {
                            containedElement = this.elements.wmlElementAt(i);
                            int j = 0;
                            while (j < numberChild && !exception) {
                                String childName = (String)vChild.elementAt(j);
                                if (containedElement.getName().equals(childName)) {
                                    exception = true;
                                }
                                ++j;
                            }
                            ++i;
                        }
                        continue;
                    }
                    if (!(child instanceof String) || !(sChild = (String)child).equals(className)) continue;
                    done = true;
                    if (!childValue.equals(ONCE)) continue;
                    i = 0;
                    while (i < numberElements && !exception) {
                        containedElement = this.elements.wmlElementAt(i);
                        if (containedElement.getName().equals(sChild)) {
                            exception = true;
                        }
                        ++i;
                    }
                }
            }
            catch (WmlElementIndexOutOfBoundsException we) {
                // empty catch block
            }
            if (!done || exception) {
                throw new WmlElementCannotBeAddedException();
            }
            this.addNCWmlElement(wmlElement, index);
        }
    }

    public void addWmlElement(WmlElement wmlElement) throws WmlElementCannotBeAddedException {
        this.addWmlElementAt(wmlElement, -1);
    }

    public boolean hasElements() {
        boolean flag = false;
        if (this.elements.getNumberElements() > 0) {
            flag = true;
        }
        return flag;
    }

    public int getNumberElements() {
        return this.elements.getNumberElements();
    }

    public WmlElement wmlElementAt(int index) throws WmlElementIndexOutOfBoundsException {
        return this.elements.wmlElementAt(index);
    }

    public int wmlElementIndex(WmlElement wmlElement) throws WmlElementNotFoundException {
        return this.elements.wmlElementIndex(wmlElement);
    }

    public void removeWmlElement(int index) throws WmlElementIndexOutOfBoundsException {
        WmlElement wmlElement = this.wmlElementAt(index);
        try {
            this.removeWmlElement(wmlElement);
        }
        catch (WmlElementNotFoundException we) {
            throw new WmlElementIndexOutOfBoundsException(index);
        }
    }

    public void removeWmlElement(WmlElement wmlElement) throws WmlElementNotFoundException {
        this.elements.removeWmlElement(wmlElement);
        wmlElement.setWmlParentElement(null);
    }

    public void removeAll() {
        int numberElements = this.getNumberElements();
        int i = 0;
        while (i < numberElements) {
            try {
                this.removeWmlElement(i);
            }
            catch (WmlElementIndexOutOfBoundsException wmlElementIndexOutOfBoundsException) {
                // empty catch block
            }
            ++i;
        }
    }

    public Hashtable getChildrenRules() {
        return null;
    }

    public boolean areWmlChildrenSane() {
        int numberElements = this.elements.getNumberElements();
        boolean done = false;
        boolean sane = true;
        try {
            Enumeration keys = this.oChildrenRules.keys();
            while (sane && keys.hasMoreElements()) {
                int j;
                WmlElement containedElement;
                WmlElement childElement;
                int i;
                Object child = keys.nextElement();
                String childValue = (String)this.oChildrenRules.get(child);
                if (child instanceof Vector) {
                    Vector vChild = (Vector)child;
                    if (!childValue.equals(ONCE) && !childValue.equals(ONE_OR_MORE)) continue;
                    int numberChild = vChild.size();
                    done = false;
                    i = 0;
                    while (i < numberElements && !done) {
                        childElement = this.elements.wmlElementAt(i);
                        Vector vContainer = this.getNonContainerElements(childElement);
                        int numberContainer = vContainer.size();
                        int k = 0;
                        while (k < numberContainer) {
                            containedElement = (WmlElement)vContainer.elementAt(k);
                            j = 0;
                            while (j < numberChild && !done) {
                                String childName = (String)vChild.elementAt(j);
                                if (containedElement.getName().equals(childName)) {
                                    done = true;
                                }
                                ++j;
                            }
                            ++k;
                        }
                        ++i;
                    }
                    if (done) continue;
                    sane = false;
                    continue;
                }
                if (!(child instanceof String)) continue;
                String sChild = (String)child;
                if (!childValue.equals(ONCE) && !childValue.equals(ONE_OR_MORE)) continue;
                done = false;
                i = 0;
                while (i < numberElements && !done) {
                    childElement = this.elements.wmlElementAt(i);
                    Vector vContainer = this.getNonContainerElements(childElement);
                    int numberContainer = vContainer.size();
                    j = 0;
                    while (j < numberContainer) {
                        containedElement = (WmlElement)vContainer.elementAt(j);
                        if (containedElement.getName().equals(sChild)) {
                            done = true;
                        }
                        ++j;
                    }
                    ++i;
                }
                if (done) continue;
                sane = false;
            }
        }
        catch (WmlElementIndexOutOfBoundsException we) {
            // empty catch block
        }
        return sane;
    }

    public void addWmlAttribute(String name, String value) throws WmlAttributeCannotBeAddedException {
        boolean exception = false;
        boolean flag = false;
        Object attributeValues = null;
        attributeValues = this.oAttributeRules.get(name);
        if (attributeValues != null) {
            if (attributeValues instanceof Vector) {
                Vector vAttributeValues = attributeValues;
                int numberValues = vAttributeValues.size();
                int i = 0;
                while (i < numberValues && !flag) {
                    String strAttributeValue = (String)vAttributeValues.elementAt(i);
                    if (strAttributeValue.equals(value)) {
                        flag = true;
                    }
                    ++i;
                }
                if (!flag) {
                    exception = true;
                }
            } else if (attributeValues instanceof String) {
                // empty if block
            }
        } else {
            exception = true;
        }
        if (exception) {
            throw new WmlAttributeCannotBeAddedException();
        }
        this.oAttributes.addAttribute(name, value);
    }

    public String getWmlAttributeValue(String name) {
        return this.oAttributes.getValue(name);
    }

    public String changeWmlAttribute(String name, String value) {
        String oldAttributeValue = this.oAttributes.change(name, value);
        return oldAttributeValue;
    }

    public void removeWmlAttribute(String name) {
        String value = this.getWmlAttributeValue(name);
        this.oAttributes.remove(name);
    }

    public int getWmlAttributeLength(String name) {
        return this.oAttributes.getAttrLength(name);
    }

    public Hashtable getAttributeRules() {
        return null;
    }

    public String[] getRequiredAttributes() {
        return null;
    }

    public boolean areWmlAttributesSane() {
        boolean sane = true;
        String value = null;
        if (this.requiredAttributes != null) {
            int i = 0;
            while (i < this.requiredAttributes.length && sane) {
                value = this.oAttributes.getValue(this.requiredAttributes[i]);
                if (value == null) {
                    sane = false;
                }
                ++i;
            }
        }
        return sane;
    }

    public int getNumberOfLines() {
        return this.elements.getNumberOfLines();
    }

    public String getStartTag() {
        return ONCE;
    }

    public String getEndTag() {
        return this.getStartTag();
    }

    public String getHead() {
        String startTag = this.getStartTag();
        StringBuffer headBuf = new StringBuffer(ONCE);
        if (!startTag.equals(ONCE)) {
            headBuf.append(LESSERTHAN);
            headBuf.append(startTag);
            headBuf.append(this.oAttributes.getContents());
            if (this.elements.getNumberElements() == 0) {
                headBuf.append(FORWARDSLASH);
            }
            headBuf.append(GREATERTHAN);
        }
        return headBuf.toString();
    }

    public int getHeadLength() {
        String startTag = this.getStartTag();
        int length = 0;
        if (!startTag.equals(ONCE)) {
            length += LESSERTHAN.length();
            length += startTag.length();
            length += this.oAttributes.getContentsLength();
            if (this.elements.getNumberElements() == 0) {
                length += FORWARDSLASH.length();
            }
            length += GREATERTHAN.length();
        }
        return length;
    }

    public String getTail() {
        String endTag = this.getEndTag();
        StringBuffer tailBuf = new StringBuffer(ONCE);
        if (!endTag.equals(ONCE) && this.elements.getNumberElements() != 0) {
            tailBuf.append(LESSERTHAN);
            tailBuf.append(FORWARDSLASH);
            tailBuf.append(endTag);
            tailBuf.append(GREATERTHAN);
            tailBuf.append(NEWLINE);
        }
        return tailBuf.toString();
    }

    public int getTailLength() {
        String endTag = this.getEndTag();
        int length = 0;
        if (!endTag.equals(ONCE) && this.elements.getNumberElements() != 0) {
            length += LESSERTHAN.length();
            length += FORWARDSLASH.length();
            length += endTag.length();
            length += GREATERTHAN.length();
            length += NEWLINE.length();
        }
        return length;
    }

    public String getBody() {
        String body = ONCE;
        try {
            String text = this.getText();
            body = text != null ? text : this.elements.getContents();
        }
        catch (WmlTextNotSetException wmlTextNotSetException) {
            // empty catch block
        }
        return body;
    }

    public int getBodyLength() {
        int length = 0;
        try {
            int tlength = this.getTextLength();
            length = tlength != -1 ? tlength : this.elements.getContentsLength();
        }
        catch (WmlTextNotSetException wmlTextNotSetException) {
            // empty catch block
        }
        return length;
    }

    public String getContents() {
        StringBuffer contentsBuf = new StringBuffer(this.getHead());
        contentsBuf.append(this.getBody());
        contentsBuf.append(this.getTail());
        return contentsBuf.toString();
    }

    public int getContentsLength() {
        int length = this.getHeadLength();
        length += this.getBodyLength();
        return length += this.getTailLength();
    }

    public void setText(String text) throws WmlTextCannotBeSetException {
        throw new WmlTextCannotBeSetException();
    }

    public String getText() throws WmlTextNotSetException {
        return null;
    }

    public int getTextLength() throws WmlTextNotSetException {
        return -1;
    }

    public void resetText() throws WmlTextCannotBeResetException {
        throw new WmlTextCannotBeResetException();
    }

    public void setWmlParentElement(WmlElement wmlParentElement) {
        this.oWmlParentElement = wmlParentElement;
    }

    public WmlElement getWmlParentElement() {
        return this.oWmlParentElement;
    }

    public static String[] getWmlDataTypes() {
        return SWmlDataTypes;
    }

    public static boolean isCoreDataType(String dataType) {
        boolean found = false;
        int i = 0;
        while (i < SWmlDataTypes.length && !found) {
            if (dataType.equals(SWmlDataTypes[i])) {
                found = true;
            }
            ++i;
        }
        return found;
    }

    public String getPCDataTag() {
        return WML_PCDATA;
    }

    private Vector getNonContainerElements(WmlElement wmlElement) {
        Vector nonContainerElements = new Vector();
        this.getNonContainerElements(wmlElement, nonContainerElements);
        return nonContainerElements;
    }

    private void getNonContainerElements(WmlElement wmlElement, Vector nonContainerElements) {
        if (wmlElement != null) {
            if (wmlElement instanceof WmlContainer) {
                int numberChildren = wmlElement.getNumberElements();
                int i = 0;
                while (i < numberChildren) {
                    try {
                        WmlElement childWmlElement = wmlElement.wmlElementAt(i);
                        this.getNonContainerElements(childWmlElement, nonContainerElements);
                    }
                    catch (WmlElementIndexOutOfBoundsException he) {
                        // empty catch block
                    }
                    ++i;
                }
            } else {
                nonContainerElements.addElement(wmlElement);
            }
        }
    }
}

