/*
 * Decompiled with CFR 0.152.
 */
package com.aligo.vxml;

import com.aligo.vxml.VxmlAttributes;
import com.aligo.vxml.VxmlElementCollection;
import com.aligo.vxml.contenthandler.VxmlContentListener;
import com.aligo.vxml.events.VxmlContentEvent;
import com.aligo.vxml.exceptions.VxmlAttributeCannotBeAddedException;
import com.aligo.vxml.exceptions.VxmlCannotBeAddedException;
import com.aligo.vxml.exceptions.VxmlTextCannotBeAddedException;
import com.aligo.vxml.interfaces.VxmlAttributeInterface;
import com.aligo.vxml.interfaces.VxmlElement;
import com.aligo.vxml.interfaces.VxmlListenerState;
import com.aligo.vxml.interfaces.VxmlRequest;
import com.aligo.vxml.interfaces.VxmlResponse;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Vector;

public class VxmlBaseElement
implements VxmlElement {
    public static final String AMPERSAND = "&";
    public static final String CLOSEBRACE = ")";
    public static final String COLON = ":";
    public static final String COMMA = ",";
    public static final String DASH = "-";
    public static final String DOLLAR = "$";
    public static final String EQUALS = "=";
    public static final String FORWARDSLASH = "/";
    public static final String GREATERTHAN = ">";
    public static final String HASH = "#";
    public static final String LESSERTHAN = "<";
    public static final String NEWLINE = "\n";
    public static final String OPENBRACE = "(";
    public static final String QUESTION = "?";
    public static final String QUOTE = "\"";
    public static final String SEMICOLON = ";";
    public static final String SPACE = " ";
    public static final String UNDERSCORE = "_";
    public static final String ONCE = "";
    public static final String ZERO_OR_ONE = "?";
    public static final String ZERO_OR_MORE = "*";
    public static final String ONE_OR_MORE = "+";
    public static final String VXML_BOOLEAN = "boolean";
    public static final String VXML_CDATA = "cdata";
    public static final String VXML_EMPH = "emph";
    public static final String VXML_FLOW = "flow";
    public static final String VXML_HREF = "href";
    public static final String VXML_ID = "id";
    public static final String VXML_INLINE = "inline";
    public static final String VXML_LAYOUT = "layout";
    public static final String VXML_LENGTH = "length";
    public static final String VXML_NUMBER = "number";
    public static final String VXML_PASSWORD = "password";
    public static final String VXML_PCDATA = "pcdata";
    public static final String VXML_TEXT = "text";
    public static final String VXML_TOKEN = "nmtoken";
    public static final String VXML_VDATA = "vdata";
    public static final String[] SVxmlDataTypes = new String[]{"boolean", "cdata", "emph", "flow", "href", "id", "inline", "layout", "length", "number", "password", "pcdata", "text", "nmtoken", "vdata"};
    public static final String VXML_VXML = "Vxml";
    public static final int LAST_ELEMENT_ID = -1;
    protected static boolean bContainerClass = false;
    protected boolean bContentsWithTag = false;
    private String SName = this.getName();
    private String sContents = null;
    protected Vector listeners = new Vector();
    protected Hashtable listenerMap = new Hashtable();
    protected VxmlElementCollection elements = new VxmlElementCollection();
    private Hashtable oChildrenRules = this.getChildrenRules();
    protected VxmlAttributeInterface oAttributes = new VxmlAttributes();
    private Hashtable oAttributeRules;
    private String[] requiredAttributes = this.getRequiredAttributes();
    protected String sText;
    private boolean isEmptyVisible = false;

    public VxmlBaseElement() {
        this.oAttributeRules = this.getAttributeRules();
    }

    public String getName() {
        return "VxmlBaseElement";
    }

    public String getXmlID() {
        return VXML_VXML;
    }

    public void addVxmlElementAt(VxmlElement vxmlElement, int index) throws VxmlCannotBeAddedException {
        int numberElements = this.elements.getNumberElements();
        boolean done = false;
        boolean exception = false;
        String className = vxmlElement.getName();
        Enumeration keys = this.oChildrenRules.keys();
        while (!done && keys.hasMoreElements()) {
            String sChild;
            VxmlElement containedElement;
            int i;
            Object child = keys.nextElement();
            String childValue = (String)this.oChildrenRules.get(child);
            if (child instanceof Vector) {
                Vector vChild = (Vector)child;
                if (!vChild.contains(className)) continue;
                done = true;
                if (!childValue.equals(ONCE)) continue;
                int numberChild = vChild.size();
                i = 0;
                while (i < numberElements && !exception) {
                    containedElement = this.elements.vxmlElementAt(i);
                    int j = 0;
                    while (j < numberChild && !exception) {
                        String childName = (String)vChild.elementAt(j);
                        if (containedElement.getName().equals(childName)) {
                            exception = true;
                        }
                        ++j;
                    }
                    ++i;
                }
                continue;
            }
            if (!(child instanceof String) || !(sChild = (String)child).equals(className)) continue;
            done = true;
            if (!childValue.equals(ONCE)) continue;
            i = 0;
            while (i < numberElements && !exception) {
                containedElement = this.elements.vxmlElementAt(i);
                if (containedElement.getName().equals(sChild)) {
                    exception = true;
                }
                ++i;
            }
        }
        if (!done || exception) {
            throw new VxmlCannotBeAddedException();
        }
        if (index == -1) {
            this.elements.addVxmlElement(vxmlElement);
        } else {
            this.elements.addVxmlElementAt(vxmlElement, index);
        }
    }

    public void addVxmlElement(VxmlElement vxmlElement) throws VxmlCannotBeAddedException {
        this.addVxmlElementAt(vxmlElement, -1);
    }

    public boolean hasElements() {
        boolean flag = false;
        if (this.elements.getNumberElements() > 0) {
            flag = true;
        }
        return flag;
    }

    public int getNumberElements() {
        return this.elements.getNumberElements();
    }

    public VxmlElement vxmlElementAt(int index) throws ArrayIndexOutOfBoundsException {
        return this.elements.vxmlElementAt(index);
    }

    public void removeVxmlElement(int index) {
        this.elements.removeVxmlElement(index);
    }

    public void removeVxmlElement(VxmlElement vxmlElement) {
        this.elements.removeVxmlElement(vxmlElement);
    }

    public void removeAll() {
        this.elements.removeAll();
    }

    public Hashtable getChildrenRules() {
        return null;
    }

    public boolean areVxmlChildrenSane() {
        int numberElements = this.elements.getNumberElements();
        boolean done = false;
        boolean sane = true;
        Enumeration keys = this.oChildrenRules.keys();
        while (sane && keys.hasMoreElements()) {
            VxmlElement containedElement;
            int i;
            Object child = keys.nextElement();
            String childValue = (String)this.oChildrenRules.get(child);
            if (child instanceof Vector) {
                Vector vChild = (Vector)child;
                if (!childValue.equals(ONCE) && !childValue.equals(ONE_OR_MORE)) continue;
                int numberChild = vChild.size();
                done = false;
                i = 0;
                while (i < numberElements && !done) {
                    containedElement = this.elements.vxmlElementAt(i);
                    int j = 0;
                    while (j < numberChild && !done) {
                        String childName = (String)vChild.elementAt(j);
                        if (containedElement.getName().equals(childName)) {
                            done = true;
                        }
                        ++j;
                    }
                    ++i;
                }
                if (done) continue;
                sane = false;
                continue;
            }
            if (!(child instanceof String)) continue;
            String sChild = (String)child;
            if (!childValue.equals(ONCE) && !childValue.equals(ONE_OR_MORE)) continue;
            done = false;
            i = 0;
            while (i < numberElements && !done) {
                containedElement = this.elements.vxmlElementAt(i);
                if (containedElement.getName().equals(sChild)) {
                    done = true;
                }
                ++i;
            }
            if (done) continue;
            sane = false;
        }
        return sane;
    }

    public void addVxmlAttribute(String name, String value) throws VxmlAttributeCannotBeAddedException {
        boolean exception = false;
        boolean flag = false;
        Object attributeValues = null;
        attributeValues = this.oAttributeRules.get(name);
        if (attributeValues != null) {
            if (attributeValues instanceof Vector) {
                Vector vAttributeValues = attributeValues;
                int numberValues = vAttributeValues.size();
                int i = 0;
                while (i < numberValues && !flag) {
                    String strAttributeValue = (String)vAttributeValues.elementAt(i);
                    if (strAttributeValue.equals(value)) {
                        flag = true;
                    }
                    ++i;
                }
                if (!flag) {
                    exception = true;
                }
            } else if (attributeValues instanceof String) {
                // empty if block
            }
        } else {
            exception = true;
        }
        if (exception) {
            throw new VxmlAttributeCannotBeAddedException();
        }
        this.oAttributes.addAttribute(name, value);
    }

    public String getVxmlAttributeValue(String name) {
        return this.oAttributes.getValue(name);
    }

    public String changeVxmlAttribute(String name, String value) {
        String oldAttributeValue = this.oAttributes.change(name, value);
        return oldAttributeValue;
    }

    public void removeVxmlAttribute(String name) {
        this.oAttributes.remove(name);
    }

    public Hashtable getAttributeRules() {
        return null;
    }

    public String[] getRequiredAttributes() {
        return null;
    }

    public boolean areVxmlAttributesSane() {
        boolean sane = true;
        String value = null;
        int i = 0;
        while (i < this.requiredAttributes.length && sane) {
            value = this.oAttributes.getValue(this.requiredAttributes[i]);
            if (value == null) {
                sane = false;
            }
            ++i;
        }
        return sane;
    }

    public int getNumberOfLines() {
        return this.elements.getNumberOfLines();
    }

    public String getStartTag() {
        return ONCE;
    }

    public String getEndTag() {
        return this.getStartTag();
    }

    public String getHead() {
        String startTag = this.getStartTag();
        String head = ONCE;
        if (!startTag.equals(ONCE)) {
            head = LESSERTHAN + startTag + this.oAttributes.getContents();
            if (this.elements.getNumberElements() == 0 && this.sContents == null) {
                head = head + FORWARDSLASH;
            }
            head = head + GREATERTHAN;
        }
        return head;
    }

    public String getTail() {
        String endTag = this.getEndTag();
        String tail = ONCE;
        if (!(endTag.equals(ONCE) || this.elements.getNumberElements() == 0 && this.sContents == null)) {
            tail = "</" + endTag + GREATERTHAN + NEWLINE;
        }
        return tail;
    }

    public String getBody() {
        String body = null;
        String text = this.getText();
        body = text == null ? this.elements.getContents() : text;
        return body;
    }

    public String getContents() {
        String contents = ONCE;
        if (this.sContents == null) {
            String body = this.getBody();
            if (this.isEmptyVisible || !body.equals(ONCE) || this.oAttributes.getNumberElements() != 0) {
                contents = this.getHead() + body + this.getTail();
            }
        } else {
            contents = this.bContentsWithTag ? this.getHead() + this.sContents + this.getTail() : this.sContents;
        }
        return contents;
    }

    public void setContents(String contents) {
        this.sContents = contents;
    }

    public void setContentsWithTag(String contents) {
        this.setContents(contents);
        this.bContentsWithTag = true;
    }

    public void setText(String text) throws VxmlTextCannotBeAddedException {
        throw new VxmlTextCannotBeAddedException();
    }

    public String getText() {
        return this.sText;
    }

    public synchronized void processVxmlContentEvent(VxmlContentEvent event) {
        Enumeration enumeration = this.listeners.elements();
        while (enumeration.hasMoreElements()) {
            VxmlContentListener l = (VxmlContentListener)enumeration.nextElement();
            l.notifyListener(event);
        }
    }

    public void addVxmlContentListener(VxmlContentListener l) {
        this.listeners.addElement(l);
    }

    public void addVxmlContentListenerRecursively(VxmlContentListener l) {
        int numChildren = this.elements.getNumberElements();
        this.addVxmlContentListener(l);
        try {
            int i = 0;
            while (i < numChildren) {
                VxmlElement child = this.elements.vxmlElementAt(i);
                child.addVxmlContentListenerRecursively(l);
                ++i;
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public void removeVxmlContentListener(VxmlContentListener l) {
        this.listeners.removeElement(l);
        this.listenerMap.remove(l);
    }

    public void removeVxmlContentListenerRecursively(VxmlContentListener l) {
        int numChildren = this.elements.getNumberElements();
        this.removeVxmlContentListener(l);
        int i = 0;
        while (i < numChildren) {
            VxmlElement child = this.elements.vxmlElementAt(i);
            child.removeVxmlContentListenerRecursively(l);
            ++i;
        }
    }

    public synchronized void handleRequest(VxmlRequest vxmlRequest, VxmlResponse vxmlResponse) {
        VxmlContentEvent event = new VxmlContentEvent(this, vxmlRequest, vxmlResponse);
        this.processVxmlContentEvent(event);
    }

    public VxmlListenerState getListenerState(VxmlContentListener vxmlListener) {
        return (VxmlListenerState)this.listenerMap.get(vxmlListener);
    }

    public void setListenerState(VxmlContentListener vxmlListener, VxmlListenerState vxmlListenerState) {
        try {
            this.listenerMap.put(vxmlListener, vxmlListenerState);
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public static String[] getVxmlDataTypes() {
        return SVxmlDataTypes;
    }

    public static boolean isCoreDataType(String dataType) {
        boolean found = false;
        int i = 0;
        while (i < SVxmlDataTypes.length && !found) {
            if (dataType.equals(SVxmlDataTypes[i])) {
                found = true;
            }
            ++i;
        }
        return found;
    }

    public String getPCDataTag() {
        return VXML_PCDATA;
    }

    public VxmlElement vxmlElementAt(String path) {
        VxmlElement elementAtPath = null;
        int spaceIndex = (path = path.trim()).indexOf(SPACE);
        if (spaceIndex != -1) {
            String sIndex = path.substring(1, spaceIndex);
            try {
                Integer sInteger = Integer.valueOf(sIndex);
                int index = sInteger;
                int numberElements = this.getNumberElements();
                if (index < numberElements) {
                    VxmlElement childElement = this.vxmlElementAt(index);
                    String subPathString = path.substring(spaceIndex + 1);
                    elementAtPath = childElement.vxmlElementAt(subPathString);
                }
            }
            catch (NumberFormatException nex) {}
        } else {
            elementAtPath = this;
        }
        return elementAtPath;
    }

    public void setEmptyVisible(boolean visibility) {
        this.isEmptyVisible = visibility;
    }
}

