/*
 * Decompiled with CFR 0.152.
 */
package com.aligo.util;

import com.aligo.util.DeltaTime;
import com.aligo.util.TimeLogger;
import java.util.Enumeration;
import java.util.Hashtable;

public class TimeStats {
    private static Hashtable timers = new Hashtable();
    private static TimeLogger tLog;

    public static void log(long ts, String fn) {
        tLog = new TimeLogger();
        tLog.setup(ts * 1000L, fn);
        tLog.start();
    }

    public static void stopLogger() {
        tLog.interrupt();
    }

    public static void createTimer(String gid, String id) {
        Hashtable<String, DeltaTime> ht = (Hashtable<String, DeltaTime>)timers.get(gid);
        if (ht == null) {
            ht = new Hashtable<String, DeltaTime>();
            timers.put(gid, ht);
        }
        ht.put(id, new DeltaTime(id));
    }

    public static void deleteTimer(String gid, String id) {
        Hashtable ht = (Hashtable)timers.get(gid);
        if (ht == null) {
            return;
        }
        ht.put(id, null);
    }

    public static void start(String gid, String id) {
        DeltaTime dt;
        Hashtable ht = (Hashtable)timers.get(gid);
        if (ht == null) {
            TimeStats.createTimer(gid, id);
            ht = (Hashtable)timers.get(gid);
        }
        if ((dt = (DeltaTime)ht.get(id)) == null) {
            TimeStats.createTimer(gid, id);
            dt = (DeltaTime)ht.get(id);
        }
        dt.start();
    }

    public static void stop(String gid, String id) {
        DeltaTime dt;
        Hashtable ht = (Hashtable)timers.get(gid);
        if (ht == null) {
            TimeStats.createTimer(gid, id);
            ht = (Hashtable)timers.get(gid);
        }
        if ((dt = (DeltaTime)ht.get(id)) == null) {
            TimeStats.createTimer(gid, id);
            dt = (DeltaTime)ht.get(id);
        }
        dt.stop();
    }

    public static void reset() {
        Enumeration gids = timers.keys();
        while (gids.hasMoreElements()) {
            Hashtable ht = (Hashtable)timers.get((String)gids.nextElement());
            Enumeration tmrs = ht.elements();
            while (tmrs.hasMoreElements()) {
                ((DeltaTime)tmrs.nextElement()).reset();
            }
        }
    }

    public static long getElapsedTime(String gid, String id) {
        DeltaTime dt;
        Hashtable ht = (Hashtable)timers.get(gid);
        if (ht != null && (dt = (DeltaTime)ht.get(id)) != null) {
            return dt.getElapsedTime();
        }
        return -1L;
    }

    public static long getAverageElapsedTime(String gid, String id) {
        DeltaTime dt;
        Hashtable ht = (Hashtable)timers.get(gid);
        if (ht != null && (dt = (DeltaTime)ht.get(id)) != null) {
            return dt.getAverageElapsedTime();
        }
        return -1L;
    }

    public static String toXML() {
        Enumeration grps = timers.keys();
        String str = "";
        while (grps.hasMoreElements()) {
            String gid = (String)grps.nextElement();
            Hashtable ht = (Hashtable)timers.get(gid);
            Enumeration tmrs = ht.keys();
            str = str + "<TimerGroup id=\"" + gid + "\" >\n";
            while (tmrs.hasMoreElements()) {
                String tid = (String)tmrs.nextElement();
                DeltaTime dt = (DeltaTime)ht.get(tid);
                str = str + dt.toXML();
            }
            str = str + "</TimerGroup>\n";
        }
        return str;
    }

    public static void main(String[] args) {
        TimeStats.log(5L, "tlog");
        System.out.println("Starting loop");
        TimeStats.start("FOO", "T1");
        int i = 0;
        while (i < 1000) {
            TimeStats.start("FOO", "T2");
            int j = 0;
            while (j < 10000) {
                int k = 0;
                while (k < 100) {
                    int x = i + j + k;
                    ++k;
                }
                ++j;
            }
            TimeStats.stop("FOO", "T2");
            ++i;
        }
        TimeStats.stop("FOO", "T1");
        System.out.println("Loop finished");
        TimeStats.stopLogger();
    }
}

