/*
 * Decompiled with CFR 0.152.
 */
package com.aligo.util;

import java.lang.reflect.Field;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;

public class ClassUtils {
    private static final String BOOLEAN_CLASS = "java.lang.Boolean";
    private static final String INTEGER_CLASS = "java.lang.Integer";
    private static final String CHARACTER_CLASS = "java.lang.Character";
    private static final String BYTE_CLASS = "java.lang.Byte";
    private static final String LONG_CLASS = "java.lang.Long";
    private static final String FLOAT_CLASS = "java.lang.Float";
    private static final String DOUBLE_CLASS = "java.lang.Double";
    private static final String SHORT_CLASS = "java.lang.Short";

    public static Object createElement(String className) {
        Object instanceObject = null;
        try {
            instanceObject = ClassUtils.createElementWithThrow(className);
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
        return instanceObject;
    }

    public static Object createElementWithThrow(String className) throws ClassNotFoundException, InstantiationException, IllegalAccessException {
        Class<?> instanceClass = Class.forName(className);
        Object instanceObject = instanceClass.newInstance();
        return instanceObject;
    }

    public static Object callMethod(Object targetObject, String methodName, Object[] args) {
        Object returnObject = null;
        try {
            returnObject = ClassUtils.callMethodWithThrow(targetObject, methodName, args);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return returnObject;
    }

    public static Object callMethodWithThrow(Object targetObject, String methodName, Object[] args) throws InvocationTargetException, IllegalAccessException, NoSuchMethodException {
        Class<Object> parameterType;
        Object arg;
        Object returnObject = null;
        int argsLength = 0;
        if (args != null) {
            argsLength = args.length;
        }
        Class<?> targetClass = targetObject.getClass();
        Method targetMethod = null;
        boolean done = false;
        Class[] parameterTypes = new Class[argsLength];
        int i = 0;
        while (i < argsLength) {
            arg = args[i];
            parameterType = arg instanceof Boolean ? Boolean.TYPE : (arg != null ? arg.getClass() : null);
            parameterTypes[i] = parameterType;
            ++i;
        }
        try {
            targetMethod = targetClass.getMethod(methodName, parameterTypes);
        }
        catch (Exception ex) {
            // empty catch block
        }
        if (targetMethod == null) {
            Method[] methods = targetClass.getMethods();
            int methodLength = methods.length;
            int i2 = 0;
            while (i2 < methodLength && !done) {
                Method method = methods[i2];
                parameterTypes = method.getParameterTypes();
                int paramLength = parameterTypes.length;
                String mName = method.getName();
                if (mName.equals(methodName)) {
                    if (argsLength == 0 && paramLength == argsLength) {
                        targetMethod = method;
                        done = true;
                    } else if (argsLength == paramLength) {
                        boolean paramsOk = true;
                        int j = 0;
                        while (j < paramLength && paramsOk) {
                            parameterType = parameterTypes[j];
                            String paramName = parameterType.getName();
                            arg = args[j];
                            if (arg != null) {
                                Class<?> argType = arg.getClass();
                                String argName = argType.getName();
                                if (parameterType.isPrimitive()) {
                                    if (paramName.equals(Boolean.TYPE.getName())) {
                                        paramName = BOOLEAN_CLASS;
                                    } else if (paramName.equals(Integer.TYPE.getName())) {
                                        paramName = INTEGER_CLASS;
                                    } else if (paramName.equals(Character.TYPE.getName())) {
                                        paramName = CHARACTER_CLASS;
                                    } else if (paramName.equals(Byte.TYPE.getName())) {
                                        paramName = BYTE_CLASS;
                                    } else if (paramName.equals(Long.TYPE.getName())) {
                                        paramName = LONG_CLASS;
                                    } else if (paramName.equals(Float.TYPE.getName())) {
                                        paramName = FLOAT_CLASS;
                                    } else if (paramName.equals(Double.TYPE.getName())) {
                                        paramName = DOUBLE_CLASS;
                                    } else if (paramName.equals(Short.TYPE.getName())) {
                                        paramName = SHORT_CLASS;
                                    }
                                }
                                if (!paramName.equals(argName) && !ClassUtils.doesImplementorExtend(argType, parameterType)) {
                                    paramsOk = false;
                                }
                            }
                            ++j;
                        }
                        if (paramsOk) {
                            targetMethod = method;
                            done = true;
                        }
                    }
                }
                ++i2;
            }
        }
        if (targetMethod == null) {
            throw new NoSuchMethodException("Sorry cannot execute method... incompatible method types");
        }
        returnObject = targetMethod.invoke(targetObject, args);
        return returnObject;
    }

    public static boolean doesExtend(Class childClass, Class parentClass) {
        String childParentClassName;
        if (childClass == null && parentClass == null) {
            return true;
        }
        boolean bDoesExtend = false;
        String parentClassName = parentClass.getName();
        Class childParentClass = childClass.getSuperclass();
        bDoesExtend = childParentClass == null ? false : ((childParentClassName = childParentClass.getName()).equals(parentClassName) ? true : ClassUtils.doesExtend(childParentClass, parentClass));
        return bDoesExtend;
    }

    public static boolean doesImplement(Class childClass, Class parentClass) {
        if (childClass == null && parentClass == null) {
            return true;
        }
        boolean bDoesImplement = false;
        String parentClassName = parentClass.getName();
        Class<?>[] childParentClasses = childClass.getInterfaces();
        if (childParentClasses == null) {
            bDoesImplement = false;
        } else {
            int length = childParentClasses.length;
            boolean done = false;
            int i = 0;
            while (i < length && !done) {
                Class<?> childParentClass = childParentClasses[i];
                String childParentClassName = childParentClass.getName();
                bDoesImplement = childParentClassName.equals(parentClassName) ? true : ClassUtils.doesImplement(childParentClass, parentClass);
                if (bDoesImplement) {
                    done = true;
                }
                ++i;
            }
        }
        return bDoesImplement;
    }

    public static boolean doesImplementorExtend(Class childClass, Class parentClass) {
        if (childClass == null && parentClass == null) {
            return true;
        }
        boolean bDoesImplementorExtend = false;
        String parentClassName = parentClass.getName();
        Class<?>[] childParentInterfaceClasses = childClass.getInterfaces();
        Class childParentSuperClass = childClass.getSuperclass();
        if (childParentInterfaceClasses == null && childParentSuperClass == null) {
            bDoesImplementorExtend = false;
        } else {
            if (childParentSuperClass != null) {
                String childParentSuperClassName = childParentSuperClass.getName();
                bDoesImplementorExtend = childParentSuperClassName.equals(parentClassName) ? true : ClassUtils.doesImplementorExtend(childParentSuperClass, parentClass);
            }
            if (!bDoesImplementorExtend && childParentInterfaceClasses != null) {
                int length = childParentInterfaceClasses.length;
                boolean done = false;
                int i = 0;
                while (i < length && !done) {
                    Class<?> childParentInterfaceClass = childParentInterfaceClasses[i];
                    String childParentInterfaceClassName = childParentInterfaceClass.getName();
                    bDoesImplementorExtend = childParentInterfaceClassName.equals(parentClassName) ? true : ClassUtils.doesImplementorExtend(childParentInterfaceClass, parentClass);
                    if (bDoesImplementorExtend) {
                        done = true;
                    }
                    ++i;
                }
            }
        }
        return bDoesImplementorExtend;
    }

    public static Object getFieldValue(Object parentObject, String fieldName) {
        Object fieldObject = null;
        if (parentObject != null) {
            try {
                Class<?> parentClass = parentObject.getClass();
                Field field = parentClass.getDeclaredField(fieldName);
                fieldObject = field.get(parentObject);
            }
            catch (Exception ex) {
                // empty catch block
            }
        }
        return fieldObject;
    }

    public static Class getParameterType(Object targetObject, String methodName, int index) {
        boolean done = false;
        Class<?> retVal = null;
        Class<?> targetClass = targetObject.getClass();
        Method[] methods = targetClass.getMethods();
        int methodLength = methods.length;
        int i = 0;
        while (i < methodLength && !done) {
            if (methods[i].getName().equals(methodName)) {
                retVal = methods[i].getParameterTypes()[index];
                done = true;
            }
            ++i;
        }
        return retVal;
    }
}

