/*
 * Decompiled with CFR 0.152.
 */
package com.aligo.tools.xml;

import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.PrintWriter;
import java.io.UnsupportedEncodingException;
import java.io.Writer;
import java.util.AbstractCollection;
import java.util.ArrayList;
import org.w3c.dom.Attr;
import org.w3c.dom.Document;
import org.w3c.dom.DocumentType;
import org.w3c.dom.NamedNodeMap;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

public class DOMWriter {
    private static final String DEFAULT_PARSER_NAME = "dom.wrappers.DOMParser";
    private static boolean setValidation = false;
    private static boolean setNameSpaces = true;
    private static boolean setSchemaSupport = true;
    private static boolean setDeferredDOM = true;
    private static String PRINTWRITER_ENCODING = "UTF-8";
    private static String[] MIME2JAVA_ENCODINGS = new String[]{"Default", "UTF-8", "US-ASCII", "ISO-8859-1", "ISO-8859-2", "ISO-8859-3", "ISO-8859-4", "ISO-8859-5", "ISO-8859-6", "ISO-8859-7", "ISO-8859-8", "ISO-8859-9", "ISO-2022-JP", "SHIFT_JIS", "EUC-JP", "GB2312", "BIG5", "EUC-KR", "ISO-2022-KR", "KOI8-R", "EBCDIC-CP-US", "EBCDIC-CP-CA", "EBCDIC-CP-NL", "EBCDIC-CP-DK", "EBCDIC-CP-NO", "EBCDIC-CP-FI", "EBCDIC-CP-SE", "EBCDIC-CP-IT", "EBCDIC-CP-ES", "EBCDIC-CP-GB", "EBCDIC-CP-FR", "EBCDIC-CP-AR1", "EBCDIC-CP-HE", "EBCDIC-CP-CH", "EBCDIC-CP-ROECE", "EBCDIC-CP-YU", "EBCDIC-CP-IS", "EBCDIC-CP-AR2", "UTF-16"};
    protected PrintWriter out;
    private boolean htmlStyle;
    private boolean beautify;
    private boolean hideBanner;
    protected ArrayList list = new ArrayList();
    private static String PADDING = "    ";
    protected boolean canonical;
    protected boolean ignoreMessyText;

    public DOMWriter(String encoding, boolean canonical) throws UnsupportedEncodingException {
        this(System.out, encoding, canonical);
    }

    public DOMWriter(OutputStream output, String encoding, boolean canonical) throws UnsupportedEncodingException {
        this.out = new PrintWriter(new OutputStreamWriter(output, encoding));
        this.canonical = canonical;
    }

    public DOMWriter(Writer writer, boolean canonical) {
        this.out = new PrintWriter(writer);
        this.canonical = canonical;
    }

    public DOMWriter(boolean canonical) throws UnsupportedEncodingException {
        this(System.out, canonical);
    }

    public DOMWriter(OutputStream output, boolean canonical) throws UnsupportedEncodingException {
        this(output, DOMWriter.getWriterEncoding(), canonical);
    }

    public static String getWriterEncoding() {
        return PRINTWRITER_ENCODING;
    }

    public static void setWriterEncoding(String encoding) {
        PRINTWRITER_ENCODING = encoding.equalsIgnoreCase("DEFAULT") ? "UTF-8" : (encoding.equalsIgnoreCase("UTF-16") ? "Unicode" : encoding);
    }

    public static boolean isValidJavaEncoding(String encoding) {
        int i = 0;
        while (i < MIME2JAVA_ENCODINGS.length) {
            if (encoding.equals(MIME2JAVA_ENCODINGS[i])) {
                return true;
            }
            ++i;
        }
        return false;
    }

    public void setHTMLStyle(boolean htmlStyle) {
        this.htmlStyle = htmlStyle;
    }

    public boolean isHTMLStyle() {
        return this.htmlStyle;
    }

    public void setBeautify(boolean beautify) {
        this.beautify = beautify;
    }

    public boolean isBeautify() {
        return this.beautify;
    }

    public void setIgnoreMessyText(boolean ignoreMessyText) {
        this.ignoreMessyText = ignoreMessyText;
    }

    public boolean isIgnoreMessyText() {
        return this.ignoreMessyText;
    }

    public boolean isHideBanner() {
        return this.hideBanner;
    }

    public void setHideBanner(boolean hideBanner) {
        this.hideBanner = hideBanner;
    }

    public void print(Node node) {
        if (node == null) {
            return;
        }
        short type = node.getNodeType();
        switch (type) {
            case 9: {
                if (!this.canonical && !this.hideBanner) {
                    String Encoding = DOMWriter.getWriterEncoding();
                    if (Encoding.equalsIgnoreCase("DEFAULT")) {
                        Encoding = "UTF-8";
                    } else if (Encoding.equalsIgnoreCase("Unicode")) {
                        Encoding = "UTF-16";
                    }
                    this.out.println("<?xml version=\"1.0\" encoding=\"" + Encoding + "\"?>");
                    Document document = (Document)node;
                    if (document.getDoctype() != null && document.getDoctype().getName() != null) {
                        DocumentType docType = document.getDoctype();
                        this.out.print("<!DOCTYPE " + docType.getName());
                        if (docType.getPublicId() != null) {
                            this.out.print(" PUBLIC \"" + docType.getPublicId() + "\"");
                        }
                        if (docType.getSystemId() != null) {
                            if (docType.getPublicId() == null) {
                                this.out.print(" SYSTEM");
                            }
                            this.out.print(" \"" + docType.getSystemId() + "\"");
                        }
                        this.out.println(">");
                    }
                }
                NodeList children = node.getChildNodes();
                int iChild = 0;
                while (iChild < children.getLength()) {
                    this.print(children.item(iChild));
                    ++iChild;
                }
                this.out.flush();
                break;
            }
            case 1: {
                int len = 0;
                NodeList children = node.getChildNodes();
                if (children != null) {
                    len = children.getLength();
                }
                if (!this.isHTMLStyle() || this.isBeautify()) {
                    this.out.print(this.getPadding());
                }
                this.list.add(node.getNodeName());
                this.out.print('<');
                this.out.print(node.getNodeName());
                Attr[] attrs = this.sortAttributes(node.getAttributes());
                int i = 0;
                while (i < attrs.length) {
                    Attr attr = attrs[i];
                    try {
                        if (attr != null && attr.getNodeName() != null && attr.getNodeValue() != null) {
                            this.out.print(' ');
                            this.out.print(attr.getNodeName());
                            if (this.isHTMLStyle() && node.getNodeName().toLowerCase().equals("meta") && attr.getNodeValue().indexOf("\"") > -1) {
                                this.out.print("='");
                            } else {
                                this.out.print("=\"");
                            }
                            if (this.isHTMLStyle()) {
                                this.out.print(attr.getNodeValue());
                            } else {
                                this.out.print(this.normalize(attr.getNodeValue()));
                            }
                            if (this.isHTMLStyle() && node.getNodeName().toLowerCase().equals("meta") && attr.getNodeValue().indexOf("\"") > -1) {
                                this.out.print("'");
                            } else {
                                this.out.print("\"");
                            }
                        }
                    }
                    catch (Exception e) {
                        // empty catch block
                    }
                    ++i;
                }
                if (len > 0) {
                    if (len == 1 && children.item(0).getNodeType() == 3) {
                        this.out.print('>');
                    } else {
                        this.out.print(">");
                        if (!this.isHTMLStyle() || this.isBeautify()) {
                            this.out.print("\n");
                        }
                    }
                } else if (!this.htmlStyle) {
                    this.out.print("/>");
                    if (!this.isHTMLStyle() || this.isBeautify()) {
                        this.out.print("\n");
                    }
                } else if (node.getNodeName().toLowerCase().equals("script") || node.getNodeName().toLowerCase().equals("table") || node.getNodeName().toLowerCase().equals("tbody") || node.getNodeName().toLowerCase().equals("tr") || node.getNodeName().toLowerCase().equals("td")) {
                    this.out.print("></");
                    this.out.print(node.getNodeName());
                    this.out.print(">");
                    if (!this.isHTMLStyle() || this.isBeautify()) {
                        this.out.print("\n");
                    }
                } else {
                    this.out.print(">");
                    if (!this.isHTMLStyle() || this.isBeautify()) {
                        this.out.print("\n");
                    }
                }
                int i2 = 0;
                while (i2 < len) {
                    this.print(children.item(i2));
                    ++i2;
                }
                break;
            }
            case 5: {
                if (this.canonical) {
                    NodeList children = node.getChildNodes();
                    if (children == null) break;
                    int len = children.getLength();
                    int i = 0;
                    while (i < len) {
                        this.print(children.item(i));
                        ++i;
                    }
                    break;
                }
                this.out.print('&');
                this.out.print(node.getNodeName());
                this.out.print(';');
                break;
            }
            case 4: {
                try {
                    if (node.getNodeValue() == null) break;
                    if (this.canonical) {
                        this.out.print(this.normalize(node.getNodeValue()));
                        break;
                    }
                    this.out.print("<![CDATA[");
                    this.out.print(node.getNodeValue());
                    this.out.print("]]>");
                }
                catch (Exception e) {}
                break;
            }
            case 3: {
                try {
                    if (node.getNodeValue() == null) break;
                    if (this.isHTMLStyle() && node.getParentNode().getNodeName().toLowerCase().equals("script")) {
                        this.out.print(node.getNodeValue());
                        break;
                    }
                    this.out.print(this.normalize(node.getNodeValue()));
                }
                catch (Exception e) {
                    e.printStackTrace();
                }
                break;
            }
            case 8: {
                try {
                    if (node.getNodeValue() == null) break;
                    this.out.print("<!--");
                    this.out.print(node.getNodeValue());
                    this.out.println("-->");
                }
                catch (Exception e) {
                    e.printStackTrace();
                }
                break;
            }
            case 7: {
                try {
                    if (node.getNodeValue() == null) break;
                    this.out.print("<?");
                    this.out.print(node.getNodeName());
                    String data = node.getNodeValue();
                    if (data != null && data.length() > 0) {
                        this.out.print(' ');
                        this.out.print(data);
                    }
                    this.out.println("?>");
                    break;
                }
                catch (Exception e) {
                    e.printStackTrace();
                }
            }
        }
        if (type == 1) {
            int len;
            ((AbstractCollection)this.list).remove(node.getNodeName());
            NodeList children = node.getChildNodes();
            if (children != null && (len = children.getLength()) > 0) {
                if (!(len == 1 && children.item(0).getNodeType() == 3 || this.isHTMLStyle() && !this.isBeautify())) {
                    this.out.print(this.getPadding());
                }
                this.out.print("</");
                this.out.print(node.getNodeName());
                this.out.print(">");
                if (!this.isHTMLStyle() || this.isBeautify()) {
                    this.out.print("\n");
                }
            }
        }
        this.out.flush();
    }

    protected String getPadding() {
        StringBuffer buffer = new StringBuffer();
        int i = 0;
        while (i < this.list.size()) {
            buffer.append(PADDING);
            ++i;
        }
        return buffer.toString();
    }

    protected Attr[] sortAttributes(NamedNodeMap attrs) {
        int len = attrs != null ? attrs.getLength() : 0;
        Attr[] array = new Attr[len];
        int i = 0;
        while (i < len) {
            array[i] = (Attr)attrs.item(i);
            ++i;
        }
        int i2 = 0;
        while (i2 < len - 1) {
            String name = array[i2].getNodeName();
            int index = i2;
            int j = i2 + 1;
            while (j < len) {
                String curName = array[j].getNodeName();
                if (curName.compareTo(name) < 0) {
                    name = curName;
                    index = j;
                }
                ++j;
            }
            if (index != i2) {
                Attr temp = array[i2];
                array[i2] = array[index];
                array[index] = temp;
            }
            ++i2;
        }
        return array;
    }

    protected String normalize(String s) {
        if (this.ignoreMessyText) {
            s = s.trim();
        }
        StringBuffer str = new StringBuffer();
        int len = s != null ? s.length() : 0;
        int i = 0;
        while (i < len) {
            char ch = s.charAt(i);
            switch (ch) {
                case '<': {
                    str.append("&lt;");
                    break;
                }
                case '>': {
                    str.append("&gt;");
                    break;
                }
                case '&': {
                    str.append("&amp;");
                    break;
                }
                case '\"': {
                    str.append("&quot;");
                    break;
                }
                case '\u00a0': {
                    str.append("&nbsp;");
                    break;
                }
                case '\u0095': 
                case '\u00a1': 
                case '\u00a2': 
                case '\u00a3': 
                case '\u00a4': 
                case '\u00a5': 
                case '\u00a6': 
                case '\u00a7': 
                case '\u00a8': 
                case '\u00a9': 
                case '\u00aa': 
                case '\u00ab': 
                case '\u00ac': 
                case '\u00ad': 
                case '\u00ae': 
                case '\u00af': 
                case '\u00b0': 
                case '\u00b1': 
                case '\u00b2': 
                case '\u00b3': 
                case '\u00b4': 
                case '\u00b5': 
                case '\u00b6': 
                case '\u00b7': 
                case '\u00b8': 
                case '\u00b9': 
                case '\u00ba': 
                case '\u00bb': 
                case '\u00bc': 
                case '\u00bd': 
                case '\u00be': 
                case '\u00bf': 
                case '\u00c0': 
                case '\u00c1': 
                case '\u00c2': 
                case '\u00c3': 
                case '\u00c4': 
                case '\u00c5': 
                case '\u00c6': 
                case '\u00c7': 
                case '\u00c8': 
                case '\u00c9': 
                case '\u00ca': 
                case '\u00cb': 
                case '\u00cc': 
                case '\u00cd': 
                case '\u00ce': 
                case '\u00cf': 
                case '\u00d0': 
                case '\u00d1': 
                case '\u00d2': 
                case '\u00d3': 
                case '\u00d4': 
                case '\u00d5': 
                case '\u00d6': 
                case '\u00d7': 
                case '\u00d8': 
                case '\u00d9': 
                case '\u00da': 
                case '\u00db': 
                case '\u00dc': 
                case '\u00dd': 
                case '\u00de': 
                case '\u00df': 
                case '\u00e0': 
                case '\u00e1': 
                case '\u00e2': 
                case '\u00e3': 
                case '\u00e4': 
                case '\u00e5': 
                case '\u00e6': 
                case '\u00e7': 
                case '\u00e8': 
                case '\u00e9': 
                case '\u00ea': 
                case '\u00eb': 
                case '\u00ec': 
                case '\u00ed': 
                case '\u00ee': 
                case '\u00ef': 
                case '\u00f0': 
                case '\u00f1': 
                case '\u00f2': 
                case '\u00f3': 
                case '\u00f4': 
                case '\u00f5': 
                case '\u00f6': 
                case '\u00f7': 
                case '\u00f8': 
                case '\u00f9': 
                case '\u00fa': 
                case '\u00fb': 
                case '\u00fc': 
                case '\u00fd': 
                case '\u00fe': 
                case '\u00ff': 
                case '\u0152': 
                case '\u0153': 
                case '\u0160': 
                case '\u0161': 
                case '\u0178': 
                case '\u0192': 
                case '\u02c6': 
                case '\u02dc': 
                case '\u0391': 
                case '\u0392': 
                case '\u0393': 
                case '\u0394': 
                case '\u0395': 
                case '\u0396': 
                case '\u0397': 
                case '\u0398': 
                case '\u0399': 
                case '\u039a': 
                case '\u039b': 
                case '\u039c': 
                case '\u039d': 
                case '\u039e': 
                case '\u039f': 
                case '\u03a0': 
                case '\u03a1': 
                case '\u03a3': 
                case '\u03a4': 
                case '\u03a5': 
                case '\u03a6': 
                case '\u03a7': 
                case '\u03a8': 
                case '\u03a9': 
                case '\u03b1': 
                case '\u03b2': 
                case '\u03b3': 
                case '\u03b4': 
                case '\u03b5': 
                case '\u03b6': 
                case '\u03b7': 
                case '\u03b8': 
                case '\u03b9': 
                case '\u03ba': 
                case '\u03bb': 
                case '\u03bc': 
                case '\u03bd': 
                case '\u03be': 
                case '\u03bf': 
                case '\u03c0': 
                case '\u03c1': 
                case '\u03c2': 
                case '\u03c3': 
                case '\u03c4': 
                case '\u03c5': 
                case '\u03c6': 
                case '\u03c7': 
                case '\u03c8': 
                case '\u03c9': 
                case '\u03d1': 
                case '\u03d2': 
                case '\u03d6': 
                case '\u2002': 
                case '\u2003': 
                case '\u2009': 
                case '\u200c': 
                case '\u200d': 
                case '\u200e': 
                case '\u200f': 
                case '\u2013': 
                case '\u2014': 
                case '\u2018': 
                case '\u2019': 
                case '\u201a': 
                case '\u201c': 
                case '\u201d': 
                case '\u201e': 
                case '\u2020': 
                case '\u2021': 
                case '\u2022': 
                case '\u2026': 
                case '\u2030': 
                case '\u2032': 
                case '\u2033': 
                case '\u2039': 
                case '\u203a': 
                case '\u203e': 
                case '\u2044': 
                case '\u20ac': 
                case '\u2111': 
                case '\u2118': 
                case '\u211c': 
                case '\u2122': 
                case '\u2135': 
                case '\u2190': 
                case '\u2191': 
                case '\u2192': 
                case '\u2193': 
                case '\u2194': 
                case '\u21b5': 
                case '\u21d0': 
                case '\u21d1': 
                case '\u21d2': 
                case '\u21d3': 
                case '\u21d4': 
                case '\u2200': 
                case '\u2202': 
                case '\u2203': 
                case '\u2205': 
                case '\u2207': 
                case '\u2208': 
                case '\u2209': 
                case '\u220b': 
                case '\u220f': 
                case '\u2211': 
                case '\u2212': 
                case '\u2217': 
                case '\u221a': 
                case '\u221d': 
                case '\u221e': 
                case '\u2220': 
                case '\u2227': 
                case '\u2228': 
                case '\u2229': 
                case '\u222a': 
                case '\u222b': 
                case '\u2234': 
                case '\u223c': 
                case '\u2245': 
                case '\u2248': 
                case '\u2260': 
                case '\u2261': 
                case '\u2264': 
                case '\u2265': 
                case '\u2282': 
                case '\u2283': 
                case '\u2284': 
                case '\u2286': 
                case '\u2287': 
                case '\u2295': 
                case '\u2297': 
                case '\u22a5': 
                case '\u22c5': 
                case '\u2308': 
                case '\u2309': 
                case '\u230a': 
                case '\u230b': 
                case '\u2329': 
                case '\u232a': 
                case '\u25ca': 
                case '\u2660': 
                case '\u2663': 
                case '\u2665': 
                case '\u2666': {
                    str.append("&#");
                    str.append(Integer.toString(ch));
                    str.append(';');
                    break;
                }
                case '\t': {
                    if (!this.ignoreMessyText) {
                        str.append('\t');
                        break;
                    }
                }
                case '\n': 
                case '\r': {
                    if (ch != '\t' && this.canonical && !this.ignoreMessyText) {
                        str.append("&#");
                        str.append(Integer.toString(ch));
                        str.append(';');
                        break;
                    }
                }
                default: {
                    str.append(ch);
                }
            }
            ++i;
        }
        return str.toString();
    }

    private static void printValidJavaEncoding() {
        System.err.println("    ENCODINGS:");
        System.err.print("   ");
        int i = 0;
        while (i < MIME2JAVA_ENCODINGS.length) {
            System.err.print(MIME2JAVA_ENCODINGS[i] + " ");
            if (i % 7 == 0) {
                System.err.println();
                System.err.print("   ");
            }
            ++i;
        }
    }

    public void close() {
        try {
            this.out.flush();
            this.out.close();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }
}

