/*
 * Decompiled with CFR 0.152.
 */
package com.aligo.tools.util;

import com.aligo.tools.interfaces.DOMXMLable;
import com.aligo.tools.util.BooleanXMLProperty;
import com.aligo.tools.util.InstanceXMLProperty;
import com.aligo.tools.util.StringXMLProperty;
import com.aligo.tools.util.XMLProperty;
import com.aligo.tools.xml.DefaultDOMXMLable;
import com.aligo.tools.xml.DocumentFactory;
import com.aligo.tools.xml.XMLUtilities;
import java.io.File;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.Map;
import java.util.TreeMap;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

public class XMLProperties
extends DefaultDOMXMLable {
    public static final String PROPERTIES_FILE_TAG = "XMLPropertiesFile";
    private Map propertyMap;
    private String fileLocation;

    public XMLProperties(String fileLocation) {
        this(fileLocation, true);
    }

    public XMLProperties(String fileLocation, boolean load) {
        this.fileLocation = fileLocation;
        if (load) {
            try {
                Document document = DocumentFactory.openDocumentFromFileAsDOM(fileLocation);
                if (document != null) {
                    this.fromXMLElement(document.getDocumentElement());
                }
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
    }

    public XMLProperties(Element element) {
        super(element);
    }

    public XMLProperties(File file) {
        super(file);
    }

    public XMLProperties(InputStream stream) {
        super(stream);
    }

    public XMLProperties(Map map) {
        this.setPropertyMap(map);
    }

    public String getFileLocation() {
        return this.fileLocation;
    }

    public Map getPropertyMap() {
        if (this.propertyMap == null) {
            this.propertyMap = new TreeMap();
        }
        return this.propertyMap;
    }

    public void setPropertyMap(Map map) {
        this.propertyMap = new TreeMap();
        if (map != null) {
            this.propertyMap.putAll(map);
        }
    }

    public void fromXMLElement(Element element) {
        this.getPropertyMap().clear();
        try {
            if (element != null) {
                NodeList list;
                if (!PROPERTIES_FILE_TAG.equals(element.getTagName())) {
                    element = XMLUtilities.getFirstMatch(element, PROPERTIES_FILE_TAG);
                }
                if (element != null && PROPERTIES_FILE_TAG.equals(element.getTagName()) && (list = element.getChildNodes()) != null && list.getLength() > 0) {
                    int i = 0;
                    while (i < list.getLength()) {
                        XMLProperty property;
                        Node next = list.item(i);
                        if (next != null && next instanceof Element && (property = XMLProperty.createProperty((Element)next)) != null && property.getName() != null) {
                            this.getPropertyMap().put(property.getName(), property);
                        }
                        ++i;
                    }
                }
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public Element toXMLElement(Document document) {
        Element rootElement = null;
        try {
            rootElement = document.createElement(PROPERTIES_FILE_TAG);
            document.appendChild(rootElement);
            Collection list = this.getPropertyMap().values();
            if (list != null) {
                Iterator properties = list.iterator();
                while (properties.hasNext()) {
                    XMLProperty property = (XMLProperty)properties.next();
                    rootElement.appendChild(property.toXMLElement(document));
                }
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return rootElement;
    }

    public void setProperty(XMLProperty property) {
        if (property != null && property.getName() != null) {
            this.getPropertyMap().put(property.getName(), property);
        }
    }

    public void setProperty(String name, String value) {
        if (name != null) {
            if (value != null) {
                this.setProperty(new StringXMLProperty(name, value));
            } else {
                this.getPropertyMap().remove(name);
            }
        }
    }

    public void setProperty(String name, boolean value) {
        if (name != null) {
            this.setProperty(new BooleanXMLProperty(name, value));
        }
    }

    public void setProperty(String name, DOMXMLable value) {
        if (name != null) {
            this.setProperty(new InstanceXMLProperty(name, value));
        }
    }

    public void setProperty(String name, int value) {
        this.setProperty(name, String.valueOf(value));
    }

    public void setProperty(String name, File value) {
        this.setProperty(name, value != null ? value.toString() : (String)null);
    }

    public XMLProperty getProperty(String propertyName) {
        XMLProperty property = null;
        if (propertyName != null && this.getPropertyMap() != null) {
            property = (XMLProperty)this.getPropertyMap().get(propertyName);
        }
        return property;
    }

    public Object getPropertyValue(String propertyName) {
        XMLProperty property = null;
        Object value = null;
        if (propertyName != null && this.getPropertyMap() != null && (property = (XMLProperty)this.getPropertyMap().get(propertyName)) != null) {
            value = property.getPropertyValue();
        }
        return value;
    }

    public boolean contains(String propertyName) {
        boolean contains = false;
        if (propertyName != null && this.getPropertyMap() != null) {
            contains = this.getPropertyMap().containsKey(propertyName);
        }
        return contains;
    }

    public File getFile(String propertyName) {
        File file = null;
        Object value = this.getPropertyValue(propertyName);
        if (value != null) {
            try {
                file = new File(value.toString());
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
        return file;
    }

    public boolean getBoolean(String propertyName) {
        boolean state = false;
        Object value = this.getPropertyValue(propertyName);
        if (value != null) {
            try {
                state = Boolean.valueOf(value.toString());
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
        return state;
    }

    public DOMXMLable getDOMXMLable(String propertyName) {
        DOMXMLable domXMLable = null;
        Object value = this.getPropertyValue(propertyName);
        if (value != null && value instanceof DOMXMLable) {
            domXMLable = (DOMXMLable)value;
        }
        return domXMLable;
    }

    public int getInt(String propertyName) {
        int intValue = 0;
        Object value = this.getPropertyValue(propertyName);
        if (value != null) {
            try {
                intValue = Integer.parseInt(value.toString());
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
        return intValue;
    }

    public String getString(String propertyName) {
        String stringValue = null;
        Object value = this.getPropertyValue(propertyName);
        if (value != null) {
            try {
                stringValue = value.toString();
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
        return stringValue;
    }

    public void saveProperties() {
        try {
            Document document = DocumentFactory.createDOMDocument();
            this.toXMLElement(document);
            XMLUtilities.printItem((Node)document, this.getFileLocation());
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public Collection getProperties() {
        return new ArrayList(this.getPropertyMap().values());
    }
}

