/*
 * Decompiled with CFR 0.152.
 */
package com.aligo.tools.util;

import java.util.StringTokenizer;

public class SourceCodeUtilities {
    public static String replaceAndreturnAsComment(String code, String toReplace, String[] replaceWith) {
        StringBuffer retVal = new StringBuffer();
        StringTokenizer st = new StringTokenizer(code, toReplace, true);
        int index = 0;
        while (st.hasMoreTokens()) {
            String element = st.nextToken();
            if (element.equals(toReplace)) {
                retVal.append(replaceWith[index]);
                ++index;
                continue;
            }
            retVal.append(element);
        }
        return SourceCodeUtilities.returnAsComment(retVal.toString());
    }

    public static String generatePackageName(String dir) {
        StringBuffer packageName = new StringBuffer();
        StringTokenizer st = new StringTokenizer(dir, "/");
        boolean passed = false;
        while (st.hasMoreTokens()) {
            if (passed) {
                packageName.append(".");
            }
            packageName.append(st.nextToken());
            passed = true;
        }
        return packageName.toString();
    }

    public static String remove(String packageName, int howMany) {
        String s = packageName;
        int i = 0;
        while (i < howMany) {
            int length = s.length();
            int index = s.lastIndexOf(".", length);
            s = s.substring(0, index);
            ++i;
        }
        return s;
    }

    public static String returnJavaName(String dbFieldName) {
        String retVal = dbFieldName.toLowerCase();
        while (retVal.indexOf("_") != -1) {
            int spaceIndex = retVal.indexOf("_");
            retVal = retVal.substring(0, spaceIndex) + retVal.substring(spaceIndex + 1, spaceIndex + 2).toUpperCase() + retVal.substring(spaceIndex + 2, retVal.length());
        }
        return retVal;
    }

    public static String returnJavaNameForAppending(String dbFieldName) {
        return SourceCodeUtilities.returnJavaName(dbFieldName).substring(0, 1).toUpperCase() + SourceCodeUtilities.returnJavaName(dbFieldName).substring(1);
    }

    public static String returnVariableName(String name) {
        return name.substring(0, 1).toLowerCase() + name.substring(1);
    }

    public static String getTypeWithoutPackageName(String fullName) {
        int index = fullName.lastIndexOf(46);
        return fullName.substring(index + 1);
    }

    public static String returnAsComment(String commentString) {
        return SourceCodeUtilities.returnAsComment(commentString, false);
    }

    public static String returnAsComment(String commentString, boolean dotNETComment) {
        return SourceCodeUtilities.returnAsComment(commentString, dotNETComment, true);
    }

    public static String returnAsComment(String commentString, boolean dotNETComment, boolean bannerStartEnd) {
        StringTokenizer st = new StringTokenizer(commentString, "\n", false);
        StringBuffer strb = new StringBuffer();
        if (bannerStartEnd) {
            SourceCodeUtilities.fillCommentStart(strb, dotNETComment);
        }
        while (st.hasMoreTokens()) {
            String element = st.nextToken();
            if ((element = element.trim()).equals("")) continue;
            if (dotNETComment) {
                strb.append("/// ");
            } else {
                strb.append(" * ");
            }
            if (element.charAt(0) != '@' && element.charAt(0) != '<') {
                strb.append("<br>");
            }
            strb.append(element);
            strb.append("\n");
        }
        if (bannerStartEnd) {
            SourceCodeUtilities.fillCommentEnd(strb, dotNETComment);
        }
        return strb.toString();
    }

    public static String getBlankCommentLine() {
        return SourceCodeUtilities.getBlankCommentLine(false);
    }

    public static void fillBlankCommentLine(StringBuffer buffer) {
        SourceCodeUtilities.fillBlankCommentLine(buffer, false);
    }

    public static String getBlankCommentLine(boolean dotNETComment) {
        StringBuffer buffer = new StringBuffer();
        SourceCodeUtilities.fillBlankCommentLine(buffer, dotNETComment);
        return buffer.toString();
    }

    public static void fillBlankCommentLine(StringBuffer buffer, boolean dotNETComment) {
        if (dotNETComment) {
            buffer.append("///\n");
        } else {
            buffer.append(" *\n");
        }
    }

    public static String getCommentStart() {
        return SourceCodeUtilities.getCommentStart(false);
    }

    public static String getCommentStart(boolean dotNETComment) {
        StringBuffer buffer = new StringBuffer();
        SourceCodeUtilities.fillCommentStart(buffer, dotNETComment);
        return buffer.toString();
    }

    public static void fillCommentStart(StringBuffer buffer) {
        SourceCodeUtilities.fillCommentStart(buffer, false);
    }

    public static void fillCommentStart(StringBuffer buffer, boolean dotNETComment) {
        if (dotNETComment) {
            buffer.append("/// <summary>\n");
        } else {
            buffer.append("/**\n");
        }
    }

    public static String getCommentEnd() {
        return SourceCodeUtilities.getCommentEnd(false);
    }

    public static String getCommentEnd(boolean dotNETComment) {
        StringBuffer buffer = new StringBuffer();
        SourceCodeUtilities.fillCommentEnd(buffer, dotNETComment);
        return buffer.toString();
    }

    public static void fillCommentEnd(StringBuffer buffer) {
        SourceCodeUtilities.fillCommentEnd(buffer, false);
    }

    public static void fillCommentEnd(StringBuffer buffer, boolean dotNETComment) {
        if (dotNETComment) {
            buffer.append("/// </summary>\n");
        } else {
            buffer.append(" */\n");
        }
    }
}

