/*
 * Decompiled with CFR 0.152.
 */
package com.aligo.tools.util;

import com.aligo.tools.util.ConstantsPopulator;
import com.aligo.tools.util.PropertyScope;
import com.aligo.tools.xml.DefaultDOMXMLable;
import com.aligo.tools.xml.XMLUtilities;
import org.w3c.dom.Document;
import org.w3c.dom.Element;

public class ScopedProperty
extends DefaultDOMXMLable
implements Comparable {
    public static final String PROPERTY_TAG = "ScopedProperty";
    public static final String KEY_TAG = "Key";
    public static final String VALUE_TAG = "Value";
    public static final String SCOPE_TAG = "Scope";
    private String key;
    private String value;
    private PropertyScope scope;

    public ScopedProperty() {
        this(null, null);
    }

    public ScopedProperty(String key, String value) {
        this.key = key;
        this.value = value;
        this.scope = PropertyScope.PUBLIC;
    }

    public ScopedProperty(Element element) {
        super(element);
    }

    public String getKey() {
        return this.key;
    }

    public void setKey(String key) {
        this.key = key;
    }

    public String getValue() {
        return this.value;
    }

    public void setValue(String value) {
        this.value = value;
    }

    public PropertyScope getScope() {
        return this.scope;
    }

    public void setScope(PropertyScope scope) {
        this.scope = scope;
    }

    public void fromXMLElement(Element element) {
        this.key = null;
        this.value = null;
        this.scope = null;
        if (element != null) {
            if (!PROPERTY_TAG.equals(element.getTagName())) {
                element = XMLUtilities.getFirstMatch(element, PROPERTY_TAG);
            }
            if (element != null && PROPERTY_TAG.equals(element.getTagName())) {
                this.key = XMLUtilities.getPCData(element, KEY_TAG);
                this.value = XMLUtilities.getPCData(element, VALUE_TAG);
                this.scope = (PropertyScope)ConstantsPopulator.getObjectFromReflectString(XMLUtilities.getPCData(element, SCOPE_TAG), true);
            }
        }
    }

    public Element toXMLElement(Document document) {
        Element element = document.createElement(PROPERTY_TAG);
        if (this.key != null) {
            XMLUtilities.createPCData(document, element, KEY_TAG, this.key);
        }
        if (this.value != null) {
            XMLUtilities.createPCData(document, element, VALUE_TAG, this.value);
        }
        if (this.scope != null) {
            XMLUtilities.createPCData(document, element, SCOPE_TAG, ConstantsPopulator.getReflectString(this.scope));
        }
        return element;
    }

    public Object clone() {
        ScopedProperty clone = null;
        try {
            clone = (ScopedProperty)super.clone();
            clone.key = this.key;
            clone.value = this.value;
            clone.scope = this.scope;
        }
        catch (CloneNotSupportedException e) {
            e.printStackTrace();
        }
        return clone;
    }

    public boolean equals(Object obj) {
        return this.compareTo(obj) == 0;
    }

    public int compareTo(Object o) {
        int comp = -1;
        if (o instanceof ScopedProperty) {
            ScopedProperty prop = (ScopedProperty)o;
            if (prop.key != null && this.key != null) {
                comp = this.key.compareTo(prop.key);
            }
        }
        return comp;
    }
}

