/*
 * Decompiled with CFR 0.152.
 */
package com.aligo.tools.util;

import com.aligo.tools.factory.ThirdpartyClassLoaderFactory;
import com.aligo.tools.interfaces.ThirdpartyClassLoader;
import com.aligo.tools.resource.ResourceUtils;
import com.aligo.tools.util.ClassType;
import java.lang.reflect.Constructor;
import java.lang.reflect.Field;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.TreeSet;

public class ReflectionUtils {
    public static final String VOID = "void";
    public static final Collection DEFAULT_BLACK_LIST = ResourceUtils.getStringListFromServerSide("Default.BeanSearch.BlackList");
    public static final TreeSet PRIM_VALUES = new TreeSet();
    public static final TreeSet PRIM_OBJECT_VALUES = new TreeSet();
    static /* synthetic */ Class class$java$lang$Integer;
    static /* synthetic */ Class class$java$lang$Boolean;
    static /* synthetic */ Class class$java$lang$Float;
    static /* synthetic */ Class class$java$lang$Double;
    static /* synthetic */ Class class$java$lang$Short;
    static /* synthetic */ Class class$java$lang$Long;
    static /* synthetic */ Class class$java$lang$Character;
    static /* synthetic */ Class class$java$lang$Byte;
    static /* synthetic */ Class class$java$lang$Number;
    static /* synthetic */ Class class$java$lang$String;

    private ReflectionUtils() {
    }

    public static Collection getReferencedClasses(Class className) {
        return ReflectionUtils.getReferencedClasses(className, false);
    }

    public static Collection getReferencedClasses(Class className, boolean declaredOnly) {
        return ReflectionUtils.getReferencedClasses(className, declaredOnly, false);
    }

    public static Collection getReferencedClasses(Class className, boolean declaredOnly, boolean publicOnly) {
        return ReflectionUtils.getReferencedClasses(className, declaredOnly, publicOnly, false);
    }

    public static Collection getReferencedClasses(Class className, boolean declaredOnly, boolean publicOnly, boolean ignoreStatic) {
        return ReflectionUtils.getReferencedClasses(className, declaredOnly, publicOnly, ignoreStatic, null);
    }

    public static Collection getReferencedClasses(Class className, boolean declaredOnly, boolean publicOnly, boolean ignoreStatic, Collection blackList) {
        TreeSet<String> referencedClasses = new TreeSet<String>();
        Method[] theMethods = declaredOnly ? className.getDeclaredMethods() : className.getMethods();
        int i = 0;
        while (i < theMethods.length) {
            Method theMethod = theMethods[i];
            boolean isPublic = Modifier.isPublic(theMethod.getModifiers());
            boolean isStatic = Modifier.isStatic(theMethod.getModifiers());
            if (!(publicOnly && !isPublic || ignoreStatic && isStatic)) {
                Class<?> returnClass = theMethod.getReturnType();
                if (returnClass.isArray()) {
                    returnClass = returnClass.getComponentType();
                }
                if (blackList == null || !blackList.contains(returnClass.getName()) && !VOID.equals(returnClass.getName())) {
                    referencedClasses.add(returnClass.getName());
                }
                Class<?>[] params = theMethods[i].getParameterTypes();
                int j = 0;
                while (j < params.length) {
                    Class<?> paramClass = params[j];
                    if (paramClass.isArray()) {
                        paramClass = paramClass.getComponentType();
                    }
                    if (blackList == null || !blackList.contains(paramClass.getName()) && !VOID.equals(paramClass.getName())) {
                        referencedClasses.add(paramClass.getName());
                    }
                    ++j;
                }
            }
            ++i;
        }
        return referencedClasses;
    }

    public static Collection getReferencedClassesAsClasses(Class className) {
        return ReflectionUtils.getReferencedClasses(className, false);
    }

    public static Collection getReferencedClassesAsClasses(Class className, boolean declaredOnly) {
        return ReflectionUtils.getReferencedClasses(className, declaredOnly, false);
    }

    public static Collection getReferencedClassesAsClasses(Class className, boolean declaredOnly, boolean publicOnly) {
        return ReflectionUtils.getReferencedClasses(className, declaredOnly, publicOnly, false);
    }

    public static Collection getReferencedClassesAsClasses(Class className, boolean declaredOnly, boolean publicOnly, boolean ignoreStatic) {
        return ReflectionUtils.getReferencedClasses(className, declaredOnly, publicOnly, ignoreStatic, null);
    }

    public static Collection getReferencedClassesAsClasses(Class className, boolean declaredOnly, boolean publicOnly, boolean ignoreStatic, Collection blackList) {
        TreeSet<String> referencedClasses = new TreeSet<String>();
        ArrayList referencedClassesAsClasses = new ArrayList();
        Method[] theMethods = declaredOnly ? className.getDeclaredMethods() : className.getMethods();
        int i = 0;
        while (i < theMethods.length) {
            Method theMethod = theMethods[i];
            boolean isPublic = Modifier.isPublic(theMethod.getModifiers());
            boolean isStatic = Modifier.isStatic(theMethod.getModifiers());
            if (!(publicOnly && !isPublic || ignoreStatic && isStatic)) {
                Class<?> returnClass = theMethod.getReturnType();
                if (returnClass.isArray()) {
                    returnClass = returnClass.getComponentType();
                }
                if (blackList == null || !blackList.contains(returnClass.getName()) && !referencedClasses.contains(returnClass.getName()) && !VOID.equals(returnClass.getName())) {
                    referencedClasses.add(returnClass.getName());
                    referencedClassesAsClasses.add(returnClass);
                }
                Class<?>[] params = theMethods[i].getParameterTypes();
                int j = 0;
                while (j < params.length) {
                    Class<?> paramClass = params[j];
                    if (paramClass.isArray()) {
                        paramClass = paramClass.getComponentType();
                    }
                    if (blackList == null || !blackList.contains(paramClass.getName()) && !referencedClasses.contains(paramClass.getName()) && !VOID.equals(paramClass.getName())) {
                        referencedClasses.add(paramClass.getName());
                        referencedClassesAsClasses.add(paramClass);
                    }
                    ++j;
                }
            }
            ++i;
        }
        return referencedClassesAsClasses;
    }

    public static boolean isClassArray(String className) {
        boolean array = false;
        if (className != null && (className.startsWith("[L") && className.endsWith(";") || className.endsWith("[]"))) {
            array = true;
        }
        return array;
    }

    public static String getClassNameFromArrayName(String className) {
        if (className != null && ReflectionUtils.isClassArray(className)) {
            className = className.endsWith("[]") ? className.substring(0, className.length() - 2) : className.substring(2, className.length() - 1);
        }
        return className;
    }

    public static boolean isNumber(ClassType classValue) {
        boolean isNumber = false;
        if (classValue != null && !classValue.isArray() && classValue.getType() != null) {
            try {
                Class<?> theClass = Class.forName(classValue.getType());
                isNumber = ReflectionUtils.isAssignableFrom(class$java$lang$Number == null ? (class$java$lang$Number = ReflectionUtils.class$("java.lang.Number")) : class$java$lang$Number, theClass);
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        return isNumber;
    }

    public static boolean isString(ClassType classValue) {
        return classValue != null && !classValue.isArray() && classValue.getType() != null && (class$java$lang$String == null ? (class$java$lang$String = ReflectionUtils.class$("java.lang.String")) : class$java$lang$String).getName().equals(classValue.getType());
    }

    public static boolean isPrimitive(ClassType classValue) {
        return classValue != null && !classValue.isArray() && ReflectionUtils.isPrimitive(classValue.getType());
    }

    public static boolean isPrimitive(String classValue) {
        boolean prim = classValue != null ? PRIM_VALUES.contains(classValue) : false;
        return prim;
    }

    public static boolean isPrimitiveObject(String classValue) {
        boolean prim = classValue != null ? PRIM_OBJECT_VALUES.contains(classValue) : false;
        return prim;
    }

    public static boolean isPrimitiveOrPrimitiveObjectOrString(ClassType classType) {
        return classType != null && !classType.isArray() && ReflectionUtils.isPrimitiveOrPrimitiveObjectOrString(classType.getType());
    }

    public static boolean isPrimitiveOrPrimitiveObjectOrString(String classValue) {
        boolean prim = ReflectionUtils.isPrimitive(classValue) || ReflectionUtils.isPrimitiveObject(classValue) || (classValue != null ? (class$java$lang$String == null ? (class$java$lang$String = ReflectionUtils.class$("java.lang.String")) : class$java$lang$String).getName().equals(classValue) : false);
        return prim;
    }

    public static Class getPrimitiveObjectClass(String primitiveClass) {
        Class primObjectClass = null;
        if (ReflectionUtils.isPrimitive(primitiveClass)) {
            if (primitiveClass.equals("int")) {
                primObjectClass = class$java$lang$Integer == null ? (class$java$lang$Integer = ReflectionUtils.class$("java.lang.Integer")) : class$java$lang$Integer;
            } else if (primitiveClass.equals("long")) {
                primObjectClass = class$java$lang$Long == null ? (class$java$lang$Long = ReflectionUtils.class$("java.lang.Long")) : class$java$lang$Long;
            } else if (primitiveClass.equals("short")) {
                primObjectClass = class$java$lang$Short == null ? (class$java$lang$Short = ReflectionUtils.class$("java.lang.Short")) : class$java$lang$Short;
            } else if (primitiveClass.equals("float")) {
                primObjectClass = class$java$lang$Float == null ? (class$java$lang$Float = ReflectionUtils.class$("java.lang.Float")) : class$java$lang$Float;
            } else if (primitiveClass.equals("double")) {
                primObjectClass = class$java$lang$Double == null ? (class$java$lang$Double = ReflectionUtils.class$("java.lang.Double")) : class$java$lang$Double;
            } else if (primitiveClass.equals("char")) {
                primObjectClass = class$java$lang$Character == null ? (class$java$lang$Character = ReflectionUtils.class$("java.lang.Character")) : class$java$lang$Character;
            } else if (primitiveClass.equals("byte")) {
                primObjectClass = class$java$lang$Byte == null ? (class$java$lang$Byte = ReflectionUtils.class$("java.lang.Byte")) : class$java$lang$Byte;
            } else if (primitiveClass.equals("boolean")) {
                primObjectClass = class$java$lang$Boolean == null ? (class$java$lang$Boolean = ReflectionUtils.class$("java.lang.Boolean")) : class$java$lang$Boolean;
            }
        }
        return primObjectClass;
    }

    public static Collection getConstructors(ClassType theClass, boolean publicOnly) {
        return ReflectionUtils.getConstructors(ReflectionUtils.getClassFromType(theClass), publicOnly);
    }

    public static Collection getConstructors(Class theClass, boolean publicOnly) {
        ArrayList constructorList = new ArrayList();
        if (theClass != null) {
            Constructor<?>[] constructors = theClass.getConstructors();
            int i = 0;
            while (i < constructors.length) {
                boolean isPublic;
                Constructor<?> constructor = constructors[i];
                int modifiers = constructor.getModifiers();
                boolean bl = isPublic = (modifiers & 1) > 0;
                if (!publicOnly || isPublic) {
                    constructorList.add(constructor);
                }
                ++i;
            }
        }
        return constructorList;
    }

    public static boolean isAssignableFrom(Class a, Class b) {
        boolean assignable = false;
        if (a != null && b != null) {
            if (a.getName().equals(b.getName())) {
                assignable = true;
            } else {
                Class<?>[] interfaces = b.getInterfaces();
                int i = 0;
                while (!assignable && i < interfaces.length) {
                    Class<?> anInterface = interfaces[i];
                    assignable = ReflectionUtils.isAssignableFrom(a, anInterface);
                    ++i;
                }
            }
            if (!assignable) {
                assignable = ReflectionUtils.isAssignableFrom(a, b.getSuperclass());
            }
        }
        return assignable;
    }

    public static Class getClassFromType(ClassType classType) {
        ThirdpartyClassLoader loader;
        Class theClass = null;
        if (classType != null && (loader = ThirdpartyClassLoaderFactory.getInstance().createClassLoader()) != null) {
            theClass = loader.findClass(classType);
        }
        return theClass;
    }

    public static Collection getMethods(ClassType theClass) {
        return ReflectionUtils.getMethods(theClass, false);
    }

    public static Collection getMethods(ClassType theClass, boolean staticOnly) {
        return ReflectionUtils.getMethods(theClass, staticOnly, false);
    }

    public static Collection getMethods(ClassType theClass, boolean staticOnly, boolean publicOnly) {
        return ReflectionUtils.getMethods(theClass, staticOnly, publicOnly, false);
    }

    public static Collection getMethods(ClassType theClass, boolean staticOnly, boolean publicOnly, boolean withReturnsOnly) {
        return ReflectionUtils.getMethods(theClass, staticOnly, publicOnly, withReturnsOnly, false);
    }

    public static Collection getMethods(ClassType theClass, boolean staticOnly, boolean publicOnly, boolean withReturnsOnly, boolean declaredOnly) {
        return ReflectionUtils.getMethods(theClass, staticOnly, publicOnly, withReturnsOnly, declaredOnly, false);
    }

    public static Collection getMethods(ClassType theClass, boolean staticOnly, boolean publicOnly, boolean withReturnsOnly, boolean declaredOnly, boolean noStatic) {
        return ReflectionUtils.getMethods(theClass, staticOnly, publicOnly, withReturnsOnly, declaredOnly, noStatic, (ClassType)null);
    }

    public static Collection getMethods(ClassType theClass, boolean staticOnly, boolean publicOnly, boolean withReturnsOnly, boolean declaredOnly, boolean noStatic, String returnType) {
        return ReflectionUtils.getMethods(theClass, staticOnly, publicOnly, withReturnsOnly, declaredOnly, noStatic, new ClassType(returnType));
    }

    public static Collection getMethods(ClassType theClass, boolean staticOnly, boolean publicOnly, boolean withReturnsOnly, boolean declaredOnly, boolean noStatic, ClassType returnType) {
        return ReflectionUtils.getMethods(ReflectionUtils.getClassFromType(theClass), staticOnly, publicOnly, withReturnsOnly, declaredOnly, noStatic, returnType);
    }

    public static Collection getMethods(Class theClass) {
        return ReflectionUtils.getMethods(theClass, false);
    }

    public static Collection getMethods(Class theClass, boolean staticOnly) {
        return ReflectionUtils.getMethods(theClass, staticOnly, false);
    }

    public static Collection getMethods(Class theClass, boolean staticOnly, boolean publicOnly) {
        return ReflectionUtils.getMethods(theClass, staticOnly, publicOnly, false);
    }

    public static Collection getMethods(Class theClass, boolean staticOnly, boolean publicOnly, boolean withReturnsOnly) {
        return ReflectionUtils.getMethods(theClass, staticOnly, publicOnly, withReturnsOnly, false);
    }

    public static Collection getMethods(Class theClass, boolean staticOnly, boolean publicOnly, boolean withReturnsOnly, boolean declaredOnly) {
        return ReflectionUtils.getMethods(theClass, staticOnly, publicOnly, withReturnsOnly, declaredOnly, false);
    }

    public static Collection getMethods(Class theClass, boolean staticOnly, boolean publicOnly, boolean withReturnsOnly, boolean declaredOnly, boolean noStatic) {
        return ReflectionUtils.getMethods(theClass, staticOnly, publicOnly, withReturnsOnly, declaredOnly, noStatic, (String)null);
    }

    public static Collection getMethods(Class theClass, boolean staticOnly, boolean publicOnly, boolean withReturnsOnly, boolean declaredOnly, boolean noStatic, String returnType) {
        return ReflectionUtils.getMethods(theClass, staticOnly, publicOnly, withReturnsOnly, declaredOnly, noStatic, returnType != null ? new ClassType(returnType) : (ClassType)null);
    }

    public static Collection getMethods(Class theClass, boolean staticOnly, boolean publicOnly, boolean withReturnsOnly, boolean declaredOnly, boolean noStatic, ClassType returnType) {
        ArrayList<Method> methodList = new ArrayList<Method>();
        if (theClass != null) {
            Method[] methods = null;
            methods = declaredOnly ? theClass.getDeclaredMethods() : theClass.getMethods();
            int i = 0;
            while (i < methods.length) {
                boolean hasReturn;
                Method method = methods[i];
                int modifiers = method.getModifiers();
                boolean isStatic = (modifiers & 8) > 0;
                boolean isPublic = (modifiers & 1) > 0;
                boolean bl = hasReturn = method.getReturnType() != null && !method.getReturnType().getName().equals(VOID);
                if (!(staticOnly && !isStatic || (!noStatic || isStatic) && noStatic || publicOnly && !isPublic || withReturnsOnly && !hasReturn || returnType != null && !ReflectionUtils.isClassSame(method.getReturnType(), returnType))) {
                    methodList.add(method);
                }
                ++i;
            }
        }
        return methodList;
    }

    public static boolean isClassSame(Class theClass, ClassType theType) {
        boolean same = false;
        if (theClass != null && theType != null && theType.getType() != null && theClass.isArray() == theType.isArray() && (theClass.isArray() && theClass.getComponentType().getName().equals(theType.getType()) || !theClass.isArray() && theClass.getName().equals(theType.getType()))) {
            same = true;
        }
        return same;
    }

    public static String getMethodSignature(Method method) {
        StringBuffer buffer = new StringBuffer();
        if (method != null) {
            ClassType returnClass = new ClassType(method.getReturnType());
            buffer.append(returnClass.getTrimmedTypeString());
            buffer.append(" ");
            buffer.append(method.getName());
            buffer.append("(");
            Class<?>[] params = method.getParameterTypes();
            int i = 0;
            while (i < params.length) {
                Class<?> param = params[i];
                ClassType name = new ClassType(param);
                buffer.append(name.getTrimmedTypeString());
                if (i + 1 < params.length) {
                    buffer.append(", ");
                }
                ++i;
            }
            buffer.append(")");
        }
        return buffer.toString();
    }

    public static Collection getFields(ClassType accessClass, String fieldType, boolean publicOnly, boolean staticOnly) {
        return ReflectionUtils.getFields(accessClass, new ClassType(fieldType), publicOnly, staticOnly);
    }

    public static Collection getFields(ClassType accessClass, ClassType fieldType, boolean publicOnly, boolean staticOnly) {
        return ReflectionUtils.getFields(accessClass, fieldType, publicOnly, staticOnly, false);
    }

    public static Collection getFields(ClassType accessClass, String fieldType, boolean publicOnly, boolean staticOnly, boolean declaredOnly) {
        return ReflectionUtils.getFields(accessClass, new ClassType(fieldType), publicOnly, staticOnly, declaredOnly);
    }

    public static Collection getFields(ClassType accessClass, ClassType fieldType, boolean publicOnly, boolean staticOnly, boolean declaredOnly) {
        return ReflectionUtils.getFields(ReflectionUtils.getClassFromType(accessClass), fieldType, publicOnly, staticOnly, declaredOnly);
    }

    public static Collection getFields(Class accessClass, String fieldType, boolean publicOnly, boolean staticOnly) {
        return ReflectionUtils.getFields(accessClass, new ClassType(fieldType), publicOnly, staticOnly);
    }

    public static Collection getFields(Class accessClass, ClassType fieldType, boolean publicOnly, boolean staticOnly) {
        return ReflectionUtils.getFields(accessClass, fieldType, publicOnly, staticOnly, false);
    }

    public static Collection getFields(Class accessClass, String fieldType, boolean publicOnly, boolean staticOnly, boolean declaredOnly) {
        return ReflectionUtils.getFields(accessClass, new ClassType(fieldType), publicOnly, staticOnly, declaredOnly);
    }

    public static Collection getFields(Class accessClass, ClassType fieldType, boolean publicOnly, boolean staticOnly, boolean declaredOnly) {
        ArrayList<Field> fieldList = new ArrayList<Field>();
        if (accessClass != null) {
            Field[] fields = null;
            fields = declaredOnly ? accessClass.getDeclaredFields() : accessClass.getFields();
            int i = 0;
            while (i < fields.length) {
                boolean isPublic;
                Field field = fields[i];
                int modifiers = field.getModifiers();
                boolean isStatic = (modifiers & 8) > 0;
                boolean bl = isPublic = (modifiers & 1) > 0;
                if (!(staticOnly && !isStatic || publicOnly && !isPublic || fieldType != null && !ReflectionUtils.isClassSame(field.getType(), fieldType))) {
                    fieldList.add(field);
                }
                ++i;
            }
        }
        return fieldList;
    }

    public static Method getMethod(Class dataAccessClass, String methodName) {
        Method theMethod = null;
        if (dataAccessClass != null && methodName != null) {
            Iterator iterator = ReflectionUtils.getMethods(dataAccessClass).iterator();
            while (iterator.hasNext()) {
                Method next = (Method)iterator.next();
                if (!methodName.equals(ReflectionUtils.getMethodSignature(next))) continue;
                theMethod = next;
                break;
            }
        }
        return theMethod;
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }

    static {
        PRIM_VALUES.add("int");
        PRIM_VALUES.add("boolean");
        PRIM_VALUES.add("float");
        PRIM_VALUES.add("double");
        PRIM_VALUES.add("short");
        PRIM_VALUES.add("long");
        PRIM_VALUES.add("char");
        PRIM_VALUES.add("byte");
        PRIM_OBJECT_VALUES.add((class$java$lang$Integer == null ? (class$java$lang$Integer = ReflectionUtils.class$("java.lang.Integer")) : class$java$lang$Integer).getName());
        PRIM_OBJECT_VALUES.add((class$java$lang$Boolean == null ? (class$java$lang$Boolean = ReflectionUtils.class$("java.lang.Boolean")) : class$java$lang$Boolean).getName());
        PRIM_OBJECT_VALUES.add((class$java$lang$Float == null ? (class$java$lang$Float = ReflectionUtils.class$("java.lang.Float")) : class$java$lang$Float).getName());
        PRIM_OBJECT_VALUES.add((class$java$lang$Double == null ? (class$java$lang$Double = ReflectionUtils.class$("java.lang.Double")) : class$java$lang$Double).getName());
        PRIM_OBJECT_VALUES.add((class$java$lang$Short == null ? (class$java$lang$Short = ReflectionUtils.class$("java.lang.Short")) : class$java$lang$Short).getName());
        PRIM_OBJECT_VALUES.add((class$java$lang$Long == null ? (class$java$lang$Long = ReflectionUtils.class$("java.lang.Long")) : class$java$lang$Long).getName());
        PRIM_OBJECT_VALUES.add((class$java$lang$Character == null ? (class$java$lang$Character = ReflectionUtils.class$("java.lang.Character")) : class$java$lang$Character).getName());
        PRIM_OBJECT_VALUES.add((class$java$lang$Byte == null ? (class$java$lang$Byte = ReflectionUtils.class$("java.lang.Byte")) : class$java$lang$Byte).getName());
    }
}

