/*
 * Decompiled with CFR 0.152.
 */
package com.aligo.tools.util;

import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStreamReader;
import java.io.PipedInputStream;
import java.io.PipedOutputStream;
import java.io.PrintStream;

public class PipedPrintStreamManager {
    private PipedOutputStream output;
    private PipedInputStream input;
    private PrintStream printStream;
    private BufferedReader reader;
    private boolean systemOut;

    public PipedPrintStreamManager() {
        this(true);
    }

    public PipedPrintStreamManager(boolean systemOut) {
        this.systemOut = systemOut;
        this.reset();
    }

    public void reset() {
        try {
            if (this.reader != null) {
                try {
                    this.reader.close();
                }
                catch (IOException e) {
                    e.printStackTrace();
                }
            }
            this.output = new PipedOutputStream();
            this.input = new PipedInputStream(this.output);
            this.printStream = new PrintStream(this.output);
            if (this.systemOut) {
                System.setOut(this.printStream);
            }
            this.reader = new BufferedReader(new InputStreamReader(this.input));
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public PipedInputStream getInput() {
        return this.input;
    }

    public PipedOutputStream getOutput() {
        return this.output;
    }

    public PrintStream getPrintStream() {
        return this.printStream;
    }

    public BufferedReader getReader() {
        return this.reader;
    }

    public boolean isSystemOut() {
        return this.systemOut;
    }
}

