/*
 * Decompiled with CFR 0.152.
 */
package com.aligo.tools.util;

import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;

public class MethodsGetter {
    private static final String TYPE_VOID = "VOID";
    private static final String GET_STRING = "GET";
    private static final String IS_STRING = "IS";
    private static final String SET_STRING = "SET";
    private static final String TO_STRING = "toString";

    public static Collection getGetterMethods(Class className, boolean declaredOnly) {
        return MethodsGetter.getGetterMethods(className, declaredOnly, false);
    }

    public static Collection getGetterMethods(Class className, boolean declaredOnly, boolean ignoreStatics) {
        return MethodsGetter.getGetterMethods(className, declaredOnly, ignoreStatics, true);
    }

    public static Collection getGetterMethods(Class className, boolean declaredOnly, boolean ignoreStatics, boolean mustHaveNoParams) {
        ArrayList<Method> retVal = new ArrayList<Method>();
        Method[] theMethods = declaredOnly ? className.getDeclaredMethods() : className.getMethods();
        int i = 0;
        while (i < theMethods.length) {
            String methodString = theMethods[i].getName();
            String retType = theMethods[i].getReturnType().getName();
            boolean isVoid = retType.equalsIgnoreCase(TYPE_VOID);
            boolean hasParams = theMethods[i].getParameterTypes().length > 0;
            boolean isStatic = Modifier.isStatic(theMethods[i].getModifiers());
            boolean isGet = methodString.substring(0, 3).equalsIgnoreCase(GET_STRING);
            if (!isVoid && isGet && (!ignoreStatics || ignoreStatics && !isStatic) && (!mustHaveNoParams || !hasParams && mustHaveNoParams)) {
                retVal.add(theMethods[i]);
            }
            ++i;
        }
        return retVal;
    }

    public static Collection getArrayClassGetterAndIsMethods(Class givenClass, boolean declaredOnly) {
        return MethodsGetter.getArrayClassGetterAndIsMethods(givenClass, declaredOnly, false);
    }

    public static Collection getArrayClassGetterAndIsMethods(Class givenClass, boolean declaredOnly, boolean ignoreStatics) {
        Collection retVal = new ArrayList();
        if (givenClass != null) {
            if (givenClass.isArray()) {
                Class<?> componentClass = givenClass.getComponentType();
                retVal = MethodsGetter.getGetterAndIsMethods(componentClass, declaredOnly, ignoreStatics);
            } else {
                retVal = MethodsGetter.getGetterAndIsMethods(givenClass, declaredOnly, ignoreStatics);
            }
        }
        return retVal;
    }

    public static Collection getArrayClassNonVoidMethods(Class givenClass, boolean declaredOnly) {
        return MethodsGetter.getArrayClassNonVoidMethods(givenClass, declaredOnly, false);
    }

    public static Collection getArrayClassNonVoidMethods(Class givenClass, boolean declaredOnly, boolean ignoreStatics) {
        Collection retVal = new ArrayList();
        if (givenClass != null) {
            if (givenClass.isArray()) {
                Class<?> componentClass = givenClass.getComponentType();
                retVal = MethodsGetter.getNonVoidMethods(componentClass, declaredOnly, ignoreStatics);
            } else {
                retVal = MethodsGetter.getNonVoidMethods(givenClass, declaredOnly, ignoreStatics);
            }
        }
        return retVal;
    }

    public static Collection getNonVoidMethods(Class className, boolean declaredOnly) {
        return MethodsGetter.getNonVoidMethods(className, declaredOnly, false);
    }

    public static Collection getNonVoidMethods(Class className, boolean declaredOnly, boolean ignoreStatics) {
        ArrayList<Method> retVal = new ArrayList<Method>();
        if (className != null) {
            Method[] theMethods = declaredOnly ? className.getDeclaredMethods() : className.getMethods();
            int i = 0;
            while (i < theMethods.length) {
                String retType = theMethods[i].getReturnType().getName();
                boolean isVoid = retType.equalsIgnoreCase(TYPE_VOID);
                boolean isStatic = Modifier.isStatic(theMethods[i].getModifiers());
                if (!isVoid && (!ignoreStatics || ignoreStatics && !isStatic)) {
                    retVal.add(theMethods[i]);
                }
                ++i;
            }
        }
        return retVal;
    }

    public static Collection getGetterAndIsMethods(Class className, boolean declaredOnly) {
        return MethodsGetter.getGetterAndIsMethods(className, declaredOnly, false);
    }

    public static Collection getGetterAndIsMethods(Class className, boolean declaredOnly, boolean ignoreStatics) {
        return MethodsGetter.getGetterAndIsMethods(className, declaredOnly, ignoreStatics, true);
    }

    public static Collection getGetterAndIsMethods(Class className, boolean declaredOnly, boolean ignoreStatics, boolean mustHaveNoParams) {
        ArrayList<Method> retVal = new ArrayList<Method>();
        if (className != null) {
            Method[] theMethods = declaredOnly ? className.getDeclaredMethods() : className.getMethods();
            int i = 0;
            while (i < theMethods.length) {
                String methodString = theMethods[i].getName();
                String retType = theMethods[i].getReturnType().getName();
                boolean isVoid = retType.equalsIgnoreCase(TYPE_VOID);
                boolean hasParams = theMethods[i].getParameterTypes().length > 0;
                boolean isGet = methodString.substring(0, 3).equalsIgnoreCase(GET_STRING);
                boolean isStatic = Modifier.isStatic(theMethods[i].getModifiers());
                boolean isIs = methodString.substring(0, 2).equalsIgnoreCase(IS_STRING);
                boolean isToString = methodString.equals(TO_STRING);
                if (!isVoid && (isGet || isIs || isToString) && (!ignoreStatics || ignoreStatics && !isStatic) && (!mustHaveNoParams || !hasParams && mustHaveNoParams)) {
                    retVal.add(theMethods[i]);
                }
                ++i;
            }
        }
        return retVal;
    }

    public static Collection getNonVoidMethods(Class className, Class retClass, boolean declaredOnly, boolean ignoreStatics, boolean mustHaveNoParams) {
        ArrayList<Method> retVal = new ArrayList<Method>();
        if (className != null) {
            Method[] theMethods = declaredOnly ? className.getDeclaredMethods() : className.getMethods();
            int i = 0;
            while (i < theMethods.length) {
                String retType = theMethods[i].getReturnType().getName();
                boolean retMatch = theMethods[i].getReturnType().equals(retClass);
                boolean isVoid = retType.equalsIgnoreCase(TYPE_VOID);
                boolean hasParams = theMethods[i].getParameterTypes().length > 0;
                boolean isStatic = Modifier.isStatic(theMethods[i].getModifiers());
                if (!isVoid && retMatch && (!ignoreStatics || ignoreStatics && !isStatic) && (!mustHaveNoParams || !hasParams && mustHaveNoParams)) {
                    retVal.add(theMethods[i]);
                }
                ++i;
            }
        }
        return retVal;
    }

    public static Collection getGetterAndIsMethodNames(Class className, boolean declaredOnly) {
        return MethodsGetter.getGetterAndIsMethodNames(className, declaredOnly, false);
    }

    public static Collection getGetterAndIsMethodNames(Class className, boolean declaredOnly, boolean ignoreStatics) {
        return MethodsGetter.getGetterAndIsMethodNames(className, declaredOnly, ignoreStatics, true);
    }

    public static Collection getGetterAndIsMethodNames(Class className, boolean declaredOnly, boolean ignoreStatics, boolean mustHaveNoParams) {
        ArrayList<String> retVal = new ArrayList<String>();
        Method[] theMethods = declaredOnly ? className.getDeclaredMethods() : className.getMethods();
        int i = 0;
        while (i < theMethods.length) {
            String methodString = theMethods[i].getName();
            String retType = theMethods[i].getReturnType().getName();
            boolean hasParams = theMethods[i].getParameterTypes().length > 0;
            boolean isVoid = retType.equalsIgnoreCase(TYPE_VOID);
            boolean isGet = methodString.substring(0, 3).equalsIgnoreCase(GET_STRING);
            boolean isStatic = Modifier.isStatic(theMethods[i].getModifiers());
            boolean isIs = methodString.substring(0, 2).equalsIgnoreCase(IS_STRING);
            if (!(isVoid || !isGet && !isIs || ignoreStatics && (!ignoreStatics || isStatic) || mustHaveNoParams && (hasParams || !mustHaveNoParams))) {
                retVal.add(methodString);
            }
            ++i;
        }
        return retVal;
    }

    public static Collection getSetterMethods(Class className, boolean declaredOnly) {
        return MethodsGetter.getSetterMethods(className, declaredOnly, false);
    }

    public static Collection getSetterMethods(Class className, boolean declaredOnly, boolean ignoreStatics) {
        ArrayList<Method> retVal = new ArrayList<Method>();
        Method[] theMethods = declaredOnly ? className.getDeclaredMethods() : className.getMethods();
        int i = 0;
        while (i < theMethods.length) {
            String methodString = theMethods[i].getName();
            String retType = theMethods[i].getReturnType().getName();
            boolean isStatic = Modifier.isStatic(theMethods[i].getModifiers());
            boolean isVoid = retType.equalsIgnoreCase(TYPE_VOID);
            boolean isSet = methodString.substring(0, 3).equalsIgnoreCase(SET_STRING);
            if (isVoid && isSet && (!ignoreStatics || ignoreStatics && !isStatic)) {
                retVal.add(theMethods[i]);
            }
            ++i;
        }
        return retVal;
    }

    public static Collection getNonQueryMethods(Class className, boolean declaredOnly, boolean ignoreStatics) {
        ArrayList<Method> retVal = new ArrayList<Method>();
        Method[] theMethods = declaredOnly ? className.getDeclaredMethods() : className.getMethods();
        int i = 0;
        while (i < theMethods.length) {
            String retType = theMethods[i].getReturnType().getName();
            boolean hasParams = theMethods[i].getParameterTypes().length > 0;
            boolean isStatic = Modifier.isStatic(theMethods[i].getModifiers());
            boolean isVoid = retType.equalsIgnoreCase(TYPE_VOID);
            if (isVoid && hasParams && (!ignoreStatics || ignoreStatics && !isStatic)) {
                retVal.add(theMethods[i]);
            }
            ++i;
        }
        return retVal;
    }

    public static void main(String[] args) {
        Collection test = new ArrayList();
        try {
            test = MethodsGetter.getGetterMethods(Class.forName("java.awt.Label"), true);
            Iterator it = test.iterator();
            while (it.hasNext()) {
                System.err.println(((Method)it.next()).getName());
            }
            test = MethodsGetter.getGetterAndIsMethods(Class.forName("java.awt.Label"), true);
            it = test.iterator();
            while (it.hasNext()) {
                System.err.println("2nd" + ((Method)it.next()).getName());
            }
            test = MethodsGetter.getSetterMethods(Class.forName("java.awt.Label"), true);
            it = test.iterator();
            while (it.hasNext()) {
                System.err.println(((Method)it.next()).getName());
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }
}

