/*
 * Decompiled with CFR 0.152.
 */
package com.aligo.tools.util;

import com.aligo.tools.ToolsUtilities;
import com.aligo.tools.xml.DefaultDOMXMLable;
import com.aligo.tools.xml.XMLUtilities;
import java.io.File;
import java.io.Serializable;
import org.w3c.dom.Document;
import org.w3c.dom.Element;

public class JarDetails
extends DefaultDOMXMLable
implements Serializable {
    public static final String JAR_DETAILS_TAG = "JarDetails";
    public static final String FILE_TAG = "File";
    public static final String PROPRIETARY_TAG = "Proprietary";
    public static final String NAME_TAG = "Name";
    public static final String DESCRIPTION_TAG = "Description";
    private File file;
    private boolean proprietary;
    private String name;
    private String description;

    public JarDetails() {
        this.proprietary = true;
    }

    public JarDetails(File file) {
        this(file, true, file != null ? file.getName() : null);
    }

    public JarDetails(File file, boolean proprietary) {
        this(file, proprietary, file != null ? file.getName() : null);
    }

    public JarDetails(File file, boolean proprietary, String name) {
        this.file = file;
        this.proprietary = proprietary;
        this.name = name;
    }

    public JarDetails(Element element) {
        super(element);
    }

    public String getDescription() {
        return this.description;
    }

    public void setDescription(String description) {
        this.description = description;
    }

    public File getFile() {
        return this.file;
    }

    public void setFile(File file) {
        this.file = file;
    }

    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public boolean isProprietary() {
        return this.proprietary;
    }

    public void setProprietary(boolean proprietary) {
        this.proprietary = proprietary;
    }

    public void fromXMLElement(Element element) {
        this.file = null;
        this.name = null;
        this.description = null;
        this.proprietary = true;
        if (element != null) {
            if (!JAR_DETAILS_TAG.equals(element.getTagName())) {
                element = XMLUtilities.getFirstMatch(element, JAR_DETAILS_TAG);
            }
            if (element != null && JAR_DETAILS_TAG.equals(element.getTagName())) {
                String fileString = XMLUtilities.getPCData(element, FILE_TAG);
                if (fileString != null) {
                    this.file = new File(fileString);
                }
                this.proprietary = Boolean.valueOf(XMLUtilities.getPCData(element, PROPRIETARY_TAG));
                this.name = XMLUtilities.getPCData(element, NAME_TAG);
                this.description = XMLUtilities.getPCData(element, DESCRIPTION_TAG);
            }
        }
    }

    public Element toXMLElement(Document document) {
        Element element = document.createElement(JAR_DETAILS_TAG);
        if (this.file != null) {
            XMLUtilities.createPCData(document, element, FILE_TAG, this.file.toString());
        }
        if (this.proprietary) {
            XMLUtilities.createPCData(document, element, PROPRIETARY_TAG, String.valueOf(this.proprietary));
        }
        if (this.name != null) {
            XMLUtilities.createPCData(document, element, NAME_TAG, this.name);
        }
        if (this.description != null) {
            XMLUtilities.createPCData(document, element, DESCRIPTION_TAG, this.description);
        }
        return element;
    }

    public boolean equals(Object item) {
        JarDetails jar;
        boolean equals = false;
        if (item instanceof JarDetails && ToolsUtilities.objectEquals((jar = (JarDetails)item).getFile() != null ? jar.getFile().toString() : null, this.getFile() != null ? this.getFile().toString() : null)) {
            equals = true;
        }
        return equals;
    }
}

