/*
 * Decompiled with CFR 0.152.
 */
package com.aligo.tools.util;

import com.aligo.tools.ToolsUtilities;
import com.aligo.tools.interfaces.ClassPathItem;
import com.aligo.tools.interfaces.Named;
import com.aligo.tools.util.DependencyResourceType;
import com.aligo.tools.xml.DefaultDOMXMLable;
import com.aligo.tools.xml.XMLUtilities;
import java.io.File;
import java.io.Serializable;
import org.w3c.dom.Document;
import org.w3c.dom.Element;

public abstract class DependencyResource
extends DefaultDOMXMLable
implements Named,
ClassPathItem,
Serializable {
    public static final String FILE_TAG = "File";
    public static final String PROPRIETARY_TAG = "Proprietary";
    public static final String NAME_TAG = "Name";
    public static final String DESCRIPTION_TAG = "Description";
    public static final String DOWNLOAD_URL_TAG = "DownloadURL";
    public static final String ID_TAG = "ID";
    private File file;
    private boolean proprietary;
    private String name;
    private String description;
    private String downloadURL;
    private int id;

    public DependencyResource() {
        this(null, true, null);
    }

    public DependencyResource(File file) {
        this(file, true, file != null ? file.getName() : null);
    }

    public DependencyResource(File file, boolean proprietary) {
        this(file, proprietary, file != null ? file.getName() : null);
    }

    public DependencyResource(File file, boolean proprietary, String name) {
        this.file = file;
        this.proprietary = proprietary;
        this.name = name;
        this.id = -1;
    }

    public DependencyResource(Element element) {
        super(element);
    }

    public String getDescription() {
        return this.description;
    }

    public void setDescription(String description) {
        this.description = description;
    }

    public abstract DependencyResourceType getType();

    public String getDownloadURL() {
        return this.downloadURL;
    }

    public void setDownloadURL(String downloadURL) {
        this.downloadURL = downloadURL;
    }

    public File getFile() {
        return this.file;
    }

    public void setFile(File file) {
        this.file = file;
    }

    public int getId() {
        return this.id;
    }

    public void setId(int id) {
        this.id = id;
    }

    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public File getPathEntry() {
        return this.getFile();
    }

    public boolean isProprietary() {
        return this.proprietary;
    }

    public void setProprietary(boolean proprietary) {
        this.proprietary = proprietary;
    }

    public void fromXMLElement(Element element) {
        this.description = null;
        this.downloadURL = null;
        this.file = null;
        this.name = null;
        this.proprietary = true;
        this.id = -1;
        if (element != null) {
            if (!this.getType().getTagName().equals(element.getTagName())) {
                element = XMLUtilities.getFirstMatch(element, this.getType().getTagName());
            }
            if (element != null && this.getType().getTagName().equals(element.getTagName())) {
                this.description = XMLUtilities.getPCData(element, DESCRIPTION_TAG);
                this.downloadURL = XMLUtilities.getPCData(element, DOWNLOAD_URL_TAG);
                this.id = XMLUtilities.getIntPCData(element, ID_TAG, this.id);
                String fileString = XMLUtilities.getPCData(element, FILE_TAG);
                if (fileString != null) {
                    this.file = new File(fileString);
                }
                this.name = XMLUtilities.getPCData(element, NAME_TAG);
                this.proprietary = Boolean.valueOf(XMLUtilities.getPCData(element, PROPRIETARY_TAG));
            }
        }
    }

    public Element toXMLElement(Document document) {
        Element element = document.createElement(this.getType().getTagName());
        if (this.description != null) {
            XMLUtilities.createPCData(document, element, DESCRIPTION_TAG, this.description);
        }
        if (this.downloadURL != null) {
            XMLUtilities.createPCData(document, element, DOWNLOAD_URL_TAG, this.downloadURL);
        }
        if (this.file != null) {
            XMLUtilities.createPCData(document, element, FILE_TAG, this.file.toString());
        }
        if (this.name != null) {
            XMLUtilities.createPCData(document, element, NAME_TAG, this.name);
        }
        if (this.proprietary) {
            XMLUtilities.createPCData(document, element, PROPRIETARY_TAG, String.valueOf(this.proprietary));
        }
        if (this.id > -1) {
            XMLUtilities.createPCData(document, element, ID_TAG, String.valueOf(this.id));
        }
        return element;
    }

    public boolean equals(Object item) {
        DependencyResource dependency;
        boolean equals = false;
        if (item instanceof DependencyResource && ToolsUtilities.objectEquals((dependency = (DependencyResource)item).getFile() != null ? dependency.getFile().toString() : null, this.getFile() != null ? this.getFile().toString() : null)) {
            equals = true;
        }
        return equals;
    }
}

