/*
 * Decompiled with CFR 0.152.
 */
package com.aligo.tools.util;

import com.aligo.tools.interfaces.ClassPathItem;
import com.aligo.tools.xml.DefaultDOMXMLable;
import com.aligo.tools.xml.XMLUtilities;
import java.io.File;
import org.w3c.dom.Document;
import org.w3c.dom.Element;

public class DefaultClassPathItem
extends DefaultDOMXMLable
implements ClassPathItem,
Comparable {
    public static final String DEFAULT_CLASS_PATH_ITEM_TAG = "DefaultClassPathItem";
    public static final String FILE_TAG = "File";
    public static final String PATH_ENTRY_TAG = "PathEntry";
    private File file;
    private File pathEntry;

    public DefaultClassPathItem() {
    }

    public DefaultClassPathItem(File file) {
        this(file, file);
    }

    public DefaultClassPathItem(File file, File pathEntry) {
        this.file = file;
        this.pathEntry = pathEntry;
    }

    public DefaultClassPathItem(Element element) {
        super(element);
    }

    public File getFile() {
        return this.file;
    }

    public void setFile(File file) {
        this.file = file;
    }

    public File getPathEntry() {
        return this.pathEntry;
    }

    public int compareTo(Object obj) {
        int comp = -1;
        if (obj != null && obj instanceof DefaultClassPathItem) {
            comp = ((DefaultClassPathItem)obj).file.compareTo(this.file);
        }
        return comp;
    }

    public boolean equals(Object obj) {
        return this.compareTo(obj) == 0;
    }

    public void setPathEntry(File pathEntry) {
        this.pathEntry = pathEntry;
    }

    public void fromXMLElement(Element element) {
        this.file = null;
        this.pathEntry = null;
        if (element != null) {
            if (!DEFAULT_CLASS_PATH_ITEM_TAG.equals(element.getTagName())) {
                element = XMLUtilities.getFirstMatch(element, DEFAULT_CLASS_PATH_ITEM_TAG);
            }
            if (element != null && DEFAULT_CLASS_PATH_ITEM_TAG.equals(element.getTagName())) {
                String pathEntryValue;
                String fileValue = XMLUtilities.getPCData(element, FILE_TAG);
                if (fileValue != null) {
                    this.file = new File(fileValue);
                }
                if ((pathEntryValue = XMLUtilities.getPCData(element, PATH_ENTRY_TAG)) != null) {
                    this.pathEntry = new File(pathEntryValue);
                }
            }
        }
    }

    public Element toXMLElement(Document document) {
        Element element = document.createElement(DEFAULT_CLASS_PATH_ITEM_TAG);
        if (this.file != null) {
            XMLUtilities.createPCData(document, element, FILE_TAG, this.file.toString());
        }
        if (this.pathEntry != null) {
            XMLUtilities.createPCData(document, element, PATH_ENTRY_TAG, this.pathEntry.toString());
        }
        return element;
    }
}

