/*
 * Decompiled with CFR 0.152.
 */
package com.aligo.tools.util;

import com.aligo.tools.xml.DefaultDOMXMLable;
import com.aligo.tools.xml.XMLUtilities;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;

public class DOMXMLableJavaProperties
extends DefaultDOMXMLable {
    public static final String DOMABLE_JAVA_PROPERTIES_TAG = "Properties";
    public static final String PROPERTY_TAG = "Property";
    public static final String KEY_TAG = "Key";
    public static final String VALUE_TAG = "Value";
    private Map properties;
    private String baseTag;

    public static Map getProperties(Element firstMatch) {
        return DOMXMLableJavaProperties.getProperties(firstMatch, DOMABLE_JAVA_PROPERTIES_TAG);
    }

    public static Map getProperties(Element firstMatch, String baseTag) {
        Map props = null;
        if (firstMatch != null) {
            DOMXMLableJavaProperties domProps = new DOMXMLableJavaProperties(firstMatch, baseTag);
            props = domProps.getProperties();
        }
        return props;
    }

    public static Node getPropertiesElement(Map properties, Document document) {
        return DOMXMLableJavaProperties.getPropertiesElement(properties, document, DOMABLE_JAVA_PROPERTIES_TAG);
    }

    public static Node getPropertiesElement(Map properties, Document document, String baseTag) {
        DOMXMLableJavaProperties domProps = new DOMXMLableJavaProperties(properties, baseTag);
        return domProps.toXMLElement(document);
    }

    public DOMXMLableJavaProperties() {
        this(DOMABLE_JAVA_PROPERTIES_TAG);
    }

    public DOMXMLableJavaProperties(String baseTag) {
        this((Map)null, baseTag);
    }

    public DOMXMLableJavaProperties(Map properties) {
        this(properties, DOMABLE_JAVA_PROPERTIES_TAG);
    }

    public DOMXMLableJavaProperties(Map properties, String baseTag) {
        this.properties = properties;
        this.baseTag = baseTag;
    }

    public DOMXMLableJavaProperties(Element element) {
        this(element, DOMABLE_JAVA_PROPERTIES_TAG);
    }

    public DOMXMLableJavaProperties(Element element, String baseTag) {
        this((Map)null, baseTag);
        this.fromXMLElement(element);
    }

    public String getBaseTag() {
        return this.baseTag;
    }

    public Map getProperties() {
        return this.properties;
    }

    public void setProperties(Map properties) {
        this.properties = properties;
    }

    public void fromXMLElement(Element element) {
        this.properties = null;
        if (element != null) {
            if (!this.getBaseTag().equals(element.getTagName())) {
                element = XMLUtilities.getFirstMatch(element, this.getBaseTag());
            }
            if (element != null && this.getBaseTag().equals(element.getTagName())) {
                this.properties = new Properties();
                List propertiesList = null;
                propertiesList = XMLUtilities.getMatchingChildren(element, PROPERTY_TAG);
                if (propertiesList != null) {
                    Iterator it = propertiesList.iterator();
                    while (it.hasNext()) {
                        Element next = (Element)it.next();
                        if (next == null) continue;
                        String key = XMLUtilities.getPCData(next, KEY_TAG);
                        String value = XMLUtilities.getPCData(next, VALUE_TAG);
                        if (key == null || value == null) continue;
                        this.properties.put(key, value);
                    }
                }
            }
        }
    }

    public Element toXMLElement(Document document) {
        Element element = document.createElement(this.getBaseTag());
        if (this.properties != null && this.properties.size() > 0) {
            Iterator keys = this.properties.keySet().iterator();
            while (keys.hasNext()) {
                Object key = keys.next();
                Object value = this.properties.get(key);
                Element propertyElement = document.createElement(PROPERTY_TAG);
                element.appendChild(propertyElement);
                XMLUtilities.createPCData(document, propertyElement, KEY_TAG, key != null ? key.toString() : null);
                XMLUtilities.createPCData(document, propertyElement, VALUE_TAG, value != null ? value.toString() : null);
            }
        }
        return element;
    }
}

