/*
 * Decompiled with CFR 0.152.
 */
package com.aligo.tools.util;

import com.aligo.tools.ToolsUtilities;
import com.aligo.tools.util.ClassName;
import com.aligo.tools.xml.DefaultDOMXMLable;
import com.aligo.tools.xml.XMLUtilities;
import java.io.Serializable;
import org.w3c.dom.Document;
import org.w3c.dom.Element;

public class ClassType
extends DefaultDOMXMLable
implements Cloneable,
Comparable,
Serializable {
    public static final String CLASS_TYPE_TAG = "ClassType";
    public static final String CLASS_TAG = "Class";
    public static final String ARRAY_TAG = "Array";
    private String type;
    private boolean array;

    public ClassType() {
    }

    public ClassType(Class theClass) {
        this(theClass.isArray() ? theClass.getComponentType().getName() : theClass.getName(), theClass.isArray());
    }

    public ClassType(String type) {
        this(type, false);
    }

    public ClassType(String type, boolean array) {
        this.type = type;
        this.array = array;
    }

    public ClassType(Element element) {
        super(element);
    }

    public String getType() {
        return this.type;
    }

    public void setType(String type) {
        this.type = type;
    }

    public boolean isArray() {
        return this.array;
    }

    public void setArray(boolean array) {
        this.array = array;
    }

    public boolean isVoid() {
        return this.type == null || "void".equals(this.type);
    }

    public void fromXMLElement(Element element) {
        if (element != null) {
            if (!CLASS_TYPE_TAG.equals(element.getTagName())) {
                element = XMLUtilities.getFirstMatch(element, CLASS_TYPE_TAG);
            }
            if (element != null && CLASS_TYPE_TAG.equals(element.getTagName())) {
                this.type = XMLUtilities.getPCData(element, CLASS_TAG);
                this.array = XMLUtilities.getBooleanPCData(element, ARRAY_TAG);
            }
        }
    }

    public Element toXMLElement(Document document) {
        Element element = document.createElement(CLASS_TYPE_TAG);
        if (this.type != null) {
            XMLUtilities.createPCData(document, element, CLASS_TAG, this.type);
        }
        if (this.array) {
            XMLUtilities.createPCData(document, element, ARRAY_TAG, this.array);
        }
        return element;
    }

    public boolean equals(Object object) {
        boolean equals = false;
        if (object != null && object instanceof ClassType) {
            ClassType otherType = (ClassType)object;
            if (ToolsUtilities.stringEquals(otherType.type, this.type) && otherType.array == this.array) {
                equals = true;
            }
        }
        return equals;
    }

    public int compareTo(Object object) {
        int comp = -1;
        if (object != null && object instanceof ClassType) {
            ClassType otherType = (ClassType)object;
            if (this.equals(otherType)) {
                comp = 0;
            } else if (otherType.type != null && this.type != null && (comp = this.type.compareTo(otherType.type)) == 0 && otherType.array != this.array) {
                comp = otherType.array ? 1 : -1;
            }
        }
        return comp;
    }

    public Object clone() {
        ClassType clone = null;
        try {
            clone = (ClassType)super.clone();
            clone.type = this.type;
            clone.array = this.array;
        }
        catch (CloneNotSupportedException e) {
            e.printStackTrace();
        }
        return clone;
    }

    public String toString() {
        return this.getTypeString();
    }

    public String getTypeString() {
        String value;
        String string = value = this.type != null ? this.type : "";
        if (this.array) {
            value = value + "[]";
        }
        return value;
    }

    public String getTrimmedTypeString() {
        String value = null;
        if (this.type != null) {
            ClassName name = new ClassName(this.type);
            value = name.getClassName();
        } else {
            value = "";
        }
        if (this.array) {
            value = value + "[]";
        }
        return value;
    }
}

