/*
 * Decompiled with CFR 0.152.
 */
package com.aligo.tools.util;

import com.aligo.tools.ToolsUtilities;
import com.aligo.tools.util.XMLProperty;
import com.aligo.tools.util.XMLPropertyType;
import com.aligo.tools.xml.XMLUtilities;
import org.w3c.dom.Document;
import org.w3c.dom.Element;

public class BooleanXMLProperty
extends XMLProperty {
    public static final String BOOLEAN_PROPERTY_TAG = "BooleanXMLProperty";
    public static final String VALUE_ATTR = "value";
    public static final String VALUE_TAG = "Value";
    private Boolean value;

    public BooleanXMLProperty(Element element) {
        super(element);
    }

    public BooleanXMLProperty(String name, Boolean value) {
        super(name);
        this.value = value;
    }

    public BooleanXMLProperty(String name, boolean value) {
        this(name, new Boolean(value));
    }

    public Object getPropertyValue() {
        return this.value;
    }

    public XMLPropertyType getPropertyType() {
        return XMLPropertyType.BOOLEAN;
    }

    public void fromXMLElement(Element element) {
        super.fromXMLElement(element);
        if (element != null) {
            if (!BOOLEAN_PROPERTY_TAG.equals(element.getTagName())) {
                element = XMLUtilities.getFirstMatch(element, BOOLEAN_PROPERTY_TAG);
            }
            if (element != null && BOOLEAN_PROPERTY_TAG.equals(element.getTagName())) {
                String valueString = element.getAttribute(VALUE_ATTR);
                if (ToolsUtilities.isNullOrEmpty(valueString)) {
                    valueString = XMLUtilities.getPCData(element, VALUE_TAG);
                }
                this.value = new Boolean(valueString);
            }
        }
    }

    public Element toXMLElement(Document document) {
        Element element = super.toXMLElement(document);
        if (this.value != null) {
            XMLUtilities.createPCData(document, element, VALUE_TAG, this.value.toString());
        }
        return element;
    }
}

