/*
 * Decompiled with CFR 0.152.
 */
package com.aligo.tools.resource;

import com.aligo.tools.ToolsUtilities;
import com.aligo.tools.resource.ResourceManager;
import com.aligo.tools.resource.ResourceManagerKey;
import java.awt.Color;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.Point;
import java.text.MessageFormat;
import java.util.List;
import javax.swing.ImageIcon;

public class ResourceUtils {
    private ResourceUtils() {
    }

    public static String getString(String resourceName) {
        return ResourceUtils.getString(ResourceManagerKey.GENERAL, resourceName);
    }

    public static String getString(ResourceManagerKey key, String resourceName) {
        return ResourceManager.getInstance().getString(key, resourceName);
    }

    public static Color getColor(String resourceName) {
        return ResourceUtils.getColor(ResourceManagerKey.GENERAL, resourceName);
    }

    public static Color getColor(ResourceManagerKey key, String resourceName) {
        return ResourceManager.getInstance().getColor(key, resourceName);
    }

    public static Font getFont(String resourceName) {
        return ResourceUtils.getFont(ResourceManagerKey.GENERAL, resourceName);
    }

    public static Font getFont(ResourceManagerKey key, String resourceName) {
        return ResourceManager.getInstance().getFont(key, resourceName);
    }

    public static int getInt(String resourceName) {
        return ResourceUtils.getInt(ResourceManagerKey.GENERAL, resourceName);
    }

    public static int getInt(ResourceManagerKey key, String resourceName) {
        return ResourceManager.getInstance().getInt(key, resourceName);
    }

    public static MessageFormat getMessageFormat(String resourceName) {
        return ResourceUtils.getMessageFormat(ResourceManagerKey.GENERAL, resourceName);
    }

    public static MessageFormat getMessageFormat(ResourceManagerKey key, String resourceName) {
        return ResourceManager.getInstance().getMessageFormat(key, resourceName);
    }

    public static ImageIcon getImage(String resourceName) {
        return ResourceUtils.getImage(ResourceManagerKey.GENERAL, resourceName);
    }

    public static ImageIcon getImage(ResourceManagerKey key, String resourceName) {
        return ResourceUtils.getImageIcon(key, resourceName);
    }

    public static ImageIcon getImageIcon(ResourceManagerKey managerKey, String imageKey) {
        ImageIcon icon = null;
        try {
            String imagePath = ResourceManager.getInstance().getString(managerKey, imageKey);
            icon = ResourceUtils.getImageIcon(imagePath);
            String imageDescription = ResourceManager.getInstance().getString(managerKey, imageKey + ".Description", true);
            icon.setDescription(imageDescription);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return icon;
    }

    public static ImageIcon getImageIcon(String location) {
        ImageIcon icon = null;
        try {
            icon = new ImageIcon(ClassLoader.getSystemResource(location));
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return icon;
    }

    public static Dimension getDimension(String resourceName) {
        return ResourceUtils.getDimension(ResourceManagerKey.GENERAL, resourceName);
    }

    public static Dimension getDimension(ResourceManagerKey key, String resourceName) {
        return ResourceManager.getInstance().getDimension(key, resourceName);
    }

    public static Point getPoint(String resourceName) {
        return ResourceUtils.getPoint(ResourceManagerKey.GENERAL, resourceName);
    }

    public static Point getPoint(ResourceManagerKey key, String resourceName) {
        return ResourceManager.getInstance().getPoint(key, resourceName);
    }

    public static String[] getStrings(String resourceName) {
        return ResourceUtils.getStrings(ResourceManagerKey.GENERAL, resourceName);
    }

    public static String[] getStrings(ResourceManagerKey key, String resourceName) {
        String list = ResourceManager.getInstance().getString(key, resourceName);
        return ToolsUtilities.createStringArray(list);
    }

    public static List getStringList(String resourceName) {
        return ResourceUtils.getStringList(ResourceManagerKey.GENERAL, resourceName);
    }

    public static List getStringList(ResourceManagerKey key, String resourceName) {
        String list = ResourceManager.getInstance().getString(key, resourceName);
        return ToolsUtilities.createStringList(list);
    }

    public static List getStringListFromServerSide(String resourceName) {
        return ResourceUtils.getStringList(ResourceManagerKey.SERVER_SIDE, resourceName);
    }
}

