/*
 * Decompiled with CFR 0.152.
 */
package com.aligo.tools.resource;

import com.aligo.tools.factory.ResourceLoaderFactory;
import com.aligo.tools.resource.ResourceManagerKey;
import java.awt.Color;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.Point;
import java.text.MessageFormat;
import java.util.ResourceBundle;
import java.util.StringTokenizer;
import java.util.TreeMap;

public class ResourceManager {
    public static final String PLAIN = "plain)";
    public static final String BOLD = "bold";
    public static final String ITALICS = "italics";
    public static final String BOLD_ITALICS = "bolditalics";
    private static ResourceManager instance;
    private TreeMap bundles = new TreeMap();

    public static ResourceManager getInstance() {
        if (instance == null) {
            instance = new ResourceManager();
        }
        return instance;
    }

    private ResourceManager() {
    }

    public ResourceBundle getBundle(ResourceManagerKey key) {
        ResourceBundle bundle = (ResourceBundle)this.bundles.get(key);
        try {
            if (bundle == null) {
                bundle = ResourceLoaderFactory.getInstance().createResourceLoader().getBundle(key.getResourceLocation());
                if (bundle == null) {
                    throw new IllegalStateException("Could not fild the bundle for the key : " + key.getName() + " : " + key.getResourceLocation());
                }
                this.bundles.put(key, bundle);
            }
        }
        catch (Exception e) {
            System.out.println("Error in getting the Bundle : " + e.getMessage());
            e.printStackTrace();
        }
        return bundle;
    }

    public String getString(ResourceManagerKey managerKey, String key) {
        String value = null;
        try {
            value = this.getBundle(managerKey).getString(key);
        }
        catch (Exception e) {
            System.out.println("Could not file resource : KEY NAME : " + managerKey.getName() + " : KEY LOCATION : " + managerKey.getResourceLocation() + " : KEY VALUE : " + key + " : " + e.getMessage());
            e.printStackTrace();
        }
        return value;
    }

    public String getString(ResourceManagerKey managerKey, String key, boolean returnAtLeastEmpty) {
        String value = null;
        try {
            ResourceBundle bundle = (ResourceBundle)this.bundles.get(managerKey);
            if (bundle == null) {
                bundle = ResourceLoaderFactory.getInstance().createResourceLoader().getBundle(managerKey.getResourceLocation());
                if (bundle == null) {
                    System.out.println("Error in getting the Bundle : it does not exist.. KEY NAME : " + managerKey.getName() + " : KEY LOCATION : " + managerKey.getResourceLocation() + " : KEY VALUE : " + key);
                    throw new IllegalStateException("Could not fild the bundle for the key : " + managerKey.getName() + " : " + managerKey.getResourceLocation());
                }
                this.bundles.put(managerKey, bundle);
            }
            value = bundle.getString(key);
        }
        catch (Exception e) {
            // empty catch block
        }
        if (returnAtLeastEmpty && value == null) {
            value = "";
        }
        return value;
    }

    public String getString(String key) {
        return this.getString(ResourceManagerKey.GENERAL, key);
    }

    public Point getPoint(String key) {
        return this.getPoint(ResourceManagerKey.GENERAL, key);
    }

    public Point getPoint(ResourceManagerKey resourceKey, String key) {
        Point point = null;
        String value = this.getString(resourceKey, key);
        try {
            int x = 0;
            int y = 0;
            try {
                StringTokenizer tokenizer = new StringTokenizer(value, ",");
                x = Integer.parseInt(tokenizer.nextToken().trim());
                y = Integer.parseInt(tokenizer.nextToken().trim());
            }
            catch (Exception e) {
                e.printStackTrace();
            }
            point = new Point(x, y);
        }
        catch (Exception e) {
            System.out.println("Could not file resource : KEY NAME : " + resourceKey.getName() + " : KEY LOCATION : " + resourceKey.getResourceLocation() + " : KEY VALUE : " + key + " : " + e.getMessage());
            e.printStackTrace();
        }
        return point;
    }

    public Dimension getDimension(String key) {
        return this.getDimension(ResourceManagerKey.GENERAL, key);
    }

    public Dimension getDimension(ResourceManagerKey resourceKey, String key) {
        Dimension dim = null;
        String value = this.getString(resourceKey, key);
        try {
            int x = 0;
            int y = 0;
            try {
                StringTokenizer tokenizer = new StringTokenizer(value, ",");
                x = Integer.parseInt(tokenizer.nextToken().trim());
                y = Integer.parseInt(tokenizer.nextToken().trim());
            }
            catch (Exception e) {
                e.printStackTrace();
            }
            dim = new Dimension(x, y);
        }
        catch (Exception e) {
            System.out.println("Could not file resource : KEY NAME : " + resourceKey.getName() + " : KEY LOCATION : " + resourceKey.getResourceLocation() + " : KEY VALUE : " + key + " : " + e.getMessage());
            e.printStackTrace();
        }
        return dim;
    }

    public Color getColor(String key) {
        return this.getColor(ResourceManagerKey.GENERAL, key);
    }

    public Color getColor(ResourceManagerKey resourceKey, String key) {
        Color color = null;
        String value = this.getString(resourceKey, key);
        try {
            int r = 0;
            int b = 0;
            int g = 0;
            try {
                StringTokenizer tokenizer = new StringTokenizer(value, ",");
                r = Integer.parseInt(tokenizer.nextToken().trim());
                g = Integer.parseInt(tokenizer.nextToken().trim());
                b = Integer.parseInt(tokenizer.nextToken().trim());
            }
            catch (Exception e) {
                e.printStackTrace();
            }
            color = new Color(r, g, b);
        }
        catch (Exception e) {
            System.out.println("Could not file resource : KEY NAME : " + resourceKey.getName() + " : KEY LOCATION : " + resourceKey.getResourceLocation() + " : KEY VALUE : " + key + " : " + e.getMessage());
            e.printStackTrace();
        }
        return color;
    }

    public Font getFont(String key) {
        return this.getFont(ResourceManagerKey.GENERAL, key);
    }

    public Font getFont(ResourceManagerKey resourceKey, String key) {
        Font font = null;
        String value = this.getString(resourceKey, key);
        try {
            String name = null;
            String styleString = null;
            int style = 0;
            int size = 0;
            try {
                StringTokenizer tokenizer = new StringTokenizer(value, ",");
                name = tokenizer.nextToken().trim();
                styleString = tokenizer.nextToken().trim().toLowerCase();
                size = Integer.parseInt(tokenizer.nextToken().trim());
                if (PLAIN.equals(styleString)) {
                    style = 0;
                } else if (BOLD.equals(styleString)) {
                    style = 1;
                } else if (ITALICS.equals(styleString)) {
                    style = 2;
                } else if (BOLD_ITALICS.equals(styleString)) {
                    style = 3;
                }
            }
            catch (Exception e) {
                e.printStackTrace();
            }
            font = new Font(name, style, size);
        }
        catch (Exception e) {
            System.out.println("Could not file resource : KEY NAME : " + resourceKey.getName() + " : KEY LOCATION : " + resourceKey.getResourceLocation() + " : KEY VALUE : " + key + " : " + e.getMessage());
            e.printStackTrace();
        }
        return font;
    }

    public Integer getInteger(String key) {
        return this.getInteger(ResourceManagerKey.GENERAL, key);
    }

    public Integer getInteger(ResourceManagerKey resourceKey, String key) {
        Integer intValue = null;
        String value = this.getString(resourceKey, key);
        try {
            intValue = new Integer(value);
        }
        catch (Exception e) {
            System.out.println("Could not file resource : KEY NAME : " + resourceKey.getName() + " : KEY LOCATION : " + resourceKey.getResourceLocation() + " : KEY VALUE : " + key + " : " + e.getMessage());
            e.printStackTrace();
        }
        return intValue;
    }

    public double getDouble(String key) {
        return this.getDouble(ResourceManagerKey.GENERAL, key);
    }

    public double getDouble(ResourceManagerKey resourceKey, String key) {
        double doubleValue = 0.0;
        String value = this.getString(resourceKey, key);
        try {
            doubleValue = Double.parseDouble(value);
        }
        catch (Exception e) {
            System.out.println("Could not file resource : KEY NAME : " + resourceKey.getName() + " : KEY LOCATION : " + resourceKey.getResourceLocation() + " : KEY VALUE : " + key + " : " + e.getMessage());
            e.printStackTrace();
        }
        return doubleValue;
    }

    public Long getLong(String key) {
        return this.getLong(ResourceManagerKey.GENERAL, key);
    }

    public Long getLong(ResourceManagerKey resourceKey, String key) {
        Long longValue = null;
        String value = this.getString(resourceKey, key);
        try {
            longValue = new Long(value);
        }
        catch (Exception e) {
            System.out.println("Could not file resource : KEY NAME : " + resourceKey.getName() + " : KEY LOCATION : " + resourceKey.getResourceLocation() + " : KEY VALUE : " + key + " : " + e.getMessage());
            e.printStackTrace();
        }
        return longValue;
    }

    public Class getAsClass(String key) {
        return this.getAsClass(ResourceManagerKey.GENERAL, key);
    }

    public Class getAsClass(ResourceManagerKey resourceKey, String key) {
        Class<?> classValue = null;
        String value = this.getString(resourceKey, key);
        try {
            classValue = Class.forName(value);
        }
        catch (Exception e) {
            System.out.println("Could not file resource : KEY NAME : " + resourceKey.getName() + " : KEY LOCATION : " + resourceKey.getResourceLocation() + " : KEY VALUE : " + key + " : " + e.getMessage());
            e.printStackTrace();
        }
        return classValue;
    }

    public int getInt(String key) {
        return this.getInt(ResourceManagerKey.GENERAL, key);
    }

    public int getInt(ResourceManagerKey resourceKey, String key) {
        int intValue = 0;
        String value = this.getString(resourceKey, key);
        try {
            intValue = Integer.parseInt(value);
        }
        catch (Exception e) {
            System.out.println("Could not file resource : KEY NAME : " + resourceKey.getName() + " : KEY LOCATION : " + resourceKey.getResourceLocation() + " : KEY VALUE : " + key + " : " + e.getMessage());
            e.printStackTrace();
        }
        return intValue;
    }

    public float getFloat(String key) {
        return this.getFloat(ResourceManagerKey.GENERAL, key);
    }

    public float getFloat(ResourceManagerKey resourceKey, String key) {
        float floatValue = 0.0f;
        String value = this.getString(resourceKey, key);
        try {
            floatValue = Float.parseFloat(value);
        }
        catch (Exception e) {
            System.out.println("Could not file resource : KEY NAME : " + resourceKey.getName() + " : KEY LOCATION : " + resourceKey.getResourceLocation() + " : KEY VALUE : " + key + " : " + e.getMessage());
            e.printStackTrace();
        }
        return floatValue;
    }

    public boolean getBoolean(String key) {
        return this.getBoolean(ResourceManagerKey.GENERAL, key);
    }

    public boolean getBoolean(ResourceManagerKey resourceKey, String key) {
        return this.getBoolean(resourceKey, key, false);
    }

    public boolean getBoolean(ResourceManagerKey resourceKey, String key, boolean ignoreExceptions) {
        boolean booleanValue;
        block2: {
            booleanValue = false;
            try {
                String value = this.getString(resourceKey, key, ignoreExceptions);
                booleanValue = Boolean.valueOf(value);
            }
            catch (Exception e) {
                if (ignoreExceptions) break block2;
                System.out.println("Could not file resource : KEY NAME : " + resourceKey.getName() + " : KEY LOCATION : " + resourceKey.getResourceLocation() + " : KEY VALUE : " + key + " : " + e.getMessage());
                e.printStackTrace();
            }
        }
        return booleanValue;
    }

    public Character getCharacter(String key) {
        return this.getCharacter(ResourceManagerKey.GENERAL, key);
    }

    public Character getCharacter(ResourceManagerKey resourceKey, String key) {
        Character charValue = null;
        String value = this.getString(resourceKey, key);
        try {
            charValue = new Character(value.charAt(0));
        }
        catch (Exception e) {
            System.out.println("Could not file resource : KEY NAME : " + resourceKey.getName() + " : KEY LOCATION : " + resourceKey.getResourceLocation() + " : KEY VALUE : " + key + " : " + e.getMessage());
            e.printStackTrace();
        }
        return charValue;
    }

    public Integer getCharAsInt(String key) {
        return this.getCharAsInt(ResourceManagerKey.GENERAL, key);
    }

    public Integer getCharAsInt(ResourceManagerKey resourceKey, String key) {
        Integer intValue = null;
        try {
            int temp = Character.getNumericValue(this.getString(resourceKey, key).charAt(0));
            intValue = new Integer(temp);
        }
        catch (Exception e) {
            System.out.println("Could not file resource : KEY NAME : " + resourceKey.getName() + " : KEY LOCATION : " + resourceKey.getResourceLocation() + " : KEY VALUE : " + key + " : " + e.getMessage());
            e.printStackTrace();
        }
        return intValue;
    }

    public MessageFormat getMessageFormat(String resourceName) {
        return this.getMessageFormat(ResourceManagerKey.GENERAL, resourceName);
    }

    public MessageFormat getMessageFormat(ResourceManagerKey resourceKey, String resourceName) {
        return new MessageFormat(this.getString(resourceKey, resourceName));
    }
}

