/*
 * Decompiled with CFR 0.152.
 */
package com.aligo.tools.query;

import com.aligo.tools.interfaces.Named;
import com.aligo.tools.query.UAQueryObject;
import com.aligo.tools.xml.DefaultDOMXMLable;
import com.aligo.tools.xml.XMLUtilities;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import org.w3c.dom.Document;
import org.w3c.dom.Element;

public class UAQuery
extends DefaultDOMXMLable
implements Named {
    public static final String UAQUERY_TAG = "UAQuery";
    public static final String PRIORITY_TAG = "priority";
    public static final String QUERY_NAME_TAG = "queryName";
    public static final String UAQUERY_OBJECTS_TAG = "queryObjects";
    private String name;
    private int priority;
    private List uaQueryObjects;

    public UAQuery() {
        this.initialize();
    }

    public UAQuery(Element element) {
        super(element);
    }

    protected void initialize() {
        this.uaQueryObjects = new ArrayList();
    }

    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public int getPriority() {
        return this.priority;
    }

    public void setPriority(int priority) {
        this.priority = priority;
    }

    public List getUAQueryObjects() {
        return new ArrayList(this.uaQueryObjects);
    }

    public void addUAQueryObject(UAQueryObject queryObject) {
        this.uaQueryObjects.add(queryObject);
    }

    public void removeDPOImage(UAQueryObject queryObject) {
        this.uaQueryObjects.remove(queryObject);
    }

    public void fromXMLElement(Element element) {
        this.uaQueryObjects = new ArrayList();
        this.name = null;
        this.priority = 0;
        if (element != null && UAQUERY_TAG.equals(element.getTagName())) {
            Element queryObjectsElement;
            Element child = XMLUtilities.getFirstMatch(element, QUERY_NAME_TAG);
            if (child != null) {
                this.name = XMLUtilities.getPCData(child);
            }
            if ((child = XMLUtilities.getFirstMatch(element, PRIORITY_TAG)) != null) {
                try {
                    this.priority = Integer.parseInt(XMLUtilities.getPCData(child));
                }
                catch (Exception e) {
                    // empty catch block
                }
            }
            if ((queryObjectsElement = XMLUtilities.getFirstMatch(element, UAQUERY_OBJECTS_TAG)) != null) {
                List queryObjectElements = XMLUtilities.getMatchingChildren(element, "UAQueryObject");
                Iterator queryObjectItems = queryObjectElements.iterator();
                while (queryObjectItems.hasNext()) {
                    Element queryObjectElement = (Element)queryObjectItems.next();
                    this.uaQueryObjects.add(new UAQueryObject(queryObjectElement));
                }
            }
        }
    }

    public Element toXMLElement(Document document) {
        Element element = document.createElement(UAQUERY_TAG);
        if (this.name != null) {
            Element nameElement = document.createElement(QUERY_NAME_TAG);
            nameElement.appendChild(document.createTextNode(this.name));
            element.appendChild(nameElement);
        }
        Element priorityElement = document.createElement(QUERY_NAME_TAG);
        priorityElement.appendChild(document.createTextNode(String.valueOf(this.getPriority())));
        element.appendChild(priorityElement);
        if (this.uaQueryObjects.size() > 0) {
            Element queryObjectsElement = document.createElement(UAQUERY_OBJECTS_TAG);
            element.appendChild(queryObjectsElement);
            Iterator queryObjectItems = this.uaQueryObjects.iterator();
            while (queryObjectItems.hasNext()) {
                UAQueryObject queryObject = (UAQueryObject)queryObjectItems.next();
                queryObjectsElement.appendChild(queryObject.toXMLElement(document));
            }
        }
        return element;
    }

    public String toString() {
        return this.getName();
    }
}

