/*
 * Decompiled with CFR 0.152.
 */
package com.aligo.tools.image;

import com.aligo.tools.image.DPOImage;
import com.aligo.tools.image.DPOImageMap;
import com.aligo.tools.xml.DefaultDOMXMLable;
import com.aligo.tools.xml.XMLUtilities;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import org.w3c.dom.Document;
import org.w3c.dom.Element;

public class ImageLibrary
extends DefaultDOMXMLable {
    public static final String IMAGE_LIBRARY_TAG = "ImageLibrary";
    private List imageMaps;

    public ImageLibrary() {
        this.initialize();
    }

    public ImageLibrary(Element element) {
        super(element);
    }

    protected void initialize() {
        this.imageMaps = new ArrayList();
    }

    public List getImageMaps() {
        return new ArrayList(this.imageMaps);
    }

    public List getListByDPOName(String dpoName) {
        ArrayList<String> retList = new ArrayList<String>();
        if (dpoName != null) {
            Iterator itr = this.getImageMaps().iterator();
            while (itr.hasNext()) {
                DPOImageMap imageMap = (DPOImageMap)itr.next();
                Iterator imagesIterator = imageMap.getDPOImagesIterator();
                while (imagesIterator.hasNext()) {
                    DPOImage dpoImage = (DPOImage)imagesIterator.next();
                    if (dpoImage.getDPOName() == null || !dpoImage.getDPOName().equals(dpoName)) continue;
                    retList.add(imageMap.getName());
                }
            }
        }
        return retList;
    }

    public void addImageMap(DPOImageMap imageMap) {
        this.imageMaps.add(imageMap);
    }

    public void removeImageMap(DPOImageMap imageMap) {
        this.imageMaps.remove(imageMap);
    }

    public void fromXMLElement(Element element) {
        this.imageMaps = new ArrayList();
        if (element != null && IMAGE_LIBRARY_TAG.equals(element.getTagName())) {
            List imageMapElements = XMLUtilities.getMatchingChildren(element, "DPOImageMap");
            Iterator imageMapItems = imageMapElements.iterator();
            while (imageMapItems.hasNext()) {
                Element imageMapElement = (Element)imageMapItems.next();
                this.imageMaps.add(new DPOImageMap(imageMapElement));
            }
        }
    }

    public Element toXMLElement(Document document) {
        Element element = document.createElement(IMAGE_LIBRARY_TAG);
        Iterator imageMapItems = this.imageMaps.iterator();
        while (imageMapItems.hasNext()) {
            DPOImageMap imageMap = (DPOImageMap)imageMapItems.next();
            element.appendChild(imageMap.toXMLElement(document));
        }
        return element;
    }

    public DPOImageMap getImageByName(String name) {
        DPOImageMap map = null;
        Iterator items = this.imageMaps.iterator();
        while (map == null && items.hasNext()) {
            DPOImageMap next = (DPOImageMap)items.next();
            if (!next.getName().equals(name)) continue;
            map = next;
        }
        return map;
    }
}

