/*
 * Decompiled with CFR 0.152.
 */
package com.aligo.tools;

import com.aligo.tools.interfaces.ClassPathItem;
import com.aligo.tools.util.ClassName;
import com.aligo.tools.util.ReflectionUtils;
import java.awt.Color;
import java.awt.Dimension;
import java.awt.Insets;
import java.awt.Point;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.InputStream;
import java.io.PrintWriter;
import java.io.StringWriter;
import java.lang.reflect.Constructor;
import java.lang.reflect.Method;
import java.net.InetAddress;
import java.net.URLConnection;
import java.net.UnknownHostException;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.StringTokenizer;
import java.util.TreeSet;
import java.util.jar.Attributes;
import java.util.jar.JarFile;
import java.util.jar.Manifest;
import java.util.zip.ZipEntry;
import java.util.zip.ZipFile;

public class ToolsUtilities {
    private static final char[] CHARSET = new char[]{'c', 'h', 'a', 'r', 's', 'e', 't'};
    private static final char[] BODY = new char[]{'<', 'b', 'o', 'd', 'y'};
    private static MessageFormat COLOR_STRING = new MessageFormat("#{0}{1}{2}");
    private static MessageFormat DIMENSION_STRING = new MessageFormat("{0},{1}");
    private static MessageFormat POINT_STRING = new MessageFormat("{0},{1}");
    private static MessageFormat INSETS_STRING = new MessageFormat("{0},{1},{2},{3}");
    public static final MessageFormat IMPORT_STATEMENT = new MessageFormat("import {0};");
    public static final MessageFormat DOTNET_IMPORT_STATEMENT = new MessageFormat("using {0};");
    public static final MessageFormat IMPORT_ALL_STATEMENT = new MessageFormat("import {0}.*;");
    public static final MessageFormat DOTNET_IMPORT_ALL_STATEMENT = new MessageFormat("using {0};");
    public static final int BLOCK_SIZE = 512;
    public static final String SET_COOKIE = "Set-Cookie";
    public static final String COOKIE_DOMAIN = "domain=";
    public static final String COOKIE_SEPARATOR = "; ";
    public static final String EMPTY_STRING = "";
    public static final String SPACE_STRING = " ";
    public static final String EQUALS_STRING = "=";
    public static final String DASH_STRING = "-";
    public static final String ASTERISK_STRING = "*";
    public static final String COMMA_STRING = ",";
    public static final String SEMICOLON_STRING = ";";
    public static final String COLON_STRING = ":";
    public static final String PERIOD_STRING = ".";
    public static final String PARENTHESIS_BEGIN_STRING = "(";
    public static final String BRACKET_BEGIN_STRING = "{";
    public static final String SQ_BRACKET_BEGIN_STRING = "[";
    public static final String PARENTHESIS_END_STRING = ")";
    public static final String BRACKET_END_STRING = "}";
    public static final String SQ_BRACKET_END_STRING = "]";
    public static final String ARRAY_START = "[L";
    public static final String ARRAY_END = ";";
    public static final String NEW_LINE = "\n";
    public static final Collection BASIC_TYPE_VALUES = Arrays.asList("boolean", "int", "long", "byte", "char", "short", "float", "double", "java.lang.String", "java.lang.Object");
    public static final Collection BASIC_RETURN_VALUES = Arrays.asList("void", "boolean", "int", "long", "byte", "char", "short", "float", "double", "java.lang.String", "java.lang.Object");
    public static final String NULL_STRING = "null";
    public static final String RETURN_STRING = "return";
    public static final String ARRAY_STRING = "[]";
    public static final String LOOP_BACK = "127.0.0.1";
    static /* synthetic */ Class class$java$util$Collection;

    public static Insets getInsetsFromString(String insetsString) {
        Insets insets = new Insets(0, 0, 0, 0);
        int[] insetsInts = ToolsUtilities.createIntArray(insetsString);
        if (insetsInts != null) {
            int i = 0;
            while (i < 4) {
                if (i == 0) {
                    insets.top = insetsInts[i];
                } else if (i == 1) {
                    insets.left = insetsInts[i];
                } else if (i == 2) {
                    insets.bottom = insetsInts[i];
                } else if (i == 3) {
                    insets.right = insetsInts[i];
                }
                ++i;
            }
        }
        return insets;
    }

    public static String getStringFromInsets(Insets insets) {
        String insetsString = null;
        if (insets != null) {
            insetsString = INSETS_STRING.format(new Object[]{String.valueOf(insets.top), String.valueOf(insets.left), String.valueOf(insets.bottom), String.valueOf(insets.right)});
        }
        return insetsString;
    }

    public static Dimension getDimensionFromString(String dimensionString) {
        Dimension size = new Dimension(0, 0);
        int[] dimInts = ToolsUtilities.createIntArray(dimensionString);
        if (dimInts != null) {
            int i = 0;
            while (i < 2) {
                if (i == 0) {
                    size.width = dimInts[i];
                } else if (i == 1) {
                    size.height = dimInts[i];
                }
                ++i;
            }
        }
        return size;
    }

    public static Point getPointFromString(String pointString) {
        Point point = new Point(0, 0);
        int[] pointInts = ToolsUtilities.createIntArray(pointString);
        if (pointInts != null) {
            if (pointInts.length >= 1) {
                point.x = pointInts[0];
            }
            if (pointInts.length >= 2) {
                point.y = pointInts[1];
            }
        }
        return point;
    }

    public static String getStringFromDimension(Dimension size) {
        String dimensionString = null;
        if (size != null) {
            dimensionString = DIMENSION_STRING.format(new Object[]{String.valueOf(size.width), String.valueOf(size.height)});
        }
        return dimensionString;
    }

    public static String getStringFromPoint(Point point) {
        String pointString = null;
        if (point != null) {
            pointString = POINT_STRING.format(new Object[]{String.valueOf(point.x), String.valueOf(point.y)});
        }
        return pointString;
    }

    public static Color getColorFromString(String colorString) {
        Color color = null;
        if (colorString != null) {
            if (colorString.startsWith("#")) {
                colorString = colorString.substring(1);
            }
            try {
                int value = Integer.parseInt(colorString, 16);
                color = new Color(value);
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
        return color;
    }

    public static String getStringFromColor(Color color) {
        String colorString = null;
        if (color != null) {
            String b;
            String g;
            String r = Integer.toHexString(color.getRed());
            if (r.length() == 1) {
                r = "0" + r;
            }
            if ((g = Integer.toHexString(color.getGreen())).length() == 1) {
                g = "0" + g;
            }
            if ((b = Integer.toHexString(color.getBlue())).length() == 1) {
                b = "0" + b;
            }
            colorString = COLOR_STRING.format(new Object[]{r, g, b});
        }
        return colorString;
    }

    public static String convertPackageToString(String packageString) {
        StringBuffer buffer = new StringBuffer();
        StringTokenizer tokens = new StringTokenizer(packageString, PERIOD_STRING, false);
        int count = 0;
        while (tokens.hasMoreTokens()) {
            if (count > 0) {
                buffer.append(File.separator);
            }
            buffer.append(tokens.nextToken());
            ++count;
        }
        return buffer.toString();
    }

    public static void performTransformAndWrite(File fileIn, File fileOut, Map replaceMap) {
        String contents = ToolsUtilities.performTransform(fileIn, replaceMap);
        ToolsUtilities.printFile(fileOut, contents);
    }

    public static String performTransform(File file, Map replaceMap) {
        String contents = null;
        try {
            contents = ToolsUtilities.performTransform(new BufferedReader(new FileReader(file)), replaceMap);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return contents;
    }

    public static String performTransform(BufferedReader reader, Map replaceMap) {
        StringBuffer data = new StringBuffer();
        try {
            String line = null;
            while ((line = reader.readLine()) != null) {
                data.append(ToolsUtilities.performTransform(line, replaceMap));
                data.append(NEW_LINE);
            }
            reader.close();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return data.toString();
    }

    public static String performTransform(String data, Map replaceMap) {
        if (data != null && replaceMap != null && replaceMap.size() > 0) {
            Iterator keys = replaceMap.keySet().iterator();
            while (keys.hasNext()) {
                String key = (String)keys.next();
                String value = (String)replaceMap.get(key);
                data = ToolsUtilities.replacePattern(data, key, value);
            }
        }
        return data;
    }

    public static String replacePattern(String line, String pattern, String replaceValue) {
        String returnValue = null;
        int index = line.indexOf(pattern);
        if (index >= 0) {
            StringBuffer buffer = new StringBuffer();
            if (index > 0) {
                buffer.append(line.substring(0, index));
            }
            buffer.append(replaceValue);
            if (index + pattern.length() < line.length()) {
                buffer.append(line.substring(index + pattern.length()));
            }
            if ((index = (returnValue = buffer.toString()).indexOf(pattern)) >= 0) {
                returnValue = ToolsUtilities.replacePattern(returnValue, pattern, replaceValue);
            }
        } else {
            returnValue = line;
        }
        return returnValue;
    }

    public static void printFile(File file, File srcFile) {
        try {
            ToolsUtilities.printFile(file, new FileInputStream(srcFile));
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public static void printFile(File file, InputStream is) {
        try {
            byte[] content = ToolsUtilities.readBytes(is);
            ToolsUtilities.printFile(file, new String(content));
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public static void printFile(File file, String contents) {
        try {
            if (!file.exists()) {
                ToolsUtilities.createFile(file);
            }
            FileWriter fileWriter = new FileWriter(file);
            PrintWriter writer = new PrintWriter(fileWriter);
            writer.println(contents);
            writer.flush();
            fileWriter.close();
            writer.close();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public static void createFile(File file) {
        if (!file.exists()) {
            if (file.getParentFile() != null && !file.getParentFile().exists()) {
                file.getParentFile().mkdirs();
            }
            if (file.isDirectory()) {
                file.mkdir();
            } else {
                try {
                    file.createNewFile();
                }
                catch (Exception e) {
                    e.printStackTrace();
                }
            }
        }
    }

    public static void forceDelete(File file) {
        if (file.exists()) {
            File[] files;
            if (file.isDirectory() && (files = file.listFiles()) != null) {
                int i = 0;
                while (i < files.length) {
                    ToolsUtilities.forceDelete(files[i]);
                    ++i;
                }
            }
            ToolsUtilities.deleteFile(file, true);
            file.delete();
        }
    }

    public static void deleteFile(File file) {
        ToolsUtilities.deleteFile(file, false);
    }

    public static void deleteFile(File file, boolean cleanUpEmptyParents) {
        if (file != null && file.exists()) {
            File parent;
            File[] files;
            if (file.isDirectory() && (files = file.listFiles()) != null) {
                int i = 0;
                while (i < files.length) {
                    ToolsUtilities.deleteFile(files[i]);
                    ++i;
                }
            }
            file.delete();
            if (cleanUpEmptyParents && (parent = file.getParentFile()) != null && parent.exists() && parent.listFiles() != null && parent.listFiles().length == 0) {
                ToolsUtilities.deleteFile(parent, true);
            }
        }
    }

    public static float[] createFloatArray(String text) {
        float[] floatArray = null;
        try {
            StringTokenizer st = new StringTokenizer(text, COMMA_STRING, false);
            floatArray = new float[st.countTokens()];
            int i = 0;
            while (st.hasMoreTokens()) {
                try {
                    floatArray[i++] = Float.parseFloat(st.nextToken());
                }
                catch (Exception e) {
                    e.printStackTrace();
                }
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return floatArray;
    }

    public static String createFloatArrayAsString(float[] floatArray) {
        StringBuffer buffer = new StringBuffer();
        if (floatArray != null && floatArray.length > 0) {
            int i = 0;
            while (i < floatArray.length) {
                if (i > 0) {
                    buffer.append(COMMA_STRING);
                }
                buffer.append(String.valueOf(floatArray[i]));
                ++i;
            }
        }
        return buffer.toString();
    }

    public static int[] createIntArray(String text) {
        int[] intArray = null;
        if (text != null) {
            try {
                StringTokenizer st = new StringTokenizer(text, COMMA_STRING, false);
                intArray = new int[st.countTokens()];
                int i = 0;
                while (st.hasMoreTokens()) {
                    try {
                        intArray[i++] = Integer.parseInt(st.nextToken());
                    }
                    catch (Exception e) {
                        e.printStackTrace();
                    }
                }
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
        return intArray;
    }

    public static String[] createStringArray(String text) {
        String[] stringArray = null;
        if (text != null) {
            try {
                StringTokenizer st = new StringTokenizer(text, COMMA_STRING, false);
                stringArray = new String[st.countTokens()];
                int i = 0;
                while (st.hasMoreTokens()) {
                    try {
                        stringArray[i++] = st.nextToken();
                    }
                    catch (Exception e) {
                        e.printStackTrace();
                    }
                }
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
        return stringArray;
    }

    public static List createStringList(String text) {
        String[] items = ToolsUtilities.createStringArray(text);
        return items != null ? Arrays.asList(items) : new ArrayList();
    }

    public static boolean stringEquals(String one, String two) {
        return ToolsUtilities.objectEquals(one, two);
    }

    public static boolean objectEquals(Object one, Object two) {
        boolean objEq = false;
        if (one == null && two == null || one != null && two != null && one.equals(two)) {
            objEq = true;
        }
        return objEq;
    }

    public static String getManifestValue(File jarFile, String key) {
        return ToolsUtilities.getManifestValue(jarFile, jarFile.getName(), key);
    }

    public static String getManifestValue(File jarFile, String jarName, String key) {
        String retVal = EMPTY_STRING;
        if (jarFile != null && key != null && jarFile.exists()) {
            try {
                Attributes attrs;
                JarFile jar = new JarFile(jarFile);
                Manifest manifest = jar.getManifest();
                if (manifest != null && (attrs = manifest.getAttributes(jarName)) != null) {
                    retVal = attrs.getValue(key);
                }
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
        return retVal;
    }

    public static String getClassName(ZipEntry entry) {
        String text = null;
        if (entry != null && ToolsUtilities.isClassEntry(entry)) {
            text = entry.getName();
            text = text.substring(0, text.indexOf(".class"));
            text = text.replace('/', '.');
        }
        return text;
    }

    public static boolean isClassEntry(ZipEntry entry) {
        boolean classEntry = false;
        if (entry != null && !entry.isDirectory() && entry.getName().endsWith(".class")) {
            classEntry = true;
        }
        return classEntry;
    }

    public static String getClassNameNoPackage(Class c) {
        String className = null;
        if (c != null) {
            className = ToolsUtilities.getClassNameNoPackage(c.getName());
        }
        return className;
    }

    public static String getClassNameNoPackage(String c) {
        String className = null;
        if (c != null) {
            ClassName cn = new ClassName(c);
            className = cn.getClassName();
        }
        return className;
    }

    public static String getClassPackage(Class c) {
        String pkg = null;
        if (c != null) {
            pkg = ToolsUtilities.getClassPackage(c.getName());
        }
        return pkg;
    }

    public static String getClassPackage(String c) {
        String pkg = null;
        if (c != null) {
            ClassName cn = new ClassName(c);
            pkg = cn.getPackageName();
        }
        return pkg;
    }

    public static boolean isClassInArchive(Class c, String archive) {
        boolean inArchive = false;
        if (c != null) {
            inArchive = ToolsUtilities.isClassInArchive(c.getName(), archive);
        }
        return inArchive;
    }

    public static boolean isClassInArchive(Class c, File archive) {
        boolean inArchive = false;
        if (c != null) {
            inArchive = ToolsUtilities.isClassInArchive(c.getName(), archive);
        }
        return inArchive;
    }

    public static boolean isClassInArchive(String className, String archive) {
        boolean inArchive = false;
        if (archive != null) {
            inArchive = ToolsUtilities.isClassInArchive(className, new File(archive));
        }
        return inArchive;
    }

    public static boolean isClassInArchive(String className, File archive) {
        boolean inArchive = false;
        if (className != null && archive != null && archive.exists()) {
            if (ReflectionUtils.isClassArray(className)) {
                className = ReflectionUtils.getClassNameFromArrayName(className);
            }
            try {
                ZipFile zip = new ZipFile(archive);
                Enumeration<? extends ZipEntry> enumeration = zip.entries();
                while (enumeration.hasMoreElements() && !inArchive) {
                    ZipEntry entry = enumeration.nextElement();
                    if (!ToolsUtilities.isClassEntry(entry) || !className.equals(ToolsUtilities.getClassName(entry))) continue;
                    inArchive = true;
                }
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
        return inArchive;
    }

    public static Collection getClassNamesInArchive(File archive) {
        TreeSet<String> classNames = new TreeSet<String>();
        if (archive != null && archive.exists()) {
            try {
                ZipFile zip = new ZipFile(archive);
                Enumeration<? extends ZipEntry> enumeration = zip.entries();
                while (enumeration.hasMoreElements()) {
                    ZipEntry entry = enumeration.nextElement();
                    if (!ToolsUtilities.isClassEntry(entry)) continue;
                    classNames.add(ToolsUtilities.getClassName(entry));
                }
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
        return classNames;
    }

    public static boolean isStatic(Method method) {
        return method != null && (method.getModifiers() & 8) > 0;
    }

    public static String getSeparatedString(Collection list, String separator) {
        String retVal = EMPTY_STRING;
        if (list != null && separator != null) {
            Iterator itr = list.iterator();
            while (itr.hasNext()) {
                Object obj = itr.next();
                if (obj instanceof ClassPathItem) {
                    ClassPathItem item = (ClassPathItem)obj;
                    if (item.getFile() == null) continue;
                    retVal = retVal + item.getFile().toString() + separator;
                    continue;
                }
                retVal = retVal + obj.toString() + separator;
            }
        }
        return retVal;
    }

    public static Collection getListAfterParsingString(String separatedString, String separator, Class type) {
        ArrayList<String> retVal = new ArrayList<String>();
        Class<?> stringClass = null;
        try {
            stringClass = Class.forName("java.lang.String");
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        Class[] params = new Class[]{stringClass};
        Constructor cons = null;
        if (type != null) {
            try {
                cons = type.getConstructor(params);
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
        if (separatedString != null) {
            int index = separatedString.indexOf(separator);
            while (index != -1) {
                String temp = null;
                if (type != null && cons != null) {
                    try {
                        temp = cons.newInstance(separatedString.substring(0, index));
                    }
                    catch (Exception e) {
                        e.printStackTrace();
                    }
                } else {
                    temp = new String(separatedString.substring(0, index));
                }
                separatedString = separatedString.substring(index + separator.length(), separatedString.length());
                index = separatedString.indexOf(separator);
                if (temp == null) continue;
                retVal.add(temp);
            }
        }
        return retVal;
    }

    public static String toUpperCaseOnFirstCharacter(String string) {
        if (string != null && string.length() > 0) {
            string = string.substring(0, 1).toUpperCase() + string.substring(1);
        }
        return string;
    }

    public static String toUpperCaseAndUnderscoresAsSeparators(String string) {
        StringBuffer buffer = new StringBuffer();
        ToolsUtilities.toUpperCaseAndUnderscoresAsSeparators(string, buffer);
        return buffer.toString();
    }

    public static void toUpperCaseAndUnderscoresAsSeparators(String string, StringBuffer buffer) {
        if (string != null && string.length() > 0) {
            int i = 0;
            while (i < string.length()) {
                if (Character.isUpperCase(string.charAt(i)) && i > 0 && (Character.isLowerCase(string.charAt(i - 1)) || i + 1 < string.length() && Character.isUpperCase(string.charAt(i - 1)) && Character.isLowerCase(string.charAt(i + 1)))) {
                    buffer.append("_");
                }
                buffer.append(Character.toUpperCase(string.charAt(i)));
                ++i;
            }
        }
    }

    public static Collection getClassNamesThatAreInJar(Collection list, String jarFile) {
        return ToolsUtilities.getClassNamesThatAreInJar(list, new File(jarFile));
    }

    public static Collection getClassNamesThatAreInJar(Collection list, File jarFile) {
        TreeSet<String> classNames = new TreeSet<String>();
        if (list != null && list.size() > 0) {
            Iterator itr = list.iterator();
            while (itr.hasNext()) {
                String name = (String)itr.next();
                if (!ToolsUtilities.isClassInArchive(name, jarFile)) continue;
                classNames.add(name);
            }
        }
        return classNames;
    }

    public static Collection getClassesThatAreInJar(Collection list, String jarFile) {
        return ToolsUtilities.getClassesThatAreInJar(list, new File(jarFile));
    }

    public static Collection getClassesThatAreInJar(Collection list, File jarFile) {
        ArrayList<Class> classes = new ArrayList<Class>();
        if (list != null && list.size() > 0) {
            TreeSet<String> classNames = new TreeSet<String>();
            Iterator itr = list.iterator();
            while (itr.hasNext()) {
                Class next = (Class)itr.next();
                if (!ToolsUtilities.isClassInArchive(next.getName(), jarFile) || classNames.contains(next.getName())) continue;
                classNames.add(next.getName());
                classes.add(next);
            }
        }
        return classes;
    }

    public static boolean isNullOrEmpty(String value) {
        return ToolsUtilities.isNullOrEmpty(value, true);
    }

    public static boolean isNullOrEmpty(String value, boolean trim) {
        boolean isNull = false;
        if (value == null || value.length() <= 0 || trim && value.trim().length() <= 0) {
            isNull = true;
        }
        return isNull;
    }

    public static byte[] readBytes(InputStream stream) {
        return ToolsUtilities.readBytes(stream, 512);
    }

    public static byte[] readBytes(InputStream stream, int blockSize) {
        byte[] content = null;
        try {
            byte[] bytes = new byte[blockSize];
            int len = -1;
            ArrayList<ByteArray> listOfBytes = new ArrayList<ByteArray>();
            while ((len = stream.read(bytes, 0, blockSize)) != -1) {
                listOfBytes.add(new ByteArray(bytes, len));
                bytes = new byte[blockSize];
            }
            if (stream != null) {
                try {
                    stream.close();
                }
                catch (Exception ex) {
                    // empty catch block
                }
            }
            content = ToolsUtilities.localAssembleContent(listOfBytes);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return content;
    }

    private static byte[] localAssembleContent(List listOfBytes) {
        int size = 0;
        Iterator iterator = listOfBytes.iterator();
        while (iterator.hasNext()) {
            ByteArray next = (ByteArray)iterator.next();
            size += next.size;
        }
        byte[] content = new byte[size];
        int index = 0;
        Iterator iterator2 = listOfBytes.iterator();
        while (iterator2.hasNext()) {
            ByteArray next = (ByteArray)iterator2.next();
            System.arraycopy(next.bytes, 0, content, index, next.size);
            index += next.size;
        }
        return content;
    }

    public static byte[] assembleContent(List listOfBytes, int sizeOfFullBuffer, int sizeOfLastBuffer) {
        byte[] content = new byte[(listOfBytes.size() - 1) * sizeOfFullBuffer + sizeOfLastBuffer];
        int index = 0;
        Iterator contentIterator = listOfBytes.iterator();
        while (contentIterator.hasNext()) {
            byte[] subBuffer = (byte[])contentIterator.next();
            int size = contentIterator.hasNext() ? sizeOfFullBuffer : sizeOfLastBuffer;
            System.arraycopy(subBuffer, 0, content, index, size);
            index += size;
        }
        return content;
    }

    public static String getContentEncoding(URLConnection conn, byte[] content) {
        String encoding = null;
        try {
            encoding = ToolsUtilities.getContentEncoding(conn);
            if (encoding == null) {
                encoding = ToolsUtilities.getContentEncoding(content);
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return encoding;
    }

    public static String getContentEncoding(URLConnection conn) {
        String encoding = null;
        try {
            String contentType;
            encoding = conn.getContentEncoding();
            if (encoding == null && (contentType = conn.getContentType()) != null && contentType.toLowerCase().indexOf("charset") >= 0) {
                String restOfIt = contentType.substring(contentType.toLowerCase().indexOf("charset") + 7);
                StringBuffer encodeBuffer = new StringBuffer();
                boolean startAdding = false;
                int i = 0;
                while (i < restOfIt.length()) {
                    char ch = restOfIt.charAt(i);
                    if (!startAdding && !Character.isWhitespace(ch) && ch != '=') {
                        startAdding = true;
                    }
                    if (startAdding) {
                        encodeBuffer.append(ch);
                    }
                    ++i;
                }
                encoding = encodeBuffer.toString();
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return encoding;
    }

    public static String getContentEncoding(byte[] content) {
        String encoding = null;
        try {
            boolean bodyFound = false;
            boolean charSetFound = false;
            boolean charSetDone = false;
            StringBuffer encodingBuffer = new StringBuffer();
            int i = 0;
            while (!charSetDone && !bodyFound && i < content.length) {
                if (ToolsUtilities.isMatch(content, i, BODY)) {
                    bodyFound = true;
                } else if (ToolsUtilities.isMatch(content, i, CHARSET)) {
                    charSetFound = true;
                    i += 7;
                } else if (charSetFound) {
                    char ch = (char)content[i];
                    if (ch == '\"') {
                        charSetDone = true;
                    } else if (!Character.isWhitespace(ch) && ch != '=') {
                        encodingBuffer.append(ch);
                    }
                }
                ++i;
            }
            if (charSetDone) {
                encoding = encodingBuffer.toString();
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return encoding;
    }

    public static boolean isMatch(byte[] content, int index, char[] chars) {
        boolean match = true;
        int i = 0;
        while (match && i < chars.length && index < content.length) {
            if (Character.toLowerCase((char)content[index]) != chars[i]) {
                match = false;
            }
            ++i;
            ++index;
        }
        return match;
    }

    public static void printHeader(URLConnection conn) {
        System.err.println("\nBEGIN HEAD");
        try {
            int n = 0;
            String key = conn.getHeaderFieldKey(n);
            String value = conn.getHeaderField(n);
            while (key != null || value != null) {
                System.err.println("KEY : " + key + " : VALUE : " + value + " : " + n);
                key = conn.getHeaderFieldKey(++n);
                value = conn.getHeaderField(n);
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        System.err.println("END HEAD\n");
    }

    public static Collection getCookiesAndReplaceDomain(URLConnection conn, String domain) {
        ArrayList<String> cookies = new ArrayList<String>();
        Iterator cookieIt = ToolsUtilities.getCookies(conn).iterator();
        while (cookieIt.hasNext()) {
            cookies.add(ToolsUtilities.replaceDomain((String)cookieIt.next(), domain));
        }
        return cookies;
    }

    public static Collection getCookies(URLConnection conn) {
        ArrayList<String> cookies = new ArrayList<String>();
        try {
            int n = 0;
            String key = conn.getHeaderFieldKey(n);
            String value = conn.getHeaderField(n);
            while (key != null || value != null) {
                if (key != null && SET_COOKIE.equals(key)) {
                    cookies.add(value);
                }
                key = conn.getHeaderFieldKey(++n);
                value = conn.getHeaderField(n);
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return cookies;
    }

    public static String replaceDomain(String cookie, String domain) {
        String newCookie = cookie;
        String lowerCookie = cookie.toLowerCase();
        if (cookie != null && lowerCookie.indexOf(COOKIE_DOMAIN) >= 0) {
            int startIndex;
            int endIndex = startIndex = lowerCookie.indexOf(COOKIE_DOMAIN);
            while (endIndex < cookie.length()) {
                if (Character.isWhitespace(cookie.charAt(endIndex))) break;
                ++endIndex;
            }
            newCookie = cookie.substring(0, startIndex) + COOKIE_DOMAIN + domain;
            if (endIndex < cookie.length()) {
                newCookie = newCookie + ";" + cookie.substring(endIndex);
            }
        }
        return newCookie;
    }

    public static String getCookieName(String cookie) {
        String cookieName = null;
        if (cookie != null) {
            String name;
            String name2;
            String part;
            int currentIndex = -1;
            int lastIndex = 0;
            while (cookieName == null && (currentIndex = cookie.indexOf(COOKIE_SEPARATOR, lastIndex)) >= 0) {
                part = cookie.substring(lastIndex, currentIndex).trim();
                if (part.length() > 0 && part.indexOf(EQUALS_STRING) > 0 && ToolsUtilities.isCookieNameValid(name2 = part.substring(0, part.indexOf(EQUALS_STRING)))) {
                    cookieName = name2;
                }
                lastIndex = currentIndex;
            }
            if (cookieName == null && lastIndex >= 0) {
                part = cookie.substring(lastIndex).trim();
                if (part.length() > 0 && part.indexOf(EQUALS_STRING) > 0 && ToolsUtilities.isCookieNameValid(name2 = part.substring(0, part.indexOf(EQUALS_STRING)))) {
                    cookieName = name2;
                }
            } else if (cookieName == null && cookie.length() > 0 && cookie.indexOf(EQUALS_STRING) > 0 && ToolsUtilities.isCookieNameValid(name = cookie.substring(0, cookie.indexOf(EQUALS_STRING)))) {
                cookieName = name;
            }
        }
        return cookieName;
    }

    private static boolean isCookieNameValid(String cookieName) {
        boolean isValid = false;
        if (!(cookieName == null || (cookieName = cookieName.toLowerCase()).equals("expires") || cookieName.equals("domain") || cookieName.equals("path") || cookieName.equals("secure"))) {
            isValid = true;
        }
        return isValid;
    }

    public static String getTrace(Throwable t) {
        StringBuffer trace = new StringBuffer();
        if (t != null) {
            StringWriter sw = new StringWriter();
            t.printStackTrace(new PrintWriter(sw));
            trace.append(sw.toString());
        }
        return trace.toString();
    }

    public static String getTraceWithMessage(Throwable t) {
        StringBuffer trace = new StringBuffer();
        if (t != null) {
            trace.append(t.getMessage());
        }
        if (t != null) {
            StringWriter sw = new StringWriter();
            t.printStackTrace(new PrintWriter(sw));
            trace.append(sw.toString());
        }
        return trace.toString();
    }

    public static boolean isCollection(Class classValue) {
        boolean collection = false;
        if (classValue != null && (class$java$util$Collection == null ? (class$java$util$Collection = ToolsUtilities.class$("java.util.Collection")) : class$java$util$Collection).isAssignableFrom(classValue)) {
            collection = true;
        }
        return collection;
    }

    public static boolean isCollection(String className) {
        Class<?> classValue = null;
        try {
            classValue = Class.forName(className);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return ToolsUtilities.isCollection(classValue);
    }

    public static String createCSharpNamespace(String packageName) {
        String namespace = null;
        if (packageName != null) {
            StringBuffer nsBuffer = new StringBuffer();
            StringTokenizer tokens = new StringTokenizer(packageName, PERIOD_STRING, false);
            while (tokens.hasMoreTokens()) {
                String token = tokens.nextToken();
                nsBuffer.append(ToolsUtilities.toUpperCaseOnFirstCharacter(token));
                if (!tokens.hasMoreTokens()) continue;
                nsBuffer.append(PERIOD_STRING);
            }
            namespace = nsBuffer.toString();
        }
        return namespace;
    }

    public static boolean isHttpsURL(String url) {
        boolean https = false;
        if (url != null && url.startsWith("https")) {
            https = true;
        }
        return https;
    }

    public static String getPort(String url) {
        String port = null;
        if (url != null) {
            int portIndex;
            int index = 7;
            if (ToolsUtilities.isHttpsURL(url)) {
                index = 8;
            }
            if ((portIndex = url.lastIndexOf(COLON_STRING)) > index) {
                int slashIndex = url.indexOf(47, portIndex);
                port = slashIndex > 0 ? url.substring(portIndex + 1, slashIndex) : url.substring(portIndex + 1);
            }
        }
        return port;
    }

    public static String getHostName(String url) {
        String host = null;
        if (url != null) {
            int portIndex;
            int index = 7;
            if (ToolsUtilities.isHttpsURL(url)) {
                index = 8;
            }
            host = (portIndex = url.lastIndexOf(COLON_STRING)) > index ? url.substring(index, portIndex) : url.substring(index);
        }
        return host;
    }

    public static String buildURL(String host, String port, boolean https) {
        StringBuffer buffer = new StringBuffer();
        if (host.length() > 0) {
            if (https) {
                buffer.append("https://");
            } else {
                buffer.append("http://");
            }
            buffer.append(host);
            if (port.length() > 0) {
                buffer.append(COLON_STRING);
                buffer.append(port);
            }
        }
        return buffer.toString();
    }

    public static Method getFirstMethod(Class aClass, String setter) {
        Method method = null;
        if (aClass != null && setter != null) {
            int i = 0;
            while (i < aClass.getMethods().length) {
                Method next = aClass.getMethods()[i];
                if (setter.equals(next.getName())) {
                    method = next;
                    break;
                }
                ++i;
            }
        }
        return method;
    }

    public static String getNullIfEmpty(String value) {
        if (ToolsUtilities.isNullOrEmpty(value)) {
            value = null;
        }
        return value;
    }

    public static String getEmptyIfNull(String value) {
        if (value == null) {
            value = EMPTY_STRING;
        }
        return value;
    }

    public static String getSystemIPAddress() {
        String ipAddress = null;
        try {
            InetAddress address = InetAddress.getLocalHost();
            ipAddress = address.getHostAddress();
        }
        catch (UnknownHostException e) {
            e.printStackTrace();
        }
        if (ToolsUtilities.isNullOrEmpty(ipAddress)) {
            ipAddress = LOOP_BACK;
        }
        return ipAddress;
    }

    public static String[] getEnv() {
        Properties props = System.getProperties();
        String[] env = new String[((Hashtable)props).size()];
        int index = 0;
        Iterator iterator = ((Hashtable)props).keySet().iterator();
        while (iterator.hasNext()) {
            String key = (String)iterator.next();
            String value = props.getProperty(key);
            env[index++] = key + EQUALS_STRING + value;
        }
        return env;
    }

    public static boolean stringLessThan(String a, String b) {
        return a != null && b != null && a.compareTo(b) < 0;
    }

    public static boolean stringLessThanEquals(String a, String b) {
        return a != null && b != null && a.compareTo(b) <= 0;
    }

    public static boolean stringGreaterThan(String a, String b) {
        return a != null && b != null && a.compareTo(b) > 0;
    }

    public static boolean stringGreaterThanEquals(String a, String b) {
        return a != null && b != null && a.compareTo(b) >= 0;
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }

    private static class ByteArray {
        public byte[] bytes;
        public int size;

        public ByteArray(byte[] bytes, int size) {
            this.bytes = bytes;
            this.size = size;
        }
    }
}

