/*
 * Decompiled with CFR 0.152.
 */
package com.aligo.profile.manager.config;

import com.aligo.config.SystemConfig;
import com.aligo.profile.manager.HeaderMap;
import com.aligo.profile.manager.SearchRule;
import java.io.Reader;

public class ProfileManagerConfig {
    private static SystemConfig sysconfig = new SystemConfig();
    public static final String PROFILE_MANANGER = "/ProfileManager";
    public static final String EXTERNAL_LIBRARY = "/ProfileManager/ExternalLibrary";
    public static final String SEARCH_RULE_SET = "/ProfileManager/SearchRuleSet";
    public static final String SEARCH_RULE = "/ProfileManager/SearchRuleSet/SearchRule";
    public static final String HEADER_ATTRIBUTE = "HeaderAttribute";
    public static final String PARTIAL_MAP_RULE = "PartialMapRule";
    public static final String SEARCH_STRING = "SearchString";
    public static final String KEYWORD_MAP = "KeywordMap";
    public static final String LOG_DIR = "/ProfileManager/LogDir";
    public static final String LOG_HEADER_FLAG = "/ProfileManager/LogHeaderFlag";
    public static final String LOG_DEBUG_FLAG = "/ProfileManager/LogDebugFlag";
    public static final String LOG_FLUSH_PERIOD_MSEC = "/ProfileManager/LogFlushPeriodMsec";
    public static final String DEFAULT_PROFILE_KEYWORD = "/ProfileManager/DefaultProfileKeyword";
    public static final String UA_HEADER_MAP_SET = "/ProfileManager/UAHeaderMapSet";
    public static final String UA_HEADER_MAP = "/ProfileManager/UAHeaderMapSet/UAHeaderMap";
    public static final String UA_DATATYPE = "UADataType";
    public static final String UA_DATAVALUE = "UADataValue";
    public static final String STRINGLIST_DELIMITER = "/ProfileManager/UAHeaderMapSet/StringListDelimiter";
    public static final String DIMENSION_DELIMITER = "/ProfileManager/UAHeaderMapSet/DimensionDelimiter";
    public static final String CLIENT_PROPERTY = "ClientProperty";

    public static void init(Reader reader) {
        try {
            sysconfig.init(reader);
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
    }

    public static String resolve(String string) {
        return sysconfig.resolve(string);
    }

    public static int count(String string) {
        return sysconfig.getCount(string);
    }

    public static SearchRule[] getSearchRules() {
        int n = ProfileManagerConfig.count(SEARCH_RULE);
        StringBuffer stringBuffer = new StringBuffer(SEARCH_RULE);
        SearchRule[] searchRuleArray = new SearchRule[n];
        int n2 = 0;
        int n3 = 0;
        while (n3 < n) {
            SearchRule searchRule;
            stringBuffer.replace(SEARCH_RULE.length(), stringBuffer.length(), "[");
            stringBuffer.append(n3);
            stringBuffer.append("]/");
            stringBuffer.append(HEADER_ATTRIBUTE);
            String string = ProfileManagerConfig.resolve(stringBuffer.toString());
            stringBuffer.replace(stringBuffer.length() - HEADER_ATTRIBUTE.length(), stringBuffer.length(), PARTIAL_MAP_RULE);
            String string2 = ProfileManagerConfig.resolve(stringBuffer.toString());
            stringBuffer.replace(stringBuffer.length() - PARTIAL_MAP_RULE.length(), stringBuffer.length(), SEARCH_STRING);
            String string3 = ProfileManagerConfig.resolve(stringBuffer.toString());
            stringBuffer.replace(stringBuffer.length() - SEARCH_STRING.length(), stringBuffer.length(), KEYWORD_MAP);
            String string4 = ProfileManagerConfig.resolve(stringBuffer.toString());
            if (string != null && string3 != null && string4 != null) {
                searchRuleArray[n2] = searchRule = new SearchRule(string, string3, string4);
                ++n2;
            } else if (string != null) {
                searchRuleArray[n2] = searchRule = new SearchRule(string, string2);
                ++n2;
            }
            ++n3;
        }
        return searchRuleArray;
    }

    public static HeaderMap[] getHeaderMaps() {
        int n = ProfileManagerConfig.count(UA_HEADER_MAP);
        StringBuffer stringBuffer = new StringBuffer(UA_HEADER_MAP);
        HeaderMap[] headerMapArray = new HeaderMap[n];
        int n2 = 0;
        int n3 = 0;
        while (n3 < n) {
            stringBuffer.replace(UA_HEADER_MAP.length(), stringBuffer.length(), "[");
            stringBuffer.append(n3);
            stringBuffer.append("]/");
            stringBuffer.append(HEADER_ATTRIBUTE);
            String string = ProfileManagerConfig.resolve(stringBuffer.toString());
            stringBuffer.replace(stringBuffer.length() - HEADER_ATTRIBUTE.length(), stringBuffer.length(), UA_DATATYPE);
            String string2 = ProfileManagerConfig.resolve(stringBuffer.toString());
            stringBuffer.replace(stringBuffer.length() - UA_DATATYPE.length(), stringBuffer.length(), SEARCH_STRING);
            String string3 = ProfileManagerConfig.resolve(stringBuffer.toString());
            stringBuffer.replace(stringBuffer.length() - SEARCH_STRING.length(), stringBuffer.length(), UA_DATAVALUE);
            String string4 = ProfileManagerConfig.resolve(stringBuffer.toString());
            stringBuffer.replace(stringBuffer.length() - UA_DATAVALUE.length(), stringBuffer.length(), CLIENT_PROPERTY);
            String string5 = ProfileManagerConfig.resolve(stringBuffer.toString());
            if (string != null && string5 != null && string2 != null) {
                HeaderMap headerMap;
                headerMapArray[n2] = headerMap = new HeaderMap(string, string3, string2, string4, string5);
                ++n2;
            }
            ++n3;
        }
        return headerMapArray;
    }

    public static String[] getStringArray(String string) {
        int n = ProfileManagerConfig.count(string);
        String[] stringArray = new String[n];
        int n2 = 0;
        while (n2 < n) {
            String string2;
            stringArray[n2] = string2 = ProfileManagerConfig.resolve(string + "[" + n2 + "]");
            ++n2;
        }
        return stringArray;
    }
}

