/*
 * Decompiled with CFR 0.152.
 */
package com.aligo.parsing;

import org.w3c.dom.Attr;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.NamedNodeMap;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

public class XMLTextUtils {
    private static final String LT = "<";
    private static final String GT = ">";
    private static final String END_LT = "</";

    public static Element getElement(Document doc, String tagName, int index) {
        NodeList rows = doc.getDocumentElement().getElementsByTagName(tagName);
        return (Element)rows.item(index);
    }

    public static int getSize(Document doc, String tagName) {
        NodeList rows = doc.getDocumentElement().getElementsByTagName(tagName);
        return rows.getLength();
    }

    public static String getValue(Element e, String tagName) {
        try {
            NodeList elements = e.getElementsByTagName(tagName);
            Node node = elements.item(0);
            NodeList nodes = node.getChildNodes();
            int i = 0;
            while (i < nodes.getLength()) {
                String s = nodes.item(i).getNodeValue().trim();
                if (!s.equals("") && !s.equals("\r")) {
                    return s;
                }
                ++i;
            }
        }
        catch (Exception ex) {
            System.out.println(ex);
            ex.printStackTrace();
        }
        return null;
    }

    public static void printNodeTypes(NodeList rows) {
        System.out.println("\tenumerating NodeList (of Elements):");
        System.out.println("\tClass\tNT\tNV");
        int ri = 0;
        while (ri < rows.getLength()) {
            Node n = rows.item(ri);
            if (n instanceof Element) {
                System.out.println("\tElement");
            } else {
                System.out.println("\tNode");
            }
            System.out.println("\t" + n.getNodeType() + "\t" + n.getNodeValue());
            ++ri;
        }
        System.out.println();
    }

    public static Attr[] getAttributes(NamedNodeMap attrs) {
        int len = attrs != null ? attrs.getLength() : 0;
        Attr[] array = new Attr[len];
        int i = 0;
        while (i < len) {
            array[i] = (Attr)attrs.item(i);
            ++i;
        }
        return array;
    }

    public static Attr[] sortAttributes(NamedNodeMap attrs) {
        int len = attrs != null ? attrs.getLength() : 0;
        Attr[] array = new Attr[len];
        int i = 0;
        while (i < len) {
            array[i] = (Attr)attrs.item(i);
            ++i;
        }
        int i2 = 0;
        while (i2 < len - 1) {
            String name = array[i2].getNodeName();
            int index = i2;
            int j = i2 + 1;
            while (j < len) {
                String curName = array[j].getNodeName();
                if (curName.compareTo(name) < 0) {
                    name = curName;
                    index = j;
                }
                ++j;
            }
            if (index != i2) {
                Attr temp = array[i2];
                array[i2] = array[index];
                array[index] = temp;
            }
            ++i2;
        }
        return array;
    }

    public static String startElement(String element) {
        StringBuffer sb = new StringBuffer();
        sb.append(LT);
        sb.append(element);
        sb.append(GT);
        return sb.toString();
    }

    public static String endElement(String element) {
        StringBuffer sb = new StringBuffer();
        sb.append(END_LT);
        sb.append(element);
        sb.append(GT);
        return sb.toString();
    }
}

