/*
 * Decompiled with CFR 0.152.
 */
package com.aligo.parsing;

import com.aligo.parsing.TestCB;
import com.aligo.parsing.XMLCallback;
import com.aligo.parsing.XMLElement;
import com.aligo.parsing.XMLEndOfInputException;
import com.aligo.parsing.XMLException;
import com.aligo.parsing.XMLHDOM;
import com.aligo.parsing.XMLInputStream;
import com.aligo.parsing.XMLName;
import java.io.File;
import java.io.FileReader;
import java.io.IOException;
import java.io.InputStreamReader;
import java.util.Enumeration;
import java.util.Vector;

public class XMLParser {
    int nlevel = 0;
    XMLName cdataName = new XMLName("CDATA");
    Vector callbacks = new Vector();

    public void registerForCallbacks(XMLCallback cb) {
        this.callbacks.addElement(cb);
    }

    public void generateElementDataEvent(XMLElement xel) {
        Enumeration e = this.callbacks.elements();
        while (e.hasMoreElements()) {
            ((XMLCallback)e.nextElement()).processDataEvent(xel, null);
        }
    }

    public void generateCdataEvent(XMLElement xel, String cdata) {
        Enumeration e = this.callbacks.elements();
        while (e.hasMoreElements()) {
            ((XMLCallback)e.nextElement()).processCDATAEvent(xel, cdata);
        }
    }

    public void generateBeginElementEvent(XMLElement xel) {
        Enumeration e = this.callbacks.elements();
        while (e.hasMoreElements()) {
            ((XMLCallback)e.nextElement()).processBeginEvent(xel, null);
        }
    }

    public void generateEndElementEvent(XMLElement xel) {
        Enumeration e = this.callbacks.elements();
        while (e.hasMoreElements()) {
            ((XMLCallback)e.nextElement()).processEndEvent(xel, null);
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public void parseElement(XMLInputStream xmlInput, XMLElement xel, XMLHDOM hdom, boolean update) throws XMLException, XMLEndOfInputException {
        try {
            char c = xmlInput.getSkipWS();
            if (c == '<') {
                c = xmlInput.getNoSkip();
                if (c == '!') {
                    c = xmlInput.getNoSkip();
                    if (c == '-') {
                        c = xmlInput.getNoSkip();
                        if (c != '-') throw new XMLException("expected comment");
                        xmlInput.consumeComment();
                    } else {
                        if (c != '[') throw new XMLException("don't know how to handle this");
                        XMLName xname = xmlInput.getName();
                        String s = xmlInput.consumeCdata();
                        this.generateCdataEvent(xel, s);
                        xel.setCData(s);
                    }
                    this.parseElement(xmlInput, xel, hdom, update);
                    return;
                }
                if (c == '?') {
                    XMLElement pxel = xmlInput.getProcessingInstruction();
                    hdom.addItem(pxel);
                    return;
                }
                if (c == '/') {
                    XMLElement eel = xmlInput.getElement();
                    if (eel.length() <= 0) return;
                    if (!eel.equals(xel)) throw new XMLException("no matching ending tag " + eel + " " + xel);
                    xel.setEndingCharIndex(xmlInput.getCurrentCharIndex() - 1);
                    this.generateEndElementEvent(xel);
                    return;
                }
                if (c == '>' || c == '<') {
                    throw new XMLException("(1) illegal character or character out of context. char=" + c);
                }
                xmlInput.reset();
                int i = xmlInput.getCurrentCharIndex() - 1;
                XMLElement nxel = xmlInput.getElement();
                ++this.nlevel;
                nxel.setStartingCharIndex(i);
                this.generateBeginElementEvent(nxel);
                if (update) {
                    this.parseElement(xmlInput, nxel, hdom.updateItem(nxel), update);
                } else {
                    this.parseElement(xmlInput, nxel, hdom.addItem(nxel), update);
                }
                --this.nlevel;
            } else if (c == '/') {
                char c2 = xmlInput.getNoSkip();
                if (c2 == '>') {
                    xel.setEndingCharIndex(xmlInput.getCurrentCharIndex() - 1);
                    this.generateEndElementEvent(xel);
                    return;
                }
                xmlInput.reset();
                StringBuffer strBuf = new StringBuffer(256);
                while (c != '<') {
                    strBuf.append(c);
                    c = xmlInput.getNoSkip();
                    if (c != '>') continue;
                    throw new XMLException("(2) illegal character or character out of context. char = " + c);
                }
                xmlInput.reset();
                xel.setData(strBuf.toString());
                this.generateElementDataEvent(xel);
            } else {
                if (c == '>') throw new XMLException("(4) illegal character or character out of context. char = " + c);
                StringBuffer strBuf = new StringBuffer(256);
                while (c != '<') {
                    strBuf.append(c);
                    c = xmlInput.getNoSkip();
                    if (c != '>') continue;
                    throw new XMLException("(3) illegal character or character out of context. char = " + c);
                }
                xmlInput.reset();
                xel.setData(strBuf.toString());
                this.generateElementDataEvent(xel);
            }
            this.parseElement(xmlInput, xel, hdom, update);
            return;
        }
        catch (IOException e) {
            if (this.nlevel == 0) throw new XMLEndOfInputException("");
            throw new XMLException("no closing tag or tags not balanced");
        }
    }

    public XMLHDOM parseFromFile(InputStreamReader reader) throws XMLException {
        try {
            char[] buffer = new char[4096];
            int i = 0;
            int lastBytesRead = 0;
            StringBuffer xmlData = new StringBuffer();
            while ((i = reader.read(buffer)) > 0) {
                xmlData.append(buffer, 0, i);
                lastBytesRead = i;
            }
            XMLHDOM hdom = this.parse(xmlData.toString());
            return hdom;
        }
        catch (IOException e) {
            throw new XMLException("Cannot read input file");
        }
    }

    public XMLHDOM parseFromFile(String fileName) throws XMLException {
        try {
            File fl = new File(fileName);
            FileReader fr = new FileReader(fl);
            char[] data = new char[(int)fl.length()];
            fr.read(data, 0, (int)fl.length());
            fr.close();
            XMLHDOM hdom = this.parse(data);
            return hdom;
        }
        catch (IOException e) {
            throw new XMLException("Cannot read input file:" + fileName);
        }
    }

    public XMLHDOM parse(String xmlstr) throws XMLException {
        XMLHDOM hdom = this.parse(xmlstr.toCharArray());
        hdom.setdefault("/");
        return hdom;
    }

    public XMLHDOM parse(XMLHDOM hdom, String xmlstr, boolean update) throws XMLException {
        this.parse(hdom, xmlstr.toCharArray(), update);
        return hdom;
    }

    public XMLHDOM parse(char[] xmlstr) throws XMLException {
        XMLHDOM hdom = new XMLHDOM();
        return this.parse(hdom, xmlstr, false);
    }

    public XMLHDOM parse(XMLHDOM hdom, char[] xmlstr, boolean update) throws XMLException {
        hdom.setRawXML(new String(xmlstr));
        XMLHDOM xhdom = hdom.defaultDI != null ? hdom.defaultDI.hdom : hdom;
        this.nlevel = 0;
        try {
            XMLInputStream xmlIn = new XMLInputStream(xmlstr);
            while (xmlIn.getSkipWS() == '<') {
                xmlIn.reset();
                this.parseElement(xmlIn, null, xhdom, update);
            }
            throw new XMLException("no recognizable starting character");
        }
        catch (IOException e) {
            throw new XMLException("i/o exception in XMLParser: " + e);
        }
        catch (XMLEndOfInputException e) {
            return hdom;
        }
    }

    public boolean updateDOM(XMLHDOM dom, String path, String xml) throws XMLException {
        if (dom.setdefault(path) != null) {
            this.parse(dom, xml, true);
            return true;
        }
        return false;
    }

    public boolean addToDOM(XMLHDOM dom, String path, String xml) throws XMLException {
        if (dom.setdefault(path) != null) {
            this.parse(dom, xml, false);
            return true;
        }
        return false;
    }

    public static void main(String[] args) {
        try {
            XMLParser p = new XMLParser();
            p.registerForCallbacks(new TestCB());
            XMLHDOM dom = p.parse("<FOO><A>1234</A><B><B1>1234</B1><B1>4567</B1><B2>2342</B2></B><C>890</C><InLineScript><![CDATA[this is a < test]]></InLineScript></FOO>");
            Enumeration e = dom.children("/FOO/B");
            while (e.hasMoreElements()) {
                System.out.println((XMLElement)e.nextElement());
            }
        }
        catch (XMLException e) {
            System.out.println(e);
        }
    }
}

