/*
 * Decompiled with CFR 0.152.
 */
package com.aligo.parsing;

import com.aligo.parsing.XMLAttributes;
import com.aligo.parsing.XMLElement;
import com.aligo.parsing.XMLName;
import java.io.CharArrayReader;
import java.io.IOException;

public class XMLInputStream
extends CharArrayReader {
    public XMLInputStream(char[] in) {
        super(in);
    }

    public int getCurrentCharIndex() {
        return this.pos;
    }

    public char getNoSkip() throws IOException {
        this.mark(1);
        int c = this.read();
        if (c == -1) {
            throw new IOException("end of stream");
        }
        return (char)c;
    }

    public char getSkipWS() throws IOException {
        char c = this.getNoSkip();
        while (Character.isWhitespace(c)) {
            c = this.getNoSkip();
        }
        return c;
    }

    public void skipWS() throws IOException {
        char c;
        while (Character.isWhitespace(c = this.getNoSkip())) {
        }
        this.reset();
    }

    /*
     * WARNING - void declaration
     */
    public XMLName getName() throws IOException {
        char c;
        StringBuffer aName = new StringBuffer(128);
        this.skipWS();
        while (!Character.isWhitespace(c = this.getNoSkip())) {
            void var2_2;
            if (var2_2 == 62 || var2_2 == 91) {
                return new XMLName(aName.toString());
            }
            aName.append((char)var2_2);
        }
        return new XMLName(aName.toString());
    }

    public XMLAttributes getAttributes() throws IOException {
        StringBuffer attrs = new StringBuffer(128);
        this.skipWS();
        while (true) {
            char c;
            if ((c = this.getNoSkip()) == '\"' || c == '\'') {
                attrs.append(c);
                c = this.getNoSkip();
                while (c != '\"' && c != '\'') {
                    attrs.append(c);
                    c = this.getNoSkip();
                }
            } else {
                if (c == '>') {
                    return new XMLAttributes(attrs.toString());
                }
                if (c == '/') {
                    this.reset();
                    return new XMLAttributes(attrs.toString());
                }
                if (c == '?' || Character.isWhitespace(c)) continue;
            }
            attrs.append(c);
        }
    }

    /*
     * WARNING - void declaration
     */
    public XMLElement getElement() throws IOException {
        char c;
        StringBuffer aName = new StringBuffer(128);
        this.skipWS();
        while (!Character.isWhitespace(c = this.getNoSkip())) {
            void var2_2;
            if (var2_2 == 62 || var2_2 == 47) {
                if (var2_2 == 47) {
                    this.reset();
                }
                return new XMLElement(new XMLName(aName.toString()), new XMLAttributes());
            }
            aName.append((char)var2_2);
        }
        XMLAttributes xattrs = this.getAttributes();
        return new XMLElement(new XMLName(aName.toString()), xattrs);
    }

    public String consumeComment() throws IOException {
        StringBuffer str = new StringBuffer(128);
        while (true) {
            char c;
            if ((c = this.getNoSkip()) == '-') {
                if (this.getNoSkip() == '-') {
                    if (this.getNoSkip() == '>') {
                        return str.toString();
                    }
                    throw new IOException("comment termination error");
                }
                this.reset();
            }
            str.append(c);
        }
    }

    /*
     * WARNING - void declaration
     */
    public XMLElement getProcessingInstruction() throws IOException {
        char c;
        StringBuffer aName = new StringBuffer(128);
        this.skipWS();
        while (!Character.isWhitespace(c = this.getNoSkip())) {
            void var2_2;
            if (var2_2 == 63) continue;
            if (var2_2 == 62) {
                XMLElement xel = new XMLElement(new XMLName(aName.toString()), new XMLAttributes());
                xel.setProcessingInstruction(true);
                return xel;
            }
            aName.append((char)var2_2);
        }
        XMLAttributes xattrs = this.getAttributes();
        XMLElement xel = new XMLElement(new XMLName(aName.toString()), xattrs);
        xel.setProcessingInstruction(true);
        return xel;
    }

    public String consumeCdata() throws IOException {
        StringBuffer str = new StringBuffer(128);
        while (true) {
            char c;
            if ((c = this.getNoSkip()) == ']') {
                if (this.getNoSkip() == ']') {
                    if (this.getNoSkip() == '>') {
                        return str.toString();
                    }
                    throw new IOException("cdata termination error");
                }
                this.reset();
            }
            str.append(c);
        }
    }
}

