/*
 * Decompiled with CFR 0.152.
 */
package com.aligo.morpher;

import com.aligo.aml.base.interfaces.AmlElement;
import com.aligo.engine.logging.LoggerContainer;
import com.aligo.engine.logging.interfaces.LoggerInterface;
import com.aligo.morpher.AmlContainerTagProcessor;
import com.aligo.morpher.AmlTextTagProcessor;
import com.aligo.morpher.AmlURLTagProcessor;
import com.aligo.morpher.TagProcessor;
import com.aligo.morpher.exceptions.MalFormedAmlException;
import com.aligo.morpher.interfaces.TagHelperInterface;
import com.aligo.morpher.interfaces.TagManagerInterface;
import com.aligo.tools.xml.XMLUtilities;
import com.aligo.util.ClassUtils;
import com.aligo.util.NodeUtils;
import java.io.IOException;
import java.io.StringReader;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.StringTokenizer;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.parsers.SAXParser;
import javax.xml.parsers.SAXParserFactory;
import org.w3c.dom.Document;
import org.w3c.dom.NamedNodeMap;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import org.xml.sax.Attributes;
import org.xml.sax.ErrorHandler;
import org.xml.sax.InputSource;
import org.xml.sax.SAXException;
import org.xml.sax.SAXParseException;
import org.xml.sax.helpers.DefaultHandler;

public class AligoMorpher
extends LoggerContainer
implements TagHelperInterface,
ErrorHandler {
    public static final String SClassPath = "com.aligo.aml";
    public static final String DOT = ".";
    public static final String ADD_CHILD_METHOD_NAME = "addAmlElement";
    public static final String ADD_CHILD_METHOD_NAME_PREFIX = "add";
    public static final String ADD_ATTRIBUTE_METHOD_NAME = "addAmlAttribute";
    public static final String SET_TEXT_METHOD_NAME = "setText";
    public static final String PROCESS_TAG_METHOD = "process";
    public static final String TEXT = "text";
    public static final String STR_METHOD_NAME_PREFIX = "set";
    public static final String STR_METHOD_NAME_DELIM = "_";
    private static final String TAG_START_TAG_START = "<";
    private static final String TAG_START_TAG_END = ">";
    private static final String TAG_START_SELF_END = "/";
    private static final String TAG_END_TAG_START = "</";
    private static final String TAG_END_TAG_END = ">";
    private static final String AML_CONTAINER_NAME = "AmlContainer";
    private static final String AML_CONTAINER_TAG_START_NAME_END = "<AmlContainer";
    private static final String AML_CONTAINER_TAG_END = "</AmlContainer>";
    private static final String AML_COLLECTION_NAME = "AmlCollection";
    private static final String AML_COLLECTION_TAG_START = "<AmlCollection>";
    private static final String AML_COLLECTION_TAG_END = "</AmlCollection>";
    private Hashtable oSpecialTagTable;
    private static Hashtable oMethodTagsTable = new Hashtable();

    private void init(LoggerInterface logger) {
        super.setLogger(logger);
        this.oSpecialTagTable = new Hashtable();
        this.addTagProcessor("AmlURL", new AmlURLTagProcessor());
        this.addTagProcessor(AML_CONTAINER_NAME, new AmlContainerTagProcessor());
        this.addTagProcessor("AmlText", new AmlTextTagProcessor());
    }

    public AligoMorpher() {
        this.init(null);
    }

    public AligoMorpher(LoggerInterface logger) {
        this.init(logger);
    }

    private void setLocalLogger(TagProcessor tagProcessor) {
        tagProcessor.setLogger(this.logger);
    }

    private void addTagProcessor(String name, TagProcessor tagProcessor) {
        this.oSpecialTagTable.put(name, tagProcessor);
        this.setLocalLogger(tagProcessor);
    }

    private void setLocalLogger() {
        Enumeration e = this.oSpecialTagTable.elements();
        while (e.hasMoreElements()) {
            TagProcessor tagProcessor = (TagProcessor)e.nextElement();
            this.setLocalLogger(tagProcessor);
        }
    }

    public void setLogger(LoggerInterface logger) {
        super.setLogger(logger);
        this.setLocalLogger();
    }

    public AmlElement getAmlObject(Node rootNode) throws MalFormedAmlException {
        return this.getAmlObject(rootNode, false, null);
    }

    public AmlElement getAmlObject(Node rootNode, boolean forgive, TagManagerInterface manager) throws MalFormedAmlException {
        AmlElement rootElement = null;
        try {
            String rootName = rootNode.getNodeName();
            rootElement = this.createElement(rootName);
            this.buildTree(rootNode, rootElement, forgive, manager);
        }
        catch (Exception ex) {
            this.logger.logError(ex);
            if (ex.getMessage() == null) {
                throw new MalFormedAmlException("Bad Aml");
            }
            throw new MalFormedAmlException(ex.getMessage());
        }
        return rootElement;
    }

    public AmlElement getAmlObject(String amlString) throws MalFormedAmlException {
        return this.getAmlObject(amlString, false);
    }

    public AmlElement getAmlObject(String amlString, boolean forgive) throws MalFormedAmlException {
        return this.getAmlObject(amlString, forgive, null);
    }

    public AmlElement getAmlObject(String amlString, boolean forgive, TagManagerInterface manager) throws MalFormedAmlException {
        return this.getAmlObject(amlString, forgive, manager, false);
    }

    public AmlElement getAmlObject(String amlString, boolean forgive, boolean multiple) throws MalFormedAmlException {
        return this.getAmlObject(amlString, forgive, null, multiple);
    }

    public AmlElement getAmlObject(String amlString, boolean forgive, TagManagerInterface manager, boolean multiple) throws MalFormedAmlException {
        return this.getAmlObject(amlString, forgive, manager, multiple, false);
    }

    public AmlElement getAmlObject(String amlString, boolean forgive, TagManagerInterface manager, boolean multiple, boolean sax) throws MalFormedAmlException {
        if (multiple) {
            StringBuffer namlString = new StringBuffer("");
            namlString.append(AML_COLLECTION_TAG_START);
            namlString.append(amlString);
            namlString.append(AML_COLLECTION_TAG_END);
            amlString = namlString.toString();
        }
        if (!sax) {
            Node rootNode = null;
            Document rootDoc = null;
            try {
                StringReader sr = new StringReader(amlString);
                InputSource is = new InputSource(sr);
                DocumentBuilderFactory dFactory = DocumentBuilderFactory.newInstance();
                DocumentBuilder dBuilder = dFactory.newDocumentBuilder();
                dBuilder.setErrorHandler(this);
                rootDoc = dBuilder.parse(is);
                rootNode = this.getFirstElementNode(rootDoc);
                return this.getAmlObject(rootNode, forgive, manager);
            }
            catch (IOException ie) {
                this.logger.logError(ie);
                throw new MalFormedAmlException("IO Error processing AML");
            }
            catch (SAXException se) {
                this.logger.logError(se);
                throw new MalFormedAmlException("SAX Error processing AML");
            }
            catch (ParserConfigurationException pce) {
                this.logger.logError(pce);
                throw new MalFormedAmlException("ParserError processing AML");
            }
        }
        Hashtable<String, String> contData = null;
        if (amlString.indexOf(AML_CONTAINER_TAG_START_NAME_END) != -1) {
            contData = new Hashtable<String, String>();
            StringBuffer sb = new StringBuffer("");
            boolean done = false;
            int lastIndex = 0;
            int number = 0;
            while (!done) {
                int index = this.indexAfter(amlString, AML_CONTAINER_TAG_START_NAME_END, lastIndex);
                sb.append(this.substring(amlString, lastIndex, index));
                if (index != -1) {
                    int teIndex = this.indexAfter(amlString, ">", index);
                    sb.append(this.substring(amlString, index, teIndex));
                    if (teIndex != -1) {
                        String sestr;
                        boolean close = false;
                        int seIndex = teIndex - ">".length() - TAG_START_SELF_END.length();
                        if (seIndex >= index && (sestr = amlString.substring(seIndex, seIndex + TAG_START_SELF_END.length())).equals(TAG_START_SELF_END)) {
                            close = true;
                        }
                        if (!close) {
                            int nIndex = this.indexAfter(amlString, AML_CONTAINER_TAG_START_NAME_END, teIndex);
                            int ceIndex = this.indexAfter(amlString, AML_CONTAINER_TAG_END, teIndex);
                            if (ceIndex == -1 || nIndex != -1 && nIndex < ceIndex) {
                                close = true;
                            } else if (ceIndex != -1) {
                                int cesIndex = amlString.indexOf(AML_CONTAINER_TAG_END, teIndex);
                                if (this.logger.debugEnabled()) {
                                    this.logger.logDebug("teIndex = " + teIndex + " cesIndex = " + cesIndex);
                                }
                                contData.put("" + number, this.substring(amlString, teIndex, cesIndex));
                                sb.append(amlString.substring(cesIndex, ceIndex));
                                lastIndex = ceIndex;
                            }
                        }
                        if (close) {
                            lastIndex = teIndex;
                        }
                    }
                    ++number;
                    continue;
                }
                done = true;
            }
            amlString = sb.toString();
        }
        try {
            StringReader sr = new StringReader(amlString);
            InputSource is = new InputSource(sr);
            SAXParserFactory factory = SAXParserFactory.newInstance();
            SAXParser saxParser = factory.newSAXParser();
            saxParser.getXMLReader().setErrorHandler(this);
            AmlParseHandler handler = new AmlParseHandler(forgive, contData, manager, this);
            saxParser.parse(is, (DefaultHandler)handler);
            return handler.getAmlObject();
        }
        catch (IOException ie) {
            this.logger.logError(ie);
            throw new MalFormedAmlException("IO Error processing AML");
        }
        catch (SAXException se) {
            this.logger.logError(se);
            throw new MalFormedAmlException("SAX Error processing AML");
        }
        catch (ParserConfigurationException pce) {
            this.logger.logError(pce);
            throw new MalFormedAmlException("ParserError processing AML");
        }
    }

    private int indexAfter(String string, String lookup, int sindex) {
        int index = string.indexOf(lookup, sindex);
        if (index != -1) {
            index += lookup.length();
        }
        return index;
    }

    private String substring(String string, int sIndex, int eIndex) {
        if (eIndex != -1) {
            return string.substring(sIndex, eIndex);
        }
        return string.substring(sIndex);
    }

    public void error(SAXParseException se) {
        this.logger.logError(this.getErrorStr(se));
    }

    public void fatalError(SAXParseException se) {
        this.error(se);
    }

    public void warning(SAXParseException se) {
        if (this.logger.debugEnabled()) {
            this.logger.logDebug(this.getErrorStr(se));
        }
    }

    private String getErrorStr(SAXParseException se) {
        int lineNumber = se.getLineNumber();
        int colNumber = se.getColumnNumber();
        String message = se.getMessage();
        return "Bad AML at line " + lineNumber + " column " + colNumber + ": " + message;
    }

    private Node getFirstElementNode(Document rootDoc) {
        NodeList children = rootDoc.getChildNodes();
        Node node = null;
        boolean done = false;
        int length = children.getLength();
        int i = 0;
        while (i < length && !done) {
            Node tnode = children.item(i);
            if (tnode.getNodeType() == 1) {
                node = tnode;
                done = true;
            }
            ++i;
        }
        return node;
    }

    private void buildTree(Node rootNode, AmlElement parentElement) throws Exception {
        this.buildTree(rootNode, parentElement, false, null);
    }

    /*
     * Unable to fully structure code
     */
    private void buildTree(Node rootNode, AmlElement parentElement, boolean forgive, TagManagerInterface manager) throws Exception {
        block15: {
            if (rootNode == null) {
                return;
            }
            this.setAttributes(rootNode, parentElement, forgive);
            children = rootNode.getChildNodes();
            if (children == null) {
                return;
            }
            numberChildren = children.getLength();
            i = 0;
            while (i < numberChildren) {
                block14: {
                    childNode = children.item(i);
                    name = childNode.getNodeName();
                    tagProcessor = this.getTagProcessor(name);
                    if (tagProcessor != null) {
                        if (this.logger.debugEnabled()) {
                            this.logger.logDebug("Found tag processor for " + name);
                        }
                        args = new Object[]{childNode, parentElement, this, manager, new Boolean(forgive)};
                        try {
                            ClassUtils.callMethod(tagProcessor, "process", args);
                        }
                        catch (Exception ex) {
                            if (forgive) ** GOTO lbl35
                            throw ex;
                        }
                    } else {
                        iNodeType = childNode.getNodeType();
                        if (iNodeType == 1) {
                            name = childNode.getNodeName();
                            childElement = this.createElement(name);
                            try {
                                this.addElement(parentElement, childElement, name);
                                this.buildTree(childNode, childElement, forgive, manager);
                            }
                            catch (Exception ex) {
                                if (forgive) break block14;
                                throw ex;
                            }
                        }
                    }
                }
                ++i;
            }
            if (manager != null) {
                try {
                    manager.postProcess(rootNode, parentElement);
                }
                catch (Exception ex) {
                    if (forgive) break block15;
                    throw ex;
                }
            }
        }
    }

    private TagProcessor getTagProcessor(String amlTag) {
        TagProcessor tagProcessor = null;
        try {
            tagProcessor = (TagProcessor)this.oSpecialTagTable.get(amlTag);
        }
        catch (Exception exception) {
            // empty catch block
        }
        return tagProcessor;
    }

    private Hashtable getMethodsTable(String amlTag) {
        Hashtable methodsTable = null;
        try {
            methodsTable = (Hashtable)oMethodTagsTable.get(amlTag);
        }
        catch (Exception exception) {
            // empty catch block
        }
        return methodsTable;
    }

    public AmlElement createElement(String name) {
        AmlElement amlElement = (AmlElement)ClassUtils.createElement("com.aligo.aml." + name);
        if (this.logger.debugEnabled()) {
            this.logger.logDebug("Created element for " + name + " " + amlElement);
        }
        return amlElement;
    }

    public void addElement(AmlElement parent, AmlElement element, String name) throws Exception {
        Object[] args = new Object[]{element};
        String methodName = ADD_CHILD_METHOD_NAME_PREFIX + name;
        String parentName = parent.getName();
        if (parentName.equals(AML_COLLECTION_NAME)) {
            methodName = ADD_CHILD_METHOD_NAME;
        }
        if (this.logger.debugEnabled()) {
            this.logger.logDebug("Morpher::Calling..Method... " + methodName + " on " + parentName + " with " + element);
        }
        ClassUtils.callMethodWithThrow(parent, methodName, args);
    }

    public void addAttribute(AmlElement parent, String name, String value) throws Exception {
        AmlElement parentElement = parent;
        String parentName = parentElement.getName();
        Hashtable methodTable = (Hashtable)oMethodTagsTable.get(parentName);
        if (methodTable != null) {
            String methodName = (String)((Hashtable)oMethodTagsTable.get(parentName)).get(name);
            if (methodName != null) {
                if (this.logger.debugEnabled()) {
                    this.logger.logDebug("Morpher::Calling..Method... " + methodName + " on " + parentName + " with " + name + " " + value);
                }
                boolean call = true;
                Object[] args = new Object[1];
                if (value.equals("true") || value.equals("false")) {
                    args[0] = new Boolean(value);
                    try {
                        ClassUtils.callMethodWithThrow(parent, methodName, args);
                        call = false;
                    }
                    catch (Exception iex) {
                        // empty catch block
                    }
                }
                if (call) {
                    args[0] = value;
                    ClassUtils.callMethodWithThrow(parent, methodName, args);
                }
            } else if (this.logger.debugEnabled()) {
                this.logger.logDebug("Invalid attributeName/MethodName combination in Map. attrName = " + name);
            }
        } else if (this.logger.debugEnabled()) {
            this.logger.logDebug("Invalid ElementName in AML. elementName = " + parentName);
        }
    }

    public void setAttributes(Node rootNode, AmlElement parentElement, boolean forgive) throws Exception {
        this.setAttributes(rootNode.getAttributes(), parentElement, forgive);
    }

    public void setAttributes(NamedNodeMap attributeNodeMap, AmlElement parentElement, boolean forgive) throws Exception {
        int numberAttributes = attributeNodeMap.getLength();
        int i = 0;
        while (i < numberAttributes) {
            block3: {
                Node attribute = attributeNodeMap.item(i);
                try {
                    this.addAttribute(parentElement, attribute.getNodeName(), attribute.getNodeValue());
                }
                catch (Exception ex) {
                    this.logger.logError(ex);
                    if (forgive) break block3;
                    throw ex;
                }
            }
            ++i;
        }
    }

    public void setAttributes(Attributes attributes, AmlElement parentElement, boolean forgive) throws Exception {
        int length = attributes.getLength();
        int i = 0;
        while (i < length) {
            block3: {
                try {
                    this.addAttribute(parentElement, attributes.getQName(i), attributes.getValue(i));
                }
                catch (Exception ex) {
                    this.logger.logError(ex);
                    if (forgive) break block3;
                    throw ex;
                }
            }
            ++i;
        }
    }

    public void setElementAsTextAttribute(Node rootNode, Object container, boolean forgive) throws Exception {
        block7: {
            try {
                String textValue = NodeUtils.getAttributeValue(rootNode, TEXT);
                if (textValue == null) {
                    StringBuffer ttext = null;
                    NodeList children = rootNode.getChildNodes();
                    if (children == null) {
                        return;
                    }
                    int numberChildren = children.getLength();
                    if (numberChildren > 0) {
                        ttext = new StringBuffer("");
                    }
                    Node childNode = null;
                    int i = 0;
                    while (i < numberChildren) {
                        childNode = children.item(i);
                        String text = XMLUtilities.toXMLString(childNode);
                        ttext.append(text);
                        ++i;
                    }
                    if (ttext != null) {
                        textValue = ttext.toString().trim();
                    }
                }
                Object[] args = new Object[]{textValue};
                String methodName = SET_TEXT_METHOD_NAME;
                ClassUtils.callMethodWithThrow(container, methodName, args);
            }
            catch (Exception ex) {
                this.logger.logError(ex);
                if (forgive) break block7;
                throw ex;
            }
        }
    }

    public String strMethodName(String name) {
        StringBuffer methodName = new StringBuffer(STR_METHOD_NAME_PREFIX);
        StringTokenizer st = new StringTokenizer(name, STR_METHOD_NAME_DELIM);
        while (st.hasMoreTokens()) {
            String token = st.nextToken();
            int length = token.length();
            if (length <= 0) continue;
            char fc = token.charAt(0);
            char ufc = Character.toUpperCase(fc);
            methodName.append(ufc);
            if (length <= 1) continue;
            methodName.append(token.substring(1));
        }
        return methodName.toString();
    }

    static {
        Hashtable<String, String> elementTagsTable = new Hashtable<String, String>();
        elementTagsTable.put("encoding", "setEncoding");
        elementTagsTable.put("title", "setTitle");
        elementTagsTable.put("titlecolor", "setTitleColor");
        elementTagsTable.put("textsize", "setTextSize");
        elementTagsTable.put("italics", "setItalics");
        elementTagsTable.put("bold", "setBold");
        elementTagsTable.put("underline", "setUnderline");
        elementTagsTable.put("halign", "setHalign");
        elementTagsTable.put("font", "setFont");
        elementTagsTable.put("blink", "setBlink");
        elementTagsTable.put("marquee", "setMarquee");
        elementTagsTable.put("audio_text", "setAudioText");
        elementTagsTable.put("audio_text_src", "setAudioTextUrl");
        elementTagsTable.put("bgcolor", "setBGColor");
        elementTagsTable.put("textcolor", "setTextColor");
        elementTagsTable.put("linkcolor", "setLinkColor");
        elementTagsTable.put("prev_label", "setPreviousLabel");
        elementTagsTable.put("next_label", "setNextLabel");
        elementTagsTable.put("refresh", "setRefresh");
        elementTagsTable.put("refresh_timeout", "setRefreshTimeout");
        elementTagsTable.put("charset", "setCharset");
        elementTagsTable.put("text_direction", "setTextDirection");
        elementTagsTable.put("markup_headers", "setMarkupHeaders");
        elementTagsTable.put("headers", "setHeaders");
        oMethodTagsTable.put("AmlDocument", elementTagsTable);
        elementTagsTable = new Hashtable();
        elementTagsTable.put("persist", "setPersist");
        elementTagsTable.put(TEXT, SET_TEXT_METHOD_NAME);
        oMethodTagsTable.put(AML_CONTAINER_NAME, elementTagsTable);
        elementTagsTable = new Hashtable();
        elementTagsTable.put("id", "setId");
        elementTagsTable.put("title", "setTitle");
        elementTagsTable.put("titlecolor", "setTitleColor");
        elementTagsTable.put("textsize", "setTextSize");
        elementTagsTable.put("italics", "setItalics");
        elementTagsTable.put("bold", "setBold");
        elementTagsTable.put("underline", "setUnderline");
        elementTagsTable.put("halign", "setHalign");
        elementTagsTable.put("font", "setFont");
        elementTagsTable.put("blink", "setBlink");
        elementTagsTable.put("marquee", "setMarquee");
        elementTagsTable.put("audio_text", "setAudioText");
        elementTagsTable.put("audio_text_src", "setAudioTextUrl");
        elementTagsTable.put("cache", "setCache");
        elementTagsTable.put("summary", "setSummaryText");
        elementTagsTable.put("summary_url", "setSummaryURL");
        elementTagsTable.put("prev_label", "setPreviousLabel");
        elementTagsTable.put("next_label", "setNextLabel");
        elementTagsTable.put("menu_pos", "setMenuPosition");
        elementTagsTable.put("cache_view", "setCacheView");
        elementTagsTable.put("wml_refresh", "setWmlRefresh");
        elementTagsTable.put("wml_refresh_timeout", "setWmlRefreshTimeout");
        oMethodTagsTable.put("AmlPage", elementTagsTable);
        elementTagsTable = new Hashtable();
        elementTagsTable.put("name", "setName");
        elementTagsTable.put("mode", "setMode");
        elementTagsTable.put("view", "setView");
        elementTagsTable.put("wml_select_label", "setWmlSelectLabel");
        elementTagsTable.put("cache", "setCache");
        elementTagsTable.put("persist", "setPersist");
        elementTagsTable.put("italics", "setItalics");
        elementTagsTable.put("bold", "setBold");
        elementTagsTable.put("underline", "setUnderline");
        elementTagsTable.put(TEXT, SET_TEXT_METHOD_NAME);
        elementTagsTable.put("textsize", "setTextSize");
        elementTagsTable.put("audio_text", "setAudioText");
        elementTagsTable.put("audio_text_src", "setAudioTextUrl");
        elementTagsTable.put("scroll_size", "setScrollSize");
        elementTagsTable.put("value", "setValue");
        oMethodTagsTable.put("AmlChoice", elementTagsTable);
        elementTagsTable = new Hashtable();
        elementTagsTable.put("url", "setURL");
        elementTagsTable.put("value", "setValue");
        elementTagsTable.put("selected", "setSelected");
        elementTagsTable.put("italics", "setItalics");
        elementTagsTable.put("bold", "setBold");
        elementTagsTable.put("underline", "setUnderline");
        elementTagsTable.put(TEXT, SET_TEXT_METHOD_NAME);
        elementTagsTable.put("textsize", "setTextSize");
        elementTagsTable.put("audio_preselect_text", "setAudioPreSelectText");
        elementTagsTable.put("audio_preselect_prefix", "setAudioPreSelectPrefix");
        elementTagsTable.put("audio_preselect_suffix", "setAudioPreSelectSuffix");
        elementTagsTable.put("audio_preselect_pause", "setAudioPreSelectPause");
        elementTagsTable.put("audio_key", "setAudioKey");
        elementTagsTable.put("audio_postselect_text", "setAudioPostSelectText");
        elementTagsTable.put("audio_postselect_prefix", "setAudioPostSelectPrefix");
        elementTagsTable.put("audio_confirmation_text", "setAudioConformationText");
        elementTagsTable.put("audio_postselect_suffix", "setAudioPostSelectSuffix");
        elementTagsTable.put("audio_postselect_pause", "setAudioPostSelectPause");
        elementTagsTable.put("audio_text", "setAudioText");
        elementTagsTable.put("audio_text_src", "setAudioTextUrl");
        oMethodTagsTable.put("AmlOption", elementTagsTable);
        elementTagsTable = new Hashtable();
        elementTagsTable.put("url", "setURL");
        elementTagsTable.put("encoding", "setEncoding");
        elementTagsTable.put("inputs", "setInputs");
        elementTagsTable.put("method", "setMethod");
        elementTagsTable.put("cache", "setCache");
        elementTagsTable.put("view", "setView");
        elementTagsTable.put("submit_label", "setSubmitLabel");
        elementTagsTable.put("reset", "setReset");
        elementTagsTable.put("reset_label", "setResetLabel");
        oMethodTagsTable.put("AmlForm", elementTagsTable);
        elementTagsTable = new Hashtable();
        elementTagsTable.put("columns", "setColumns");
        elementTagsTable.put("maxcolwidth", "setMaxColWidth");
        elementTagsTable.put("border", "setBorder");
        elementTagsTable.put("halign", "setHalign");
        elementTagsTable.put("cache", "setCache");
        elementTagsTable.put("persist", "setPersist");
        oMethodTagsTable.put("AmlTable", elementTagsTable);
        elementTagsTable = new Hashtable();
        elementTagsTable.put("header", "setHeader");
        elementTagsTable.put("persist", "setPersist");
        oMethodTagsTable.put("AmlTableRow", elementTagsTable);
        elementTagsTable = new Hashtable();
        elementTagsTable.put("maxcolwidth", "setMaxColWidth");
        elementTagsTable.put("priority", "setPriority");
        elementTagsTable.put("halign", "setHalign");
        elementTagsTable.put("valign", "setValign");
        elementTagsTable.put("bgcolor", "setBGColor");
        elementTagsTable.put("italics", "setItalics");
        elementTagsTable.put("bold", "setBold");
        elementTagsTable.put("underline", "setUnderline");
        elementTagsTable.put(TEXT, SET_TEXT_METHOD_NAME);
        elementTagsTable.put("textsize", "setTextSize");
        elementTagsTable.put("audio_text", "setAudioText");
        elementTagsTable.put("audio_text_src", "setAudioTextUrl");
        oMethodTagsTable.put("AmlTableCol", elementTagsTable);
        elementTagsTable = new Hashtable();
        elementTagsTable.put("maxcolwidth", "setMaxColWidth");
        elementTagsTable.put("priority", "setPriority");
        elementTagsTable.put("halign", "setHalign");
        elementTagsTable.put("valign", "setValign");
        elementTagsTable.put("bgcolor", "setBGColor");
        elementTagsTable.put("italics", "setItalics");
        elementTagsTable.put("bold", "setBold");
        elementTagsTable.put("underline", "setUnderline");
        elementTagsTable.put(TEXT, SET_TEXT_METHOD_NAME);
        elementTagsTable.put("textsize", "setTextSize");
        elementTagsTable.put("audio_text", "setAudioText");
        elementTagsTable.put("audio_text_src", "setAudioTextUrl");
        oMethodTagsTable.put("AmlTableHead", elementTagsTable);
        elementTagsTable = new Hashtable();
        elementTagsTable.put("align", "setAlignment");
        elementTagsTable.put(TEXT, SET_TEXT_METHOD_NAME);
        elementTagsTable.put("italics", "setItalics");
        elementTagsTable.put("bold", "setBold");
        elementTagsTable.put("underline", "setUnderline");
        elementTagsTable.put("textsize", "setTextSize");
        elementTagsTable.put("audio_text", "setAudioText");
        elementTagsTable.put("audio_text_src", "setAudioTextUrl");
        oMethodTagsTable.put("AmlPCData", elementTagsTable);
        elementTagsTable = new Hashtable();
        elementTagsTable.put("name", "setName");
        elementTagsTable.put("type", "setType");
        elementTagsTable.put("value", "setValue");
        elementTagsTable.put("view", "setView");
        elementTagsTable.put("format", "setFormat");
        elementTagsTable.put("maxchars", "setMaxChars");
        elementTagsTable.put("width", "setWidth");
        elementTagsTable.put("italics", "setItalics");
        elementTagsTable.put("bold", "setBold");
        elementTagsTable.put("underline", "setUnderline");
        elementTagsTable.put(TEXT, SET_TEXT_METHOD_NAME);
        elementTagsTable.put("textsize", "setTextSize");
        elementTagsTable.put("audio_text", "setAudioText");
        elementTagsTable.put("audio_text_src", "setAudioTextUrl");
        elementTagsTable.put("audio_grammar_src", "setAudioGrammarUrl");
        elementTagsTable.put("persist", "setPersist");
        oMethodTagsTable.put("AmlInput", elementTagsTable);
        elementTagsTable = new Hashtable();
        elementTagsTable.put("url", "setURL");
        elementTagsTable.put("selected_color", "setSelectedColor");
        elementTagsTable.put("italics", "setItalics");
        elementTagsTable.put("bold", "setBold");
        elementTagsTable.put("underline", "setUnderline");
        elementTagsTable.put(TEXT, SET_TEXT_METHOD_NAME);
        elementTagsTable.put("textsize", "setTextSize");
        elementTagsTable.put("wml_select_label", "setWmlSelectLabel");
        elementTagsTable.put("audio_preselect_text", "setAudioPreSelectText");
        elementTagsTable.put("audio_preselect_prefix", "setAudioPreSelectPrefix");
        elementTagsTable.put("audio_preselect_suffix", "setAudioPreSelectSuffix");
        elementTagsTable.put("audio_preselect_pause", "setAudioPreSelectPause");
        elementTagsTable.put("audio_key", "setAudioKey");
        elementTagsTable.put("audio_text", "setAudioText");
        elementTagsTable.put("audio_text_src", "setAudioTextUrl");
        elementTagsTable.put("persist", "setPersist");
        oMethodTagsTable.put("AmlLink", elementTagsTable);
        elementTagsTable = new Hashtable();
        elementTagsTable.put("url", "setURL");
        elementTagsTable.put("label", "setLabel");
        elementTagsTable.put("italics", "setItalics");
        elementTagsTable.put("bold", "setBold");
        elementTagsTable.put("underline", "setUnderline");
        elementTagsTable.put(TEXT, SET_TEXT_METHOD_NAME);
        elementTagsTable.put("textsize", "setTextSize");
        elementTagsTable.put("key", "setKey");
        elementTagsTable.put("audio_menu_text", "setAudioMenuText");
        elementTagsTable.put("audio_key_prefix", "setAudioKeyPrefix");
        elementTagsTable.put("audio_key_suffix", "setAudioKeySuffix");
        elementTagsTable.put("audio_key", "setAudioKey");
        elementTagsTable.put("audio_text", "setAudioText");
        elementTagsTable.put("audio_text_src", "setAudioTextUrl");
        oMethodTagsTable.put("AmlControlMenu", elementTagsTable);
        elementTagsTable = new Hashtable();
        elementTagsTable.put("name", "setName");
        elementTagsTable.put("value", "setValue");
        elementTagsTable.put("view", "setView");
        elementTagsTable.put("height", "setHeight");
        elementTagsTable.put("width", "setWidth");
        elementTagsTable.put("format", "setFormat");
        elementTagsTable.put("maxchars", "setMaxChars");
        elementTagsTable.put("italics", "setItalics");
        elementTagsTable.put("bold", "setBold");
        elementTagsTable.put("underline", "setUnderline");
        elementTagsTable.put(TEXT, SET_TEXT_METHOD_NAME);
        elementTagsTable.put("textsize", "setTextSize");
        elementTagsTable.put("audio_text", "setAudioText");
        elementTagsTable.put("audio_text_src", "setAudioTextUrl");
        elementTagsTable.put("audio_grammar_src", "setAudioGrammarUrl");
        elementTagsTable.put("persist", "setPersist");
        oMethodTagsTable.put("AmlTextArea", elementTagsTable);
        elementTagsTable = new Hashtable();
        elementTagsTable.put("name", "setName");
        elementTagsTable.put("selected", "setSelected");
        elementTagsTable.put("select_label", "setSelectLabel");
        elementTagsTable.put("unselect_label", "setUnselectLabel");
        elementTagsTable.put("view", "setView");
        elementTagsTable.put("persist", "setPersist");
        elementTagsTable.put("italics", "setItalics");
        elementTagsTable.put("bold", "setBold");
        elementTagsTable.put("underline", "setUnderline");
        elementTagsTable.put(TEXT, SET_TEXT_METHOD_NAME);
        elementTagsTable.put("textsize", "setTextSize");
        elementTagsTable.put("audio_text", "setAudioText");
        elementTagsTable.put("audio_text_src", "setAudioTextUrl");
        elementTagsTable.put("value", "setValue");
        oMethodTagsTable.put("AmlCheckBox", elementTagsTable);
        elementTagsTable = new Hashtable();
        elementTagsTable.put(TEXT, SET_TEXT_METHOD_NAME);
        elementTagsTable.put("textsize", "setTextSize");
        elementTagsTable.put("halign", "setHalign");
        elementTagsTable.put("valign", "setValign");
        elementTagsTable.put("font", "setFont");
        elementTagsTable.put("italics", "setItalics");
        elementTagsTable.put("bold", "setBold");
        elementTagsTable.put("underline", "setUnderline");
        elementTagsTable.put("audio_text", "setAudioText");
        elementTagsTable.put("audio_text_src", "setAudioTextUrl");
        elementTagsTable.put("color", "setColor");
        elementTagsTable.put("blink", "setBlink");
        elementTagsTable.put("marquee", "setMarquee");
        elementTagsTable.put("cache", "setCache");
        elementTagsTable.put("persist", "setPersist");
        elementTagsTable.put("encode", "setEncode");
        oMethodTagsTable.put("AmlText", elementTagsTable);
        elementTagsTable = new Hashtable();
        oMethodTagsTable.put("AmlBr", elementTagsTable);
        elementTagsTable = new Hashtable();
        elementTagsTable.put("src", "setSrc");
        elementTagsTable.put("alt", "setAlt");
        elementTagsTable.put("align", "setAlign");
        elementTagsTable.put("height", "setHeight");
        elementTagsTable.put("width", "setWidth");
        elementTagsTable.put("vspace", "setVspace");
        elementTagsTable.put("hspace", "setHspace");
        elementTagsTable.put("persist", "setPersist");
        oMethodTagsTable.put("AmlImage", elementTagsTable);
        elementTagsTable = new Hashtable();
        elementTagsTable.put("halign", "setHalign");
        elementTagsTable.put("valign", "setValign");
        elementTagsTable.put("mode", "setMode");
        elementTagsTable.put("cache", "setCache");
        elementTagsTable.put("persist", "setPersist");
        oMethodTagsTable.put("AmlGroup", elementTagsTable);
        elementTagsTable = new Hashtable();
        oMethodTagsTable.put("AmlListItem", elementTagsTable);
        elementTagsTable = new Hashtable();
        oMethodTagsTable.put("AmlSelectListItem", elementTagsTable);
        elementTagsTable = new Hashtable();
        elementTagsTable.put("type", "setType");
        elementTagsTable.put("indent", "setIndent");
        elementTagsTable.put("start", "setStart");
        elementTagsTable.put("cache", "setCache");
        elementTagsTable.put("persist", "setPersist");
        oMethodTagsTable.put("AmlOrderedList", elementTagsTable);
        elementTagsTable = new Hashtable();
        elementTagsTable.put("bullet", "setBullet");
        elementTagsTable.put("indent", "setIndent");
        elementTagsTable.put("cache", "setCache");
        elementTagsTable.put("persist", "setPersist");
        oMethodTagsTable.put("AmlList", elementTagsTable);
        elementTagsTable = new Hashtable();
        elementTagsTable.put("wml_select_label", "setWmlSelectLabel");
        elementTagsTable.put("cache", "setCache");
        elementTagsTable.put("persist", "setPersist");
        oMethodTagsTable.put("AmlSelectList", elementTagsTable);
        elementTagsTable = new Hashtable();
        elementTagsTable.put("size", "setSize");
        elementTagsTable.put("cache", "setCache");
        elementTagsTable.put("persist", "setPersist");
        oMethodTagsTable.put("AmlSpace", elementTagsTable);
        elementTagsTable = new Hashtable();
        elementTagsTable.put("gridx", "setGridX");
        elementTagsTable.put("gridy", "setGridY");
        elementTagsTable.put("gridwidth", "setGridWidth");
        elementTagsTable.put("gridheight", "setGridHeight");
        elementTagsTable.put("anchor", "setAnchor");
        oMethodTagsTable.put("AmlGridBagConstraints", elementTagsTable);
        elementTagsTable = new Hashtable();
        oMethodTagsTable.put("AmlGridBagLayout", elementTagsTable);
        elementTagsTable = new Hashtable();
        elementTagsTable.put("ordernumber", "setOrderNumber");
        oMethodTagsTable.put("AmlOrderedConstraints", elementTagsTable);
        elementTagsTable = new Hashtable();
        elementTagsTable.put("direction", "setDirection");
        oMethodTagsTable.put("AmlOrderedLayout", elementTagsTable);
        elementTagsTable = new Hashtable();
        elementTagsTable.put("dpo", "setUAQuery");
        elementTagsTable.put("protocol", "setProtocol");
        elementTagsTable.put("device", "setDevice");
        elementTagsTable.put("styleid", "setStyleId");
        elementTagsTable.put("inlinestyle", "setInlineStyle");
        oMethodTagsTable.put("AmlStyle", elementTagsTable);
    }

    private class AmlParseHandler
    extends DefaultHandler {
        private boolean forgive;
        private Hashtable contData;
        private TagManagerInterface manager;
        private TagHelperInterface helper;
        private AmlElement rootElement = null;
        private AmlElement currentElement = null;
        private ArrayList parentElements = new ArrayList();
        private int contNumber = 0;

        public AmlParseHandler(boolean forgive, Hashtable contData, TagManagerInterface manager, TagHelperInterface helper) {
            this.forgive = forgive;
            this.contData = contData;
            this.manager = manager;
            this.helper = helper;
        }

        public void startElement(String uri, String localName, String qName, Attributes attributes) throws SAXException {
            block8: {
                if (AligoMorpher.this.logger.debugEnabled()) {
                    AligoMorpher.this.logger.logDebug("qName = " + qName + " localName = " + localName);
                }
                try {
                    String contents;
                    AmlElement element = AligoMorpher.this.createElement(qName);
                    if (this.currentElement == null) {
                        this.rootElement = element;
                    } else {
                        AligoMorpher.this.addElement(this.currentElement, element, qName);
                    }
                    boolean handled = false;
                    if (qName.equals(AligoMorpher.AML_CONTAINER_NAME) && this.contData != null && (contents = (String)this.contData.get("" + this.contNumber++)) != null) {
                        if (AligoMorpher.this.logger.debugEnabled()) {
                            AligoMorpher.this.logger.logDebug("Setting contents for container... " + contents);
                        }
                        AligoMorpher.this.addAttribute(element, AligoMorpher.TEXT, contents);
                        handled = true;
                    }
                    if (!handled) {
                        AligoMorpher.this.setAttributes(attributes, element, this.forgive);
                    }
                    this.parentElements.add(element);
                    this.currentElement = element;
                }
                catch (Exception ex) {
                    AligoMorpher.this.logger.logError(ex);
                    if (this.forgive) break block8;
                    throw new SAXException(ex);
                }
            }
        }

        public void endElement(String uri, String localName, String qName) throws SAXException {
            int pos = this.parentElements.size() - 1;
            this.parentElements.remove(pos--);
            this.currentElement = pos >= 0 ? (AmlElement)this.parentElements.get(pos) : null;
        }

        public AmlElement getAmlObject() {
            return this.rootElement;
        }
    }
}

