/*
 * Decompiled with CFR 0.152.
 */
package com.aligo.modules.xhtml.util;

import com.aligo.axml.interfaces.AxmlElement;
import com.aligo.modules.errors.HandlerError;
import com.aligo.modules.interfaces.HandlerManagerInterface;
import com.aligo.modules.interfaces.PageAllocatorInterface;
import com.aligo.modules.paths.interfaces.AmlPathInterface;
import com.aligo.modules.styles.exceptions.XmlElementIndexOutOfBoundsException;
import com.aligo.modules.styles.interfaces.XmlElementInterface;
import com.aligo.modules.xhtml.events.XHtmlAmlDetachFromTreeMemoryHandlerEvent;
import com.aligo.modules.xhtml.events.XHtmlAmlGetPageAllocatorMemoryHandlerEvent;
import com.aligo.modules.xhtml.events.XHtmlAmlGetPresentationElementsHandlerEvent;
import com.aligo.modules.xhtml.events.XHtmlAmlGetRootElementHandlerEvent;
import com.aligo.modules.xhtml.events.XHtmlAmlGetTopStyleElementStateHandlerEvent;
import com.aligo.modules.xhtml.events.XHtmlAmlGetTopXHtmlElementStateHandlerEvent;
import com.aligo.modules.xhtml.events.XHtmlAmlGetXHtmlChildContainerStateHandlerEvent;
import com.aligo.modules.xhtml.events.XHtmlAmlIsDeckSaneMemoryHandlerEvent;
import com.aligo.modules.xhtml.events.XHtmlAmlIsPersistentHandlerEvent;
import com.aligo.modules.xhtml.events.XHtmlAmlIsSufficientMemoryHandlerEvent;
import com.aligo.modules.xhtml.events.XHtmlAmlSetRootElementHandlerEvent;
import com.aligo.modules.xhtml.handlets.events.XHtmlAmlAddXmlXHtmlAttributeHandletEvent;
import com.aligo.modules.xhtml.handlets.events.XHtmlAmlAddXmlXHtmlElementHandletEvent;
import com.aligo.modules.xhtml.handlets.events.XHtmlAmlCreateXmlXHtmlElementHandletEvent;
import com.aligo.modules.xhtml.handlets.events.XHtmlAmlRemoveXmlXHtmlAttributeHandletEvent;
import com.aligo.modules.xhtml.handlets.events.XHtmlAmlRemoveXmlXHtmlElementHandletEvent;
import com.aligo.modules.xhtml.handlets.events.XHtmlAmlResetXmlXHtmlTextHandletEvent;
import com.aligo.modules.xhtml.handlets.events.XHtmlAmlSetXmlXHtmlTextHandletEvent;
import com.aligo.modules.xhtml.handlets.events.XHtmlAmlXmlXHtmlElementHandletEvent;
import com.aligo.modules.xhtml.util.exceptions.XHtmlAmlGetRootElementFailedException;
import com.aligo.modules.xhtml.util.exceptions.XHtmlAmlSetRootElementFailedException;
import com.aligo.xhtml.interfaces.XHtmlElement;
import java.util.Hashtable;

public class XHtmlAmlElementUtils {
    public static PageAllocatorInterface getPageAllocator(HandlerManagerInterface handlerManager) {
        PageAllocatorInterface pageAllocator = null;
        try {
            XHtmlAmlGetPageAllocatorMemoryHandlerEvent getPageAllocatorEvent = new XHtmlAmlGetPageAllocatorMemoryHandlerEvent();
            handlerManager.postEventNow(getPageAllocatorEvent);
            pageAllocator = getPageAllocatorEvent.getPageAllocator();
        }
        catch (HandlerError handlerError) {
            // empty catch block
        }
        return pageAllocator;
    }

    public static AxmlElement getRootAmlElement(HandlerManagerInterface handlerManager) throws XHtmlAmlGetRootElementFailedException {
        try {
            XHtmlAmlGetRootElementHandlerEvent getRootElementHandlerEvent = new XHtmlAmlGetRootElementHandlerEvent();
            handlerManager.postEventNow(getRootElementHandlerEvent);
            return getRootElementHandlerEvent.getAmlElement();
        }
        catch (HandlerError handlerError) {
            throw new XHtmlAmlGetRootElementFailedException(handlerError.toString());
        }
    }

    public static void setRootAmlElement(HandlerManagerInterface handlerManager, AxmlElement rootAmlElement) throws XHtmlAmlSetRootElementFailedException {
        try {
            XHtmlAmlSetRootElementHandlerEvent setRootElementHandlerEvent = new XHtmlAmlSetRootElementHandlerEvent(rootAmlElement);
            handlerManager.postEventNow(setRootElementHandlerEvent);
        }
        catch (HandlerError handlerError) {
            throw new XHtmlAmlSetRootElementFailedException(handlerError.toString());
        }
    }

    public static boolean isSufficientMemory(HandlerManagerInterface handlerManager, AmlPathInterface currentAmlPath) throws HandlerError {
        XHtmlAmlIsSufficientMemoryHandlerEvent isSufficientMemoryEvent = new XHtmlAmlIsSufficientMemoryHandlerEvent(currentAmlPath);
        handlerManager.postEventNow(isSufficientMemoryEvent);
        return isSufficientMemoryEvent.isSufficient();
    }

    public static XHtmlElement getTopXHtmlElement(HandlerManagerInterface handlerManager, AmlPathInterface currentAmlPath) throws HandlerError {
        XHtmlAmlGetTopXHtmlElementStateHandlerEvent getTopXHtmlElementStateEvent = new XHtmlAmlGetTopXHtmlElementStateHandlerEvent(currentAmlPath);
        handlerManager.postEventNow(getTopXHtmlElementStateEvent);
        return getTopXHtmlElementStateEvent.getXHtmlElement();
    }

    public static void detachFromTree(HandlerManagerInterface handlerManager, AmlPathInterface currentAmlPath) throws HandlerError {
        XHtmlAmlDetachFromTreeMemoryHandlerEvent detachFromTreeEvent = new XHtmlAmlDetachFromTreeMemoryHandlerEvent(currentAmlPath);
        handlerManager.postEventNow(detachFromTreeEvent);
    }

    public static boolean isDeckSane(HandlerManagerInterface handlerManager) throws HandlerError {
        XHtmlAmlIsDeckSaneMemoryHandlerEvent isDeckSaneEvent = new XHtmlAmlIsDeckSaneMemoryHandlerEvent();
        handlerManager.postEventNow(isDeckSaneEvent);
        return isDeckSaneEvent.isSane();
    }

    public static XHtmlElement getChildContainerXHtmlElement(HandlerManagerInterface handlerManager, AmlPathInterface currentAmlPath) throws HandlerError {
        XHtmlAmlGetXHtmlChildContainerStateHandlerEvent getXHtmlChildContainerStateEvent = new XHtmlAmlGetXHtmlChildContainerStateHandlerEvent(currentAmlPath);
        handlerManager.postEventNow(getXHtmlChildContainerStateEvent);
        return getXHtmlChildContainerStateEvent.getXHtmlElement();
    }

    public static XmlElementInterface getTopStyleElement(HandlerManagerInterface handlerManager, AmlPathInterface currentAmlPath) throws HandlerError {
        XHtmlAmlGetTopStyleElementStateHandlerEvent getTopStyleElementStateEvent = new XHtmlAmlGetTopStyleElementStateHandlerEvent(currentAmlPath);
        handlerManager.postEventNow(getTopStyleElementStateEvent);
        return getTopStyleElementStateEvent.getXmlElement();
    }

    public static XmlElementInterface getFirstMatchingChild(HandlerManagerInterface handlerManager, XmlElementInterface topElement, String name) {
        XmlElementInterface matchedElement = null;
        String itName = topElement.getXmlElementName();
        if (name.equals(itName)) {
            matchedElement = topElement;
        } else {
            int numberElements = topElement.getNumberXmlElements();
            boolean done = false;
            int i = 0;
            while (i < numberElements && !done) {
                try {
                    XmlElementInterface xmlElement = topElement.getXmlElement(i);
                    XmlElementInterface childMatchElement = XHtmlAmlElementUtils.getFirstMatchingChild(handlerManager, xmlElement, name);
                    if (childMatchElement != null) {
                        matchedElement = childMatchElement;
                        done = true;
                    }
                }
                catch (XmlElementIndexOutOfBoundsException xe) {
                    // empty catch block
                }
                ++i;
            }
        }
        return matchedElement;
    }

    public static XHtmlElement getXHtmlElement(HandlerManagerInterface handlerManager, AmlPathInterface currentAmlPath, XmlElementInterface xmlElement) throws HandlerError {
        XHtmlAmlXmlXHtmlElementHandletEvent xmlXHtmlElementEvent = new XHtmlAmlXmlXHtmlElementHandletEvent("Get", currentAmlPath, xmlElement);
        handlerManager.postEventNow(xmlXHtmlElementEvent);
        return xmlXHtmlElementEvent.getXHtmlElement();
    }

    public static void setXHtmlElement(HandlerManagerInterface handlerManager, AmlPathInterface currentAmlPath, XmlElementInterface xmlElement, XHtmlElement xhtmlElement) throws HandlerError {
        XHtmlAmlXmlXHtmlElementHandletEvent xmlXHtmlElementEvent = new XHtmlAmlXmlXHtmlElementHandletEvent("Set", currentAmlPath, xmlElement);
        xmlXHtmlElementEvent.setXHtmlElement(xhtmlElement);
        handlerManager.postEventNow(xmlXHtmlElementEvent);
    }

    public static XHtmlElement createXHtmlElement(HandlerManagerInterface handlerManager, AmlPathInterface currentAmlPath, String name) throws HandlerError {
        XHtmlAmlCreateXmlXHtmlElementHandletEvent createXmlXHtmlEvent = new XHtmlAmlCreateXmlXHtmlElementHandletEvent(currentAmlPath, name);
        handlerManager.postEventNow(createXmlXHtmlEvent);
        return createXmlXHtmlEvent.getXHtmlElement();
    }

    public static void addXHtmlElement(HandlerManagerInterface handlerManager, AmlPathInterface currentAmlPath, XHtmlElement xhtmlElement, XHtmlElement childXHtmlElement) throws HandlerError {
        XHtmlAmlElementUtils.addXHtmlElement(handlerManager, currentAmlPath, xhtmlElement, childXHtmlElement, -1);
    }

    public static void addXHtmlElement(HandlerManagerInterface handlerManager, AmlPathInterface currentAmlPath, XHtmlElement xhtmlElement, XHtmlElement childXHtmlElement, int childIndex) throws HandlerError {
        XHtmlAmlAddXmlXHtmlElementHandletEvent addXmlXHtmlElementEvent = new XHtmlAmlAddXmlXHtmlElementHandletEvent(currentAmlPath, xhtmlElement, childXHtmlElement, childIndex);
        handlerManager.postEventNow(addXmlXHtmlElementEvent);
    }

    public static void addXHtmlAttribute(HandlerManagerInterface handlerManager, AmlPathInterface currentAmlPath, XHtmlElement xhtmlElement, String name, String value) throws HandlerError {
        XHtmlAmlAddXmlXHtmlAttributeHandletEvent addXmlXHtmlAttributeEvent = new XHtmlAmlAddXmlXHtmlAttributeHandletEvent(currentAmlPath, xhtmlElement, name, value);
        handlerManager.postEventNow(addXmlXHtmlAttributeEvent);
    }

    public static void setXHtmlText(HandlerManagerInterface handlerManager, AmlPathInterface currentAmlPath, XHtmlElement xhtmlElement, String text) throws HandlerError {
        XHtmlAmlSetXmlXHtmlTextHandletEvent setXmlXHtmlTextEvent = new XHtmlAmlSetXmlXHtmlTextHandletEvent(currentAmlPath, xhtmlElement, text);
        handlerManager.postEventNow(setXmlXHtmlTextEvent);
    }

    public static void removeXHtmlElement(HandlerManagerInterface handlerManager, AmlPathInterface currentAmlPath, XHtmlElement xhtmlElement, XHtmlElement childXHtmlElement) throws HandlerError {
        XHtmlAmlRemoveXmlXHtmlElementHandletEvent removeXmlXHtmlElementEvent = new XHtmlAmlRemoveXmlXHtmlElementHandletEvent(currentAmlPath, xhtmlElement, childXHtmlElement);
        handlerManager.postEventNow(removeXmlXHtmlElementEvent);
    }

    public static void removeXHtmlAttribute(HandlerManagerInterface handlerManager, AmlPathInterface currentAmlPath, XHtmlElement xhtmlElement, String name) throws HandlerError {
        XHtmlAmlRemoveXmlXHtmlAttributeHandletEvent removeXmlXHtmlAttributeEvent = new XHtmlAmlRemoveXmlXHtmlAttributeHandletEvent(currentAmlPath, xhtmlElement, name);
        handlerManager.postEventNow(removeXmlXHtmlAttributeEvent);
    }

    public static void resetXHtmlText(HandlerManagerInterface handlerManager, AmlPathInterface currentAmlPath, XHtmlElement xhtmlElement) throws HandlerError {
        XHtmlAmlResetXmlXHtmlTextHandletEvent resetXmlXHtmlTextEvent = new XHtmlAmlResetXmlXHtmlTextHandletEvent(currentAmlPath, xhtmlElement);
        handlerManager.postEventNow(resetXmlXHtmlTextEvent);
    }

    public static Hashtable getPresentationElements(HandlerManagerInterface handlerManager) throws HandlerError {
        XHtmlAmlGetPresentationElementsHandlerEvent getPresentationElementsEvent = new XHtmlAmlGetPresentationElementsHandlerEvent();
        handlerManager.postEventNow(getPresentationElementsEvent);
        return getPresentationElementsEvent.getXHtmlElements();
    }

    public static boolean isPresentationElement(HandlerManagerInterface handlerManager, XHtmlElement xhtmlElement) throws HandlerError {
        boolean present = false;
        Hashtable xhtmlElements = XHtmlAmlElementUtils.getPresentationElements(handlerManager);
        if (xhtmlElements.get(xhtmlElement) != null) {
            present = true;
        }
        return present;
    }

    public static void addPresentationElement(HandlerManagerInterface handlerManager, XHtmlElement xhtmlElement) throws HandlerError {
        Hashtable xhtmlElements = XHtmlAmlElementUtils.getPresentationElements(handlerManager);
        XHtmlAmlElementUtils.addPresentationElement(xhtmlElements, xhtmlElement);
    }

    public static void removePresentationElement(HandlerManagerInterface handlerManager, XHtmlElement xhtmlElement) throws HandlerError {
        Hashtable xhtmlElements = XHtmlAmlElementUtils.getPresentationElements(handlerManager);
        XHtmlAmlElementUtils.removePresentationElement(xhtmlElements, xhtmlElement);
    }

    public static void addPresentationElement(Hashtable xhtmlElements, XHtmlElement xhtmlElement) {
        xhtmlElements.put(xhtmlElement, xhtmlElement);
    }

    public static void removePresentationElement(Hashtable xhtmlElements, XHtmlElement xhtmlElement) {
        xhtmlElements.remove(xhtmlElement);
    }

    public static boolean isPersistent(HandlerManagerInterface handlerManager, AmlPathInterface currentAmlPath) throws HandlerError {
        XHtmlAmlIsPersistentHandlerEvent isPersistentEvent = new XHtmlAmlIsPersistentHandlerEvent(currentAmlPath);
        handlerManager.postEventNow(isPersistentEvent);
        return isPersistentEvent.isPersistent();
    }
}

