/*
 * Decompiled with CFR 0.152.
 */
package com.aligo.modules.xhtml.state;

import com.aligo.axml.interfaces.AxmlElement;
import com.aligo.modules.styles.interfaces.StyleIDInterface;
import com.aligo.modules.styles.interfaces.XmlElementInterface;
import com.aligo.modules.xhtml.state.exceptions.XHtmlAmlStateKeeperAttributeNotFoundException;
import com.aligo.modules.xhtml.state.exceptions.XHtmlAmlStateKeeperElementNotFoundException;
import com.aligo.modules.xhtml.state.interfaces.XHtmlAmlStateKeeperInterface;
import com.aligo.xhtml.XHtmlElementCollection;
import com.aligo.xhtml.exceptions.XHtmlElementCannotBeAddedException;
import com.aligo.xhtml.exceptions.XHtmlElementNotFoundException;
import com.aligo.xhtml.interfaces.XHtmlElement;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Vector;

public class XHtmlAmlStateKeeper
implements XHtmlAmlStateKeeperInterface {
    private AxmlElement oAmlElement;
    private XHtmlElement oXHtmlChildContainerElement;
    private XHtmlElement oXHtmlElements = new XHtmlElementCollection();
    private XHtmlElement oXHtmlTopElement;
    private XHtmlElement oXHtmlEndElements = new XHtmlElementCollection();
    private int iXHtmlChildPosition = -1;
    private Hashtable oXHtmlAttrTable = new Hashtable();
    private XHtmlElement oXHtmlTextElements = new XHtmlElementCollection();
    private XmlElementInterface oTopStyleElement;
    private StyleIDInterface oStyleID;

    public void setAmlElement(AxmlElement amlElement) {
        this.oAmlElement = amlElement;
    }

    public AxmlElement getAmlElement() {
        return this.oAmlElement;
    }

    public void setXHtmlChildContainerElement(XHtmlElement xhtmlChildContainerElement) {
        this.oXHtmlChildContainerElement = xhtmlChildContainerElement;
    }

    public XHtmlElement getXHtmlChildContainerElement() {
        return this.oXHtmlChildContainerElement;
    }

    public void setXHtmlChildPosition(int xhtmlChildPosition) {
        this.iXHtmlChildPosition = xhtmlChildPosition;
    }

    public int getXHtmlChildPosition() {
        return this.iXHtmlChildPosition;
    }

    public void setTopXHtmlElement(XHtmlElement xhtmlTopElement) {
        this.oXHtmlTopElement = xhtmlTopElement;
    }

    public XHtmlElement getTopXHtmlElement() {
        return this.oXHtmlTopElement;
    }

    public void addEndXHtmlElement(XHtmlElement xhtmlEndElement) {
        try {
            this.oXHtmlEndElements.addXHtmlElement(xhtmlEndElement);
        }
        catch (XHtmlElementCannotBeAddedException xHtmlElementCannotBeAddedException) {
            // empty catch block
        }
    }

    public XHtmlElement getEndXHtmlElements() {
        return this.oXHtmlEndElements;
    }

    public void removeAllEndXHtmlElements() {
        this.oXHtmlEndElements.removeAll();
    }

    public void removeEndXHtmlElement(XHtmlElement xhtmlElement) throws XHtmlAmlStateKeeperElementNotFoundException {
        try {
            this.oXHtmlEndElements.removeXHtmlElement(xhtmlElement);
        }
        catch (XHtmlElementNotFoundException we) {
            throw new XHtmlAmlStateKeeperElementNotFoundException();
        }
    }

    public void addXHtmlElement(XHtmlElement xhtmlElement) {
        try {
            this.oXHtmlElements.addXHtmlElement(xhtmlElement);
        }
        catch (XHtmlElementCannotBeAddedException xHtmlElementCannotBeAddedException) {
            // empty catch block
        }
    }

    public XHtmlElement getXHtmlElements() {
        return this.oXHtmlElements;
    }

    public void removeAllXHtmlElements() {
        this.oXHtmlElements.removeAll();
    }

    public void removeXHtmlElement(XHtmlElement xhtmlElement) throws XHtmlAmlStateKeeperElementNotFoundException {
        try {
            this.oXHtmlElements.removeXHtmlElement(xhtmlElement);
        }
        catch (XHtmlElementNotFoundException we) {
            throw new XHtmlAmlStateKeeperElementNotFoundException();
        }
    }

    private Vector createXHtmlAttributeVector(XHtmlElement xhtmlElement) {
        Vector attributeVector = new Vector();
        this.oXHtmlAttrTable.put(xhtmlElement, attributeVector);
        return attributeVector;
    }

    public void addXHtmlAttribute(XHtmlElement xhtmlElement, String attrName) {
        Vector attributeVector = (Vector)this.oXHtmlAttrTable.get(xhtmlElement);
        if (attributeVector == null) {
            attributeVector = this.createXHtmlAttributeVector(xhtmlElement);
        }
        attributeVector.addElement(attrName);
    }

    public XHtmlElement getXHtmlAttributeElements() {
        XHtmlElementCollection attributeElements = new XHtmlElementCollection();
        Enumeration keys = this.oXHtmlAttrTable.keys();
        while (keys.hasMoreElements()) {
            try {
                XHtmlElement xhtmlElement = (XHtmlElement)keys.nextElement();
                attributeElements.addXHtmlElement(xhtmlElement);
            }
            catch (XHtmlElementCannotBeAddedException xHtmlElementCannotBeAddedException) {
                // empty catch block
            }
        }
        return attributeElements;
    }

    public Enumeration getXHtmlAttributes(XHtmlElement xhtmlElement) throws XHtmlAmlStateKeeperElementNotFoundException {
        Vector attributeVector = (Vector)this.oXHtmlAttrTable.get(xhtmlElement);
        if (attributeVector == null) {
            throw new XHtmlAmlStateKeeperElementNotFoundException();
        }
        return attributeVector.elements();
    }

    public void removeAllXHtmlAttributes() {
        this.oXHtmlAttrTable.clear();
    }

    public void removeXHtmlAttributes(XHtmlElement xhtmlElement) throws XHtmlAmlStateKeeperElementNotFoundException {
        Vector attributeVector = (Vector)this.oXHtmlAttrTable.get(xhtmlElement);
        if (attributeVector == null) {
            throw new XHtmlAmlStateKeeperElementNotFoundException();
        }
        this.oXHtmlAttrTable.remove(xhtmlElement);
    }

    public void removeXHtmlAttribute(XHtmlElement xhtmlElement, String xhtmlAttrName) throws XHtmlAmlStateKeeperElementNotFoundException, XHtmlAmlStateKeeperAttributeNotFoundException {
        Vector attributeVector = (Vector)this.oXHtmlAttrTable.get(xhtmlElement);
        if (attributeVector == null) {
            throw new XHtmlAmlStateKeeperElementNotFoundException();
        }
        boolean present = attributeVector.remove(xhtmlAttrName);
        if (!present) {
            throw new XHtmlAmlStateKeeperAttributeNotFoundException();
        }
    }

    public void addXHtmlText(XHtmlElement xhtmlElement) {
        try {
            this.oXHtmlTextElements.addXHtmlElement(xhtmlElement);
        }
        catch (XHtmlElementCannotBeAddedException xHtmlElementCannotBeAddedException) {
            // empty catch block
        }
    }

    public XHtmlElement getXHtmlTextElements() {
        return this.oXHtmlTextElements;
    }

    public void removeAllXHtmlTextElements() {
        this.oXHtmlTextElements.removeAll();
    }

    public void removeXHtmlText(XHtmlElement xhtmlElement) throws XHtmlAmlStateKeeperElementNotFoundException {
        try {
            this.oXHtmlTextElements.removeXHtmlElement(xhtmlElement);
        }
        catch (XHtmlElementNotFoundException we) {
            throw new XHtmlAmlStateKeeperElementNotFoundException();
        }
    }

    public void setTopStyleElement(XmlElementInterface topStyleElement) {
        this.oTopStyleElement = topStyleElement;
    }

    public XmlElementInterface getTopStyleElement() {
        return this.oTopStyleElement;
    }

    public void setStyleID(StyleIDInterface styleID) {
        this.oStyleID = styleID;
    }

    public StyleIDInterface getStyleID() {
        return this.oStyleID;
    }
}

