/*
 * Decompiled with CFR 0.152.
 */
package com.aligo.modules.xhtml.amlhandlets;

import com.aligo.axml.AxmlPage;
import com.aligo.axml.interfaces.AxmlElement;
import com.aligo.modules.EventDescriptor;
import com.aligo.modules.aml.utils.AmlPathUtils;
import com.aligo.modules.errors.HandlerError;
import com.aligo.modules.interfaces.PageAllocatorInterface;
import com.aligo.modules.paths.interfaces.AmlPathInterface;
import com.aligo.modules.styles.interfaces.XmlElementInterface;
import com.aligo.modules.xhtml.errors.XHtmlAmlHandlerError;
import com.aligo.modules.xhtml.handlets.XHtmlAmlStylePathHandlet;
import com.aligo.modules.xhtml.handlets.events.XHtmlAmlAddElementHandledHandletEvent;
import com.aligo.modules.xhtml.handlets.events.XHtmlAmlAddXmlAmlAddAttributeHandletEvent;
import com.aligo.modules.xhtml.interfaces.XHtmlEventHookPosition;
import com.aligo.modules.xhtml.util.XHtmlAmlElementUtils;
import com.aligo.modules.xhtml.util.XHtmlEventDescriptor;
import com.aligo.modules.xhtml.util.XHtmlEventHookDescriptor;
import com.aligo.util.xhtml.TextUtils;
import com.aligo.xhtml.XHtmlA;
import com.aligo.xhtml.exceptions.XHtmlAttributeCannotBeAddedException;
import com.aligo.xhtml.exceptions.XHtmlElementCannotBeAddedException;
import com.aligo.xhtml.interfaces.XHtmlElement;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Vector;

public class XHtmlAmlLinkingHandlet
extends XHtmlAmlStylePathHandlet {
    private static final String TYPE = "type";
    private static final String OPTIONS = "options";
    private static final String LABEL = "label";
    private static final String PREVIOUS_PAGE = "Previous Page";
    private static final String SENDREFERER = "sendreferer";
    private static final String TRUE = "true";
    private static final String HREF = "href";
    private static final String NEXT_PAGE = "Next Page";
    private static final String ID = "id";
    private Hashtable oPageIDs = new Hashtable();
    private Hashtable oIDPages = new Hashtable();
    private Hashtable oIDLinks = new Hashtable();
    private XHtmlElement oXHtmlElement;

    public Vector getEvents() {
        Vector<EventDescriptor> events = new Vector<EventDescriptor>();
        XHtmlEventHookDescriptor eventHookDescriptor = new XHtmlEventHookDescriptor("XHtmlAmlAddElementHandledHandletEvent", XHtmlEventHookPosition.POSITION_AFTER);
        events.addElement(eventHookDescriptor);
        XHtmlEventDescriptor eventDescriptor = new XHtmlEventDescriptor("XHtmlAmlAddXmlAmlAddAttributeHandletEvent");
        events.addElement(eventDescriptor);
        return events;
    }

    public long xhtmlAmlStylePathRelevance() {
        long currentXHtmlAmlStylePathRelevance = 0L;
        if (this.oCurrentEvent instanceof XHtmlAmlAddElementHandledHandletEvent) {
            XHtmlAmlAddElementHandledHandletEvent addElementHandledEvent = (XHtmlAmlAddElementHandledHandletEvent)this.oCurrentEvent;
            this.oStyleXmlElement = addElementHandledEvent.getXmlElement();
            this.oCurrentAmlPath = addElementHandledEvent.getAmlPath();
            try {
                this.oXHtmlElement = XHtmlAmlElementUtils.getXHtmlElement(this.oHandlerManager, this.oCurrentAmlPath, this.oStyleXmlElement);
                AxmlElement amlElement = AmlPathUtils.getAmlElement(this.oHandlerManager, this.oCurrentAmlPath);
                if (amlElement instanceof AxmlPage && this.oXHtmlElement instanceof XHtmlA) {
                    currentXHtmlAmlStylePathRelevance = 20L;
                }
            }
            catch (HandlerError he) {}
        } else if (this.oCurrentEvent instanceof XHtmlAmlAddXmlAmlAddAttributeHandletEvent) {
            XHtmlAmlAddXmlAmlAddAttributeHandletEvent addAttributeEvent = (XHtmlAmlAddXmlAmlAddAttributeHandletEvent)this.oCurrentEvent;
            XmlElementInterface styleXmlElement = addAttributeEvent.getXmlElement();
            this.oCurrentAmlPath = addAttributeEvent.getAmlPath();
            try {
                XHtmlElement xhtmlElement = XHtmlAmlElementUtils.getXHtmlElement(this.oHandlerManager, this.oCurrentAmlPath, styleXmlElement);
                String xhtmlName = addAttributeEvent.getXHtmlName();
                if (xhtmlElement instanceof XHtmlA && xhtmlName.equals("name")) {
                    currentXHtmlAmlStylePathRelevance = 20L;
                } else if (xhtmlElement instanceof XHtmlA && xhtmlName.equals(HREF)) {
                    currentXHtmlAmlStylePathRelevance = 20L;
                }
            }
            catch (Exception ex) {
                // empty catch block
            }
        }
        return currentXHtmlAmlStylePathRelevance;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public void handleStylePathEventNow() throws HandlerError {
        if (this.oCurrentEvent instanceof XHtmlAmlAddElementHandledHandletEvent) {
            try {
                this.addName(this.oXHtmlElement);
                return;
            }
            catch (Exception ex) {
                if (ex instanceof HandlerError) return;
                throw new XHtmlAmlHandlerError(ex);
            }
        } else {
            if (!(this.oCurrentEvent instanceof XHtmlAmlAddXmlAmlAddAttributeHandletEvent)) return;
            XHtmlAmlAddXmlAmlAddAttributeHandletEvent addAttributeEvent = (XHtmlAmlAddXmlAmlAddAttributeHandletEvent)this.oCurrentEvent;
            XmlElementInterface styleXmlElement = addAttributeEvent.getXmlElement();
            XHtmlElement xhtmlElement = XHtmlAmlElementUtils.getXHtmlElement(this.oHandlerManager, this.oCurrentAmlPath, styleXmlElement);
            String xhtmlName = addAttributeEvent.getXHtmlName();
            if (xhtmlElement instanceof XHtmlA && xhtmlName.equals("name")) {
                String xhtmlValue = addAttributeEvent.getXHtmlValue();
                if (xhtmlValue == null) return;
                this.setCardId(xhtmlElement, xhtmlValue);
                String strPath = this.oCurrentAmlPath.toString();
                return;
            } else {
                String xhtmlValue;
                if (!(xhtmlElement instanceof XHtmlA) || !xhtmlName.equals(HREF) || (xhtmlValue = addAttributeEvent.getXHtmlValue()) == null) return;
                String url = xhtmlValue;
                int refIndex = xhtmlValue.indexOf("#");
                if (refIndex != -1) {
                    Vector links;
                    String id = xhtmlValue.substring(refIndex + 1);
                    Vector paths = (Vector)this.oIDPages.get(id);
                    if (paths != null && paths.size() > 0) {
                        url = this.getUrl(this.oCurrentAmlPath, paths, id);
                    }
                    if ((links = (Vector)this.oIDLinks.get(id)) == null) {
                        links = new Vector();
                        this.oIDLinks.put(id, links);
                    }
                    Vector<Object> linkDesc = new Vector<Object>();
                    linkDesc.addElement(this.oCurrentAmlPath);
                    linkDesc.addElement(xhtmlElement);
                    links.addElement(linkDesc);
                } else {
                    url = TextUtils.transformAttr(HREF, url);
                }
                XHtmlAmlElementUtils.addXHtmlAttribute(this.oHandlerManager, this.oCurrentAmlPath, xhtmlElement, HREF, url);
            }
        }
    }

    public String addName(XHtmlElement xhtmlElement) throws XHtmlAttributeCannotBeAddedException, XHtmlElementCannotBeAddedException, HandlerError {
        String name = null;
        if (xhtmlElement instanceof XHtmlA) {
            PageAllocatorInterface pageAllocator = XHtmlAmlElementUtils.getPageAllocator(this.oHandlerManager);
            pageAllocator.allocateElement();
            name = pageAllocator.getCurrentElementID();
            this.setCardId(xhtmlElement, name);
        }
        return name;
    }

    private void setCardId(XHtmlElement xhtmlElement, String id) {
        try {
            XHtmlAmlElementUtils.addXHtmlAttribute(this.oHandlerManager, this.oCurrentAmlPath, xhtmlElement, "name", id);
        }
        catch (HandlerError he) {
            // empty catch block
        }
        String strPath = this.oCurrentAmlPath.toString();
        String oldId = (String)this.oPageIDs.get(strPath);
        if (oldId != null) {
            this.oIDPages.remove(oldId);
            PageAllocatorInterface pageAllocator = XHtmlAmlElementUtils.getPageAllocator(this.oHandlerManager);
            pageAllocator.changeElement(oldId, id);
        }
        this.oPageIDs.put(strPath, id);
        Vector<AmlPathInterface> pages = (Vector<AmlPathInterface>)this.oIDPages.get(id);
        if (pages == null) {
            pages = new Vector<AmlPathInterface>();
            this.oIDPages.put(id, pages);
        }
        pages.addElement(this.oCurrentAmlPath);
        Vector links = (Vector)this.oIDLinks.get(id);
        if (links != null) {
            int number = links.size();
            int i = 0;
            while (i < number) {
                Vector linkDesc = (Vector)links.elementAt(i);
                AmlPathInterface amlPath = (AmlPathInterface)linkDesc.elementAt(0);
                XHtmlElement linkElement = (XHtmlElement)linkDesc.elementAt(1);
                try {
                    String url = this.getUrl(amlPath, pages, id);
                    XHtmlAmlElementUtils.addXHtmlAttribute(this.oHandlerManager, amlPath, linkElement, HREF, url);
                }
                catch (HandlerError he) {
                    // empty catch block
                }
                ++i;
            }
        }
    }

    private String getUrl(AmlPathInterface srcPath, Vector paths, String id) {
        String url = "#" + id;
        int srcRealm = srcPath.getRealm();
        Enumeration keys = paths.elements();
        boolean isSame = false;
        boolean first = true;
        AmlPathInterface firstPath = null;
        int firstRealm = -1;
        while (keys.hasMoreElements() && !isSame) {
            AmlPathInterface destPath = (AmlPathInterface)keys.nextElement();
            int destRealm = destPath.getRealm();
            if (srcRealm == destRealm) {
                isSame = true;
                continue;
            }
            if (first) {
                firstRealm = destRealm;
                firstPath = destPath;
                first = false;
                continue;
            }
            if (destRealm >= firstRealm) continue;
            firstRealm = destRealm;
            firstPath = destPath;
        }
        if (!isSame && firstPath != null) {
            url = this.getUrl(srcPath, firstPath, id);
        }
        return url;
    }

    private String getUrl(AmlPathInterface srcPath, AmlPathInterface destPath, String id) {
        int destRealm;
        String url = "#" + id;
        int srcRealm = srcPath.getRealm();
        if (srcRealm != (destRealm = destPath.getRealm())) {
            PageAllocatorInterface pageAllocator = XHtmlAmlElementUtils.getPageAllocator(this.oHandlerManager);
            url = pageAllocator.getElementURL(id);
        }
        return url;
    }
}

