/*
 * Decompiled with CFR 0.152.
 */
package com.aligo.modules.xhtml;

import com.aligo.axml.AxmlBr;
import com.aligo.axml.AxmlCheckBox;
import com.aligo.axml.AxmlChoice;
import com.aligo.axml.AxmlControlMenu;
import com.aligo.axml.AxmlForm;
import com.aligo.axml.AxmlGroup;
import com.aligo.axml.AxmlInput;
import com.aligo.axml.AxmlLink;
import com.aligo.axml.AxmlListItem;
import com.aligo.axml.AxmlOption;
import com.aligo.axml.AxmlPage;
import com.aligo.axml.AxmlText;
import com.aligo.axml.AxmlTextArea;
import com.aligo.axml.interfaces.AxmlElement;
import com.aligo.modules.aml.utils.AmlPathUtils;
import com.aligo.modules.errors.HandlerError;
import com.aligo.modules.interfaces.PageAllocatorInterface;
import com.aligo.modules.paths.AmlPath;
import com.aligo.modules.paths.interfaces.AmlPathInterface;
import com.aligo.modules.styles.interfaces.XmlElementInterface;
import com.aligo.modules.xhtml.XHtmlAmlHandler;
import com.aligo.modules.xhtml.errors.XHtmlAmlHandlerError;
import com.aligo.modules.xhtml.events.XHtmlAmlAddControlMenuElementHandlerEvent;
import com.aligo.modules.xhtml.events.XHtmlAmlCheckLinkFormHandlerEvent;
import com.aligo.modules.xhtml.events.XHtmlAmlCheckLinkPageHandlerEvent;
import com.aligo.modules.xhtml.events.XHtmlAmlCombineTextHandlerEvent;
import com.aligo.modules.xhtml.events.XHtmlAmlCreateElementHandlerEvent;
import com.aligo.modules.xhtml.events.XHtmlAmlDetachFromTreeMemoryHandlerEvent;
import com.aligo.modules.xhtml.events.XHtmlAmlEndRenderingHandlerEvent;
import com.aligo.modules.xhtml.events.XHtmlAmlGetCreatedIndicesHandlerEvent;
import com.aligo.modules.xhtml.events.XHtmlAmlGetCurrentPageIDHandlerEvent;
import com.aligo.modules.xhtml.events.XHtmlAmlGetDynamicURLHandlerEvent;
import com.aligo.modules.xhtml.events.XHtmlAmlGetFormRedirectionInfoHandlerEvent;
import com.aligo.modules.xhtml.events.XHtmlAmlGetLastWorkingPathHandlerEvent;
import com.aligo.modules.xhtml.events.XHtmlAmlGetPreviousChildIndexHandlerEvent;
import com.aligo.modules.xhtml.events.XHtmlAmlGetPreviousPageIDHandlerEvent;
import com.aligo.modules.xhtml.events.XHtmlAmlInsufficientMemoryHandlerEvent;
import com.aligo.modules.xhtml.events.XHtmlAmlIsCachedChoiceFormHandlerEvent;
import com.aligo.modules.xhtml.events.XHtmlAmlRemoveCreatedIndexHandlerEvent;
import com.aligo.modules.xhtml.events.XHtmlAmlResetTextStateHandlerEvent;
import com.aligo.modules.xhtml.events.XHtmlAmlSetCurrentPageHandlerEvent;
import com.aligo.modules.xhtml.events.XHtmlAmlSetTopXHtmlElementStateHandlerEvent;
import com.aligo.modules.xhtml.events.XHtmlAmlShouldDetachTextMemoryHandlerEvent;
import com.aligo.modules.xhtml.events.XHtmlAmlStartNewRealmMemoryHandlerEvent;
import com.aligo.modules.xhtml.exceptions.XHtmlAmlInsufficientMemoryException;
import com.aligo.modules.xhtml.handlets.events.XHtmlAmlRemoveXmlXHtmlElementHandletEvent;
import com.aligo.modules.xhtml.handlets.events.XHtmlAmlSetFormUrlHandletEvent;
import com.aligo.modules.xhtml.util.XHtmlAmlElementUtils;
import com.aligo.modules.xhtml.util.XHtmlAmlMemoryUtils;
import com.aligo.modules.xhtml.util.XHtmlEventDescriptor;
import com.aligo.util.FormRedirectionInfo;
import com.aligo.util.FormRedirector;
import com.aligo.xhtml.XHtmlA;
import com.aligo.xhtml.XHtmlContainer;
import com.aligo.xhtml.XHtmlOption;
import com.aligo.xhtml.XHtmlP;
import com.aligo.xhtml.XHtmlPCData;
import com.aligo.xhtml.exceptions.XHtmlElementIndexOutOfBoundsException;
import com.aligo.xhtml.exceptions.XHtmlElementNotFoundException;
import com.aligo.xhtml.interfaces.XHtmlElement;
import java.util.Arrays;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Vector;

public class XHtmlAmlMemoryHandler
extends XHtmlAmlHandler {
    public static final String PERSIST = "persist";
    public static final String PERSIST_FALSE = "false";
    private static final String PAGE = "com.aligo.axml.AxmlPage";
    private static final String FORM = "com.aligo.axml.AxmlForm";
    private static final String CHOICE = "com.aligo.axml.AxmlChoice";
    private static final String FORM_NAME = "Form";
    private static final String FORM_DO = "Do";
    private static final String TEXT_NAME = "P";
    private static final String FORM_ACTION = "href";
    private static final String EQUALS = "=";
    private static final String AMPERSAND = "&amp;";
    private int iRealm = 0;
    private AmlPathInterface oLastWorkingPath = null;
    private static final String MORE = "More";
    private static final String BACK = "Back";
    private static final String HREF = "href";
    private static final String TEXT = "text";
    private static final String TYPE = "type";
    private static final String OPTIONS = "options";
    private static final String LABEL = "label";
    private static final String SENDREFERER = "sendreferer";
    private static final String TRUE = "true";
    private static final String HALIGN = "halign";
    private static final String VALIGN = "valign";
    private static final String SUBMIT_IDENTIFIER = "s";
    private static final String FORMNUM_IDENTIFIER = "agf";
    private AmlPathInterface oLastPagePath = null;
    private AmlPathInterface oCurrentPagePath = null;
    private boolean bPageSet = false;
    private AmlPathInterface oLastFormPath = null;
    private AmlPathInterface oLastFormProcessedPath = null;
    private boolean bIsChoiceFormPresent = false;
    private Vector oLastFormRedirectors;
    private String oSecondLastChoiceFormURL = null;
    private boolean bClosingChoiceFormCall = false;
    private boolean bDisablePageBack = false;
    private boolean bDisablePageMore = false;
    private boolean bPFClosingChoiceForm = false;
    private int iFormNumber = 0;
    private Hashtable formState = new Hashtable();
    private Vector currentFormPaths = new Vector();
    private static final String INPUTS = "inputs";
    private static final String LAST_ELEMENT = "lastelement";
    private static final String PATH_LAST_ELEMENT = "pathlastelement";
    private static final String URL = "url";
    private static final String NAME = "name";

    public XHtmlAmlMemoryHandler() {
        this.oLastFormRedirectors = new Vector();
    }

    public Vector getEvents() {
        Vector<XHtmlEventDescriptor> events = new Vector<XHtmlEventDescriptor>();
        XHtmlEventDescriptor eventDescriptor = new XHtmlEventDescriptor("XHtmlAmlInsufficientMemoryHandlerEvent");
        events.addElement(eventDescriptor);
        eventDescriptor = new XHtmlEventDescriptor("XHtmlAmlStartNewRealmMemoryHandlerEvent");
        events.addElement(eventDescriptor);
        eventDescriptor = new XHtmlEventDescriptor("XHtmlAmlDetachFromTreeMemoryHandlerEvent");
        events.addElement(eventDescriptor);
        eventDescriptor = new XHtmlEventDescriptor("XHtmlAmlSetCurrentPageHandlerEvent");
        events.addElement(eventDescriptor);
        eventDescriptor = new XHtmlEventDescriptor("XHtmlAmlCombineTextHandlerEvent");
        events.addElement(eventDescriptor);
        eventDescriptor = new XHtmlEventDescriptor("XHtmlAmlCheckLinkPageHandlerEvent");
        events.addElement(eventDescriptor);
        eventDescriptor = new XHtmlEventDescriptor("XHtmlAmlCheckLinkFormHandlerEvent");
        events.addElement(eventDescriptor);
        eventDescriptor = new XHtmlEventDescriptor("XHtmlAmlIsCachedChoiceFormHandlerEvent");
        events.addElement(eventDescriptor);
        eventDescriptor = new XHtmlEventDescriptor("XHtmlAmlGetLastWorkingPathHandlerEvent");
        events.addElement(eventDescriptor);
        return events;
    }

    public long xhtmlAmlRelevance() {
        long currentXHtmlAmlRelevance = 0L;
        if (this.oCurrentEvent instanceof XHtmlAmlInsufficientMemoryHandlerEvent || this.oCurrentEvent instanceof XHtmlAmlStartNewRealmMemoryHandlerEvent || this.oCurrentEvent instanceof XHtmlAmlDetachFromTreeMemoryHandlerEvent) {
            currentXHtmlAmlRelevance = 20L;
        } else if (this.oCurrentEvent instanceof XHtmlAmlSetCurrentPageHandlerEvent) {
            currentXHtmlAmlRelevance = 20L;
        } else if (this.oCurrentEvent instanceof XHtmlAmlCombineTextHandlerEvent) {
            currentXHtmlAmlRelevance = 20L;
        } else if (this.oCurrentEvent instanceof XHtmlAmlCheckLinkPageHandlerEvent) {
            currentXHtmlAmlRelevance = 20L;
        } else if (this.oCurrentEvent instanceof XHtmlAmlCheckLinkFormHandlerEvent) {
            currentXHtmlAmlRelevance = 20L;
        } else if (this.oCurrentEvent instanceof XHtmlAmlIsCachedChoiceFormHandlerEvent) {
            currentXHtmlAmlRelevance = 20L;
        } else if (this.oCurrentEvent instanceof XHtmlAmlGetLastWorkingPathHandlerEvent) {
            currentXHtmlAmlRelevance = 20L;
        }
        return currentXHtmlAmlRelevance;
    }

    public void handleEvent() {
        block31: {
            if (this.oCurrentEvent instanceof XHtmlAmlInsufficientMemoryHandlerEvent) {
                AmlPathInterface workingPath = ((XHtmlAmlInsufficientMemoryHandlerEvent)this.oCurrentEvent).getAmlPath();
                boolean sane = false;
                if (this.oHandlerLogger.debugEnabled()) {
                    this.oHandlerLogger.logDebug("InSufficient memory...");
                }
                try {
                    AmlPathInterface lastWorkingPath;
                    do {
                        AmlPathInterface parentPath;
                        block30: {
                            try {
                                AxmlElement amlElement;
                                if (workingPath != null && this.isTextElement(workingPath) && (parentPath = AmlPathUtils.getParentPath(this.oHandlerManager, workingPath)) != null && ((amlElement = AmlPathUtils.getAmlElement(this.oHandlerManager, parentPath)) instanceof AxmlTextArea || amlElement instanceof AxmlInput || amlElement instanceof AxmlCheckBox || amlElement instanceof AxmlOption || amlElement instanceof AxmlListItem || amlElement instanceof AxmlLink)) {
                                    XHtmlAmlResetTextStateHandlerEvent resetTextStateEvent = new XHtmlAmlResetTextStateHandlerEvent(workingPath);
                                    this.oHandlerManager.postEventNow(resetTextStateEvent);
                                }
                            }
                            catch (HandlerError he) {
                                // empty catch block
                            }
                            try {
                                XHtmlAmlElementUtils.detachFromTree(this.oHandlerManager, workingPath);
                            }
                            catch (HandlerError he) {
                                this.oHandlerLogger.logError(he);
                                if (!this.oHandlerLogger.debugEnabled()) break block30;
                                this.oHandlerLogger.logDebug("Detach from tree failed " + workingPath);
                            }
                        }
                        sane = XHtmlAmlElementUtils.isDeckSane(this.oHandlerManager);
                        if (sane && (parentPath = AmlPathUtils.getParentPath(this.oHandlerManager, workingPath)) != null && !XHtmlAmlMemoryUtils.isCacheable(this.oHandlerManager, parentPath)) {
                            sane = XHtmlAmlMemoryUtils.isCacheable(this.oHandlerManager, workingPath);
                            if (this.oHandlerLogger.debugEnabled()) {
                                this.oHandlerLogger.logDebug("Cache sanity: working path " + workingPath + " sanity " + sane);
                            }
                        }
                        lastWorkingPath = workingPath;
                        try {
                            workingPath = this.getPreviousPath(lastWorkingPath);
                            if (workingPath == null) continue;
                            int currentNumberElements = workingPath.getNumberAmlPathComponents();
                            int lastNumberElements = lastWorkingPath.getNumberAmlPathComponents();
                            if (lastNumberElements == currentNumberElements) continue;
                            boolean detach = true;
                            if (this.isTextElement(lastWorkingPath)) {
                                XHtmlAmlShouldDetachTextMemoryHandlerEvent shouldDetachTextMemoryEvent = new XHtmlAmlShouldDetachTextMemoryHandlerEvent(lastWorkingPath);
                                this.oHandlerManager.postEventNow(shouldDetachTextMemoryEvent);
                                detach = shouldDetachTextMemoryEvent.isDetach();
                            }
                            if (!detach) continue;
                            sane = false;
                        }
                        catch (HandlerError he) {
                            sane = true;
                        }
                    } while (!sane && workingPath != null);
                    AmlPathInterface textParentPath = AmlPathUtils.getParentPath(this.oHandlerManager, lastWorkingPath);
                    int childIndex = AmlPathUtils.getChildIndex(this.oHandlerManager, lastWorkingPath);
                    this.combineTexts(textParentPath, childIndex);
                    this.checkLinkForm(lastWorkingPath);
                    this.checkLinkPage();
                    boolean end = false;
                    if (workingPath == null) {
                        end = true;
                    } else if (this.oLastWorkingPath != null) {
                        boolean insufficient = false;
                        try {
                            boolean ancestorPersistent = XHtmlAmlMemoryUtils.isAncestorPersistent(this.oHandlerManager, lastWorkingPath);
                            if (ancestorPersistent) {
                                insufficient = true;
                            }
                        }
                        catch (HandlerError he) {
                            // empty catch block
                        }
                        if (!this.isTextElement(lastWorkingPath)) {
                            String lastCanonicalPath = this.oLastWorkingPath.getCanonicalPath();
                            String currentLastCanonicalPath = lastWorkingPath.getCanonicalPath();
                            if (currentLastCanonicalPath.equals(lastCanonicalPath)) {
                                insufficient = true;
                            }
                        }
                        if (insufficient) {
                            this.oHandlerLogger.logDebug("Page too big for device");
                            end = true;
                        }
                    }
                    if (end) {
                        if (this.oHandlerLogger.debugEnabled()) {
                            this.oHandlerLogger.logDebug("Unable to fit page");
                        }
                        this.end();
                        break block31;
                    }
                    if (this.oHandlerLogger.debugEnabled()) {
                        this.oHandlerLogger.logDebug("Starting new realm...");
                    }
                    this.startNewRealm(lastWorkingPath);
                }
                catch (Exception ex) {
                    this.oHandlerLogger.logError(ex);
                    if (this.oHandlerLogger.debugEnabled()) {
                        this.oHandlerLogger.logDebug("Ending...");
                    }
                    this.end();
                }
            } else if (this.oCurrentEvent instanceof XHtmlAmlStartNewRealmMemoryHandlerEvent) {
                this.startNewRealm(((XHtmlAmlStartNewRealmMemoryHandlerEvent)this.oCurrentEvent).getAmlPath());
            }
        }
    }

    public void handleEventNow() throws HandlerError {
        if (this.oCurrentEvent instanceof XHtmlAmlDetachFromTreeMemoryHandlerEvent) {
            this.detachFromTree(((XHtmlAmlDetachFromTreeMemoryHandlerEvent)this.oCurrentEvent).getAmlPath());
        } else if (this.oCurrentEvent instanceof XHtmlAmlSetCurrentPageHandlerEvent) {
            XHtmlAmlSetCurrentPageHandlerEvent setCurrentPageEvent = (XHtmlAmlSetCurrentPageHandlerEvent)this.oCurrentEvent;
            this.oCurrentPagePath = setCurrentPageEvent.getAmlPath();
            this.bPageSet = true;
        } else if (this.oCurrentEvent instanceof XHtmlAmlCombineTextHandlerEvent) {
            AmlPathInterface textPath = ((XHtmlAmlCombineTextHandlerEvent)this.oCurrentEvent).getAmlPath();
            int childIndex = ((XHtmlAmlCombineTextHandlerEvent)this.oCurrentEvent).getChildIndex();
            this.combineTexts(textPath, childIndex);
        } else if (this.oCurrentEvent instanceof XHtmlAmlCheckLinkPageHandlerEvent) {
            this.checkLinkPage();
        } else if (this.oCurrentEvent instanceof XHtmlAmlCheckLinkFormHandlerEvent) {
            AmlPathInterface formPath = ((XHtmlAmlCheckLinkFormHandlerEvent)this.oCurrentEvent).getAmlPath();
            this.checkLinkForm(formPath);
        } else if (this.oCurrentEvent instanceof XHtmlAmlIsCachedChoiceFormHandlerEvent) {
            XHtmlAmlIsCachedChoiceFormHandlerEvent isCachedChoiceFormEvent = (XHtmlAmlIsCachedChoiceFormHandlerEvent)this.oCurrentEvent;
            AmlPathInterface path = isCachedChoiceFormEvent.getAmlPath();
            boolean cached = this.isCachedChoiceForm(path);
            isCachedChoiceFormEvent.setCached(cached);
        } else if (this.oCurrentEvent instanceof XHtmlAmlGetLastWorkingPathHandlerEvent) {
            ((XHtmlAmlGetLastWorkingPathHandlerEvent)this.oCurrentEvent).setAmlPath(this.oLastWorkingPath);
        }
    }

    private Hashtable getFormPathState(AmlPathInterface formPath) {
        Hashtable formPathState = (Hashtable)this.formState.get(formPath.toString());
        if (formPathState == null) {
            formPathState = new Hashtable();
            this.formState.put(formPath.toString(), formPathState);
            this.currentFormPaths.addElement(formPath);
        }
        return formPathState;
    }

    private void end() {
        XHtmlAmlEndRenderingHandlerEvent endRenderingEvent = new XHtmlAmlEndRenderingHandlerEvent();
        this.oHandlerManager.postEvent(endRenderingEvent);
    }

    private void startNewRealm(AmlPathInterface lastWorkingPath) {
        this.oLastWorkingPath = lastWorkingPath;
        if (this.oHandlerLogger.debugEnabled()) {
            this.oHandlerLogger.logDebug("lastWorkingPath == " + this.oLastWorkingPath.toString());
        }
        ++this.iRealm;
        PageAllocatorInterface pageAllocator = XHtmlAmlElementUtils.getPageAllocator(this.oHandlerManager);
        pageAllocator.allocatePage();
        AmlPath path = new AmlPath();
        path.setRealm(this.iRealm);
        if (this.oHandlerLogger.debugEnabled()) {
            this.oHandlerLogger.logDebug(path.toString());
        }
        XHtmlAmlCreateElementHandlerEvent createElementEvent = new XHtmlAmlCreateElementHandlerEvent(path);
        this.oHandlerManager.postEvent(createElementEvent);
    }

    private boolean isTextElement(AmlPathInterface amlPath) {
        AxmlElement amlElement;
        boolean textElement = false;
        if (amlPath != null && (amlElement = AmlPathUtils.getAmlElement(this.oHandlerManager, amlPath)) instanceof AxmlText) {
            textElement = true;
        }
        return textElement;
    }

    private AmlPathInterface getPreviousPath(AmlPathInterface currentAmlPath) throws HandlerError {
        AmlPathInterface previousPath = null;
        int currentChildIndex = AmlPathUtils.getChildIndex(this.oHandlerManager, currentAmlPath);
        XHtmlAmlGetPreviousChildIndexHandlerEvent getPreviousChildIndexEvent = new XHtmlAmlGetPreviousChildIndexHandlerEvent(currentAmlPath, currentChildIndex);
        this.oHandlerManager.postEventNow(getPreviousChildIndexEvent);
        int previousChildIndex = getPreviousChildIndexEvent.getPreviousIndex();
        AmlPathInterface parentAmlPath = AmlPathUtils.getParentPath(this.oHandlerManager, currentAmlPath);
        previousPath = previousChildIndex < 0 ? parentAmlPath : AmlPathUtils.getChildPath(this.oHandlerManager, parentAmlPath, previousChildIndex);
        return previousPath;
    }

    private AmlPathInterface getPreviousPath(AmlPathInterface currentAmlPath, int index) throws HandlerError {
        int previousChildIndex;
        AmlPathInterface previousPath = null;
        if (index == -1) {
            int currentChildIndex = AmlPathUtils.getChildIndex(this.oHandlerManager, currentAmlPath);
            XHtmlAmlGetPreviousChildIndexHandlerEvent getPreviousChildIndexEvent = new XHtmlAmlGetPreviousChildIndexHandlerEvent(currentAmlPath, currentChildIndex);
            this.oHandlerManager.postEventNow(getPreviousChildIndexEvent);
            previousChildIndex = getPreviousChildIndexEvent.getPreviousIndex();
        } else {
            previousChildIndex = index;
        }
        AmlPathInterface parentAmlPath = AmlPathUtils.getParentPath(this.oHandlerManager, currentAmlPath);
        previousPath = previousChildIndex < 0 ? parentAmlPath : AmlPathUtils.getChildPath(this.oHandlerManager, parentAmlPath, previousChildIndex);
        return previousPath;
    }

    private void detachFromTree(AmlPathInterface currentAmlPath) throws HandlerError {
        int originalIndex;
        AmlPathInterface parentAmlPath;
        block3: {
            XHtmlElement topElement = XHtmlAmlElementUtils.getTopXHtmlElement(this.oHandlerManager, currentAmlPath);
            parentAmlPath = AmlPathUtils.getParentPath(this.oHandlerManager, currentAmlPath);
            originalIndex = AmlPathUtils.getChildIndex(this.oHandlerManager, currentAmlPath);
            try {
                XHtmlAmlRemoveXmlXHtmlElementHandletEvent removeXmlXHtmlElementEvent = new XHtmlAmlRemoveXmlXHtmlElementHandletEvent(currentAmlPath, null, topElement);
                this.oHandlerManager.postEventNow(removeXmlXHtmlElementEvent);
            }
            catch (HandlerError he) {
                Exception ex = he.getException();
                if (ex instanceof XHtmlElementNotFoundException) break block3;
                throw he;
            }
        }
        if (parentAmlPath != null) {
            XHtmlAmlRemoveCreatedIndexHandlerEvent removeCreatedIndexEvent = new XHtmlAmlRemoveCreatedIndexHandlerEvent(parentAmlPath, originalIndex);
            this.oHandlerManager.postEventNow(removeCreatedIndexEvent);
        }
    }

    private boolean isPersistentElement(AxmlElement amlElement) {
        boolean persistentElement = false;
        if (amlElement instanceof AxmlControlMenu) {
            persistentElement = true;
        } else {
            String value = amlElement.getAxmlAttributeValue(PERSIST);
            if (value != null && !value.equals(PERSIST_FALSE)) {
                persistentElement = true;
            }
        }
        return persistentElement;
    }

    private void checkLinkPage() {
        if (this.bPageSet) {
            this.linkPage();
            this.bPageSet = false;
        }
    }

    private boolean isValidLabel(String label) {
        boolean valid = true;
        if (label == null || label != null && label.equalsIgnoreCase("none")) {
            valid = false;
        }
        return valid;
    }

    private String getNextLabel(AmlPathInterface path) {
        String nextLabel = MORE;
        try {
            AxmlElement page = AmlPathUtils.getAmlElement(this.oHandlerManager, path);
            String tNextLabel = page.getAxmlAttributeValue("next_label");
            if (this.isValidLabel(tNextLabel)) {
                nextLabel = tNextLabel;
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        return nextLabel;
    }

    private String getPrevLabel(AmlPathInterface path) {
        String prevLabel = BACK;
        try {
            AxmlElement page = AmlPathUtils.getAmlElement(this.oHandlerManager, path);
            String tPrevLabel = page.getAxmlAttributeValue("prev_label");
            if (this.isValidLabel(tPrevLabel)) {
                prevLabel = tPrevLabel;
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        return prevLabel;
    }

    private void linkPage() {
        try {
            AxmlElement amlElement = AmlPathUtils.getAmlElement(this.oHandlerManager, this.oCurrentPagePath);
            if (amlElement instanceof AxmlPage) {
                if (this.oLastPagePath != null) {
                    AxmlElement amlPage = amlElement;
                    XHtmlElement pageElement = XHtmlAmlElementUtils.getChildContainerXHtmlElement(this.oHandlerManager, this.oCurrentPagePath);
                    if (pageElement != null) {
                        XHtmlAmlAddControlMenuElementHandlerEvent addControlMenuElementEvent;
                        XHtmlPCData xhtmlPCData;
                        XHtmlA xhtmlA;
                        String prevLabel;
                        AxmlElement lastPage = AmlPathUtils.getAmlElement(this.oHandlerManager, this.oLastPagePath);
                        XHtmlElement lastPageElement = XHtmlAmlElementUtils.getChildContainerXHtmlElement(this.oHandlerManager, this.oLastPagePath);
                        PageAllocatorInterface pageAllocator = XHtmlAmlElementUtils.getPageAllocator(this.oHandlerManager);
                        String prevURL = pageAllocator.getPreviousPageURL();
                        String currURL = pageAllocator.getCurrentPageURL();
                        if (!this.bDisablePageBack && this.isValidLabel(prevLabel = amlPage.getAxmlAttributeValue("prev_label"))) {
                            xhtmlA = new XHtmlA();
                            xhtmlA.addXHtmlAttribute("href", prevURL);
                            xhtmlPCData = new XHtmlPCData();
                            xhtmlPCData.addXHtmlAttribute(TEXT, prevLabel);
                            xhtmlA.addXHtmlElement(xhtmlPCData);
                            addControlMenuElementEvent = new XHtmlAmlAddControlMenuElementHandlerEvent(this.oCurrentPagePath, xhtmlA);
                            this.oHandlerManager.postEventNow(addControlMenuElementEvent);
                        }
                        if (!this.bDisablePageMore) {
                            String nextLabel = this.getNextLabel(this.oLastPagePath);
                            xhtmlA = new XHtmlA();
                            xhtmlA.addXHtmlAttribute("href", currURL);
                            xhtmlPCData = new XHtmlPCData();
                            xhtmlPCData.addXHtmlAttribute(TEXT, nextLabel);
                            xhtmlA.addXHtmlElement(xhtmlPCData);
                            addControlMenuElementEvent = new XHtmlAmlAddControlMenuElementHandlerEvent(this.oLastPagePath, xhtmlA);
                            this.oHandlerManager.postEventNow(addControlMenuElementEvent);
                        }
                    }
                }
                if (this.oHandlerLogger.debugEnabled()) {
                    this.oHandlerLogger.logDebug("+++++oLastPagePath = " + this.oLastPagePath);
                }
                this.oLastPagePath = this.oCurrentPagePath;
            }
        }
        catch (Exception ex) {
            this.oHandlerLogger.logError(ex);
        }
    }

    private boolean isCachedChoiceForm(AmlPathInterface amlPath) {
        boolean cached = false;
        if (amlPath != null && this.oLastWorkingPath != null) {
            try {
                AmlPathInterface lastChoiceFormPath;
                AxmlElement amlElement = AmlPathUtils.getAmlElement(this.oHandlerManager, this.oLastWorkingPath);
                if (!(amlElement instanceof AxmlChoice) && (lastChoiceFormPath = AmlPathUtils.getAncestorPath(this.oHandlerManager, this.oLastWorkingPath, CHOICE)) != null && amlPath.getCanonicalPath().equals(lastChoiceFormPath.getCanonicalPath())) {
                    cached = true;
                }
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        return cached;
    }

    private void checkLinkForm(AmlPathInterface currentAmlPath) {
        this.bDisablePageBack = false;
        this.bDisablePageMore = false;
        int formNumber = this.iFormNumber;
        try {
            PageAllocatorInterface pageAllocator = XHtmlAmlElementUtils.getPageAllocator(this.oHandlerManager);
            XHtmlAmlGetFormRedirectionInfoHandlerEvent getFormRedirectionInfoEvent = new XHtmlAmlGetFormRedirectionInfoHandlerEvent();
            this.oHandlerManager.postEventNow(getFormRedirectionInfoEvent);
            FormRedirectionInfo formRedirectionInfo = getFormRedirectionInfoEvent.getInfo();
            if (this.bPFClosingChoiceForm) {
                this.bDisablePageMore = true;
                this.bPFClosingChoiceForm = false;
            }
            AmlPathInterface currentFormPath = null;
            if (currentAmlPath != null) {
                currentFormPath = AmlPathUtils.getAncestorPath(this.oHandlerManager, currentAmlPath, FORM);
            }
            if (this.bClosingChoiceFormCall && this.oLastFormPath != null) {
                this.oLastFormPath = AmlPathUtils.getNextRealmPath(this.oHandlerManager, this.oLastFormPath);
            }
            boolean lastFormPathSet = false;
            if (this.oLastFormPath != null) {
                this.bDisablePageMore = true;
                AmlPathInterface lastChoiceFormPath = null;
                if (this.oLastWorkingPath != null) {
                    try {
                        AxmlElement amlElement = AmlPathUtils.getAmlElement(this.oHandlerManager, this.oLastWorkingPath);
                        if (!(amlElement instanceof AxmlChoice)) {
                            lastChoiceFormPath = AmlPathUtils.getAncestorPath(this.oHandlerManager, this.oLastWorkingPath, CHOICE);
                            if (this.bClosingChoiceFormCall) {
                                lastChoiceFormPath = AmlPathUtils.getNextRealmPath(this.oHandlerManager, lastChoiceFormPath);
                            }
                        }
                    }
                    catch (Exception ex) {
                        // empty catch block
                    }
                }
                if (this.oHandlerLogger.debugEnabled()) {
                    this.oHandlerLogger.logDebug("lastChoiceFormPath = " + lastChoiceFormPath);
                }
                boolean isLastChoiceFormPresent = false;
                String choiceName = null;
                String choiceForwardValue = null;
                String choiceBackwardValue = null;
                boolean isSecondLastChoiceFormPresent = false;
                if (lastChoiceFormPath != null) {
                    isLastChoiceFormPresent = true;
                    try {
                        AxmlElement amlElement = AmlPathUtils.getAmlElement(this.oHandlerManager, lastChoiceFormPath);
                        choiceName = amlElement.getAxmlAttributeValue(NAME);
                    }
                    catch (Exception ex) {
                        // empty catch block
                    }
                }
                if (isLastChoiceFormPresent && this.oSecondLastChoiceFormURL != null) {
                    isSecondLastChoiceFormPresent = true;
                }
                if (isLastChoiceFormPresent) {
                    XHtmlElement choiceElement;
                    XHtmlPCData xhtmlPCData;
                    XHtmlOption xhtmlOption;
                    this.bDisablePageBack = true;
                    this.bDisablePageMore = true;
                    if (isSecondLastChoiceFormPresent) {
                        try {
                            xhtmlOption = new XHtmlOption();
                            xhtmlPCData = new XHtmlPCData();
                            choiceBackwardValue = this.getPrevLabel(this.oLastPagePath);
                            xhtmlPCData.addXHtmlAttribute(TEXT, choiceBackwardValue);
                            xhtmlOption.addXHtmlAttribute("value", choiceBackwardValue);
                            xhtmlOption.addXHtmlElement(xhtmlPCData);
                            choiceElement = XHtmlAmlElementUtils.getChildContainerXHtmlElement(this.oHandlerManager, lastChoiceFormPath);
                            try {
                                XHtmlAmlElementUtils.addXHtmlElement(this.oHandlerManager, lastChoiceFormPath, choiceElement, xhtmlOption, 0);
                            }
                            catch (HandlerError he) {}
                        }
                        catch (Exception ex) {
                            this.oHandlerLogger.logError(ex);
                        }
                    }
                    if (!this.bClosingChoiceFormCall) {
                        try {
                            xhtmlOption = new XHtmlOption();
                            xhtmlPCData = new XHtmlPCData();
                            choiceForwardValue = this.getNextLabel(this.oLastPagePath);
                            xhtmlPCData.addXHtmlAttribute(TEXT, choiceForwardValue);
                            xhtmlOption.addXHtmlAttribute("value", choiceForwardValue);
                            xhtmlOption.addXHtmlElement(xhtmlPCData);
                            choiceElement = XHtmlAmlElementUtils.getChildContainerXHtmlElement(this.oHandlerManager, lastChoiceFormPath);
                            try {
                                XHtmlAmlElementUtils.addXHtmlElement(this.oHandlerManager, lastChoiceFormPath, choiceElement, xhtmlOption);
                            }
                            catch (HandlerError he) {}
                        }
                        catch (Exception ex) {
                            this.oHandlerLogger.logError(ex);
                        }
                    }
                }
                String currURL = null;
                boolean originalUrl = true;
                if (!this.bClosingChoiceFormCall) {
                    currURL = pageAllocator.getCurrentPageURL();
                    originalUrl = false;
                } else if (this.isDiffCanonicalPaths(currentFormPath, this.oLastFormPath)) {
                    currURL = this.getFormURL(this.oLastFormPath);
                } else {
                    currURL = pageAllocator.getNextPageURL();
                    originalUrl = false;
                }
                String sCurrURL = null;
                if (isLastChoiceFormPresent) {
                    String modifier;
                    XHtmlAmlGetDynamicURLHandlerEvent getDynamicURLEvent = new XHtmlAmlGetDynamicURLHandlerEvent();
                    this.oHandlerManager.postEventNow(getDynamicURLEvent);
                    String dynamicURL = getDynamicURLEvent.getURL();
                    String dCurrURL = null;
                    String id = null;
                    if (!this.bClosingChoiceFormCall) {
                        XHtmlAmlGetPreviousPageIDHandlerEvent getPreviousPageIDEvent = new XHtmlAmlGetPreviousPageIDHandlerEvent();
                        this.oHandlerManager.postEventNow(getPreviousPageIDEvent);
                        id = getPreviousPageIDEvent.getID();
                    } else {
                        XHtmlAmlGetCurrentPageIDHandlerEvent getCurrentPageIDEvent = new XHtmlAmlGetCurrentPageIDHandlerEvent();
                        this.oHandlerManager.postEventNow(getCurrentPageIDEvent);
                        id = getCurrentPageIDEvent.getID();
                    }
                    dCurrURL = dynamicURL + id;
                    FormRedirector formRedirector = new FormRedirector();
                    formRedirector.setDynamicURL(dCurrURL);
                    if (isSecondLastChoiceFormPresent) {
                        modifier = choiceName + EQUALS + choiceBackwardValue;
                        formRedirector.addModifier(modifier, this.oSecondLastChoiceFormURL);
                    }
                    if (!this.bClosingChoiceFormCall) {
                        modifier = choiceName + EQUALS + choiceForwardValue;
                        formRedirector.addModifier(modifier, currURL);
                    }
                    this.oLastFormRedirectors.addElement(formRedirector);
                    sCurrURL = currURL;
                    currURL = dCurrURL;
                }
                XmlElementInterface topStyleElement = XHtmlAmlElementUtils.getTopStyleElement(this.oHandlerManager, this.oLastFormPath);
                XmlElementInterface formElement = XHtmlAmlElementUtils.getFirstMatchingChild(this.oHandlerManager, topStyleElement, FORM_NAME);
                XHtmlElement xhtmlElement = XHtmlAmlElementUtils.getXHtmlElement(this.oHandlerManager, this.oLastFormPath, formElement);
                try {
                    this.setFormURL(this.oLastFormPath, currURL, formNumber);
                }
                catch (HandlerError he) {
                    // empty catch block
                }
                if (isLastChoiceFormPresent) {
                    this.oSecondLastChoiceFormURL = pageAllocator.getPreviousPageURL();
                    currURL = sCurrURL;
                }
                if (isLastChoiceFormPresent) {
                    boolean closeRedirection;
                    AmlPathInterface currentChoiceFormPath = null;
                    if (currentAmlPath != null) {
                        currentChoiceFormPath = AmlPathUtils.getAncestorPath(this.oHandlerManager, currentAmlPath, CHOICE);
                    }
                    if (closeRedirection = this.isDiffCanonicalPaths(currentChoiceFormPath, lastChoiceFormPath)) {
                        if (!this.bClosingChoiceFormCall) {
                            this.bClosingChoiceFormCall = true;
                            this.checkLinkForm(currentAmlPath);
                            this.oLastFormPath = null;
                            lastFormPathSet = true;
                            this.bPFClosingChoiceForm = true;
                            this.bClosingChoiceFormCall = false;
                        }
                        if (this.bClosingChoiceFormCall) {
                            int numberElements = this.oLastFormRedirectors.size();
                            int i = 0;
                            while (i < numberElements) {
                                FormRedirector formRedirector = (FormRedirector)this.oLastFormRedirectors.elementAt(i);
                                formRedirector.setOriginalURL(currURL);
                                formRedirectionInfo.addFormRedirector(formRedirector);
                                if (this.oHandlerLogger.debugEnabled()) {
                                    this.oHandlerLogger.logDebug("formRedirector = " + formRedirector.toString());
                                }
                                ++i;
                            }
                            this.oLastFormRedirectors.clear();
                            this.oSecondLastChoiceFormURL = null;
                        }
                    }
                }
            }
            if (!this.bClosingChoiceFormCall && this.isDiffCanonicalPaths(currentFormPath, this.oLastFormProcessedPath)) {
                AmlPathInterface destPath = AmlPathUtils.getNextRealmPath(this.oHandlerManager, this.oLastFormPath);
                String destURL = this.getFormURL(destPath);
                XHtmlAmlGetDynamicURLHandlerEvent getDynamicURLEvent = new XHtmlAmlGetDynamicURLHandlerEvent();
                this.oHandlerManager.postEventNow(getDynamicURLEvent);
                String dynamicURL = getDynamicURLEvent.getURL();
                XHtmlAmlGetCurrentPageIDHandlerEvent getCurrentPageIDEvent = new XHtmlAmlGetCurrentPageIDHandlerEvent();
                this.oHandlerManager.postEventNow(getCurrentPageIDEvent);
                String id = getCurrentPageIDEvent.getID();
                String dDestURL = dynamicURL + id + SUBMIT_IDENTIFIER;
                FormRedirector formRedirector = new FormRedirector();
                formRedirector.setDynamicURL(dDestURL);
                formRedirector.setOriginalURL(destURL);
                formRedirectionInfo.addFormRedirector(formRedirector);
                this.setFormURL(destPath, dDestURL, formNumber);
                ++this.iFormNumber;
            }
            if (this.oHandlerLogger.debugEnabled()) {
                this.oHandlerLogger.logDebug("*****oLastFormPath = " + this.oLastFormPath);
            }
            if (!lastFormPathSet) {
                this.oLastFormPath = currentFormPath;
            }
            this.oLastFormProcessedPath = currentFormPath;
        }
        catch (Exception ex) {
            this.oHandlerLogger.logError(ex);
        }
    }

    private void setFormURL(AmlPathInterface formPath, String formURL, int formNumber) throws HandlerError {
        try {
            AxmlElement formAmlElement = AmlPathUtils.getAmlElement(this.oHandlerManager, formPath);
            if (formAmlElement instanceof AxmlForm) {
                String methodType = formAmlElement.getAxmlAttributeValue("method");
                String numURL = "agf=" + formNumber;
                formURL = this.composeURL(formURL, numURL);
                this.setFormNativeURL(formPath, formURL);
            }
        }
        catch (Exception ex) {
            this.conditionalError(ex);
        }
    }

    private void setFormNativeURL(AmlPathInterface formPath, String formURL) throws HandlerError {
        try {
            XHtmlAmlSetFormUrlHandletEvent setUrlEvent = new XHtmlAmlSetFormUrlHandletEvent(formPath, formURL, false);
            this.oHandlerManager.postEventNow(setUrlEvent);
        }
        catch (HandlerError handlerError) {
            // empty catch block
        }
    }

    private String composeURL(String currURL, String paramURL) {
        if (paramURL != null) {
            currURL = currURL.indexOf("?") == -1 ? currURL + "?" : currURL + "&";
            currURL = currURL + paramURL;
        }
        return currURL;
    }

    private XHtmlElement getFirstChildXHtmlElement(XHtmlElement parent) {
        XHtmlElement element = null;
        if (parent.getNumberElements() > 0) {
            try {
                element = parent.xhtmlElementAt(0);
                if (element instanceof XHtmlContainer) {
                    element = this.getFirstChildXHtmlElement(element);
                }
            }
            catch (XHtmlElementIndexOutOfBoundsException xHtmlElementIndexOutOfBoundsException) {
                // empty catch block
            }
        }
        return element;
    }

    private void combineTexts(AmlPathInterface currentPath, int childIndex) {
        try {
            AxmlElement currentAxmlElement = AmlPathUtils.getAmlElement(this.oHandlerManager, currentPath);
            int noOfChilds = currentAxmlElement.getNumberElements();
            XHtmlAmlGetCreatedIndicesHandlerEvent XHtmlAmlGetCreatedIndicesHandlerEvent2 = new XHtmlAmlGetCreatedIndicesHandlerEvent(currentPath);
            this.oHandlerManager.postEventNow(XHtmlAmlGetCreatedIndicesHandlerEvent2);
            Vector elementsVector = XHtmlAmlGetCreatedIndicesHandlerEvent2.getIndices();
            Object[] sortedVector = elementsVector.toArray();
            Arrays.sort(sortedVector);
            int size = sortedVector.length;
            Vector<AmlPathInterface> brContainer = new Vector<AmlPathInterface>();
            AmlPathInterface previousAmlPath = null;
            XHtmlElement previousCombineParent = null;
            XHtmlElement previousTopElement = null;
            int i = 0;
            while (i < size) {
                int elementIndex = (Integer)sortedVector[i];
                AmlPathInterface amlPath = AmlPathUtils.getChildPath(this.oHandlerManager, currentPath, elementIndex);
                AxmlElement axmlElement = AmlPathUtils.getAmlElement(this.oHandlerManager, amlPath);
                if (previousCombineParent != null && axmlElement instanceof AxmlBr) {
                    brContainer.addElement(amlPath);
                } else {
                    XHtmlElement currentTopElement = XHtmlAmlElementUtils.getTopXHtmlElement(this.oHandlerManager, amlPath);
                    XHtmlElement currentElement = currentTopElement.xhtmlElementAt(0);
                    if (currentElement instanceof XHtmlP) {
                        boolean combine = false;
                        if (previousAmlPath != null) {
                            AxmlElement previousAxmlElement = AmlPathUtils.getAmlElement(this.oHandlerManager, previousAmlPath);
                            if (!(axmlElement instanceof AxmlGroup) && !(previousAxmlElement instanceof AxmlGroup) && axmlElement.getAxmlAttributeValue(HALIGN) == null && previousAxmlElement.getAxmlAttributeValue(HALIGN) == null) {
                                try {
                                    combine = true;
                                    this.combineElements(previousAmlPath, previousTopElement, previousCombineParent, amlPath, currentTopElement, currentElement, brContainer);
                                }
                                catch (HandlerError he) {
                                    this.oHandlerLogger.logDebug("Combining failed..." + he.toString());
                                    this.oHandlerLogger.logError(he);
                                }
                            }
                        }
                        if (!combine) {
                            previousAmlPath = amlPath;
                            previousTopElement = currentTopElement;
                            previousCombineParent = currentElement;
                        }
                    } else {
                        previousAmlPath = null;
                        previousTopElement = null;
                        previousCombineParent = null;
                    }
                    brContainer.clear();
                }
                ++i;
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    private boolean areElementsSimilar(XHtmlElement xhtmlElementa, XHtmlElement xhtmlElementb) {
        boolean similar = false;
        if (xhtmlElementa != null && xhtmlElementb != null) {
            similar = xhtmlElementa.getHead().equals(xhtmlElementb.getHead());
        }
        return similar;
    }

    private void removeFirstBr(Vector brContainer) throws HandlerError {
        try {
            if (brContainer != null && brContainer.size() > 0) {
                AmlPathInterface amlPath = (AmlPathInterface)brContainer.elementAt(0);
                XHtmlElement currentTopElement = XHtmlAmlElementUtils.getTopXHtmlElement(this.oHandlerManager, amlPath);
                XHtmlElement currentElementP = currentTopElement.xhtmlElementAt(0);
                XHtmlAmlElementUtils.removeXHtmlElement(this.oHandlerManager, amlPath, currentTopElement, currentElementP);
            }
        }
        catch (Exception ex) {
            this.conditionalError(ex);
        }
    }

    private void checkThrow(HandlerError he) throws HandlerError {
        Exception ex = he.getException();
        if (!(ex instanceof XHtmlAmlInsufficientMemoryException)) {
            throw he;
        }
    }

    private void combineElements(AmlPathInterface previousAmlPath, XHtmlElement previousTopElement, XHtmlElement previousCombineElement, AmlPathInterface currentAmlPath, XHtmlElement currentTopElement, XHtmlElement currentElement, Vector brContainer) throws HandlerError {
        try {
            Enumeration keys = brContainer.elements();
            while (keys.hasMoreElements()) {
                AmlPathInterface amlPath = (AmlPathInterface)keys.nextElement();
                XHtmlElement brTopElement = XHtmlAmlElementUtils.getTopXHtmlElement(this.oHandlerManager, amlPath);
                XHtmlElement brElementP = brTopElement.xhtmlElementAt(0);
                XHtmlElement brElement = brElementP.xhtmlElementAt(0);
                try {
                    XHtmlAmlElementUtils.removeXHtmlElement(this.oHandlerManager, amlPath, brTopElement, brElementP);
                }
                catch (HandlerError he) {
                    this.checkThrow(he);
                }
                try {
                    XHtmlAmlElementUtils.addXHtmlElement(this.oHandlerManager, previousAmlPath, previousCombineElement, brElement);
                }
                catch (HandlerError he) {
                    this.checkThrow(he);
                }
                XHtmlAmlSetTopXHtmlElementStateHandlerEvent setTopXHtmlElementStateEvent = new XHtmlAmlSetTopXHtmlElementStateHandlerEvent(amlPath, previousTopElement);
                this.oHandlerManager.postEventNow(setTopXHtmlElementStateEvent);
            }
            int numberElements = currentElement.getNumberElements();
            try {
                XHtmlAmlElementUtils.removeXHtmlElement(this.oHandlerManager, currentAmlPath, currentTopElement, currentElement);
            }
            catch (HandlerError he) {
                this.checkThrow(he);
            }
            XHtmlContainer xhtmlContainer = new XHtmlContainer();
            int i = 0;
            while (i < numberElements) {
                XHtmlElement xhtmlElement = currentElement.xhtmlElementAt(i);
                xhtmlContainer.addXHtmlElement(xhtmlElement);
                ++i;
            }
            try {
                XHtmlAmlElementUtils.addXHtmlElement(this.oHandlerManager, previousAmlPath, previousCombineElement, xhtmlContainer);
            }
            catch (HandlerError he) {
                this.checkThrow(he);
            }
            XHtmlAmlSetTopXHtmlElementStateHandlerEvent setTopXHtmlElementStateEvent = new XHtmlAmlSetTopXHtmlElementStateHandlerEvent(currentAmlPath, previousTopElement);
            this.oHandlerManager.postEventNow(setTopXHtmlElementStateEvent);
        }
        catch (Exception ex) {
            this.conditionalError(ex);
        }
    }

    private void conditionalError(Exception ex) throws HandlerError {
        if (ex instanceof HandlerError) {
            throw (HandlerError)ex;
        }
        throw new XHtmlAmlHandlerError(ex);
    }

    private XmlElementInterface getTextXmlElement(AmlPathInterface textPath) throws HandlerError {
        XmlElementInterface topStyleElement = XHtmlAmlElementUtils.getTopStyleElement(this.oHandlerManager, textPath);
        XmlElementInterface textElement = XHtmlAmlElementUtils.getFirstMatchingChild(this.oHandlerManager, topStyleElement, TEXT_NAME);
        return textElement;
    }

    private boolean indexPresent(int i, Object[] vector) {
        int k = 0;
        while (k < vector.length) {
            int current = (Integer)vector[k];
            if (i == current) {
                return true;
            }
            if (i < current) {
                return false;
            }
            ++k;
        }
        return false;
    }

    private int getPreviousElementIndex(int i, Object[] vector) {
        int k = 0;
        while (k < vector.length) {
            int current = (Integer)vector[k];
            if (i == current) {
                if (k > 0) {
                    return (Integer)vector[k - 1];
                }
                return -1;
            }
            ++k;
        }
        return -1;
    }

    private String getFormURL(AmlPathInterface amlPath) throws HandlerError {
        String url = null;
        try {
            AxmlElement amlElement = AmlPathUtils.getAmlElement(this.oHandlerManager, amlPath);
            url = amlElement.getAxmlAttributeValue(URL);
        }
        catch (Exception ex) {
            this.conditionalError(ex);
        }
        return url;
    }

    private boolean isDiffCanonicalPaths(AmlPathInterface currPath, AmlPathInterface prevPath) {
        boolean different = false;
        if (prevPath != null) {
            if (currPath == null) {
                different = true;
            } else if (!currPath.getCanonicalPath().equals(prevPath.getCanonicalPath())) {
                different = true;
            }
        }
        return different;
    }
}

