/*
 * Decompiled with CFR 0.152.
 */
package com.aligo.modules.xhtml;

import com.aligo.axml.AxmlChoice;
import com.aligo.axml.AxmlDocument;
import com.aligo.axml.interfaces.AxmlElement;
import com.aligo.modules.aml.utils.AmlPathUtils;
import com.aligo.modules.paths.interfaces.AmlPathInterface;
import com.aligo.modules.xhtml.XHtmlAmlPathHandler;
import com.aligo.modules.xhtml.events.XHtmlAmlCombineTextHandlerEvent;
import com.aligo.modules.xhtml.events.XHtmlAmlCreateNextChildHandledHandlerEvent;
import com.aligo.modules.xhtml.events.XHtmlAmlCreateNextChildHandlerEvent;
import com.aligo.modules.xhtml.events.XHtmlAmlCreateNextChildNoneHandlerEvent;
import com.aligo.modules.xhtml.events.XHtmlAmlGetNextChildIndexHandlerEvent;
import com.aligo.modules.xhtml.events.XHtmlAmlInsufficientMemoryHandlerEvent;
import com.aligo.modules.xhtml.events.XHtmlAmlIsCachedChoiceFormHandlerEvent;
import com.aligo.modules.xhtml.util.XHtmlEventDescriptor;
import java.util.Vector;

public class XHtmlAmlCreateNextChildHandler
extends XHtmlAmlPathHandler {
    private boolean bPendingMemoryEvent = false;

    public Vector getEvents() {
        Vector<XHtmlEventDescriptor> events = new Vector<XHtmlEventDescriptor>();
        XHtmlEventDescriptor eventDescriptor = new XHtmlEventDescriptor("XHtmlAmlCreateNextChildHandlerEvent");
        events.addElement(eventDescriptor);
        return events;
    }

    public long xhtmlAmlPathRelevance() {
        long currentXHtmlAmlPathRelevance = 0L;
        if (this.oCurrentEvent instanceof XHtmlAmlCreateNextChildHandlerEvent) {
            currentXHtmlAmlPathRelevance = 20L;
        }
        return currentXHtmlAmlPathRelevance;
    }

    public void handlePathEvent() {
        if (this.oCurrentEvent instanceof XHtmlAmlCreateNextChildHandlerEvent) {
            boolean none = false;
            AmlPathInterface parentAmlPath = null;
            try {
                parentAmlPath = AmlPathUtils.getParentPath(this.oHandlerManager, this.oCurrentAmlPath);
                AxmlElement currentAmlElement = AmlPathUtils.getAmlElement(this.oHandlerManager, parentAmlPath);
                int childIndex = AmlPathUtils.getChildIndex(this.oHandlerManager, this.oCurrentAmlPath);
                XHtmlAmlGetNextChildIndexHandlerEvent getNextChildIndexEvent = new XHtmlAmlGetNextChildIndexHandlerEvent(this.oCurrentAmlPath, childIndex);
                this.oHandlerManager.postEventNow(getNextChildIndexEvent);
                int nextIndex = getNextChildIndexEvent.getNextIndex();
                int numberChildren = currentAmlElement.getNumberElements();
                if (nextIndex < numberChildren) {
                    AmlPathInterface childAmlPath = AmlPathUtils.getChildPath(this.oHandlerManager, parentAmlPath, nextIndex);
                    if (this.bPendingMemoryEvent) {
                        this.bPendingMemoryEvent = false;
                        XHtmlAmlInsufficientMemoryHandlerEvent insufficientMemoryEvent = new XHtmlAmlInsufficientMemoryHandlerEvent(childAmlPath);
                        this.oHandlerManager.postEvent(insufficientMemoryEvent);
                    } else {
                        if (this.oHandlerLogger.debugEnabled()) {
                            this.oHandlerLogger.logDebug("Creating child..." + childAmlPath.toString());
                        }
                        XHtmlAmlCreateNextChildHandledHandlerEvent createNextChildHandledEvent = new XHtmlAmlCreateNextChildHandledHandlerEvent(childAmlPath);
                        this.oHandlerManager.postEvent(createNextChildHandledEvent);
                    }
                } else {
                    none = true;
                }
            }
            catch (Exception ex) {
                this.oHandlerLogger.logError(ex);
                none = true;
            }
            if (none) {
                boolean memoryEvent = false;
                Object memoryPath = null;
                try {
                    XHtmlAmlCombineTextHandlerEvent xhtmlAmlCombineTextHandlerEvent = new XHtmlAmlCombineTextHandlerEvent(parentAmlPath, -1);
                    this.oHandlerManager.postEventNow(xhtmlAmlCombineTextHandlerEvent);
                }
                catch (Exception ex) {
                    // empty catch block
                }
                try {
                    AxmlElement amlElement = AmlPathUtils.getAmlElement(this.oHandlerManager, parentAmlPath);
                    if (amlElement instanceof AxmlChoice) {
                        XHtmlAmlIsCachedChoiceFormHandlerEvent isCachedChoiceFormEvent = new XHtmlAmlIsCachedChoiceFormHandlerEvent(parentAmlPath);
                        this.oHandlerManager.postEventNow(isCachedChoiceFormEvent);
                        if (isCachedChoiceFormEvent.isCached()) {
                            this.bPendingMemoryEvent = true;
                        }
                    } else if (amlElement instanceof AxmlDocument) {
                        this.bPendingMemoryEvent = false;
                    }
                }
                catch (Exception ex) {
                    // empty catch block
                }
                XHtmlAmlCreateNextChildNoneHandlerEvent createNextChildNoneEvent = new XHtmlAmlCreateNextChildNoneHandlerEvent(parentAmlPath);
                this.oHandlerManager.postEvent(createNextChildNoneEvent);
            }
        }
    }
}

