/*
 * Decompiled with CFR 0.152.
 */
package com.aligo.modules.wml.amlhandlets;

import com.aligo.modules.aml.utils.AmlPathUtils;
import com.aligo.modules.errors.HandlerError;
import com.aligo.modules.paths.interfaces.AmlPathInterface;
import com.aligo.modules.styles.interfaces.XmlAmlHandlerAttributeInterface;
import com.aligo.modules.styles.interfaces.XmlAttributeInterface;
import com.aligo.modules.wml.amlhandlets.events.WmlAmlAddWmlEventHandletEvent;
import com.aligo.modules.wml.handlets.WmlAmlStylePathHandlet;
import com.aligo.modules.wml.handlets.events.WmlAmlAddAttributeHandletEvent;
import com.aligo.modules.wml.handlets.events.WmlAmlAddNextAttributeHandletEvent;
import com.aligo.modules.wml.util.WmlAmlElementUtils;
import com.aligo.modules.wml.util.WmlEventDescriptor;
import com.aligo.util.NestedHash;
import com.aligo.wml.WmlOnevent;
import com.aligo.wml.interfaces.WmlElement;
import java.util.Vector;

public class WmlAmlWmlEventHandlet
extends WmlAmlStylePathHandlet {
    private static final String PAGE_REFRESH = "page-refresh";
    private static final String INPUT_VALUE_RESET = "input-value-reset";
    private static final String PAGE_CLASS = "com.aligo.axml.AxmlPage";
    private static final String EMPTY = "";
    private static final String ON_ENTER = "onenter";
    private static final String ON_TIMER = "ontimer";
    private NestedHash oAttrContainer = new NestedHash();
    private NestedHash oEventContainer = new NestedHash();
    private XmlAmlHandlerAttributeInterface oXmlAmlHandlerAttribute;
    private String sAmlName;

    public Vector getEvents() {
        Vector<WmlEventDescriptor> events = new Vector<WmlEventDescriptor>();
        WmlEventDescriptor eventDescriptor = new WmlEventDescriptor("WmlAmlAddWmlEventHandletEvent");
        events.addElement(eventDescriptor);
        eventDescriptor = new WmlEventDescriptor("WmlAmlAddAttributeHandletEvent");
        events.addElement(eventDescriptor);
        return events;
    }

    public long wmlAmlPathRelevance() {
        long currentWmlAmlPathRelevance = 0L;
        if (this.oCurrentEvent instanceof WmlAmlAddWmlEventHandletEvent) {
            try {
                currentWmlAmlPathRelevance = 20L;
            }
            catch (Exception ex) {
                this.oHandlerLogger.logError(ex);
            }
        } else {
            currentWmlAmlPathRelevance = super.wmlAmlPathRelevance();
        }
        return currentWmlAmlPathRelevance;
    }

    public long wmlAmlStylePathRelevance() {
        XmlAmlHandlerAttributeInterface xmlAmlHandlerAttribute;
        String amlName;
        WmlAmlAddAttributeHandletEvent addAttributeEvent;
        XmlAttributeInterface xmlAttribute;
        long currentWmlAmlStylePathRelevance = 0L;
        if (this.oCurrentEvent instanceof WmlAmlAddAttributeHandletEvent && (xmlAttribute = (addAttributeEvent = (WmlAmlAddAttributeHandletEvent)this.oCurrentEvent).getXmlAttribute()) instanceof XmlAmlHandlerAttributeInterface && ((amlName = (xmlAmlHandlerAttribute = (XmlAmlHandlerAttributeInterface)xmlAttribute).getAmlAttributeName()).equals(PAGE_REFRESH) || amlName.equals(INPUT_VALUE_RESET))) {
            this.oXmlAmlHandlerAttribute = xmlAmlHandlerAttribute;
            this.sAmlName = amlName;
            currentWmlAmlStylePathRelevance = 20L;
        }
        return currentWmlAmlStylePathRelevance;
    }

    public void handleStylePathEvent() {
        if (this.oCurrentEvent instanceof WmlAmlAddAttributeHandletEvent) {
            AmlPathInterface currentAmlPath = this.oCurrentAmlPath;
            try {
                WmlElement wmlElement = WmlAmlElementUtils.getWmlElement(this.oHandlerManager, currentAmlPath, this.oStyleXmlElement);
                this.oAttrContainer.put(this.getIdentifier(currentAmlPath), this.sAmlName, wmlElement);
            }
            catch (HandlerError he) {
                this.oHandlerLogger.logError(he);
            }
            WmlAmlAddNextAttributeHandletEvent addNextAttributeEvent = new WmlAmlAddNextAttributeHandletEvent(this.oCurrentAmlPath, this.oStyleXmlElement, this.oXmlAmlHandlerAttribute);
            this.oHandlerManager.postEvent(addNextAttributeEvent);
        }
    }

    public void handlePathEventNow() throws HandlerError {
        if (this.oCurrentEvent instanceof WmlAmlAddWmlEventHandletEvent) {
            WmlAmlAddWmlEventHandletEvent wmlEventEvent = (WmlAmlAddWmlEventHandletEvent)this.oCurrentEvent;
            AmlPathInterface currentAmlPath = this.oCurrentAmlPath;
            String amlName = wmlEventEvent.getAmlName();
            String wmlName = wmlEventEvent.getWmlEventName();
            WmlElement wmlElement = wmlEventEvent.getWmlElement();
            this.addWmlEvent(wmlElement, amlName, wmlName, currentAmlPath);
        } else {
            super.handlePathEventNow();
        }
    }

    private void addWmlEvent(WmlElement wmlElement, String amlName, String wmlName, AmlPathInterface currentAmlPath) throws HandlerError {
        WmlElement eventElement = this.getEventAttribute(currentAmlPath, amlName, wmlName);
        if (eventElement != null) {
            WmlAmlElementUtils.addWmlElement(this.oHandlerManager, currentAmlPath, eventElement, wmlElement);
        }
    }

    private WmlElement getEventAttribute(AmlPathInterface currentAmlPath, String amlName, String wmlName) {
        WmlElement containerElement = (WmlElement)this.oAttrContainer.get(this.getIdentifier(currentAmlPath), amlName);
        WmlElement wmlElement = null;
        if (containerElement != null) {
            if (!wmlName.equals(EMPTY)) {
                if (!this.doesConflict(wmlName, containerElement) && (wmlElement = (WmlElement)this.oEventContainer.get(containerElement, wmlName)) == null) {
                    wmlElement = new WmlOnevent();
                    try {
                        wmlElement.addWmlAttribute("type", wmlName);
                        containerElement.addWmlElement(wmlElement);
                        this.oEventContainer.put(containerElement, wmlName, wmlElement);
                    }
                    catch (Exception ex) {
                        this.oHandlerLogger.logError(ex);
                    }
                }
            } else {
                wmlElement = containerElement;
            }
        }
        return wmlElement;
    }

    private String getIdentifier(AmlPathInterface currentAmlPath) {
        AmlPathInterface idPath = AmlPathUtils.getAncestorPath(this.oHandlerManager, currentAmlPath, PAGE_CLASS);
        if (idPath == null) {
            idPath = currentAmlPath;
        }
        return idPath.toString();
    }

    private boolean doesConflict(String wmlName, WmlElement containerElement) {
        WmlElement wmlElement;
        boolean conflict = false;
        if (wmlName.startsWith(ON_ENTER) && (wmlElement = (WmlElement)this.oEventContainer.get(containerElement, ON_TIMER)) != null) {
            conflict = true;
        }
        return conflict;
    }
}

