/*
 * Decompiled with CFR 0.152.
 */
package com.aligo.modules.wml.amlhandlets;

import com.aligo.axml.AxmlBr;
import com.aligo.axml.AxmlImage;
import com.aligo.axml.AxmlText;
import com.aligo.axml.interfaces.AxmlElement;
import com.aligo.modules.aml.utils.AmlPathUtils;
import com.aligo.modules.errors.HandlerError;
import com.aligo.modules.paths.interfaces.AmlPathInterface;
import com.aligo.modules.wml.amlhandlets.events.WmlAmlGotTextHandletEvent;
import com.aligo.modules.wml.amlhandlets.events.WmlAmlTextHandletEvent;
import com.aligo.modules.wml.events.WmlAmlGetPreviousChildIndexHandlerEvent;
import com.aligo.modules.wml.events.WmlAmlGetWmlChildContainerStateHandlerEvent;
import com.aligo.modules.wml.events.WmlAmlInsufficientMemoryHandlerEvent;
import com.aligo.modules.wml.exceptions.WmlAmlInsufficientMemoryException;
import com.aligo.modules.wml.handlets.WmlAmlStylePathHandlet;
import com.aligo.modules.wml.handlets.events.WmlAmlAddElementHandledHandletEvent;
import com.aligo.modules.wml.util.WmlAmlElementUtils;
import com.aligo.modules.wml.util.WmlEventDescriptor;
import com.aligo.wml.WmlContainer;
import com.aligo.wml.exceptions.WmlElementNotFoundException;
import com.aligo.wml.interfaces.WmlElement;
import java.util.Vector;

public class WmlAmlTextHandlet
extends WmlAmlStylePathHandlet {
    protected AxmlElement oCurrentAxmlElement;
    protected WmlElement wmlElement;
    protected int iChildIndex = 0;

    public Vector getEvents() {
        Vector<WmlEventDescriptor> events = new Vector<WmlEventDescriptor>();
        WmlEventDescriptor eventDescriptor = new WmlEventDescriptor("WmlAmlTextHandletEvent");
        events.addElement(eventDescriptor);
        return events;
    }

    public long wmlAmlStylePathRelevance() {
        long currentWmlAmlStylePathRelevance = 0L;
        if (this.oCurrentEvent instanceof WmlAmlTextHandletEvent) {
            currentWmlAmlStylePathRelevance = 20L;
        }
        return currentWmlAmlStylePathRelevance;
    }

    public void handleStylePathEvent() {
        boolean flag = true;
        boolean memoryError = false;
        if (this.oCurrentEvent instanceof WmlAmlTextHandletEvent) {
            try {
                WmlAmlTextHandletEvent wmlAmlTextHandletEvent = (WmlAmlTextHandletEvent)this.oCurrentEvent;
                WmlElement wmlTextElement = wmlAmlTextHandletEvent.getWmlTextElement();
                WmlElement textParentElement = wmlTextElement.getWmlParentElement();
                WmlElement textParentsParentElement = null;
                int position = -1;
                AmlPathInterface currentPath = wmlAmlTextHandletEvent.getAmlPath();
                AmlPathInterface parentPath = AmlPathUtils.getParentPath(this.oHandlerManager, currentPath);
                AmlPathInterface previousPath = this.getPreviousPath(currentPath);
                if (previousPath != null) {
                    WmlAmlGetWmlChildContainerStateHandlerEvent wmlAmlGetWmlChildContainerStateHandlerEvent = new WmlAmlGetWmlChildContainerStateHandlerEvent(parentPath);
                    this.oHandlerManager.postEventNow(wmlAmlGetWmlChildContainerStateHandlerEvent);
                    textParentsParentElement = wmlAmlGetWmlChildContainerStateHandlerEvent.getWmlElement();
                    this.oHandlerLogger.logDebug("text parent" + textParentElement + " its parent " + textParentsParentElement);
                    if (textParentsParentElement != null) {
                        try {
                            position = textParentsParentElement.wmlElementIndex(textParentElement);
                        }
                        catch (WmlElementNotFoundException we) {
                            // empty catch block
                        }
                    }
                }
                if (previousPath != null) {
                    WmlElement previousTextContainerElement;
                    AxmlElement previousElement = AmlPathUtils.getAmlElement(this.oHandlerManager, previousPath);
                    this.oHandlerLogger.logDebug("position = " + position);
                    if (position > 0 && (previousTextContainerElement = textParentsParentElement.wmlElementAt(position - 1)) instanceof WmlContainer && previousTextContainerElement.getNumberElements() > 0 && (previousElement instanceof AxmlText || previousElement instanceof AxmlImage || previousElement instanceof AxmlBr)) {
                        this.oHandlerLogger.logDebug("posting got text");
                        WmlAmlGotTextHandletEvent wmlAmlGotTextHandletEvent = new WmlAmlGotTextHandletEvent(this.oCurrentAmlPath, this.oStyleXmlElement, wmlAmlTextHandletEvent.getWmlElement(), wmlTextElement, previousTextContainerElement);
                        this.oHandlerManager.postEvent(wmlAmlGotTextHandletEvent);
                        flag = false;
                    }
                }
                if (flag) {
                    WmlAmlElementUtils.addWmlElement(this.oHandlerManager, this.oCurrentAmlPath, wmlTextElement, wmlAmlTextHandletEvent.getWmlElement());
                }
            }
            catch (HandlerError he) {
                Exception ex = he.getException();
                if (ex instanceof WmlAmlInsufficientMemoryException) {
                    memoryError = true;
                }
            }
            catch (Exception ex) {
                this.oHandlerLogger.logError(ex);
            }
            if (memoryError) {
                WmlAmlInsufficientMemoryHandlerEvent insufficientMemoryEvent = new WmlAmlInsufficientMemoryHandlerEvent(this.oCurrentAmlPath);
                this.oHandlerManager.postEvent(insufficientMemoryEvent);
            } else if (flag) {
                WmlAmlAddElementHandledHandletEvent wmlAddElementHandledEvent = new WmlAmlAddElementHandledHandletEvent(this.oCurrentAmlPath, this.oStyleXmlElement);
                this.oHandlerManager.postEvent(wmlAddElementHandledEvent);
            }
        }
    }

    private AmlPathInterface getPreviousPath(AmlPathInterface currentAmlPath) throws HandlerError {
        AmlPathInterface previousPath = null;
        int currentChildIndex = AmlPathUtils.getChildIndex(this.oHandlerManager, currentAmlPath);
        WmlAmlGetPreviousChildIndexHandlerEvent getPreviousChildIndexEvent = new WmlAmlGetPreviousChildIndexHandlerEvent(currentAmlPath, currentChildIndex);
        this.oHandlerManager.postEventNow(getPreviousChildIndexEvent);
        int previousChildIndex = getPreviousChildIndexEvent.getPreviousIndex();
        AmlPathInterface parentAmlPath = AmlPathUtils.getParentPath(this.oHandlerManager, currentAmlPath);
        previousPath = previousChildIndex < 0 ? parentAmlPath : AmlPathUtils.getChildPath(this.oHandlerManager, parentAmlPath, previousChildIndex);
        return previousPath;
    }
}

